# frozen_string_literal: true

class QueueBackfillIdentifierNamesOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '17.5'

  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillIdentifierNamesOfVulnerabilityReads"
  DELAY_INTERVAL = 160.seconds
  BATCH_SIZE = 12000
  SUB_BATCH_SIZE = 40 # Total number of sub-batches: 375

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_reads,
      :id,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_reads, :id, [])
  end
end
