/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsKt {
    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $this$mapToIndex) {
        Intrinsics.checkNotNullParameter($this$mapToIndex, (String)"<this>");
        LinkedHashMap map = new LinkedHashMap();
        Iterator<K> iterator2 = $this$mapToIndex.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            K k = iterator2.next();
            Map map2 = map;
            Integer n2 = index;
            map2.put(k, n2);
        }
        return map;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $this$addIfNotNull, @Nullable T t) {
        Intrinsics.checkNotNullParameter($this$addIfNotNull, (String)"<this>");
        if (t != null) {
            $this$addIfNotNull.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compact(@NotNull ArrayList<T> $this$compact) {
        List list;
        Intrinsics.checkNotNullParameter($this$compact, (String)"<this>");
        int n = $this$compact.size();
        switch (n) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)$this$compact));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> $this$compact_u24lambda_u2d1 = arrayList = $this$compact;
                boolean bl = false;
                $this$compact_u24lambda_u2d1.trimToSize();
                list = arrayList;
            }
        }
        return list;
    }
}

