/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.indexing;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public final class JavaFxControllerClassIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"JavaFxControllerClassIndex");
    private static final MyInputFilter myInputFilter = new MyInputFilter();
    private static final MyDataIndexer myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = JavaFxControllerClassIndex.myDataIndexer;
        if (myDataIndexer == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(1);
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = JavaFxControllerClassIndex.myInputFilter;
        if (myInputFilter == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(3);
        }
        return myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    public static List<PsiFile> findFxmlWithController(Project project, @NotNull String className) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(4);
        }
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<PsiFile> findFxmlWithController(Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(6);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, arg_0 -> ((PsiManager)psiManager).findFile(arg_0), scope);
    }

    public static List<VirtualFile> findFxmlsWithController(Project project, @NotNull String className) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(7);
        }
        return JavaFxControllerClassIndex.findFxmlsWithController(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<VirtualFile> findFxmlsWithController(Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(9);
        }
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, Functions.id(), scope);
    }

    private static <T> List<T> findFxmlWithController(Project project, @NotNull String className, Function<VirtualFile, T> f, GlobalSearchScope scope) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(10);
        }
        return JavaFxControllerClassIndex.findFxmls(NAME, project, className, f, scope);
    }

    static <T> List<T> findFxmls(ID<String, ?> id, Project project, @NotNull String className, Function<VirtualFile, T> f, GlobalSearchScope scope) {
        if (className == null) {
            JavaFxControllerClassIndex.$$$reportNull$$$0(11);
        }
        return (List)ReadAction.compute(() -> {
            Collection files;
            try {
                files = FileBasedIndex.getInstance().getContainingFiles(id, (Object)className, GlobalSearchScope.projectScope((Project)project).intersectWith(scope));
            }
            catch (IndexNotReadyException e) {
                return Collections.emptyList();
            }
            if (files.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (VirtualFile file : files) {
                Object fFile;
                if (!file.isValid() || (fFile = f.fun((Object)file)) == null) continue;
                result.add(fFile);
            }
            return result;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFxmlWithController";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFxmlsWithController";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFxmls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            String className;
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            if ((className = MyDataIndexer.getControllerClassName(inputData.getContentAsText().toString())) != null) {
                Map<String, Object> map = Collections.singletonMap(className, null);
                if (map == null) {
                    MyDataIndexer.$$$reportNull$$$0(1);
                }
                return map;
            }
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                MyDataIndexer.$$$reportNull$$$0(2);
            }
            return map;
        }

        @Nullable
        private static String getControllerClassName(String content) {
            if (!content.contains("http://javafx.com/fxml")) {
                return null;
            }
            final String[] className = new String[]{null};
            NanoXmlUtil.parse((Reader)new StringReader(content), (IXMLBuilder)new NanoXmlBuilder(){
                private boolean myFxRootUsed = false;

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                    if (value != null && ("fx:controller".equals(nsPrefix + ":" + key) || "type".equals(key) && this.myFxRootUsed)) {
                        className[0] = value;
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                    this.myFxRootUsed = "fx:root".equals(nsPrefix + ":" + name);
                }
            });
            return className[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyDataIndexer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyInputFilter
    extends DefaultFileTypeSpecificInputFilter {
        public MyInputFilter() {
            super(new FileType[]{XmlFileType.INSTANCE});
        }

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                MyInputFilter.$$$reportNull$$$0(0);
            }
            return JavaFxFileTypeFactory.isFxml(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyInputFilter", "acceptInput"));
        }
    }
}

