/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.rt.debugger.coroutines.CoroutinesDebugHelper;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineStackFrameInterceptorKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineLibraryAgent2Proxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutinesInfoFromJsonAndReferencesProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfJob;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J&\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy;", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "dumpCoroutines", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoCache;", "fetchAndSetJobsAndParentsForCoroutines", "", "infos", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "fallBackToMirrorFetchJobsAndParentsForCoroutines", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineDebugProbesProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineDebugProbesProxy.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1563#2:89\n1634#2,3:90\n1563#2:93\n1634#2,3:94\n*S KotlinDebug\n*F\n+ 1 CoroutineDebugProbesProxy.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy\n*L\n58#1:89\n58#1:90,3\n60#1:93\n60#1:94,3\n*E\n"})
public final class CoroutineDebugProbesProxy {
    @NotNull
    private final SuspendContextImpl suspendContext;

    public CoroutineDebugProbesProxy(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        this.suspendContext = suspendContext;
    }

    @NotNull
    public final SuspendContextImpl getSuspendContext() {
        return this.suspendContext;
    }

    @NotNull
    public final synchronized CoroutineInfoCache dumpCoroutines() {
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        CoroutineInfoCache coroutineInfoCache = new CoroutineInfoCache(null, null, 3, null);
        try {
            DefaultExecutionContext executionContext = CoroutineUtilsKt.executionContext(this.suspendContext);
            List<CoroutineInfoData> list2 = new CoroutinesInfoFromJsonAndReferencesProvider(executionContext).dumpCoroutinesWithStacktraces();
            if (list2 == null) {
                CoroutineLibraryAgent2Proxy coroutineLibraryAgent2Proxy = CoroutineLibraryAgent2Proxy.Companion.instance(executionContext);
                list2 = coroutineLibraryAgent2Proxy != null ? coroutineLibraryAgent2Proxy.dumpCoroutinesInfo() : null;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
            }
            List<CoroutineInfoData> coroutineInfos = list2;
            coroutineInfoCache.ok(coroutineInfos);
        }
        catch (Throwable e) {
            DebuggerUtilsImpl.logError((String)"Exception is thrown by calling dumpCoroutines.", (Throwable)e);
            coroutineInfoCache.fail();
        }
        return coroutineInfoCache;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final boolean fetchAndSetJobsAndParentsForCoroutines(@NotNull List<? extends CoroutineInfoData> infos) {
        List jobsWithParents;
        Iterable it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        DefaultExecutionContext defaultExecutionContext = CoroutineUtilsKt.executionContext(this.suspendContext);
        if (defaultExecutionContext == null) {
            return false;
        }
        DefaultExecutionContext executionContext = defaultExecutionContext;
        Iterable $this$map$iv = infos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CoroutineInfoData coroutineInfoData = (CoroutineInfoData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CoroutineInfoData)((Object)it)).getDebugCoroutineInfoRef());
        }
        List debugCoroutineInfos = (List)destination$iv$iv;
        Value array = CoroutineStackFrameInterceptorKt.callMethodFromHelper(CoroutinesDebugHelper.class, executionContext, "getJobsAndParentsForCoroutines", debugCoroutineInfos, new String[0]);
        Object object = array instanceof ArrayReference ? (ArrayReference)array : null;
        if (object != null && (object = object.getValues()) != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = (Iterable)object;
            boolean $i$f$map2 = false;
            it = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Value value = (Value)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                StringReference stringReference = it2 instanceof StringReference ? (StringReference)it2 : null;
                collection.add(stringReference != null ? stringReference.value() : null);
            }
            v3 = (List)destination$iv$iv2;
        } else {
            v3 = jobsWithParents = this.fallBackToMirrorFetchJobsAndParentsForCoroutines(executionContext, infos);
        }
        if (jobsWithParents.isEmpty()) {
            return false;
        }
        iterable = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)jobsWithParents.size())), (int)2);
        int i2 = iterable.getFirst();
        int n = iterable.getLast();
        int n2 = iterable.getStep();
        if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
            while (true) {
                infos.get(i2 / 2).setJob((String)jobsWithParents.get(i2));
                infos.get(i2 / 2).setParentJob((String)jobsWithParents.get(i2 + 1));
                if (i2 == n) break;
                i2 += n2;
            }
        }
        return true;
    }

    private final List<String> fallBackToMirrorFetchJobsAndParentsForCoroutines(DefaultExecutionContext executionContext, List<? extends CoroutineInfoData> infos) {
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(executionContext);
        if (debugProbesImpl == null) {
            return CollectionsKt.emptyList();
        }
        DebugProbesImpl debugProbesImpl2 = debugProbesImpl;
        if (!debugProbesImpl2.isInstalled()) {
            return CollectionsKt.emptyList();
        }
        CoroutineInfo coroutineInfo = CoroutineInfo.Companion.instance(executionContext);
        if (coroutineInfo == null) {
            return CollectionsKt.emptyList();
        }
        CoroutineInfo debugCoroutineInfoImpl = coroutineInfo;
        Object[] jobsWithParents = new String[infos.size() * 2];
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)jobsWithParents.length)), (int)2);
        int i2 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
            while (true) {
                CoroutineInfoData info2;
                MirrorOfCoroutineInfo debugCoroutineInfoMirror;
                Object object;
                MirrorOfJob job;
                MirrorOfJob mirrorOfJob = job = (object = (debugCoroutineInfoMirror = (MirrorOfCoroutineInfo)debugCoroutineInfoImpl.mirror((info2 = infos.get(i2 / 2)).getDebugCoroutineInfoRef(), executionContext))) != null && (object = ((MirrorOfCoroutineInfo)object).getContext()) != null ? ((MirrorOfCoroutineContext)object).getJob() : null;
                jobsWithParents[i2] = mirrorOfJob != null ? mirrorOfJob.getDetails() : null;
                Object object2 = job;
                Object object3 = object2 != null && (object2 = ((MirrorOfJob)object2).getParent()) != null && (object2 = object2.getJob()) != null ? ((MirrorOfJob)object2).getDetails() : (jobsWithParents[i2 + 1] = null);
                if (i2 == n) break;
                i2 += n2;
            }
        }
        return ArraysKt.toList((Object[])jobsWithParents);
    }
}

