/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.output;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.OutputStylingUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J,\u0010\u0012\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/InlayScratchFileRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "outputType", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputType;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputType;)V", "getText", "()Ljava/lang/String;", "getFontInfo", "Lcom/intellij/openapi/editor/impl/FontInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nInlayScratchFileRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayScratchFileRenderer.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/output/InlayScratchFileRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,44:1\n648#2,5:45\n*S KotlinDebug\n*F\n+ 1 InlayScratchFileRenderer.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/output/InlayScratchFileRenderer\n*L\n41#1:45,5\n*E\n"})
public final class InlayScratchFileRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final String text;
    @NotNull
    private final ScratchOutputType outputType;

    public InlayScratchFileRenderer(@NotNull String text, @NotNull ScratchOutputType outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)outputType), (String)"outputType");
        this.text = text;
        this.outputType = outputType;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    private final FontInfo getFontInfo(Editor editor) {
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        FontPreferences fontPreferences = colorsScheme.getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        FontPreferences fontPreferences2 = fontPreferences;
        TextAttributes attributes = OutputStylingUtilsKt.getAttributesForOutputType(this.outputType);
        int fontStyle = attributes.getFontType();
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)97, (int)fontStyle, (FontPreferences)fontPreferences2, (FontRenderContext)FontInfo.getFontRenderContext((Component)editor.getContentComponent()));
        Intrinsics.checkNotNullExpressionValue((Object)fontInfo, (String)"getFontAbleToDisplay(...)");
        return fontInfo;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FontInfo fontInfo = this.getFontInfo(editor);
        return fontInfo.fontMetrics().stringWidth(this.text);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        TextAttributes attributes = OutputStylingUtilsKt.getAttributesForOutputType(this.outputType);
        Color color = attributes.getForegroundColor();
        if (color == null) {
            return;
        }
        Color fgColor = color;
        g.setColor(fgColor);
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FontInfo fontInfo = this.getFontInfo(editor);
        g.setFont(fontInfo.getFont());
        FontMetrics metrics = fontInfo.fontMetrics();
        g.drawString(this.text, targetRegion.x, targetRegion.y + metrics.getAscent());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        block1: {
            void var1_1;
            String $this$takeWhile$iv = this.text;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string + this.outputType.name() + ": " + ((Object)StringsKt.trim((CharSequence)this.text)).toString();
    }
}

