/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0006\u001a\u001b\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\n0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "<init>", "(Lcom/intellij/platform/workspace/storage/EntityStorage;)V", "contentRootsToModule", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/util/NlsSafe;", "getContentRootsToModule", "()Ljava/util/Map;", "contentRootsToModule$delegate", "Lkotlin/Lazy;", "shortenPath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUnderContentRoots", "", "intellij.eclipse"})
@SourceDebugExtension(value={"SMAP\nrelativeModulePathSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 relativeModulePathSupport.kt\norg/jetbrains/idea/eclipse/config/ModulePathShortener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,63:1\n1255#2,2:64\n697#2:66\n730#2,4:67\n*S KotlinDebug\n*F\n+ 1 relativeModulePathSupport.kt\norg/jetbrains/idea/eclipse/config/ModulePathShortener\n*L\n60#1:64,2\n42#1:66\n42#1:67,4\n*E\n"})
public final class ModulePathShortener {
    @NotNull
    private final EntityStorage storage;
    @NotNull
    private final Lazy contentRootsToModule$delegate;

    public ModulePathShortener(@NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.contentRootsToModule$delegate = LazyKt.lazy(() -> ModulePathShortener.contentRootsToModule_delegate$lambda$2(this));
    }

    private final Map<String, String> getContentRootsToModule() {
        Lazy lazy = this.contentRootsToModule$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String shortenPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, String> map = this.getContentRootsToModule();
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            String moduleName = map.get(current.getUrl());
            if (moduleName == null) continue;
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String string2 = string;
            int n = current.getUrl().length();
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return "/" + moduleName + string3;
        }
        return null;
    }

    public final boolean isUnderContentRoots(@NotNull VirtualFile file) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Map<String, String> map = this.getContentRootsToModule();
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)file, ModulePathShortener::isUnderContentRoots$lambda$3);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!map.containsKey(it.getUrl())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map contentRootsToModule_delegate$lambda$2(ModulePathShortener this$0) {
        void $this$associateByTo$iv$iv;
        Sequence $this$associateBy$iv = this$0.storage.entities(ContentRootEntity.class);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ContentRootEntity contentRootEntity = (ContentRootEntity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            ContentRootEntity it = (ContentRootEntity)element$iv$iv;
            String string = it.getUrl().getUrl();
            boolean bl2 = false;
            String string2 = it.getModule().getName();
            map.put(string, string2);
        }
        return destination$iv$iv;
    }

    private static final VirtualFile isUnderContentRoots$lambda$3(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

