"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("regenerator-runtime/runtime");
const ppl_language_analyzer_1 = require("../ppl_language_analyzer");
// Simple worker implementation that doesn't depend on Monaco's internal modules
class PPLWorkerImpl {
    analyzer;
    async tokenize(content) {
        if (!this.analyzer) {
            this.analyzer = (0, ppl_language_analyzer_1.getPPLLanguageAnalyzer)();
        }
        return this.analyzer.tokenize(content);
    }
    async validate(content) {
        if (!this.analyzer) {
            this.analyzer = (0, ppl_language_analyzer_1.getPPLLanguageAnalyzer)();
        }
        return this.analyzer.validate(content);
    }
}
// Initialize worker
const worker = new PPLWorkerImpl();
// Handle messages from main thread
self.onmessage = async (e) => {
    const { id, method, args } = e.data;
    try {
        let result;
        switch (method) {
            case 'tokenize':
                result = await worker.tokenize(args[0]);
                break;
            case 'validate':
                result = await worker.validate(args[0]);
                break;
            default:
                throw new Error(`Unknown method: ${method}`);
        }
        // Send result back to main thread
        self.postMessage({
            id,
            result,
        });
    }
    catch (error) {
        // Send error back to main thread
        self.postMessage({
            id,
            error: error instanceof Error ? error.message : String(error),
        });
    }
};
//# sourceMappingURL=ppl.worker.js.map