/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.Session;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.apache.hadoop.shaded.org.jline.reader.LineReader;
import org.apache.hadoop.shaded.org.jline.reader.LineReaderBuilder;
import org.apache.hadoop.shaded.org.jline.reader.impl.LineReaderImpl;
import org.apache.hadoop.shaded.org.jline.terminal.Terminal;
import org.apache.hadoop.shaded.org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN"})
@InterfaceStability.Unstable
@WebSocket
public class ContainerShellWebSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerShellWebSocket.class);
    private Session mySession;
    private Terminal terminal;
    private LineReader reader;
    private boolean sttySet = false;

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        if (!this.sttySet) {
            session.getRemote().sendString("stty -echo");
            session.getRemote().sendString("\r");
            session.getRemote().flush();
            this.sttySet = true;
        }
        this.terminal.output().write(message.getBytes(Charset.forName("UTF-8")));
        this.terminal.output().flush();
    }

    @OnWebSocketConnect
    public void onConnect(Session s) {
        this.initTerminal(s);
        LOG.info(s.getRemoteAddress().getHostString() + " connected!");
    }

    @OnWebSocketClose
    public void onClose(Session session, int status, String reason) {
        if (status == 1000) {
            LOG.info(session.getRemoteAddress().getHostString() + " closed, status: " + status);
        } else {
            LOG.warn(session.getRemoteAddress().getHostString() + " closed, status: " + status + " Reason: " + reason);
        }
    }

    public void run() {
        try {
            Reader consoleReader = new Reader();
            Thread inputThread = new Thread((Runnable)consoleReader, "consoleReader");
            inputThread.start();
            while (this.mySession.isOpen()) {
                String message;
                this.mySession.getRemote().flush();
                if (consoleReader.hasData()) {
                    message = consoleReader.read();
                    this.mySession.getRemote().sendString(message);
                    this.mySession.getRemote().sendString("\r");
                }
                message = "1{}";
                this.mySession.getRemote().sendString(message);
                Thread.sleep(100L);
                this.mySession.getRemote().flush();
            }
            inputThread.join();
        }
        catch (IOException | InterruptedException e) {
            try {
                this.mySession.disconnect();
            }
            catch (IOException e1) {
                LOG.error("Error closing connection: ", (Throwable)e1);
            }
        }
    }

    protected void initTerminal(Session session) {
        try {
            this.mySession = session;
            try {
                this.terminal = TerminalBuilder.builder().system(true).build();
            }
            catch (IOException t) {
                this.terminal = TerminalBuilder.builder().system(false).streams(System.in, (OutputStream)System.out).build();
            }
            this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        }
        catch (IOException e) {
            session.close(1002, e.getMessage());
        }
    }

    class Reader
    implements Runnable {
        private StringBuilder sb = new StringBuilder();
        private boolean hasData = false;

        Reader() {
        }

        public String read() {
            try {
                String string = this.sb.toString();
                return string;
            }
            finally {
                this.hasData = false;
                this.sb.setLength(0);
            }
        }

        public boolean hasData() {
            return this.hasData;
        }

        @Override
        public void run() {
            while (true) {
                int c;
                if ((c = ((LineReaderImpl)ContainerShellWebSocket.this.reader).readCharacter()) == 10 || c == 13) {
                    this.hasData = true;
                    continue;
                }
                this.sb.append(new String(Character.toChars(c)));
            }
        }
    }
}

