// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ModelsLocation models location
//
// swagger:model models.Location
type ModelsLocation struct {

	// CountryCode is the two-character country ISO identifier (uppercase).
	CountryCode string `json:"country_code,omitempty"`

	// DisplayName is the user-facing string for a given location.
	DisplayName string `json:"display_name,omitempty"`

	// Any location that has at least one bridge configured will set this to true.
	HasBridges bool `json:"has_bridges,omitempty"`

	// TODO Not used right now, but intended to signal when a location has all of their
	// nodes overwhelmed.
	Healthy bool `json:"healthy,omitempty"`

	// Hemisphere is a legacy label for a gateway. The rationale was once
	// intended to be to allocate gateways for an hemisphere with certain
	// regional "fairness", even if they're geographically located in a
	// different region. We might want to set this on the Gateway or Bridge, not in the
	// Location itself...
	Hemisphere string `json:"hemisphere,omitempty"`

	// Label is the short representation of a location, used internally.
	Label string `json:"label,omitempty"`

	// Lat is the latitude for the location.
	Lat string `json:"lat,omitempty"`

	// Lon is the longitude for the location.
	Lon string `json:"lon,omitempty"`

	// Region is the continental region this gateway is assigned to. Not used at the moment,
	// intended to use a label from the 7-continent model.
	Region string `json:"region,omitempty"`

	// Timezone is the TZ for the location (-1, 0, +1, ...)
	Timezone string `json:"timezone,omitempty"`
}

// Validate validates this models location
func (m *ModelsLocation) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this models location based on context it is used
func (m *ModelsLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ModelsLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsLocation) UnmarshalBinary(b []byte) error {
	var res ModelsLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
