; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i1 @test_conds_single_use_in_different_blocks(i8 %x) {
; CHECK-LABEL: @test_conds_single_use_in_different_blocks(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[T_1:%.*]] = icmp ugt i8 [[X]], 5
; CHECK-NEXT:    [[C_2:%.*]] = icmp ugt i8 [[X]], 5
; CHECK-NEXT:    br i1 [[C_1]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i1 true
; CHECK:       else:
; CHECK-NEXT:    ret i1 [[C_2]]
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %t.1 = icmp ugt i8 %x, 5
  %c.2 = icmp ugt i8 %x, 5
  br i1 %c.1, label %then, label %else

then:
  ret i1 %t.1

else:
  ret i1 %c.2
}


define i1 @test_conds_single_use_in_different_blocks_2(i8 %x, i8 %y) {
; CHECK-LABEL: @test_conds_single_use_in_different_blocks_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[T_1:%.*]] = icmp ugt i8 [[Y:%.*]], 5
; CHECK-NEXT:    [[C_2:%.*]] = icmp ugt i8 [[Y]], [[X]]
; CHECK-NEXT:    [[C_3:%.*]] = icmp ugt i8 [[Y]], 5
; CHECK-NEXT:    br i1 [[C_1]], label [[THEN_1:%.*]], label [[ELSE:%.*]]
; CHECK:       then.1:
; CHECK-NEXT:    br i1 [[C_2]], label [[THEN_2:%.*]], label [[ELSE]]
; CHECK:       then.2:
; CHECK-NEXT:    ret i1 true
; CHECK:       else:
; CHECK-NEXT:    ret i1 [[C_3]]
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %t.1 = icmp ugt i8 %y, 5
  %c.2 = icmp ugt i8 %y, %x
  %c.3 = icmp ugt i8 %y, 5
  br i1 %c.1, label %then.1, label %else

then.1:
  br i1 %c.2, label %then.2, label %else

then.2:
  ret i1 %t.1

else:
  ret i1 %c.3
}

declare void @llvm.assume(i1)

; Only the use of %t.1 in %then.2 could be simplified, but not the one in
; %entry.
define i1 @test_conds_multiple_uses_in_different_blocks_2(i8 %x, i8 %y) {
; CHECK-LABEL: @test_conds_multiple_uses_in_different_blocks_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[T_1:%.*]] = icmp ugt i8 [[Y:%.*]], 5
; CHECK-NEXT:    call void @llvm.assume(i1 [[T_1]])
; CHECK-NEXT:    [[C_2:%.*]] = icmp ugt i8 [[Y]], [[X]]
; CHECK-NEXT:    [[C_3:%.*]] = icmp ugt i8 [[Y]], 5
; CHECK-NEXT:    br i1 [[C_1]], label [[THEN_1:%.*]], label [[ELSE:%.*]]
; CHECK:       then.1:
; CHECK-NEXT:    br i1 [[C_2]], label [[THEN_2:%.*]], label [[ELSE]]
; CHECK:       then.2:
; CHECK-NEXT:    ret i1 true
; CHECK:       else:
; CHECK-NEXT:    ret i1 true
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %t.1 = icmp ugt i8 %y, 5
  call void @llvm.assume(i1 %t.1)
  %c.2 = icmp ugt i8 %y, %x
  %c.3 = icmp ugt i8 %y, 5
  br i1 %c.1, label %then.1, label %else

then.1:
  br i1 %c.2, label %then.2, label %else

then.2:
  ret i1 %t.1

else:
  ret i1 %c.3
}
