/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -7 -C -k '1,3-11,$' -i 1 src/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 297
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 8
#define MAX_HASH_VALUE 2446
/* maximum key range = 2439, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447,    1,   11, 2447,   41,  236,
        26,  471,   86,  131,   61,  196,    1,  246,    1, 2447,
      2447, 2447, 2447, 2447, 2447,   21,  506,  317,  231,    1,
        91,  131,  311,    1,   66,   46,  507,  116,    6,    1,
        51, 2447,   16,    1,    1,  438,    6,    1,  391,    1,
         1, 2447, 2447, 2447, 2447,  166, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447,
      2447, 2447, 2447, 2447, 2447, 2447, 2447, 2447
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
        hval += asso_values[(unsigned char) str[7]];
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  static const struct alias wordlist[] =
    {
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"SJIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"R8", ei_hp_roman8},
      {""}, {""}, {""},
      {"TCVN", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"850", ei_cp850},
      {"KOI8-R", ei_koi8_r},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"KOREAN", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"JAVA", ei_java},
      {"JP", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""},
      {"MS-EE", ei_cp1250},
      {"866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-6", ei_ascii},
      {""}, {""},
      {"MS-ANSI", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-58", ei_gb2312},
      {""}, {""}, {""},
      {"ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""},
      {"SHIFT-JIS", ei_sjis},
      {""}, {""}, {""},
      {"TIS620", ei_tis620},
      {""},
      {"TIS-620", ei_tis620},
      {""}, {""}, {""}, {""},
      {"JIS0208", ei_jisx0208},
      {""}, {""},
      {"GREEK8", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-226", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620-0", ei_tis620},
      {""}, {""}, {""}, {""},
      {"GBK", ei_ces_gbk},
      {""}, {""}, {""},
      {"GREEK", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-2022-JP-2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO-2022-JP", ei_iso2022_jp},
      {""}, {""}, {""}, {""},
      {"IBM866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"HZ", ei_hz},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CN", ei_iso646_cn},
      {"EUCTW", ei_euc_tw},
      {""},
      {"EUC-TW", ei_euc_tw},
      {""}, {""}, {""}, {""},
      {"VISCII", ei_viscii},
      {""},
      {"CHINESE", ei_gb2312},
      {""},
      {"IBM850", ei_cp850},
      {"SHIFT_JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-148", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MS-GREEK", ei_cp1253},
      {""}, {""}, {""}, {""}, {""},
      {"GEORGIAN-PS", ei_georgian_ps},
      {""},
      {"CHAR", ei_local_char},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ASMO-708", ei_iso8859_6},
      {""},
      {"ISO646-JP", ei_iso646_jp},
      {""},
      {"ISO-IR-100", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"ISO-8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""},
      {"EUCKR", ei_euc_kr},
      {""},
      {"EUC-KR", ei_euc_kr},
      {""},
      {"CSKOI8R", ei_koi8_r},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-126", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-87", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS_KANJI", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-14", ei_iso646_jp},
      {""}, {""},
      {"US", ei_ascii},
      {""}, {""}, {""},
      {"ISO-8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""},
      {"ISO-IR-166", ei_tis620},
      {"ELOT_928", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
      {"ISO-2022-CN", ei_iso2022_cn},
      {""},
      {"X0208", ei_jisx0208},
      {""}, {""}, {""},
      {"ARMSCII-8", ei_armscii_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"HP-ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-JP-1", ei_iso2022_jp1},
      {""},
      {"EUCJP", ei_euc_jp},
      {""},
      {"EUC-JP", ei_euc_jp},
      {""}, {""}, {""},
      {"UCS-2", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP866", ei_cp866},
      {""}, {""}, {""},
      {"L8", ei_iso8859_14},
      {"NEXTSTEP", ei_nextstep},
      {""}, {""}, {""},
      {"ISO-8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN8", ei_iso8859_14},
      {"WCHAR_T", ei_local_wchar_t},
      {"ISO-IR-144", ei_iso8859_5},
      {""}, {""},
      {"CSISO2022KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"L2", ei_iso8859_2},
      {"CP850", ei_cp850},
      {"UTF-8", ei_utf8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO646-CN", ei_iso646_cn},
      {""}, {""}, {""},
      {"ISO-IR-57", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"ISO-8859-4", ei_iso8859_4},
      {"ISO_8859-8:1988", ei_iso8859_8},
      {""}, {""}, {""},
      {"L6", ei_iso8859_10},
      {""}, {""},
      {"LATIN2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO-IR-110", ei_iso8859_4},
      {""}, {""}, {""}, {""},
      {"ISO-IR-165", ei_isoir165},
      {""}, {""}, {""},
      {"CSISO2022JP2", ei_iso2022_jp2},
      {"L4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"MACROMAN", ei_mac_roman},
      {""}, {""},
      {"ISO_8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4", ei_ucs4},
      {"CSISO2022JP", ei_iso2022_jp},
      {""}, {""},
      {"ECMA-118", ei_iso8859_7},
      {"WINDOWS-874", ei_cp874},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"TCVN-5712", ei_tcvn},
      {""},
      {"L5", ei_iso8859_9},
      {""}, {""},
      {"LATIN6", ei_iso8859_10},
      {""}, {""},
      {"MACROMANIA", ei_mac_romania},
      {""},
      {"WINDOWS-1258", ei_cp1258},
      {""}, {""},
      {"ISO_8859-4:1988", ei_iso8859_4},
      {"EUCCN", ei_euc_cn},
      {"CSVISCII", ei_viscii},
      {"EUC-CN", ei_euc_cn},
      {"ISO-8859-5", ei_iso8859_5},
      {""}, {""}, {""}, {""},
      {"ISO646-US", ei_ascii},
      {""},
      {"ISO_646.IRV:1991", ei_ascii},
      {"GEORGIAN-ACADEMY", ei_georgian_academy},
      {""}, {""},
      {"CSASCII", ei_ascii},
      {""}, {""}, {""}, {""},
      {"MS-TURK", ei_cp1254},
      {""},
      {"WINDOWS-1252", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-6", ei_iso8859_6},
      {""},
      {"MACGREEK", ei_mac_greek},
      {""}, {""},
      {"ISO-IR-127", ei_iso8859_6},
      {""}, {""},
      {"WINDOWS-1250", ei_cp1250},
      {""}, {""},
      {"CP874", ei_cp874},
      {""},
      {"LATIN4", ei_iso8859_4},
      {""}, {""},
      {"ISO_8859-5:1988", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"L7", ei_iso8859_13},
      {""}, {""},
      {"WINDOWS-1256", ei_cp1256},
      {""},
      {"X0212", ei_jisx0212},
      {""},
      {"ISO-8859-10", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""},
      {"CP1258", ei_cp1258},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO_8859-4", ei_iso8859_4},
      {""}, {""},
      {"WINDOWS-1254", ei_cp1254},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-138", ei_iso8859_8},
      {""}, {""},
      {"JIS_X0208", ei_jisx0208},
      {"BIGFIVE", ei_ces_big5},
      {"L1", ei_iso8859_1},
      {"BIG-FIVE", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-16", ei_iso8859_16},
      {"MAC", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"CP1252", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACTHAI", ei_mac_thai},
      {""}, {""},
      {"WINDOWS-1255", ei_cp1255},
      {"CSISO2022CN", ei_iso2022_cn},
      {"ISO-IR-101", ei_iso8859_2},
      {"CP950", ei_cp950},
      {""},
      {"LATIN5", ei_iso8859_9},
      {""},
      {"ISO-8859-7", ei_iso8859_7},
      {"ISO_8859-2:1987", ei_iso8859_2},
      {""}, {""},
      {"US-ASCII", ei_ascii},
      {"ISO-IR-157", ei_iso8859_10},
      {"ECMA-114", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1250", ei_cp1250},
      {""},
      {"ISO-IR-109", ei_iso8859_3},
      {"CSSHIFTJIS", ei_sjis},
      {"ISO-8859-14", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620.2529-1", ei_tis620},
      {"ISO_8859-5", ei_iso8859_5},
      {"ISO_8859-6:1987", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"MACCROATIAN", ei_mac_croatian},
      {""},
      {"UCS-2-SWAPPED", ei_ucs2swapped},
      {""},
      {"CP1256", ei_cp1256},
      {""}, {""}, {""},
      {"HEBREW", ei_iso8859_8},
      {"WINDOWS-1257", ei_cp1257},
      {""},
      {"ISO-IR-149", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""},
      {"CSHPROMAN8", ei_hp_roman8},
      {"IBM819", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-8859-1", ei_iso8859_1},
      {""},
      {"ISO_8859-10:1992", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"GB_1988-80", ei_iso646_cn},
      {""},
      {"ISO_8859-10", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1251", ei_cp1251},
      {""},
      {"ISO-8859-9", ei_iso8859_9},
      {""},
      {"ISO_8859-14:1998", ei_iso8859_14},
      {"CP1254", ei_cp1254},
      {""},
      {"ISO-IR-159", ei_jisx0212},
      {""},
      {"ISO-8859-15", ei_iso8859_15},
      {""},
      {"UTF-16", ei_utf16},
      {""},
      {"UCS-4-SWAPPED", ei_ucs4swapped},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-16:2000", ei_iso8859_16},
      {"BIG5", ei_ces_big5},
      {""},
      {"BIG-5", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN7", ei_iso8859_13},
      {""}, {""}, {""},
      {"ISO_8859-16", ei_iso8859_16},
      {""},
      {"CSISOLATIN2", ei_iso8859_2},
      {""}, {""},
      {"GB2312", ei_euc_cn},
      {""}, {""}, {""}, {""},
      {"UTF-7", ei_utf7},
      {""}, {""}, {""},
      {"KOI8-U", ei_koi8_u},
      {"ISO_8859-15:1998", ei_iso8859_15},
      {""}, {""},
      {"X0201", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"KOI8-RU", ei_koi8_ru},
      {""},
      {"ISO_8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""},
      {"ISO-IR-179", ei_iso8859_13},
      {"ISO_8859-7:1987", ei_iso8859_7},
      {""}, {""},
      {"JIS_C6220-1969-RO", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-14", ei_iso8859_14},
      {"ISO-10646-UCS-2", ei_ucs2},
      {"GB18030", ei_gb18030},
      {""}, {""}, {""},
      {"MACUKRAINE", ei_mac_ukraine},
      {"MS-HEBR", ei_cp1255},
      {""}, {""}, {""},
      {"CP1255", ei_cp1255},
      {""},
      {"L3", ei_iso8859_3},
      {"UCS-2BE", ei_ucs2be},
      {"UCS-2LE", ei_ucs2le},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_X0212", ei_jisx0212},
      {"CSISOLATIN6", ei_iso8859_10},
      {""}, {""},
      {"CSISO87JISX0208", ei_jisx0208},
      {"LATIN1", ei_iso8859_1},
      {""}, {""},
      {"ISO_8859-1:1987", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-199", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-2-INTERNAL", ei_ucs2internal},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"JIS_X0208-1990", ei_jisx0208},
      {""}, {""},
      {"ISO-10646-UCS-4", ei_ucs4},
      {""},
      {"ISO_8859-1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3:1988", ei_iso8859_3},
      {""}, {""},
      {"CSISOLATIN4", ei_iso8859_4},
      {"ISO-IR-203", ei_iso8859_15},
      {"UCS-4BE", ei_ucs4be},
      {"UCS-4LE", ei_ucs4le},
      {""}, {""},
      {"CSISO14JISC6220RO", ei_iso646_jp},
      {""},
      {"IBM367", ei_ascii},
      {"CSISOLATINGREEK", ei_iso8859_7},
      {""},
      {"ISO_8859-9", ei_iso8859_9},
      {"CP819", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"ISO_8859-9:1989", ei_iso8859_9},
      {"ISO_8859-15", ei_iso8859_15},
      {""}, {""}, {""}, {""},
      {"CSISO159JISX02121990", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UCS-4-INTERNAL", ei_ucs4internal},
      {"MACINTOSH", ei_mac_roman},
      {"UHC", ei_cp949},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSEUCTW", ei_euc_tw},
      {""},
      {"TCVN5712-1", ei_tcvn},
      {""}, {""}, {""}, {""}, {""},
      {"CP932", ei_cp932},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1257", ei_cp1257},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1253", ei_cp1253},
      {""}, {""},
      {"CN-GB-ISOIR165", ei_isoir165},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
      {"CSISOLATIN5", ei_iso8859_9},
      {""}, {""},
      {"CSIBM866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CP949", ei_cp949},
      {""}, {""}, {""},
      {"GB_2312-80", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSEUCKR", ei_euc_kr},
      {""}, {""},
      {"CP936", ei_ces_gbk},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSISOLATINHEBREW", ei_iso8859_8},
      {""}, {""}, {""},
      {"CP1251", ei_cp1251},
      {"ARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""},
      {"MS-ARAB", ei_cp1256},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATINARABIC", ei_iso8859_6},
      {""}, {""},
      {"JIS_X0201", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSBIG5", ei_ces_big5},
      {""},
      {"CN-BIG5", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KSC_5601", ei_ksc5601},
      {""}, {""},
      {"JIS_X0212-1990", ei_jisx0212},
      {"CP367", ei_ascii},
      {""}, {""}, {""}, {""},
      {"CSUCS4", ei_ucs4},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_X0212.1990-0", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"MACHEBREW", ei_mac_hebrew},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"VISCII1.1-1", ei_viscii},
      {"TIS620.2533-0", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"WINBALTRIM", ei_cp1257},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACCENTRALEUROPE", ei_mac_centraleurope},
      {""},
      {"CSUNICODE", ei_ucs2},
      {""}, {""}, {""},
      {"TCVN5712-1:1993", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-3", ei_iso8859_3},
      {""}, {""}, {""},
      {"CSISOLATIN1", ei_iso8859_1},
      {""}, {""}, {""},
      {"UTF-16BE", ei_utf16be},
      {"UTF-16LE", ei_utf16le},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"JISX0201-1976", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ANSI_X3.4-1968", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSMACINTOSH", ei_mac_roman},
      {"JOHAB", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"BIG5HKSCS", ei_big5hkscs},
      {"JIS_X0208-1983", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN3", ei_iso8859_3},
      {""}, {""},
      {"CN-GB", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""},
      {"MS-CYRL", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620.2533-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"ISO_8859-3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATINCYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""},
      {"UNICODELITTLE", ei_ucs2le},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CP1361", ei_johab},
      {""}, {""}, {""}, {""},
      {"MACTURKISH", ei_mac_turkish},
      {""}, {""}, {""},
      {"ISO-8859-13", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"KS_C_5601-1987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""},
      {"MULELAO-1", ei_mulelao},
      {""}, {""}, {""}, {""}, {""},
      {"MACARABIC", ei_mac_arabic},
      {"CSISO58GB231280", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1253", ei_cp1253},
      {""}, {""},
      {"KS_C_5601-1989", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1-UTF-7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-13", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"HZ-GB-2312", ei_hz},
      {""},
      {"CSGB2312", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MACICELAND", ei_mac_iceland},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODEBIG", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSISO57GB1988", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISOLATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSHALFWIDTHKATAKANA", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSKSC56011987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"CYRILLIC", ei_iso8859_5},
      {""}, {""}, {""},
      {"CSUNICODE11UTF7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSUNICODE11", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"IBM-CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MACCYRILLIC", ei_mac_cyrillic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSPC850MULTILINGUAL", ei_cp850}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
