// This file is part of the AliceVision project.
// Copyright (c) 2019 AliceVision contributors.
// This Source Code Form is subject to the terms of the Mozilla Public License,
// v. 2.0. If a copy of the MPL was not distributed with this file,
// You can obtain one at https://mozilla.org/MPL/2.0/.

#include "emorCurve.hpp"
#include <functional>
#include <fstream>
#include <iostream>
#include <sstream>

namespace aliceVision {
namespace hdr {

static const double kEmor[kEmorMDimension][kEmorQuantization] = {
  {0.000000e+000, 8.833750e-003, 1.497601e-002, 2.023710e-002, 2.498590e-002, 2.937536e-002, 3.348347e-002, 3.740247e-002, 4.116645e-002,
   4.481240e-002, 4.835121e-002, 5.178991e-002, 5.514774e-002, 5.843527e-002, 6.167138e-002, 6.485830e-002, 6.799864e-002, 7.109369e-002,
   7.414113e-002, 7.714684e-002, 8.011208e-002, 8.303313e-002, 8.591695e-002, 8.876004e-002, 9.156913e-002, 9.434381e-002, 9.708718e-002,
   9.980128e-002, 1.024881e-001, 1.051487e-001, 1.077847e-001, 1.103984e-001, 1.129923e-001, 1.155692e-001, 1.181306e-001, 1.206751e-001,
   1.232042e-001, 1.257223e-001, 1.282268e-001, 1.307177e-001, 1.331949e-001, 1.356606e-001, 1.381127e-001, 1.405497e-001, 1.429754e-001,
   1.453869e-001, 1.477816e-001, 1.501633e-001, 1.525314e-001, 1.548870e-001, 1.572343e-001, 1.595739e-001, 1.619041e-001, 1.642287e-001,
   1.665419e-001, 1.688466e-001, 1.711441e-001, 1.734281e-001, 1.757041e-001, 1.779716e-001, 1.802266e-001, 1.824685e-001, 1.847028e-001,
   1.869270e-001, 1.891430e-001, 1.913527e-001, 1.935541e-001, 1.957470e-001, 1.979323e-001, 2.001116e-001, 2.022840e-001, 2.044483e-001,
   2.066046e-001, 2.087546e-001, 2.108964e-001, 2.130336e-001, 2.151646e-001, 2.172897e-001, 2.194090e-001, 2.215230e-001, 2.236334e-001,
   2.257399e-001, 2.278428e-001, 2.299395e-001, 2.320352e-001, 2.341277e-001, 2.362148e-001, 2.383003e-001, 2.403819e-001, 2.424598e-001,
   2.445341e-001, 2.466031e-001, 2.486695e-001, 2.507313e-001, 2.527875e-001, 2.548405e-001, 2.568878e-001, 2.589288e-001, 2.609657e-001,
   2.629976e-001, 2.650239e-001, 2.670452e-001, 2.690614e-001, 2.710740e-001, 2.730820e-001, 2.750845e-001, 2.770829e-001, 2.790768e-001,
   2.810665e-001, 2.830520e-001, 2.850325e-001, 2.870062e-001, 2.889752e-001, 2.909403e-001, 2.929002e-001, 2.948523e-001, 2.967999e-001,
   2.987424e-001, 3.006780e-001, 3.026081e-001, 3.045304e-001, 3.064477e-001, 3.083587e-001, 3.102641e-001, 3.121645e-001, 3.140588e-001,
   3.159478e-001, 3.178321e-001, 3.197115e-001, 3.215854e-001, 3.234539e-001, 3.253173e-001, 3.271750e-001, 3.290263e-001, 3.308733e-001,
   3.327147e-001, 3.345507e-001, 3.363827e-001, 3.382077e-001, 3.400275e-001, 3.418430e-001, 3.436523e-001, 3.454572e-001, 3.472560e-001,
   3.490492e-001, 3.508357e-001, 3.526168e-001, 3.543927e-001, 3.561617e-001, 3.579243e-001, 3.596821e-001, 3.614338e-001, 3.631794e-001,
   3.649187e-001, 3.666514e-001, 3.683797e-001, 3.701042e-001, 3.718237e-001, 3.735390e-001, 3.752482e-001, 3.769527e-001, 3.786515e-001,
   3.803469e-001, 3.820369e-001, 3.837210e-001, 3.853998e-001, 3.870728e-001, 3.887416e-001, 3.904061e-001, 3.920668e-001, 3.937225e-001,
   3.953728e-001, 3.970202e-001, 3.986625e-001, 4.003001e-001, 4.019333e-001, 4.035619e-001, 4.051867e-001, 4.068054e-001, 4.084197e-001,
   4.100310e-001, 4.116374e-001, 4.132398e-001, 4.148394e-001, 4.164354e-001, 4.180263e-001, 4.196143e-001, 4.211982e-001, 4.227779e-001,
   4.243544e-001, 4.259255e-001, 4.274937e-001, 4.290582e-001, 4.306178e-001, 4.321742e-001, 4.337241e-001, 4.352709e-001, 4.368133e-001,
   4.383513e-001, 4.398857e-001, 4.414162e-001, 4.429419e-001, 4.444639e-001, 4.459815e-001, 4.474938e-001, 4.490017e-001, 4.505049e-001,
   4.520032e-001, 4.534963e-001, 4.549859e-001, 4.564702e-001, 4.579507e-001, 4.594252e-001, 4.608951e-001, 4.623603e-001, 4.638208e-001,
   4.652769e-001, 4.667274e-001, 4.681745e-001, 4.696162e-001, 4.710546e-001, 4.724894e-001, 4.739204e-001, 4.753461e-001, 4.767679e-001,
   4.781860e-001, 4.795997e-001, 4.810095e-001, 4.824153e-001, 4.838171e-001, 4.852141e-001, 4.866072e-001, 4.879966e-001, 4.893811e-001,
   4.907610e-001, 4.921370e-001, 4.935079e-001, 4.948743e-001, 4.962369e-001, 4.975940e-001, 4.989463e-001, 5.002944e-001, 5.016375e-001,
   5.029762e-001, 5.043101e-001, 5.056411e-001, 5.069678e-001, 5.082890e-001, 5.096068e-001, 5.109207e-001, 5.122312e-001, 5.135380e-001,
   5.148395e-001, 5.161376e-001, 5.174326e-001, 5.187239e-001, 5.200108e-001, 5.212956e-001, 5.225765e-001, 5.238539e-001, 5.251270e-001,
   5.263976e-001, 5.276647e-001, 5.289288e-001, 5.301895e-001, 5.314460e-001, 5.326988e-001, 5.339488e-001, 5.351959e-001, 5.364394e-001,
   5.376781e-001, 5.389128e-001, 5.401439e-001, 5.413711e-001, 5.425948e-001, 5.438155e-001, 5.450334e-001, 5.462481e-001, 5.474585e-001,
   5.486653e-001, 5.498682e-001, 5.510679e-001, 5.522646e-001, 5.534584e-001, 5.546488e-001, 5.558350e-001, 5.570184e-001, 5.581970e-001,
   5.593729e-001, 5.605464e-001, 5.617169e-001, 5.628855e-001, 5.640514e-001, 5.652144e-001, 5.663742e-001, 5.675307e-001, 5.686837e-001,
   5.698335e-001, 5.709814e-001, 5.721262e-001, 5.732678e-001, 5.744062e-001, 5.755408e-001, 5.766719e-001, 5.777991e-001, 5.789228e-001,
   5.800434e-001, 5.811608e-001, 5.822757e-001, 5.833864e-001, 5.844935e-001, 5.855962e-001, 5.866946e-001, 5.877900e-001, 5.888820e-001,
   5.899714e-001, 5.910584e-001, 5.921409e-001, 5.932197e-001, 5.942954e-001, 5.953670e-001, 5.964353e-001, 5.975001e-001, 5.985620e-001,
   5.996207e-001, 6.006759e-001, 6.017287e-001, 6.027787e-001, 6.038259e-001, 6.048711e-001, 6.059128e-001, 6.069513e-001, 6.079871e-001,
   6.090199e-001, 6.100498e-001, 6.110774e-001, 6.121015e-001, 6.131222e-001, 6.141404e-001, 6.151544e-001, 6.161652e-001, 6.171720e-001,
   6.181760e-001, 6.191776e-001, 6.201763e-001, 6.211720e-001, 6.221657e-001, 6.231560e-001, 6.241430e-001, 6.251274e-001, 6.261093e-001,
   6.270888e-001, 6.280658e-001, 6.290399e-001, 6.300118e-001, 6.309817e-001, 6.319492e-001, 6.329147e-001, 6.338775e-001, 6.348380e-001,
   6.357973e-001, 6.367547e-001, 6.377090e-001, 6.386612e-001, 6.396111e-001, 6.405584e-001, 6.415040e-001, 6.424475e-001, 6.433883e-001,
   6.443268e-001, 6.452632e-001, 6.461974e-001, 6.471300e-001, 6.480595e-001, 6.489846e-001, 6.499076e-001, 6.508284e-001, 6.517463e-001,
   6.526614e-001, 6.535751e-001, 6.544869e-001, 6.553963e-001, 6.563038e-001, 6.572084e-001, 6.581105e-001, 6.590103e-001, 6.599075e-001,
   6.608029e-001, 6.616960e-001, 6.625868e-001, 6.634748e-001, 6.643607e-001, 6.652449e-001, 6.661269e-001, 6.670068e-001, 6.678847e-001,
   6.687603e-001, 6.696338e-001, 6.705051e-001, 6.713738e-001, 6.722403e-001, 6.731052e-001, 6.739680e-001, 6.748279e-001, 6.756849e-001,
   6.765397e-001, 6.773922e-001, 6.782424e-001, 6.790905e-001, 6.799357e-001, 6.807790e-001, 6.816211e-001, 6.824613e-001, 6.832992e-001,
   6.841354e-001, 6.849693e-001, 6.858009e-001, 6.866306e-001, 6.874586e-001, 6.882845e-001, 6.891088e-001, 6.899312e-001, 6.907522e-001,
   6.915713e-001, 6.923889e-001, 6.932055e-001, 6.940204e-001, 6.948331e-001, 6.956444e-001, 6.964545e-001, 6.972630e-001, 6.980709e-001,
   6.988765e-001, 6.996802e-001, 7.004820e-001, 7.012829e-001, 7.020820e-001, 7.028784e-001, 7.036729e-001, 7.044662e-001, 7.052567e-001,
   7.060448e-001, 7.068312e-001, 7.076163e-001, 7.084000e-001, 7.091818e-001, 7.099615e-001, 7.107392e-001, 7.115153e-001, 7.122902e-001,
   7.130639e-001, 7.138360e-001, 7.146063e-001, 7.153750e-001, 7.161427e-001, 7.169086e-001, 7.176714e-001, 7.184334e-001, 7.191948e-001,
   7.199551e-001, 7.207136e-001, 7.214710e-001, 7.222273e-001, 7.229821e-001, 7.237351e-001, 7.244873e-001, 7.252385e-001, 7.259878e-001,
   7.267357e-001, 7.274823e-001, 7.282280e-001, 7.289722e-001, 7.297146e-001, 7.304559e-001, 7.311956e-001, 7.319334e-001, 7.326702e-001,
   7.334058e-001, 7.341401e-001, 7.348725e-001, 7.356036e-001, 7.363326e-001, 7.370595e-001, 7.377838e-001, 7.385062e-001, 7.392276e-001,
   7.399476e-001, 7.406657e-001, 7.413815e-001, 7.420955e-001, 7.428083e-001, 7.435197e-001, 7.442295e-001, 7.449381e-001, 7.456450e-001,
   7.463493e-001, 7.470524e-001, 7.477545e-001, 7.484556e-001, 7.491544e-001, 7.498516e-001, 7.505475e-001, 7.512428e-001, 7.519365e-001,
   7.526290e-001, 7.533205e-001, 7.540111e-001, 7.547005e-001, 7.553885e-001, 7.560757e-001, 7.567612e-001, 7.574450e-001, 7.581269e-001,
   7.588078e-001, 7.594872e-001, 7.601647e-001, 7.608397e-001, 7.615131e-001, 7.621848e-001, 7.628556e-001, 7.635244e-001, 7.641918e-001,
   7.648576e-001, 7.655221e-001, 7.661856e-001, 7.668478e-001, 7.675096e-001, 7.681704e-001, 7.688298e-001, 7.694874e-001, 7.701442e-001,
   7.708006e-001, 7.714566e-001, 7.721111e-001, 7.727647e-001, 7.734175e-001, 7.740696e-001, 7.747209e-001, 7.753715e-001, 7.760213e-001,
   7.766698e-001, 7.773165e-001, 7.779616e-001, 7.786055e-001, 7.792483e-001, 7.798897e-001, 7.805297e-001, 7.811681e-001, 7.818059e-001,
   7.824431e-001, 7.830795e-001, 7.837143e-001, 7.843478e-001, 7.849804e-001, 7.856122e-001, 7.862434e-001, 7.868737e-001, 7.875034e-001,
   7.881315e-001, 7.887587e-001, 7.893850e-001, 7.900109e-001, 7.906364e-001, 7.912619e-001, 7.918865e-001, 7.925099e-001, 7.931321e-001,
   7.937540e-001, 7.943754e-001, 7.949960e-001, 7.956153e-001, 7.962338e-001, 7.968516e-001, 7.974686e-001, 7.980840e-001, 7.986981e-001,
   7.993113e-001, 7.999234e-001, 8.005342e-001, 8.011433e-001, 8.017515e-001, 8.023587e-001, 8.029649e-001, 8.035695e-001, 8.041722e-001,
   8.047736e-001, 8.053747e-001, 8.059753e-001, 8.065749e-001, 8.071730e-001, 8.077706e-001, 8.083676e-001, 8.089641e-001, 8.095600e-001,
   8.101552e-001, 8.107499e-001, 8.113440e-001, 8.119368e-001, 8.125279e-001, 8.131183e-001, 8.137079e-001, 8.142971e-001, 8.148864e-001,
   8.154749e-001, 8.160624e-001, 8.166492e-001, 8.172353e-001, 8.178209e-001, 8.184058e-001, 8.189893e-001, 8.195708e-001, 8.201507e-001,
   8.207299e-001, 8.213078e-001, 8.218841e-001, 8.224596e-001, 8.230342e-001, 8.236078e-001, 8.241803e-001, 8.247514e-001, 8.253219e-001,
   8.258914e-001, 8.264596e-001, 8.270267e-001, 8.275923e-001, 8.281567e-001, 8.287201e-001, 8.292832e-001, 8.298456e-001, 8.304071e-001,
   8.309677e-001, 8.315275e-001, 8.320871e-001, 8.326465e-001, 8.332050e-001, 8.337630e-001, 8.343207e-001, 8.348772e-001, 8.354332e-001,
   8.359882e-001, 8.365424e-001, 8.370960e-001, 8.376492e-001, 8.382020e-001, 8.387537e-001, 8.393034e-001, 8.398514e-001, 8.403982e-001,
   8.409439e-001, 8.414888e-001, 8.420314e-001, 8.425724e-001, 8.431122e-001, 8.436513e-001, 8.441898e-001, 8.447275e-001, 8.452641e-001,
   8.457995e-001, 8.463338e-001, 8.468673e-001, 8.474001e-001, 8.479313e-001, 8.484619e-001, 8.489916e-001, 8.495206e-001, 8.500489e-001,
   8.505759e-001, 8.511019e-001, 8.516276e-001, 8.521532e-001, 8.526788e-001, 8.532041e-001, 8.537274e-001, 8.542500e-001, 8.547719e-001,
   8.552934e-001, 8.558142e-001, 8.563345e-001, 8.568541e-001, 8.573727e-001, 8.578908e-001, 8.584080e-001, 8.589247e-001, 8.594402e-001,
   8.599549e-001, 8.604689e-001, 8.609809e-001, 8.614913e-001, 8.620006e-001, 8.625081e-001, 8.630143e-001, 8.635199e-001, 8.640247e-001,
   8.645286e-001, 8.650318e-001, 8.655342e-001, 8.660358e-001, 8.665362e-001, 8.670353e-001, 8.675341e-001, 8.680320e-001, 8.685293e-001,
   8.690256e-001, 8.695210e-001, 8.700148e-001, 8.705079e-001, 8.710004e-001, 8.714923e-001, 8.719839e-001, 8.724751e-001, 8.729660e-001,
   8.734568e-001, 8.739459e-001, 8.744347e-001, 8.749232e-001, 8.754115e-001, 8.758991e-001, 8.763859e-001, 8.768713e-001, 8.773560e-001,
   8.778394e-001, 8.783218e-001, 8.788030e-001, 8.792834e-001, 8.797630e-001, 8.802419e-001, 8.807204e-001, 8.811979e-001, 8.816744e-001,
   8.821505e-001, 8.826258e-001, 8.831009e-001, 8.835756e-001, 8.840499e-001, 8.845239e-001, 8.849976e-001, 8.854704e-001, 8.859428e-001,
   8.864150e-001, 8.868866e-001, 8.873580e-001, 8.878287e-001, 8.882986e-001, 8.887683e-001, 8.892373e-001, 8.897059e-001, 8.901739e-001,
   8.906407e-001, 8.911065e-001, 8.915716e-001, 8.920358e-001, 8.924988e-001, 8.929612e-001, 8.934233e-001, 8.938844e-001, 8.943450e-001,
   8.948051e-001, 8.952646e-001, 8.957233e-001, 8.961818e-001, 8.966400e-001, 8.970972e-001, 8.975541e-001, 8.980107e-001, 8.984668e-001,
   8.989224e-001, 8.993777e-001, 8.998324e-001, 9.002873e-001, 9.007422e-001, 9.011971e-001, 9.016515e-001, 9.021055e-001, 9.025588e-001,
   9.030118e-001, 9.034647e-001, 9.039173e-001, 9.043691e-001, 9.048198e-001, 9.052697e-001, 9.057189e-001, 9.061676e-001, 9.066155e-001,
   9.070628e-001, 9.075091e-001, 9.079547e-001, 9.083993e-001, 9.088430e-001, 9.092861e-001, 9.097289e-001, 9.101710e-001, 9.106125e-001,
   9.110534e-001, 9.114935e-001, 9.119334e-001, 9.123729e-001, 9.128117e-001, 9.132502e-001, 9.136887e-001, 9.141261e-001, 9.145633e-001,
   9.150005e-001, 9.154379e-001, 9.158750e-001, 9.163116e-001, 9.167482e-001, 9.171846e-001, 9.176209e-001, 9.180570e-001, 9.184931e-001,
   9.189291e-001, 9.193650e-001, 9.198002e-001, 9.202344e-001, 9.206675e-001, 9.211001e-001, 9.215318e-001, 9.219623e-001, 9.223921e-001,
   9.228206e-001, 9.232483e-001, 9.236752e-001, 9.241015e-001, 9.245273e-001, 9.249527e-001, 9.253776e-001, 9.258018e-001, 9.262260e-001,
   9.266500e-001, 9.270736e-001, 9.274966e-001, 9.279189e-001, 9.283404e-001, 9.287611e-001, 9.291817e-001, 9.296025e-001, 9.300234e-001,
   9.304442e-001, 9.308649e-001, 9.312853e-001, 9.317051e-001, 9.321247e-001, 9.325440e-001, 9.329630e-001, 9.333813e-001, 9.337989e-001,
   9.342158e-001, 9.346318e-001, 9.350470e-001, 9.354616e-001, 9.358757e-001, 9.362891e-001, 9.367019e-001, 9.371142e-001, 9.375252e-001,
   9.379359e-001, 9.383464e-001, 9.387562e-001, 9.391652e-001, 9.395733e-001, 9.399811e-001, 9.403880e-001, 9.407948e-001, 9.412017e-001,
   9.416088e-001, 9.420160e-001, 9.424232e-001, 9.428301e-001, 9.432357e-001, 9.436407e-001, 9.440456e-001, 9.444499e-001, 9.448543e-001,
   9.452587e-001, 9.456630e-001, 9.460668e-001, 9.464702e-001, 9.468731e-001, 9.472752e-001, 9.476769e-001, 9.480781e-001, 9.484789e-001,
   9.488786e-001, 9.492763e-001, 9.496733e-001, 9.500697e-001, 9.504652e-001, 9.508601e-001, 9.512542e-001, 9.516477e-001, 9.520401e-001,
   9.524325e-001, 9.528247e-001, 9.532167e-001, 9.536083e-001, 9.539985e-001, 9.543878e-001, 9.547762e-001, 9.551640e-001, 9.555517e-001,
   9.559390e-001, 9.563265e-001, 9.567139e-001, 9.571011e-001, 9.574878e-001, 9.578741e-001, 9.582601e-001, 9.586452e-001, 9.590301e-001,
   9.594146e-001, 9.597986e-001, 9.601827e-001, 9.605663e-001, 9.609499e-001, 9.613334e-001, 9.617168e-001, 9.621000e-001, 9.624829e-001,
   9.628657e-001, 9.632470e-001, 9.636274e-001, 9.640080e-001, 9.643889e-001, 9.647693e-001, 9.651495e-001, 9.655296e-001, 9.659094e-001,
   9.662882e-001, 9.666668e-001, 9.670450e-001, 9.674231e-001, 9.678013e-001, 9.681793e-001, 9.685573e-001, 9.689350e-001, 9.693117e-001,
   9.696878e-001, 9.700628e-001, 9.704373e-001, 9.708112e-001, 9.711849e-001, 9.715584e-001, 9.719319e-001, 9.723043e-001, 9.726759e-001,
   9.730465e-001, 9.734168e-001, 9.737866e-001, 9.741559e-001, 9.745245e-001, 9.748921e-001, 9.752583e-001, 9.756247e-001, 9.759911e-001,
   9.763572e-001, 9.767229e-001, 9.770882e-001, 9.774521e-001, 9.778142e-001, 9.781752e-001, 9.785354e-001, 9.788955e-001, 9.792559e-001,
   9.796167e-001, 9.799774e-001, 9.803373e-001, 9.806962e-001, 9.810546e-001, 9.814132e-001, 9.817717e-001, 9.821283e-001, 9.824845e-001,
   9.828408e-001, 9.831978e-001, 9.835534e-001, 9.839081e-001, 9.842627e-001, 9.846173e-001, 9.849717e-001, 9.853253e-001, 9.856776e-001,
   9.860290e-001, 9.863792e-001, 9.867276e-001, 9.870745e-001, 9.874211e-001, 9.877674e-001, 9.881133e-001, 9.884589e-001, 9.888046e-001,
   9.891491e-001, 9.894908e-001, 9.898319e-001, 9.901736e-001, 9.905145e-001, 9.908552e-001, 9.911950e-001, 9.915323e-001, 9.918691e-001,
   9.922037e-001, 9.925383e-001, 9.928728e-001, 9.932051e-001, 9.935379e-001, 9.938715e-001, 9.942054e-001, 9.945395e-001, 9.948709e-001,
   9.952013e-001, 9.955306e-001, 9.958570e-001, 9.961821e-001, 9.965066e-001, 9.968276e-001, 9.971488e-001, 9.974682e-001, 9.977856e-001,
   9.981028e-001, 9.984198e-001, 9.987365e-001, 9.990528e-001, 9.993689e-001, 9.996846e-001, 1.000000e+000},
  {0.000000e+000,  -1.452326e-003, -2.133227e-003, -2.674255e-003, -3.149903e-003, -3.582399e-003, -3.980914e-003, -4.359803e-003, -4.725236e-003,
   -5.080627e-003, -5.427092e-003, -5.765801e-003, -6.098779e-003, -6.426347e-003, -6.750412e-003, -7.071325e-003, -7.389887e-003, -7.705940e-003,
   -8.018821e-003, -8.329350e-003, -8.636635e-003, -8.939656e-003, -9.239358e-003, -9.535422e-003, -9.828782e-003, -1.011918e-002, -1.040701e-002,
   -1.069241e-002, -1.097627e-002, -1.125855e-002, -1.153943e-002, -1.181888e-002, -1.209722e-002, -1.237451e-002, -1.265082e-002, -1.292588e-002,
   -1.319994e-002, -1.347363e-002, -1.374673e-002, -1.401901e-002, -1.429037e-002, -1.456117e-002, -1.483101e-002, -1.509930e-002, -1.536673e-002,
   -1.563288e-002, -1.589735e-002, -1.616107e-002, -1.642365e-002, -1.668546e-002, -1.694699e-002, -1.720795e-002, -1.746800e-002, -1.772795e-002,
   -1.798663e-002, -1.824441e-002, -1.850145e-002, -1.875670e-002, -1.901103e-002, -1.926427e-002, -1.951601e-002, -1.976624e-002, -2.001590e-002,
   -2.026443e-002, -2.051216e-002, -2.075924e-002, -2.100532e-002, -2.125028e-002, -2.149434e-002, -2.173771e-002, -2.198008e-002, -2.222141e-002,
   -2.246182e-002, -2.270150e-002, -2.293991e-002, -2.317745e-002, -2.341402e-002, -2.364972e-002, -2.388422e-002, -2.411771e-002, -2.435039e-002,
   -2.458214e-002, -2.481298e-002, -2.504251e-002, -2.527139e-002, -2.549926e-002, -2.572567e-002, -2.595116e-002, -2.617529e-002, -2.639808e-002,
   -2.661950e-002, -2.683932e-002, -2.705793e-002, -2.727509e-002, -2.749054e-002, -2.770478e-002, -2.791765e-002, -2.812906e-002, -2.833907e-002,
   -2.854777e-002, -2.875515e-002, -2.896148e-002, -2.916651e-002, -2.937037e-002, -2.957319e-002, -2.977480e-002, -2.997510e-002, -3.017387e-002,
   -3.037131e-002, -3.056735e-002, -3.076189e-002, -3.095487e-002, -3.114650e-002, -3.133707e-002, -3.152595e-002, -3.171299e-002, -3.189852e-002,
   -3.208257e-002, -3.226478e-002, -3.244534e-002, -3.262393e-002, -3.280084e-002, -3.297597e-002, -3.314928e-002, -3.332076e-002, -3.349039e-002,
   -3.365804e-002, -3.382414e-002, -3.398861e-002, -3.415137e-002, -3.431267e-002, -3.447234e-002, -3.463056e-002, -3.478694e-002, -3.494207e-002,
   -3.509573e-002, -3.524784e-002, -3.539876e-002, -3.554815e-002, -3.569617e-002, -3.584304e-002, -3.598837e-002, -3.613225e-002, -3.627470e-002,
   -3.641544e-002, -3.655459e-002, -3.669223e-002, -3.682852e-002, -3.696315e-002, -3.709616e-002, -3.722770e-002, -3.735784e-002, -3.748648e-002,
   -3.761366e-002, -3.773904e-002, -3.786323e-002, -3.798581e-002, -3.810706e-002, -3.822713e-002, -3.834571e-002, -3.846347e-002, -3.857978e-002,
   -3.869504e-002, -3.880919e-002, -3.892227e-002, -3.903446e-002, -3.914561e-002, -3.925559e-002, -3.936454e-002, -3.947248e-002, -3.957931e-002,
   -3.968514e-002, -3.978970e-002, -3.989321e-002, -3.999547e-002, -4.009679e-002, -4.019671e-002, -4.029567e-002, -4.039327e-002, -4.048966e-002,
   -4.058472e-002, -4.067842e-002, -4.077072e-002, -4.086172e-002, -4.095115e-002, -4.103928e-002, -4.112599e-002, -4.121130e-002, -4.129514e-002,
   -4.137745e-002, -4.145831e-002, -4.153784e-002, -4.161594e-002, -4.169268e-002, -4.176806e-002, -4.184201e-002, -4.191495e-002, -4.198670e-002,
   -4.205730e-002, -4.212682e-002, -4.219527e-002, -4.226271e-002, -4.232926e-002, -4.239516e-002, -4.246016e-002, -4.252416e-002, -4.258751e-002,
   -4.264987e-002, -4.271121e-002, -4.277182e-002, -4.283147e-002, -4.289001e-002, -4.294758e-002, -4.300416e-002, -4.305989e-002, -4.311482e-002,
   -4.316872e-002, -4.322183e-002, -4.327415e-002, -4.332560e-002, -4.337624e-002, -4.342598e-002, -4.347473e-002, -4.352182e-002, -4.356825e-002,
   -4.361366e-002, -4.365823e-002, -4.370212e-002, -4.374504e-002, -4.378715e-002, -4.382844e-002, -4.386884e-002, -4.390862e-002, -4.394763e-002,
   -4.398574e-002, -4.402313e-002, -4.405966e-002, -4.409571e-002, -4.413102e-002, -4.416548e-002, -4.419924e-002, -4.423225e-002, -4.426458e-002,
   -4.429625e-002, -4.432721e-002, -4.435773e-002, -4.438731e-002, -4.441590e-002, -4.444384e-002, -4.447094e-002, -4.449737e-002, -4.452283e-002,
   -4.454739e-002, -4.457123e-002, -4.459430e-002, -4.461653e-002, -4.463811e-002, -4.465908e-002, -4.467913e-002, -4.469845e-002, -4.471662e-002,
   -4.473380e-002, -4.475009e-002, -4.476545e-002, -4.477980e-002, -4.479333e-002, -4.480625e-002, -4.481868e-002, -4.483077e-002, -4.484231e-002,
   -4.485350e-002, -4.486444e-002, -4.487481e-002, -4.488466e-002, -4.489428e-002, -4.490342e-002, -4.491209e-002, -4.492045e-002, -4.492805e-002,
   -4.493506e-002, -4.494158e-002, -4.494787e-002, -4.495373e-002, -4.495914e-002, -4.496418e-002, -4.496864e-002, -4.497266e-002, -4.497585e-002,
   -4.497837e-002, -4.498044e-002, -4.498202e-002, -4.498301e-002, -4.498330e-002, -4.498296e-002, -4.498195e-002, -4.498020e-002, -4.497782e-002,
   -4.497470e-002, -4.497100e-002, -4.496672e-002, -4.496213e-002, -4.495708e-002, -4.495139e-002, -4.494517e-002, -4.493846e-002, -4.493136e-002,
   -4.492396e-002, -4.491610e-002, -4.490805e-002, -4.489969e-002, -4.489106e-002, -4.488211e-002, -4.487255e-002, -4.486277e-002, -4.485249e-002,
   -4.484181e-002, -4.483081e-002, -4.481932e-002, -4.480724e-002, -4.479465e-002, -4.478147e-002, -4.476786e-002, -4.475389e-002, -4.473952e-002,
   -4.472469e-002, -4.470938e-002, -4.469373e-002, -4.467754e-002, -4.466059e-002, -4.464314e-002, -4.462507e-002, -4.460638e-002, -4.458708e-002,
   -4.456743e-002, -4.454741e-002, -4.452720e-002, -4.450653e-002, -4.448564e-002, -4.446457e-002, -4.444315e-002, -4.442160e-002, -4.439973e-002,
   -4.437771e-002, -4.435557e-002, -4.433333e-002, -4.431076e-002, -4.428809e-002, -4.426507e-002, -4.424180e-002, -4.421827e-002, -4.419435e-002,
   -4.416995e-002, -4.414517e-002, -4.411995e-002, -4.409431e-002, -4.406830e-002, -4.404176e-002, -4.401464e-002, -4.398713e-002, -4.395903e-002,
   -4.393053e-002, -4.390148e-002, -4.387187e-002, -4.384186e-002, -4.381149e-002, -4.378073e-002, -4.374977e-002, -4.371862e-002, -4.368725e-002,
   -4.365557e-002, -4.362372e-002, -4.359164e-002, -4.355944e-002, -4.352701e-002, -4.349412e-002, -4.346092e-002, -4.342764e-002, -4.339421e-002,
   -4.336059e-002, -4.332684e-002, -4.329287e-002, -4.325861e-002, -4.322421e-002, -4.318963e-002, -4.315485e-002, -4.311988e-002, -4.308463e-002,
   -4.304913e-002, -4.301337e-002, -4.297723e-002, -4.294067e-002, -4.290364e-002, -4.286630e-002, -4.282879e-002, -4.279104e-002, -4.275296e-002,
   -4.271456e-002, -4.267588e-002, -4.263693e-002, -4.259777e-002, -4.255827e-002, -4.251860e-002, -4.247873e-002, -4.243858e-002, -4.239825e-002,
   -4.235783e-002, -4.231732e-002, -4.227674e-002, -4.223604e-002, -4.219519e-002, -4.215421e-002, -4.211319e-002, -4.207202e-002, -4.203058e-002,
   -4.198890e-002, -4.194710e-002, -4.190514e-002, -4.186294e-002, -4.182052e-002, -4.177779e-002, -4.173476e-002, -4.169156e-002, -4.164812e-002,
   -4.160442e-002, -4.156042e-002, -4.151617e-002, -4.147183e-002, -4.142717e-002, -4.138201e-002, -4.133632e-002, -4.129025e-002, -4.124396e-002,
   -4.119736e-002, -4.115062e-002, -4.110383e-002, -4.105702e-002, -4.101012e-002, -4.096321e-002, -4.091652e-002, -4.086999e-002, -4.082333e-002,
   -4.077658e-002, -4.072966e-002, -4.068264e-002, -4.063561e-002, -4.058844e-002, -4.054119e-002, -4.049385e-002, -4.044649e-002, -4.039923e-002,
   -4.035198e-002, -4.030469e-002, -4.025731e-002, -4.020983e-002, -4.016225e-002, -4.011440e-002, -4.006619e-002, -4.001770e-002, -3.996890e-002,
   -3.991991e-002, -3.987055e-002, -3.982097e-002, -3.977121e-002, -3.972128e-002, -3.967103e-002, -3.962057e-002, -3.956995e-002, -3.951911e-002,
   -3.946820e-002, -3.941725e-002, -3.936621e-002, -3.931499e-002, -3.926351e-002, -3.921183e-002, -3.915993e-002, -3.910795e-002, -3.905590e-002,
   -3.900372e-002, -3.895139e-002, -3.889896e-002, -3.884661e-002, -3.879430e-002, -3.874202e-002, -3.868974e-002, -3.863756e-002, -3.858543e-002,
   -3.853330e-002, -3.848104e-002, -3.842885e-002, -3.837659e-002, -3.832437e-002, -3.827206e-002, -3.821967e-002, -3.816718e-002, -3.811467e-002,
   -3.806202e-002, -3.800927e-002, -3.795642e-002, -3.790338e-002, -3.785004e-002, -3.779642e-002, -3.774283e-002, -3.768910e-002, -3.763511e-002,
   -3.758087e-002, -3.752642e-002, -3.747180e-002, -3.741704e-002, -3.736217e-002, -3.730733e-002, -3.725246e-002, -3.719750e-002, -3.714247e-002,
   -3.708753e-002, -3.703262e-002, -3.697800e-002, -3.692337e-002, -3.686882e-002, -3.681430e-002, -3.675979e-002, -3.670506e-002, -3.665026e-002,
   -3.659535e-002, -3.654034e-002, -3.648529e-002, -3.643007e-002, -3.637474e-002, -3.631929e-002, -3.626369e-002, -3.620801e-002, -3.615226e-002,
   -3.609632e-002, -3.604017e-002, -3.598370e-002, -3.592686e-002, -3.586971e-002, -3.581237e-002, -3.575475e-002, -3.569686e-002, -3.563889e-002,
   -3.558077e-002, -3.552268e-002, -3.546456e-002, -3.540657e-002, -3.534881e-002, -3.529128e-002, -3.523379e-002, -3.517636e-002, -3.511898e-002,
   -3.506159e-002, -3.500414e-002, -3.494666e-002, -3.488908e-002, -3.483150e-002, -3.477383e-002, -3.471608e-002, -3.465814e-002, -3.460010e-002,
   -3.454205e-002, -3.448395e-002, -3.442572e-002, -3.436726e-002, -3.430844e-002, -3.424929e-002, -3.418989e-002, -3.413021e-002, -3.407043e-002,
   -3.401052e-002, -3.395045e-002, -3.389023e-002, -3.382983e-002, -3.376928e-002, -3.370871e-002, -3.364813e-002, -3.358757e-002, -3.352692e-002,
   -3.346630e-002, -3.340576e-002, -3.334525e-002, -3.328481e-002, -3.322440e-002, -3.316406e-002, -3.310386e-002, -3.304379e-002, -3.298377e-002,
   -3.292377e-002, -3.286372e-002, -3.280355e-002, -3.274319e-002, -3.268266e-002, -3.262198e-002, -3.256111e-002, -3.250009e-002, -3.243891e-002,
   -3.237754e-002, -3.231607e-002, -3.225447e-002, -3.219283e-002, -3.213101e-002, -3.206899e-002, -3.200680e-002, -3.194430e-002, -3.188145e-002,
   -3.181831e-002, -3.175498e-002, -3.169153e-002, -3.162793e-002, -3.156425e-002, -3.150052e-002, -3.143672e-002, -3.137295e-002, -3.130926e-002,
   -3.124574e-002, -3.118237e-002, -3.111912e-002, -3.105597e-002, -3.099290e-002, -3.092988e-002, -3.086698e-002, -3.080408e-002, -3.074124e-002,
   -3.067840e-002, -3.061561e-002, -3.055281e-002, -3.048987e-002, -3.042686e-002, -3.036359e-002, -3.030020e-002, -3.023671e-002, -3.017308e-002,
   -3.010935e-002, -3.004546e-002, -2.998135e-002, -2.991703e-002, -2.985247e-002, -2.978771e-002, -2.972264e-002, -2.965720e-002, -2.959146e-002,
   -2.952556e-002, -2.945951e-002, -2.939339e-002, -2.932716e-002, -2.926086e-002, -2.919452e-002, -2.912804e-002, -2.906153e-002, -2.899507e-002,
   -2.892880e-002, -2.886262e-002, -2.879658e-002, -2.873073e-002, -2.866496e-002, -2.859924e-002, -2.853353e-002, -2.846785e-002, -2.840220e-002,
   -2.833658e-002, -2.827092e-002, -2.820524e-002, -2.813952e-002, -2.807372e-002, -2.800790e-002, -2.794213e-002, -2.787632e-002, -2.781050e-002,
   -2.774459e-002, -2.767845e-002, -2.761209e-002, -2.754545e-002, -2.747860e-002, -2.741149e-002, -2.734402e-002, -2.727633e-002, -2.720847e-002,
   -2.714041e-002, -2.707219e-002, -2.700379e-002, -2.693523e-002, -2.686658e-002, -2.679786e-002, -2.672913e-002, -2.666035e-002, -2.659160e-002,
   -2.652289e-002, -2.645426e-002, -2.638563e-002, -2.631707e-002, -2.624859e-002, -2.618019e-002, -2.611194e-002, -2.604383e-002, -2.597575e-002,
   -2.590775e-002, -2.583979e-002, -2.577181e-002, -2.570380e-002, -2.563576e-002, -2.556754e-002, -2.549921e-002, -2.543084e-002, -2.536250e-002,
   -2.529422e-002, -2.522590e-002, -2.515742e-002, -2.508879e-002, -2.501993e-002, -2.495078e-002, -2.488133e-002, -2.481160e-002, -2.474170e-002,
   -2.467165e-002, -2.460146e-002, -2.453125e-002, -2.446102e-002, -2.439082e-002, -2.432065e-002, -2.425063e-002, -2.418066e-002, -2.411074e-002,
   -2.404082e-002, -2.397092e-002, -2.390089e-002, -2.383077e-002, -2.376058e-002, -2.369044e-002, -2.362035e-002, -2.355029e-002, -2.348017e-002,
   -2.340993e-002, -2.333951e-002, -2.326897e-002, -2.319835e-002, -2.312768e-002, -2.305693e-002, -2.298606e-002, -2.291496e-002, -2.284367e-002,
   -2.277219e-002, -2.270046e-002, -2.262853e-002, -2.255652e-002, -2.248440e-002, -2.241222e-002, -2.234001e-002, -2.226780e-002, -2.219553e-002,
   -2.212314e-002, -2.205074e-002, -2.197841e-002, -2.190626e-002, -2.183424e-002, -2.176229e-002, -2.169028e-002, -2.161810e-002, -2.154568e-002,
   -2.147305e-002, -2.140035e-002, -2.132762e-002, -2.125478e-002, -2.118175e-002, -2.110860e-002, -2.103531e-002, -2.096183e-002, -2.088818e-002,
   -2.081438e-002, -2.074048e-002, -2.066639e-002, -2.059209e-002, -2.051752e-002, -2.044265e-002, -2.036751e-002, -2.029207e-002, -2.021638e-002,
   -2.014058e-002, -2.006472e-002, -1.998890e-002, -1.991314e-002, -1.983744e-002, -1.976183e-002, -1.968627e-002, -1.961074e-002, -1.953539e-002,
   -1.946019e-002, -1.938501e-002, -1.930989e-002, -1.923479e-002, -1.915966e-002, -1.908452e-002, -1.900944e-002, -1.893439e-002, -1.885926e-002,
   -1.878408e-002, -1.870884e-002, -1.863348e-002, -1.855796e-002, -1.848231e-002, -1.840652e-002, -1.833057e-002, -1.825440e-002, -1.817798e-002,
   -1.810133e-002, -1.802449e-002, -1.794747e-002, -1.787021e-002, -1.779264e-002, -1.771478e-002, -1.763670e-002, -1.755842e-002, -1.747999e-002,
   -1.740148e-002, -1.732291e-002, -1.724431e-002, -1.716563e-002, -1.708696e-002, -1.700842e-002, -1.693010e-002, -1.685210e-002, -1.677433e-002,
   -1.669677e-002, -1.661930e-002, -1.654190e-002, -1.646447e-002, -1.638702e-002, -1.630954e-002, -1.623204e-002, -1.615443e-002, -1.607676e-002,
   -1.599907e-002, -1.592144e-002, -1.584389e-002, -1.576632e-002, -1.568863e-002, -1.561081e-002, -1.553288e-002, -1.545472e-002, -1.537633e-002,
   -1.529772e-002, -1.521894e-002, -1.513999e-002, -1.506083e-002, -1.498161e-002, -1.490233e-002, -1.482310e-002, -1.474395e-002, -1.466488e-002,
   -1.458589e-002, -1.450702e-002, -1.442836e-002, -1.434983e-002, -1.427133e-002, -1.419289e-002, -1.411455e-002, -1.403623e-002, -1.395785e-002,
   -1.387951e-002, -1.380115e-002, -1.372280e-002, -1.364444e-002, -1.356610e-002, -1.348754e-002, -1.340874e-002, -1.332979e-002, -1.325070e-002,
   -1.317143e-002, -1.309201e-002, -1.301245e-002, -1.293275e-002, -1.285271e-002, -1.277242e-002, -1.269182e-002, -1.261105e-002, -1.253009e-002,
   -1.244900e-002, -1.236778e-002, -1.228641e-002, -1.220500e-002, -1.212366e-002, -1.204226e-002, -1.196090e-002, -1.187970e-002, -1.179848e-002,
   -1.171736e-002, -1.163649e-002, -1.155585e-002, -1.147541e-002, -1.139521e-002, -1.131516e-002, -1.123521e-002, -1.115536e-002, -1.107554e-002,
   -1.099559e-002, -1.091568e-002, -1.083583e-002, -1.075604e-002, -1.067644e-002, -1.059687e-002, -1.051720e-002, -1.043748e-002, -1.035779e-002,
   -1.027803e-002, -1.019800e-002, -1.011781e-002, -1.003758e-002, -9.957239e-003, -9.876816e-003, -9.796439e-003, -9.716210e-003, -9.636026e-003,
   -9.555834e-003, -9.475533e-003, -9.395003e-003, -9.314153e-003, -9.233184e-003, -9.152170e-003, -9.071143e-003, -8.990137e-003, -8.909167e-003,
   -8.828271e-003, -8.747499e-003, -8.666663e-003, -8.585664e-003, -8.504367e-003, -8.422923e-003, -8.341348e-003, -8.259648e-003, -8.177829e-003,
   -8.095776e-003, -8.013583e-003, -7.931298e-003, -7.848872e-003, -7.766315e-003, -7.683466e-003, -7.600526e-003, -7.517544e-003, -7.434385e-003,
   -7.351137e-003, -7.267938e-003, -7.184759e-003, -7.101645e-003, -7.018527e-003, -6.935418e-003, -6.851983e-003, -6.768426e-003, -6.685034e-003,
   -6.601836e-003, -6.518750e-003, -6.435825e-003, -6.353018e-003, -6.270365e-003, -6.187727e-003, -6.105019e-003, -6.022069e-003, -5.938993e-003,
   -5.855980e-003, -5.773054e-003, -5.690185e-003, -5.607578e-003, -5.525072e-003, -5.442573e-003, -5.360150e-003, -5.277665e-003, -5.194958e-003,
   -5.111897e-003, -5.028772e-003, -4.945543e-003, -4.862157e-003, -4.778586e-003, -4.694894e-003, -4.611060e-003, -4.527402e-003, -4.443631e-003,
   -4.359563e-003, -4.274865e-003, -4.189983e-003, -4.104942e-003, -4.019846e-003, -3.934731e-003, -3.849588e-003, -3.764451e-003, -3.679434e-003,
   -3.594517e-003, -3.509579e-003, -3.424345e-003, -3.339334e-003, -3.254477e-003, -3.169773e-003, -3.085151e-003, -3.000545e-003, -2.915934e-003,
   -2.831347e-003, -2.746836e-003, -2.662332e-003, -2.577334e-003, -2.492046e-003, -2.406713e-003, -2.321474e-003, -2.236671e-003, -2.151859e-003,
   -2.066829e-003, -1.981710e-003, -1.896570e-003, -1.811610e-003, -1.726102e-003, -1.639910e-003, -1.553454e-003, -1.466765e-003, -1.379805e-003,
   -1.292726e-003, -1.205572e-003, -1.118955e-003, -1.032592e-003, -9.464431e-004, -8.607769e-004, -7.746067e-004, -6.883249e-004, -6.019335e-004,
   -5.156037e-004, -4.293733e-004, -3.432325e-004, -2.572296e-004, -1.713395e-004, -8.560801e-005, -1.734677e-018},
  {0.000000e+000,  -6.834736e-003, -1.030655e-002, -1.309653e-002, -1.550273e-002, -1.765338e-002, -1.961569e-002, -2.144469e-002, -2.316949e-002,
   -2.480979e-002, -2.637446e-002, -2.787000e-002, -2.930205e-002, -3.067509e-002, -3.199528e-002, -3.326566e-002, -3.448766e-002, -3.566654e-002,
   -3.680414e-002, -3.790353e-002, -3.896870e-002, -3.999961e-002, -4.099430e-002, -4.195820e-002, -4.289104e-002, -4.379444e-002, -4.467011e-002,
   -4.551842e-002, -4.634050e-002, -4.713816e-002, -4.791264e-002, -4.866400e-002, -4.939394e-002, -5.010301e-002, -5.079321e-002, -5.146556e-002,
   -5.212060e-002, -5.275808e-002, -5.338037e-002, -5.398612e-002, -5.457620e-002, -5.515033e-002, -5.570914e-002, -5.625304e-002, -5.678294e-002,
   -5.729777e-002, -5.779807e-002, -5.828404e-002, -5.875630e-002, -5.921497e-002, -5.966021e-002, -6.009192e-002, -6.051124e-002, -6.091733e-002,
   -6.131049e-002, -6.169107e-002, -6.205854e-002, -6.241281e-002, -6.275280e-002, -6.307833e-002, -6.339045e-002, -6.368931e-002, -6.397532e-002,
   -6.424917e-002, -6.450968e-002, -6.475804e-002, -6.499499e-002, -6.522048e-002, -6.543458e-002, -6.563702e-002, -6.582738e-002, -6.600698e-002,
   -6.617651e-002, -6.633596e-002, -6.648488e-002, -6.662203e-002, -6.674955e-002, -6.686704e-002, -6.697447e-002, -6.707293e-002, -6.716189e-002,
   -6.724087e-002, -6.731006e-002, -6.737121e-002, -6.742258e-002, -6.746481e-002, -6.749928e-002, -6.752386e-002, -6.753829e-002, -6.754365e-002,
   -6.754009e-002, -6.752833e-002, -6.750745e-002, -6.747733e-002, -6.743835e-002, -6.738998e-002, -6.733389e-002, -6.726971e-002, -6.719592e-002,
   -6.711396e-002, -6.702469e-002, -6.692758e-002, -6.682206e-002, -6.670795e-002, -6.658773e-002, -6.646093e-002, -6.632665e-002, -6.618518e-002,
   -6.603761e-002, -6.588456e-002, -6.572434e-002, -6.555916e-002, -6.538862e-002, -6.521215e-002, -6.502931e-002, -6.484248e-002, -6.464931e-002,
   -6.445091e-002, -6.424875e-002, -6.404104e-002, -6.382964e-002, -6.361353e-002, -6.339300e-002, -6.316857e-002, -6.293894e-002, -6.270501e-002,
   -6.246678e-002, -6.222511e-002, -6.198001e-002, -6.173081e-002, -6.147881e-002, -6.122315e-002, -6.096412e-002, -6.070220e-002, -6.043667e-002,
   -6.016932e-002, -5.989955e-002, -5.962626e-002, -5.935165e-002, -5.907452e-002, -5.879482e-002, -5.851286e-002, -5.822720e-002, -5.793945e-002,
   -5.764931e-002, -5.735722e-002, -5.706336e-002, -5.676615e-002, -5.646789e-002, -5.616717e-002, -5.586355e-002, -5.555858e-002, -5.525142e-002,
   -5.494337e-002, -5.463375e-002, -5.432268e-002, -5.400878e-002, -5.369359e-002, -5.337638e-002, -5.305805e-002, -5.273846e-002, -5.241742e-002,
   -5.209304e-002, -5.176789e-002, -5.144062e-002, -5.111253e-002, -5.078344e-002, -5.045272e-002, -5.011944e-002, -4.978481e-002, -4.944995e-002,
   -4.911371e-002, -4.877491e-002, -4.843408e-002, -4.809225e-002, -4.774920e-002, -4.740392e-002, -4.705772e-002, -4.671063e-002, -4.636272e-002,
   -4.601150e-002, -4.565978e-002, -4.530795e-002, -4.495361e-002, -4.459696e-002, -4.424074e-002, -4.388182e-002, -4.352130e-002, -4.316080e-002,
   -4.279696e-002, -4.243225e-002, -4.206572e-002, -4.169662e-002, -4.132640e-002, -4.095428e-002, -4.058141e-002, -4.020654e-002, -3.983143e-002,
   -3.945481e-002, -3.907752e-002, -3.869863e-002, -3.831916e-002, -3.793909e-002, -3.755856e-002, -3.717837e-002, -3.679812e-002, -3.641870e-002,
   -3.603933e-002, -3.566199e-002, -3.528460e-002, -3.490798e-002, -3.453196e-002, -3.415788e-002, -3.378426e-002, -3.341166e-002, -3.303988e-002,
   -3.266905e-002, -3.229894e-002, -3.192930e-002, -3.156158e-002, -3.119414e-002, -3.082719e-002, -3.046210e-002, -3.009774e-002, -2.973468e-002,
   -2.937301e-002, -2.901148e-002, -2.865136e-002, -2.829204e-002, -2.793274e-002, -2.757493e-002, -2.721877e-002, -2.686271e-002, -2.650782e-002,
   -2.615378e-002, -2.580023e-002, -2.544731e-002, -2.509595e-002, -2.474575e-002, -2.439674e-002, -2.404838e-002, -2.370154e-002, -2.335531e-002,
   -2.301049e-002, -2.266754e-002, -2.232499e-002, -2.198264e-002, -2.164178e-002, -2.130193e-002, -2.096273e-002, -2.062418e-002, -2.028711e-002,
   -1.995205e-002, -1.961796e-002, -1.928439e-002, -1.895179e-002, -1.862081e-002, -1.829111e-002, -1.796200e-002, -1.763426e-002, -1.730856e-002,
   -1.698441e-002, -1.666101e-002, -1.633836e-002, -1.601732e-002, -1.569876e-002, -1.538064e-002, -1.506325e-002, -1.474730e-002, -1.443237e-002,
   -1.411902e-002, -1.380695e-002, -1.349567e-002, -1.318542e-002, -1.287660e-002, -1.256888e-002, -1.226211e-002, -1.195664e-002, -1.165172e-002,
   -1.134866e-002, -1.104682e-002, -1.074621e-002, -1.044633e-002, -1.014755e-002, -9.850819e-003, -9.554834e-003, -9.260157e-003, -8.967085e-003,
   -8.674770e-003, -8.383864e-003, -8.094663e-003, -7.806046e-003, -7.518072e-003, -7.231338e-003, -6.945811e-003, -6.661126e-003, -6.377697e-003,
   -6.095236e-003, -5.814124e-003, -5.534324e-003, -5.255688e-003, -4.978303e-003, -4.701866e-003, -4.426695e-003, -4.152214e-003, -3.878992e-003,
   -3.607353e-003, -3.336666e-003, -3.067033e-003, -2.797994e-003, -2.529929e-003, -2.263697e-003, -1.998356e-003, -1.733835e-003, -1.470706e-003,
   -1.208125e-003, -9.470783e-004, -6.878352e-004, -4.302868e-004, -1.744681e-004, 8.006053e-005,  3.337304e-004,  5.862463e-004,  8.373778e-004,
   1.086435e-003,  1.334537e-003,  1.581397e-003,  1.826863e-003,  2.071398e-003,  2.314104e-003,  2.555159e-003,  2.794924e-003,  3.033519e-003,
   3.270476e-003,  3.505720e-003,  3.739996e-003,  3.972842e-003,  4.204140e-003,  4.434708e-003,  4.664032e-003,  4.890714e-003,  5.116126e-003,
   5.340849e-003,  5.564195e-003,  5.786559e-003,  6.007642e-003,  6.226949e-003,  6.444732e-003,  6.661478e-003,  6.876964e-003,  7.091547e-003,
   7.304253e-003,  7.515924e-003,  7.726824e-003,  7.935763e-003,  8.142976e-003,  8.349168e-003,  8.553944e-003,  8.757340e-003,  8.959792e-003,
   9.161106e-003,  9.361287e-003,  9.559349e-003,  9.756497e-003,  9.952685e-003,  1.014762e-002,  1.034074e-002,  1.053309e-002,  1.072541e-002,
   1.091594e-002,  1.110504e-002,  1.129373e-002,  1.148156e-002,  1.166782e-002,  1.185313e-002,  1.203736e-002,  1.222075e-002,  1.240279e-002,
   1.258331e-002,  1.276309e-002,  1.294256e-002,  1.312040e-002,  1.329677e-002,  1.347249e-002,  1.364706e-002,  1.382051e-002,  1.399266e-002,
   1.416408e-002,  1.433441e-002,  1.450364e-002,  1.467111e-002,  1.483672e-002,  1.500138e-002,  1.516571e-002,  1.532860e-002,  1.549030e-002,
   1.565125e-002,  1.581128e-002,  1.596967e-002,  1.612637e-002,  1.628214e-002,  1.643701e-002,  1.659115e-002,  1.674467e-002,  1.689665e-002,
   1.704747e-002,  1.719766e-002,  1.734634e-002,  1.749310e-002,  1.763928e-002,  1.778497e-002,  1.792967e-002,  1.807319e-002,  1.821614e-002,
   1.835842e-002,  1.849997e-002,  1.864049e-002,  1.878001e-002,  1.891777e-002,  1.905389e-002,  1.918975e-002,  1.932466e-002,  1.945806e-002,
   1.959045e-002,  1.972178e-002,  1.985215e-002,  1.998132e-002,  2.010955e-002,  2.023659e-002,  2.036272e-002,  2.048797e-002,  2.061253e-002,
   2.073551e-002,  2.085671e-002,  2.097730e-002,  2.109728e-002,  2.121611e-002,  2.133362e-002,  2.145057e-002,  2.156713e-002,  2.168222e-002,
   2.179582e-002,  2.190811e-002,  2.201902e-002,  2.212963e-002,  2.223941e-002,  2.234774e-002,  2.245507e-002,  2.256168e-002,  2.266780e-002,
   2.277300e-002,  2.287686e-002,  2.298009e-002,  2.308251e-002,  2.318447e-002,  2.328479e-002,  2.338382e-002,  2.348174e-002,  2.357885e-002,
   2.367505e-002,  2.377069e-002,  2.386548e-002,  2.395961e-002,  2.405276e-002,  2.414502e-002,  2.423653e-002,  2.432725e-002,  2.441701e-002,
   2.450582e-002,  2.459374e-002,  2.468095e-002,  2.476778e-002,  2.485295e-002,  2.493731e-002,  2.502082e-002,  2.510419e-002,  2.518703e-002,
   2.526896e-002,  2.534992e-002,  2.543015e-002,  2.550961e-002,  2.558855e-002,  2.566690e-002,  2.574410e-002,  2.581993e-002,  2.589510e-002,
   2.596982e-002,  2.604419e-002,  2.611726e-002,  2.618891e-002,  2.625982e-002,  2.633075e-002,  2.640090e-002,  2.646978e-002,  2.653755e-002,
   2.660499e-002,  2.667202e-002,  2.673802e-002,  2.680315e-002,  2.686678e-002,  2.692976e-002,  2.699183e-002,  2.705374e-002,  2.711568e-002,
   2.717667e-002,  2.723653e-002,  2.729552e-002,  2.735416e-002,  2.741264e-002,  2.747052e-002,  2.752731e-002,  2.758320e-002,  2.763833e-002,
   2.769307e-002,  2.774696e-002,  2.780023e-002,  2.785280e-002,  2.790422e-002,  2.795501e-002,  2.800557e-002,  2.805546e-002,  2.810432e-002,
   2.815198e-002,  2.819804e-002,  2.824345e-002,  2.828880e-002,  2.833374e-002,  2.837770e-002,  2.842043e-002,  2.846258e-002,  2.850428e-002,
   2.854542e-002,  2.858598e-002,  2.862594e-002,  2.866495e-002,  2.870252e-002,  2.873966e-002,  2.877646e-002,  2.881295e-002,  2.884832e-002,
   2.888255e-002,  2.891574e-002,  2.894903e-002,  2.898223e-002,  2.901508e-002,  2.904705e-002,  2.907791e-002,  2.910819e-002,  2.913826e-002,
   2.916796e-002,  2.919735e-002,  2.922622e-002,  2.925391e-002,  2.928040e-002,  2.930629e-002,  2.933194e-002,  2.935745e-002,  2.938241e-002,
   2.940608e-002,  2.942892e-002,  2.945141e-002,  2.947362e-002,  2.949535e-002,  2.951647e-002,  2.953636e-002,  2.955591e-002,  2.957522e-002,
   2.959431e-002,  2.961273e-002,  2.963049e-002,  2.964725e-002,  2.966316e-002,  2.967857e-002,  2.969379e-002,  2.970889e-002,  2.972363e-002,
   2.973772e-002,  2.975090e-002,  2.976332e-002,  2.977532e-002,  2.978702e-002,  2.979864e-002,  2.980987e-002,  2.982054e-002,  2.983048e-002,
   2.983975e-002,  2.984855e-002,  2.985685e-002,  2.986464e-002,  2.987176e-002,  2.987795e-002,  2.988374e-002,  2.988937e-002,  2.989469e-002,
   2.989998e-002,  2.990470e-002,  2.990875e-002,  2.991192e-002,  2.991424e-002,  2.991637e-002,  2.991777e-002,  2.991885e-002,  2.991928e-002,
   2.991874e-002,  2.991738e-002,  2.991572e-002,  2.991373e-002,  2.991128e-002,  2.990860e-002,  2.990584e-002,  2.990235e-002,  2.989797e-002,
   2.989336e-002,  2.988847e-002,  2.988322e-002,  2.987778e-002,  2.987201e-002,  2.986577e-002,  2.985911e-002,  2.985255e-002,  2.984558e-002,
   2.983821e-002,  2.983035e-002,  2.982172e-002,  2.981263e-002,  2.980268e-002,  2.979215e-002,  2.978133e-002,  2.977045e-002,  2.975935e-002,
   2.974743e-002,  2.973463e-002,  2.972134e-002,  2.970785e-002,  2.969386e-002,  2.967948e-002,  2.966457e-002,  2.964874e-002,  2.963212e-002,
   2.961527e-002,  2.959817e-002,  2.958032e-002,  2.956216e-002,  2.954350e-002,  2.952412e-002,  2.950376e-002,  2.948252e-002,  2.946105e-002,
   2.943933e-002,  2.941770e-002,  2.939591e-002,  2.937378e-002,  2.935096e-002,  2.932764e-002,  2.930405e-002,  2.928041e-002,  2.925683e-002,
   2.923300e-002,  2.920860e-002,  2.918345e-002,  2.915766e-002,  2.913147e-002,  2.910496e-002,  2.907784e-002,  2.905027e-002,  2.902246e-002,
   2.899426e-002,  2.896544e-002,  2.893613e-002,  2.890619e-002,  2.887590e-002,  2.884529e-002,  2.881411e-002,  2.878199e-002,  2.874931e-002,
   2.871610e-002,  2.868268e-002,  2.864918e-002,  2.861521e-002,  2.858077e-002,  2.854600e-002,  2.851046e-002,  2.847440e-002,  2.843823e-002,
   2.840170e-002,  2.836473e-002,  2.832715e-002,  2.828919e-002,  2.825080e-002,  2.821174e-002,  2.817164e-002,  2.813137e-002,  2.809064e-002,
   2.804988e-002,  2.800906e-002,  2.796814e-002,  2.792655e-002,  2.788389e-002,  2.784049e-002,  2.779686e-002,  2.775313e-002,  2.770916e-002,
   2.766488e-002,  2.762008e-002,  2.757387e-002,  2.752694e-002,  2.748006e-002,  2.743309e-002,  2.738562e-002,  2.733757e-002,  2.728918e-002,
   2.724059e-002,  2.719126e-002,  2.714126e-002,  2.709101e-002,  2.704059e-002,  2.699002e-002,  2.693964e-002,  2.688949e-002,  2.683898e-002,
   2.678728e-002,  2.673486e-002,  2.668206e-002,  2.662915e-002,  2.657626e-002,  2.652307e-002,  2.646954e-002,  2.641526e-002,  2.636039e-002,
   2.630526e-002,  2.625021e-002,  2.619506e-002,  2.613945e-002,  2.608340e-002,  2.602684e-002,  2.596993e-002,  2.591262e-002,  2.585493e-002,
   2.579680e-002,  2.573835e-002,  2.567970e-002,  2.562103e-002,  2.556225e-002,  2.550317e-002,  2.544336e-002,  2.538317e-002,  2.532253e-002,
   2.526149e-002,  2.520069e-002,  2.513982e-002,  2.507873e-002,  2.501757e-002,  2.495623e-002,  2.489478e-002,  2.483325e-002,  2.477154e-002,
   2.470957e-002,  2.464714e-002,  2.458375e-002,  2.451995e-002,  2.445596e-002,  2.439214e-002,  2.432815e-002,  2.426368e-002,  2.419895e-002,
   2.413401e-002,  2.406879e-002,  2.400333e-002,  2.393762e-002,  2.387124e-002,  2.380421e-002,  2.373677e-002,  2.366924e-002,  2.360201e-002,
   2.353462e-002,  2.346708e-002,  2.339930e-002,  2.333108e-002,  2.326216e-002,  2.319319e-002,  2.312445e-002,  2.305565e-002,  2.298672e-002,
   2.291752e-002,  2.284820e-002,  2.277878e-002,  2.270904e-002,  2.263863e-002,  2.256796e-002,  2.249704e-002,  2.242582e-002,  2.235437e-002,
   2.228287e-002,  2.221145e-002,  2.213982e-002,  2.206778e-002,  2.199519e-002,  2.192199e-002,  2.184854e-002,  2.177484e-002,  2.170073e-002,
   2.162616e-002,  2.155125e-002,  2.147579e-002,  2.139931e-002,  2.132241e-002,  2.124553e-002,  2.116845e-002,  2.109140e-002,  2.101413e-002,
   2.093653e-002,  2.085859e-002,  2.078051e-002,  2.070170e-002,  2.062251e-002,  2.054327e-002,  2.046379e-002,  2.038417e-002,  2.030452e-002,
   2.022499e-002,  2.014550e-002,  2.006557e-002,  1.998500e-002,  1.990404e-002,  1.982261e-002,  1.974109e-002,  1.965972e-002,  1.957832e-002,
   1.949669e-002,  1.941454e-002,  1.933192e-002,  1.924860e-002,  1.916515e-002,  1.908171e-002,  1.899820e-002,  1.891452e-002,  1.883073e-002,
   1.874656e-002,  1.866178e-002,  1.857668e-002,  1.849097e-002,  1.840473e-002,  1.831818e-002,  1.823158e-002,  1.814483e-002,  1.805806e-002,
   1.797132e-002,  1.788475e-002,  1.779823e-002,  1.771130e-002,  1.762377e-002,  1.753588e-002,  1.744771e-002,  1.735949e-002,  1.727150e-002,
   1.718335e-002,  1.709513e-002,  1.700680e-002,  1.691792e-002,  1.682779e-002,  1.673734e-002,  1.664724e-002,  1.655709e-002,  1.646661e-002,
   1.637596e-002,  1.628514e-002,  1.619373e-002,  1.610176e-002,  1.600926e-002,  1.591590e-002,  1.582272e-002,  1.572961e-002,  1.563630e-002,
   1.554271e-002,  1.544886e-002,  1.535515e-002,  1.526130e-002,  1.516701e-002,  1.507180e-002,  1.497624e-002,  1.488052e-002,  1.478434e-002,
   1.468826e-002,  1.459273e-002,  1.449716e-002,  1.440158e-002,  1.430571e-002,  1.420940e-002,  1.411214e-002,  1.401480e-002,  1.391760e-002,
   1.382018e-002,  1.372267e-002,  1.362512e-002,  1.352760e-002,  1.343008e-002,  1.333228e-002,  1.323431e-002,  1.313591e-002,  1.303727e-002,
   1.293852e-002,  1.283950e-002,  1.274032e-002,  1.264080e-002,  1.254123e-002,  1.244169e-002,  1.234195e-002,  1.224205e-002,  1.214193e-002,
   1.204189e-002,  1.194184e-002,  1.184131e-002,  1.174076e-002,  1.164014e-002,  1.153936e-002,  1.143851e-002,  1.133759e-002,  1.123653e-002,
   1.113548e-002,  1.103454e-002,  1.093387e-002,  1.083302e-002,  1.073188e-002,  1.063088e-002,  1.052970e-002,  1.042837e-002,  1.032659e-002,
   1.022455e-002,  1.012248e-002,  1.002035e-002,  9.918116e-003,  9.815804e-003,  9.713331e-003,  9.610621e-003,  9.507541e-003,  9.404811e-003,
   9.301925e-003,  9.198768e-003,  9.094977e-003,  8.991043e-003,  8.887070e-003,  8.782970e-003,  8.678326e-003,  8.573843e-003,  8.469633e-003,
   8.365521e-003,  8.261370e-003,  8.157106e-003,  8.052351e-003,  7.947350e-003,  7.842282e-003,  7.737671e-003,  7.632770e-003,  7.527568e-003,
   7.422291e-003,  7.316904e-003,  7.211409e-003,  7.106033e-003,  7.000307e-003,  6.894502e-003,  6.788705e-003,  6.682880e-003,  6.576743e-003,
   6.470157e-003,  6.363435e-003,  6.256815e-003,  6.150156e-003,  6.043626e-003,  5.936934e-003,  5.829892e-003,  5.723172e-003,  5.616471e-003,
   5.509550e-003,  5.401966e-003,  5.294037e-003,  5.186386e-003,  5.078716e-003,  4.971001e-003,  4.863286e-003,  4.755597e-003,  4.647307e-003,
   4.538980e-003,  4.430595e-003,  4.322479e-003,  4.214607e-003,  4.106767e-003,  3.998947e-003,  3.891184e-003,  3.783453e-003,  3.675667e-003,
   3.567486e-003,  3.459373e-003,  3.351252e-003,  3.242571e-003,  3.134150e-003,  3.025716e-003,  2.917545e-003,  2.810184e-003,  2.702678e-003,
   2.595736e-003,  2.488716e-003,  2.381184e-003,  2.272856e-003,  2.164048e-003,  2.054665e-003,  1.945212e-003,  1.835736e-003,  1.726726e-003,
   1.618062e-003,  1.509930e-003,  1.402651e-003,  1.295712e-003,  1.188421e-003,  1.080173e-003,  9.714036e-004,  8.630221e-004,  7.551179e-004,
   6.472019e-004,  5.393068e-004,  4.314098e-004,  3.235321e-004,  2.156618e-004,  1.078233e-004,  1.817274e-018},
  {0.000000e+000,  -1.492129e-002, -2.127088e-002, -2.618806e-002, -3.030776e-002, -3.390256e-002, -3.710799e-002, -4.003321e-002, -4.274783e-002,
   -4.528460e-002, -4.765963e-002, -4.988519e-002, -5.197049e-002, -5.392217e-002, -5.575409e-002, -5.747167e-002, -5.908103e-002, -6.059303e-002,
   -6.201298e-002, -6.335102e-002, -6.461079e-002, -6.579581e-002, -6.690524e-002, -6.794801e-002, -6.892519e-002, -6.984189e-002, -7.069960e-002,
   -7.150041e-002, -7.224501e-002, -7.293687e-002, -7.357614e-002, -7.416297e-002, -7.469762e-002, -7.517955e-002, -7.561567e-002, -7.600640e-002,
   -7.634987e-002, -7.664419e-002, -7.689663e-002, -7.710327e-002, -7.726759e-002, -7.738455e-002, -7.745873e-002, -7.749457e-002, -7.748945e-002,
   -7.744165e-002, -7.735865e-002, -7.723364e-002, -7.707189e-002, -7.687827e-002, -7.664647e-002, -7.637822e-002, -7.608302e-002, -7.575068e-002,
   -7.538839e-002, -7.499824e-002, -7.457771e-002, -7.412979e-002, -7.364984e-002, -7.314172e-002, -7.260533e-002, -7.204270e-002, -7.145579e-002,
   -7.084881e-002, -7.021362e-002, -6.955401e-002, -6.887651e-002, -6.817895e-002, -6.746294e-002, -6.672660e-002, -6.597115e-002, -6.519937e-002,
   -6.441377e-002, -6.361464e-002, -6.280368e-002, -6.197680e-002, -6.113930e-002, -6.029036e-002, -5.943020e-002, -5.856084e-002, -5.768074e-002,
   -5.678807e-002, -5.588325e-002, -5.497403e-002, -5.405088e-002, -5.311932e-002, -5.218269e-002, -5.123219e-002, -5.027069e-002, -4.930252e-002,
   -4.832386e-002, -4.733829e-002, -4.634025e-002, -4.533376e-002, -4.432209e-002, -4.329936e-002, -4.226919e-002, -4.123282e-002, -4.018882e-002,
   -3.913876e-002, -3.808507e-002, -3.702615e-002, -3.596504e-002, -3.490341e-002, -3.384366e-002, -3.278206e-002, -3.171784e-002, -3.065539e-002,
   -2.959573e-002, -2.854068e-002, -2.748243e-002, -2.643014e-002, -2.538179e-002, -2.433511e-002, -2.329353e-002, -2.225788e-002, -2.122554e-002,
   -2.019842e-002, -1.918127e-002, -1.816785e-002, -1.716183e-002, -1.616060e-002, -1.516746e-002, -1.418151e-002, -1.320141e-002, -1.222747e-002,
   -1.126370e-002, -1.030776e-002, -9.360055e-003, -8.420152e-003, -7.488138e-003, -6.566507e-003, -5.655479e-003, -4.756311e-003, -3.866571e-003,
   -2.990216e-003, -2.126094e-003, -1.267782e-003, -4.210361e-004, 4.168841e-004,  1.246749e-003,  2.066966e-003,  2.877267e-003,  3.679979e-003,
   4.472107e-003,  5.252754e-003,  6.023304e-003,  6.788588e-003,  7.544078e-003,  8.288665e-003,  9.025675e-003,  9.753873e-003,  1.047475e-002,
   1.118661e-002,  1.188755e-002,  1.258288e-002,  1.326729e-002,  1.394282e-002,  1.461229e-002,  1.527265e-002,  1.592762e-002,  1.657146e-002,
   1.720636e-002,  1.782967e-002,  1.844406e-002,  1.904969e-002,  1.964527e-002,  2.023076e-002,  2.081047e-002,  2.138261e-002,  2.194487e-002,
   2.250196e-002,  2.304905e-002,  2.358819e-002,  2.411839e-002,  2.463960e-002,  2.514865e-002,  2.565030e-002,  2.614183e-002,  2.662619e-002,
   2.710025e-002,  2.756598e-002,  2.802123e-002,  2.846987e-002,  2.891075e-002,  2.934243e-002,  2.976562e-002,  3.018131e-002,  3.058678e-002,
   3.098458e-002,  3.137367e-002,  3.175329e-002,  3.212513e-002,  3.248639e-002,  3.283770e-002,  3.318035e-002,  3.351670e-002,  3.384299e-002,
   3.416177e-002,  3.447175e-002,  3.477535e-002,  3.507138e-002,  3.536013e-002,  3.564247e-002,  3.591487e-002,  3.617964e-002,  3.643723e-002,
   3.668991e-002,  3.693380e-002,  3.717302e-002,  3.740944e-002,  3.763660e-002,  3.785714e-002,  3.806982e-002,  3.827548e-002,  3.847419e-002,
   3.866396e-002,  3.885067e-002,  3.903115e-002,  3.920685e-002,  3.937780e-002,  3.954491e-002,  3.970796e-002,  3.986178e-002,  4.001373e-002,
   4.015855e-002,  4.029890e-002,  4.043529e-002,  4.056528e-002,  4.069092e-002,  4.081260e-002,  4.092676e-002,  4.103873e-002,  4.114570e-002,
   4.124747e-002,  4.134345e-002,  4.143188e-002,  4.151645e-002,  4.159395e-002,  4.166355e-002,  4.173055e-002,  4.179073e-002,  4.184467e-002,
   4.189187e-002,  4.193239e-002,  4.196968e-002,  4.200237e-002,  4.202886e-002,  4.205290e-002,  4.207137e-002,  4.208656e-002,  4.209566e-002,
   4.209963e-002,  4.209968e-002,  4.209733e-002,  4.208945e-002,  4.207928e-002,  4.206520e-002,  4.204744e-002,  4.202663e-002,  4.199872e-002,
   4.196584e-002,  4.193164e-002,  4.189285e-002,  4.184639e-002,  4.179631e-002,  4.174293e-002,  4.168768e-002,  4.162983e-002,  4.156668e-002,
   4.149975e-002,  4.142993e-002,  4.135414e-002,  4.127279e-002,  4.119022e-002,  4.110327e-002,  4.101329e-002,  4.092093e-002,  4.082437e-002,
   4.072230e-002,  4.061815e-002,  4.051180e-002,  4.040312e-002,  4.029203e-002,  4.017848e-002,  4.006180e-002,  3.994356e-002,  3.982271e-002,
   3.969911e-002,  3.957502e-002,  3.945107e-002,  3.932636e-002,  3.919872e-002,  3.906977e-002,  3.893930e-002,  3.880742e-002,  3.867382e-002,
   3.853734e-002,  3.839708e-002,  3.825433e-002,  3.811106e-002,  3.796525e-002,  3.781681e-002,  3.766634e-002,  3.751375e-002,  3.735865e-002,
   3.720277e-002,  3.704359e-002,  3.688229e-002,  3.671925e-002,  3.655369e-002,  3.638574e-002,  3.621416e-002,  3.604147e-002,  3.586678e-002,
   3.569232e-002,  3.551728e-002,  3.534102e-002,  3.516244e-002,  3.498119e-002,  3.479838e-002,  3.461231e-002,  3.442526e-002,  3.423686e-002,
   3.404634e-002,  3.385433e-002,  3.366179e-002,  3.346944e-002,  3.327630e-002,  3.308278e-002,  3.288709e-002,  3.268883e-002,  3.248765e-002,
   3.228683e-002,  3.208361e-002,  3.187810e-002,  3.166924e-002,  3.146022e-002,  3.124957e-002,  3.103519e-002,  3.081974e-002,  3.060306e-002,
   3.038578e-002,  3.016596e-002,  2.994620e-002,  2.972404e-002,  2.949999e-002,  2.927360e-002,  2.904702e-002,  2.882051e-002,  2.859334e-002,
   2.836347e-002,  2.813350e-002,  2.790291e-002,  2.767057e-002,  2.743701e-002,  2.720281e-002,  2.696625e-002,  2.673157e-002,  2.649659e-002,
   2.626168e-002,  2.602569e-002,  2.578910e-002,  2.555118e-002,  2.531368e-002,  2.507698e-002,  2.484014e-002,  2.460235e-002,  2.436583e-002,
   2.412815e-002,  2.388920e-002,  2.365033e-002,  2.341059e-002,  2.316970e-002,  2.292831e-002,  2.268420e-002,  2.244054e-002,  2.219756e-002,
   2.195360e-002,  2.170899e-002,  2.146600e-002,  2.122240e-002,  2.097791e-002,  2.073426e-002,  2.049191e-002,  2.025015e-002,  2.000811e-002,
   1.976600e-002,  1.952313e-002,  1.928183e-002,  1.904155e-002,  1.880019e-002,  1.855812e-002,  1.831728e-002,  1.807667e-002,  1.783590e-002,
   1.759459e-002,  1.735397e-002,  1.711338e-002,  1.687298e-002,  1.663316e-002,  1.639232e-002,  1.615232e-002,  1.591339e-002,  1.567317e-002,
   1.543240e-002,  1.519348e-002,  1.495407e-002,  1.471271e-002,  1.447120e-002,  1.423002e-002,  1.398939e-002,  1.374940e-002,  1.350901e-002,
   1.326724e-002,  1.302598e-002,  1.278601e-002,  1.254618e-002,  1.230531e-002,  1.206388e-002,  1.182352e-002,  1.158297e-002,  1.134161e-002,
   1.110085e-002,  1.085994e-002,  1.061897e-002,  1.037977e-002,  1.014137e-002,  9.901052e-003,  9.659893e-003,  9.419405e-003,  9.179110e-003,
   8.937359e-003,  8.695699e-003,  8.456020e-003,  8.215845e-003,  7.975956e-003,  7.736163e-003,  7.496472e-003,  7.256680e-003,  7.015320e-003,
   6.775422e-003,  6.534686e-003,  6.293493e-003,  6.053075e-003,  5.813559e-003,  5.574828e-003,  5.336566e-003,  5.099228e-003,  4.863776e-003,
   4.628290e-003,  4.393131e-003,  4.158830e-003,  3.925326e-003,  3.692849e-003,  3.459805e-003,  3.227877e-003,  2.996216e-003,  2.765209e-003,
   2.535830e-003,  2.308013e-003,  2.081011e-003,  1.854741e-003,  1.629909e-003,  1.406858e-003,  1.184176e-003,  9.618576e-004,  7.402950e-004,
   5.197663e-004,  2.995273e-004,  8.047108e-005,  -1.378609e-004, -3.561288e-004, -5.742468e-004, -7.912948e-004, -1.006561e-003, -1.221347e-003,
   -1.436459e-003, -1.652513e-003, -1.867854e-003, -2.082229e-003, -2.296697e-003, -2.511206e-003, -2.725272e-003, -2.938945e-003, -3.151963e-003,
   -3.364068e-003, -3.575356e-003, -3.785537e-003, -3.996126e-003, -4.205662e-003, -4.413863e-003, -4.620833e-003, -4.828086e-003, -5.034579e-003,
   -5.239381e-003, -5.442322e-003, -5.644325e-003, -5.846386e-003, -6.048032e-003, -6.249134e-003, -6.448037e-003, -6.646043e-003, -6.841923e-003,
   -7.036523e-003, -7.230505e-003, -7.423379e-003, -7.614369e-003, -7.804266e-003, -7.992173e-003, -8.178170e-003, -8.364124e-003, -8.549087e-003,
   -8.733346e-003, -8.918920e-003, -9.103168e-003, -9.287606e-003, -9.472283e-003, -9.655203e-003, -9.837420e-003, -1.001970e-002, -1.020096e-002,
   -1.038267e-002, -1.056340e-002, -1.074229e-002, -1.091976e-002, -1.109704e-002, -1.127340e-002, -1.144945e-002, -1.162365e-002, -1.179651e-002,
   -1.196920e-002, -1.214148e-002, -1.231243e-002, -1.248266e-002, -1.265180e-002, -1.281936e-002, -1.298695e-002, -1.315444e-002, -1.332086e-002,
   -1.348694e-002, -1.365192e-002, -1.381604e-002, -1.398117e-002, -1.414626e-002, -1.431091e-002, -1.447517e-002, -1.463846e-002, -1.480160e-002,
   -1.496485e-002, -1.512775e-002, -1.528922e-002, -1.544980e-002, -1.560926e-002, -1.576820e-002, -1.592641e-002, -1.608491e-002, -1.624321e-002,
   -1.640017e-002, -1.655687e-002, -1.671230e-002, -1.686651e-002, -1.702076e-002, -1.717454e-002, -1.732689e-002, -1.747800e-002, -1.762782e-002,
   -1.777712e-002, -1.792688e-002, -1.807691e-002, -1.822576e-002, -1.837435e-002, -1.852222e-002, -1.866919e-002, -1.881573e-002, -1.896344e-002,
   -1.911117e-002, -1.925852e-002, -1.940528e-002, -1.955111e-002, -1.969716e-002, -1.984384e-002, -1.999016e-002, -2.013557e-002, -2.028047e-002,
   -2.042520e-002, -2.057056e-002, -2.071559e-002, -2.085892e-002, -2.100088e-002, -2.114227e-002, -2.128283e-002, -2.142158e-002, -2.155918e-002,
   -2.169606e-002, -2.183246e-002, -2.196871e-002, -2.210460e-002, -2.223865e-002, -2.237185e-002, -2.250417e-002, -2.263552e-002, -2.276588e-002,
   -2.289492e-002, -2.302223e-002, -2.314923e-002, -2.327584e-002, -2.340239e-002, -2.352801e-002, -2.365306e-002, -2.377671e-002, -2.389804e-002,
   -2.401916e-002, -2.413960e-002, -2.425943e-002, -2.437922e-002, -2.449893e-002, -2.461832e-002, -2.473598e-002, -2.485238e-002, -2.496896e-002,
   -2.508484e-002, -2.520058e-002, -2.531536e-002, -2.542905e-002, -2.554121e-002, -2.565210e-002, -2.576196e-002, -2.586960e-002, -2.597567e-002,
   -2.608072e-002, -2.618498e-002, -2.628824e-002, -2.639022e-002, -2.648999e-002, -2.658812e-002, -2.668522e-002, -2.678123e-002, -2.687642e-002,
   -2.696982e-002, -2.706123e-002, -2.715124e-002, -2.724066e-002, -2.732941e-002, -2.741711e-002, -2.750363e-002, -2.758979e-002, -2.767590e-002,
   -2.776181e-002, -2.784758e-002, -2.793144e-002, -2.801439e-002, -2.809756e-002, -2.818080e-002, -2.826359e-002, -2.834509e-002, -2.842487e-002,
   -2.850355e-002, -2.858192e-002, -2.866000e-002, -2.873745e-002, -2.881340e-002, -2.888830e-002, -2.896095e-002, -2.903270e-002, -2.910387e-002,
   -2.917398e-002, -2.924238e-002, -2.930963e-002, -2.937588e-002, -2.944073e-002, -2.950452e-002, -2.956450e-002, -2.962310e-002, -2.968106e-002,
   -2.973823e-002, -2.979351e-002, -2.984713e-002, -2.989988e-002, -2.995041e-002, -3.000066e-002, -3.005056e-002, -3.010012e-002, -3.014840e-002,
   -3.019567e-002, -3.024223e-002, -3.028617e-002, -3.032814e-002, -3.036954e-002, -3.041102e-002, -3.045222e-002, -3.049327e-002, -3.053466e-002,
   -3.057574e-002, -3.061549e-002, -3.065404e-002, -3.069146e-002, -3.072746e-002, -3.076229e-002, -3.079727e-002, -3.083157e-002, -3.086484e-002,
   -3.089665e-002, -3.092718e-002, -3.095631e-002, -3.098415e-002, -3.101104e-002, -3.103658e-002, -3.106086e-002, -3.108326e-002, -3.110436e-002,
   -3.112487e-002, -3.114376e-002, -3.116162e-002, -3.117918e-002, -3.119660e-002, -3.121399e-002, -3.123114e-002, -3.124711e-002, -3.126241e-002,
   -3.127668e-002, -3.129050e-002, -3.130314e-002, -3.131486e-002, -3.132576e-002, -3.133567e-002, -3.134454e-002, -3.135222e-002, -3.135904e-002,
   -3.136564e-002, -3.137218e-002, -3.137862e-002, -3.138390e-002, -3.138817e-002, -3.139153e-002, -3.139400e-002, -3.139580e-002, -3.139690e-002,
   -3.139783e-002, -3.139858e-002, -3.139891e-002, -3.139831e-002, -3.139585e-002, -3.139237e-002, -3.138806e-002, -3.138327e-002, -3.137886e-002,
   -3.137495e-002, -3.137116e-002, -3.136708e-002, -3.136174e-002, -3.135583e-002, -3.135000e-002, -3.134365e-002, -3.133670e-002, -3.133094e-002,
   -3.132526e-002, -3.131825e-002, -3.130912e-002, -3.129914e-002, -3.128862e-002, -3.127698e-002, -3.126509e-002, -3.125428e-002, -3.124434e-002,
   -3.123373e-002, -3.122201e-002, -3.120911e-002, -3.119552e-002, -3.118113e-002, -3.116580e-002, -3.114961e-002, -3.113421e-002, -3.111750e-002,
   -3.110020e-002, -3.108284e-002, -3.106499e-002, -3.104645e-002, -3.102719e-002, -3.100783e-002, -3.098805e-002, -3.096867e-002, -3.094856e-002,
   -3.092767e-002, -3.090604e-002, -3.088390e-002, -3.086107e-002, -3.083835e-002, -3.081606e-002, -3.079334e-002, -3.076981e-002, -3.074538e-002,
   -3.071995e-002, -3.069313e-002, -3.066548e-002, -3.063684e-002, -3.060647e-002, -3.057544e-002, -3.054392e-002, -3.051034e-002, -3.047645e-002,
   -3.044176e-002, -3.040569e-002, -3.036833e-002, -3.032999e-002, -3.029101e-002, -3.025124e-002, -3.021057e-002, -3.016863e-002, -3.012580e-002,
   -3.008211e-002, -3.003763e-002, -2.999231e-002, -2.994693e-002, -2.990135e-002, -2.985585e-002, -2.980960e-002, -2.976303e-002, -2.971655e-002,
   -2.966943e-002, -2.962093e-002, -2.957121e-002, -2.952121e-002, -2.947046e-002, -2.941903e-002, -2.936703e-002, -2.931414e-002, -2.926076e-002,
   -2.920690e-002, -2.915168e-002, -2.909498e-002, -2.903775e-002, -2.897961e-002, -2.892032e-002, -2.886049e-002, -2.879999e-002, -2.873869e-002,
   -2.867589e-002, -2.861158e-002, -2.854613e-002, -2.847926e-002, -2.841161e-002, -2.834415e-002, -2.827651e-002, -2.820831e-002, -2.813997e-002,
   -2.807145e-002, -2.800227e-002, -2.793237e-002, -2.786218e-002, -2.779120e-002, -2.771971e-002, -2.764775e-002, -2.757554e-002, -2.750195e-002,
   -2.742777e-002, -2.735320e-002, -2.727702e-002, -2.719959e-002, -2.712069e-002, -2.704102e-002, -2.695988e-002, -2.687810e-002, -2.679571e-002,
   -2.671273e-002, -2.662901e-002, -2.654375e-002, -2.645708e-002, -2.636810e-002, -2.627746e-002, -2.618469e-002, -2.609053e-002, -2.599556e-002,
   -2.589976e-002, -2.580349e-002, -2.570639e-002, -2.560821e-002, -2.550845e-002, -2.540844e-002, -2.530785e-002, -2.520559e-002, -2.510217e-002,
   -2.499837e-002, -2.489339e-002, -2.478844e-002, -2.468330e-002, -2.457710e-002, -2.446992e-002, -2.436192e-002, -2.425277e-002, -2.414230e-002,
   -2.403049e-002, -2.391828e-002, -2.380561e-002, -2.369251e-002, -2.357840e-002, -2.346281e-002, -2.334630e-002, -2.322889e-002, -2.310974e-002,
   -2.298976e-002, -2.286840e-002, -2.274575e-002, -2.262220e-002, -2.249813e-002, -2.237310e-002, -2.224729e-002, -2.212094e-002, -2.199337e-002,
   -2.186401e-002, -2.173349e-002, -2.160165e-002, -2.146829e-002, -2.133448e-002, -2.119999e-002, -2.106507e-002, -2.092976e-002, -2.079391e-002,
   -2.065639e-002, -2.051733e-002, -2.037726e-002, -2.023626e-002, -2.009377e-002, -1.995007e-002, -1.980568e-002, -1.966048e-002, -1.951412e-002,
   -1.936651e-002, -1.921762e-002, -1.906792e-002, -1.891756e-002, -1.876641e-002, -1.861296e-002, -1.845867e-002, -1.830355e-002, -1.814728e-002,
   -1.799036e-002, -1.783077e-002, -1.767085e-002, -1.751058e-002, -1.734999e-002, -1.718899e-002, -1.702579e-002, -1.686109e-002, -1.669571e-002,
   -1.652990e-002, -1.636388e-002, -1.619736e-002, -1.603026e-002, -1.586195e-002, -1.569253e-002, -1.552149e-002, -1.534850e-002, -1.517396e-002,
   -1.499892e-002, -1.482333e-002, -1.464706e-002, -1.446959e-002, -1.429032e-002, -1.410958e-002, -1.392775e-002, -1.374517e-002, -1.356104e-002,
   -1.337471e-002, -1.318766e-002, -1.299876e-002, -1.280845e-002, -1.261703e-002, -1.242486e-002, -1.223155e-002, -1.203656e-002, -1.184078e-002,
   -1.164411e-002, -1.144457e-002, -1.124374e-002, -1.104176e-002, -1.083946e-002, -1.063695e-002, -1.043423e-002, -1.023041e-002, -1.002511e-002,
   -9.819270e-003, -9.612281e-003, -9.401320e-003, -9.189639e-003, -8.978009e-003, -8.766439e-003, -8.554695e-003, -8.342656e-003, -8.130345e-003,
   -7.916270e-003, -7.699817e-003, -7.482708e-003, -7.262805e-003, -7.040255e-003, -6.817261e-003, -6.593612e-003, -6.368892e-003, -6.143592e-003,
   -5.916395e-003, -5.688754e-003, -5.459543e-003, -5.228324e-003, -4.994517e-003, -4.757789e-003, -4.520199e-003, -4.281770e-003, -4.040579e-003,
   -3.798196e-003, -3.554220e-003, -3.309345e-003, -3.064056e-003, -2.817498e-003, -2.566793e-003, -2.312722e-003, -2.057098e-003, -1.799981e-003,
   -1.542788e-003, -1.285585e-003, -1.028354e-003, -7.711852e-004, -5.140255e-004, -2.569877e-004, -7.472155e-018},
  {0.000000e+000,  -3.686752e-002, -4.707916e-002, -5.424298e-002, -5.974686e-002, -6.421704e-002, -6.809730e-002, -7.150207e-002, -7.456737e-002,
   -7.735639e-002, -7.991997e-002, -8.227440e-002, -8.439895e-002, -8.625641e-002, -8.779916e-002, -8.904610e-002, -9.001451e-002, -9.072532e-002,
   -9.124275e-002, -9.158673e-002, -9.182539e-002, -9.200225e-002, -9.208038e-002, -9.210195e-002, -9.201929e-002, -9.184150e-002, -9.158301e-002,
   -9.123810e-002, -9.083478e-002, -9.035514e-002, -8.977864e-002, -8.910458e-002, -8.833068e-002, -8.745202e-002, -8.646511e-002, -8.537988e-002,
   -8.419200e-002, -8.287240e-002, -8.145336e-002, -7.994302e-002, -7.834295e-002, -7.665127e-002, -7.490048e-002, -7.308915e-002, -7.122782e-002,
   -6.932175e-002, -6.738629e-002, -6.542944e-002, -6.343609e-002, -6.141668e-002, -5.936762e-002, -5.726929e-002, -5.513005e-002, -5.294581e-002,
   -5.074574e-002, -4.853045e-002, -4.630711e-002, -4.409634e-002, -4.189540e-002, -3.972582e-002, -3.758626e-002, -3.549378e-002, -3.341818e-002,
   -3.135686e-002, -2.930771e-002, -2.727640e-002, -2.526127e-002, -2.327324e-002, -2.131527e-002, -1.937966e-002, -1.746311e-002, -1.557883e-002,
   -1.372572e-002, -1.189704e-002, -1.009320e-002, -8.330456e-003, -6.600937e-003, -4.892731e-003, -3.204983e-003, -1.539323e-003, 1.087786e-004,
   1.741523e-003,  3.357796e-003,  4.946539e-003,  6.526105e-003,  8.087222e-003,  9.623635e-003,  1.114311e-002,  1.263078e-002,  1.409044e-002,
   1.553051e-002,  1.693758e-002,  1.832100e-002,  1.967297e-002,  2.099259e-002,  2.228373e-002,  2.354167e-002,  2.476117e-002,  2.593983e-002,
   2.709688e-002,  2.822413e-002,  2.932345e-002,  3.039570e-002,  3.144278e-002,  3.247026e-002,  3.347581e-002,  3.445661e-002,  3.541730e-002,
   3.635977e-002,  3.728128e-002,  3.817157e-002,  3.903504e-002,  3.988187e-002,  4.070002e-002,  4.147968e-002,  4.222756e-002,  4.294408e-002,
   4.363506e-002,  4.429347e-002,  4.491849e-002,  4.550622e-002,  4.606525e-002,  4.659057e-002,  4.708795e-002,  4.755407e-002,  4.798880e-002,
   4.839570e-002,  4.878390e-002,  4.914796e-002,  4.949170e-002,  4.981731e-002,  5.012803e-002,  5.041794e-002,  5.068709e-002,  5.093673e-002,
   5.117082e-002,  5.139053e-002,  5.160546e-002,  5.180635e-002,  5.198778e-002,  5.216079e-002,  5.232146e-002,  5.245521e-002,  5.258058e-002,
   5.268417e-002,  5.277219e-002,  5.284493e-002,  5.289987e-002,  5.294295e-002,  5.295232e-002,  5.293886e-002,  5.290820e-002,  5.285789e-002,
   5.278694e-002,  5.269092e-002,  5.258416e-002,  5.245384e-002,  5.230755e-002,  5.215269e-002,  5.197809e-002,  5.179503e-002,  5.160154e-002,
   5.138270e-002,  5.115835e-002,  5.092048e-002,  5.066528e-002,  5.040347e-002,  5.012365e-002,  4.983004e-002,  4.953082e-002,  4.922354e-002,
   4.890520e-002,  4.855925e-002,  4.820714e-002,  4.784969e-002,  4.748517e-002,  4.708991e-002,  4.668237e-002,  4.626548e-002,  4.584670e-002,
   4.539089e-002,  4.493146e-002,  4.446371e-002,  4.396844e-002,  4.345779e-002,  4.294188e-002,  4.240077e-002,  4.184042e-002,  4.127357e-002,
   4.066929e-002,  4.005822e-002,  3.942501e-002,  3.876983e-002,  3.809920e-002,  3.740036e-002,  3.669153e-002,  3.595514e-002,  3.521205e-002,
   3.445416e-002,  3.368468e-002,  3.290001e-002,  3.210693e-002,  3.130610e-002,  3.049788e-002,  2.969452e-002,  2.888758e-002,  2.808967e-002,
   2.729010e-002,  2.650343e-002,  2.571092e-002,  2.492943e-002,  2.414864e-002,  2.338439e-002,  2.262252e-002,  2.186761e-002,  2.111868e-002,
   2.037299e-002,  1.963561e-002,  1.889743e-002,  1.817550e-002,  1.745468e-002,  1.673810e-002,  1.603273e-002,  1.532968e-002,  1.463230e-002,
   1.393855e-002,  1.324819e-002,  1.256748e-002,  1.189409e-002,  1.121913e-002,  1.055384e-002,  9.891197e-003,  9.226005e-003,  8.570603e-003,
   7.924821e-003,  7.278813e-003,  6.636009e-003,  6.003245e-003,  5.370034e-003,  4.736873e-003,  4.114991e-003,  3.497752e-003,  2.884234e-003,
   2.272889e-003,  1.669924e-003,  1.068295e-003,  4.689074e-004,  -1.273354e-004, -7.135699e-004, -1.299002e-003, -1.884465e-003, -2.465799e-003,
   -3.035150e-003, -3.602649e-003, -4.165791e-003, -4.726458e-003, -5.272796e-003, -5.815489e-003, -6.352506e-003, -6.881806e-003, -7.399020e-003,
   -7.909706e-003, -8.412922e-003, -8.907683e-003, -9.398501e-003, -9.875158e-003, -1.034606e-002, -1.081212e-002, -1.127346e-002, -1.172512e-002,
   -1.216630e-002, -1.260043e-002, -1.302984e-002, -1.345338e-002, -1.386666e-002, -1.427369e-002, -1.467342e-002, -1.506746e-002, -1.545470e-002,
   -1.583157e-002, -1.620119e-002, -1.656596e-002, -1.692563e-002, -1.728027e-002, -1.762665e-002, -1.796578e-002, -1.829915e-002, -1.862659e-002,
   -1.894976e-002, -1.926897e-002, -1.958175e-002, -1.989009e-002, -2.019472e-002, -2.049394e-002, -2.078876e-002, -2.107657e-002, -2.136162e-002,
   -2.164384e-002, -2.192293e-002, -2.219727e-002, -2.246562e-002, -2.273129e-002, -2.299395e-002, -2.325271e-002, -2.351119e-002, -2.376432e-002,
   -2.401186e-002, -2.425936e-002, -2.450587e-002, -2.475234e-002, -2.500292e-002, -2.524975e-002, -2.549221e-002, -2.573377e-002, -2.597303e-002,
   -2.620966e-002, -2.644458e-002, -2.667915e-002, -2.691132e-002, -2.714220e-002, -2.736910e-002, -2.759550e-002, -2.782144e-002, -2.804273e-002,
   -2.826174e-002, -2.848028e-002, -2.869335e-002, -2.890189e-002, -2.910718e-002, -2.930464e-002, -2.949511e-002, -2.968108e-002, -2.986668e-002,
   -3.004672e-002, -3.022181e-002, -3.039373e-002, -3.056167e-002, -3.072471e-002, -3.088472e-002, -3.104097e-002, -3.119396e-002, -3.134184e-002,
   -3.148208e-002, -3.161625e-002, -3.174617e-002, -3.187219e-002, -3.199329e-002, -3.210708e-002, -3.221758e-002, -3.232474e-002, -3.242694e-002,
   -3.252236e-002, -3.261333e-002, -3.269782e-002, -3.277689e-002, -3.284772e-002, -3.291825e-002, -3.298548e-002, -3.304762e-002, -3.310467e-002,
   -3.315795e-002, -3.320481e-002, -3.323905e-002, -3.327168e-002, -3.330400e-002, -3.333563e-002, -3.336245e-002, -3.338772e-002, -3.341355e-002,
   -3.343043e-002, -3.344169e-002, -3.344942e-002, -3.345532e-002, -3.345876e-002, -3.346031e-002, -3.346090e-002, -3.345749e-002, -3.344829e-002,
   -3.343847e-002, -3.342726e-002, -3.341415e-002, -3.340012e-002, -3.338378e-002, -3.336691e-002, -3.334871e-002, -3.333131e-002, -3.330978e-002,
   -3.328701e-002, -3.326246e-002, -3.323938e-002, -3.321396e-002, -3.318061e-002, -3.314734e-002, -3.311349e-002, -3.308041e-002, -3.304688e-002,
   -3.301147e-002, -3.297355e-002, -3.293685e-002, -3.289329e-002, -3.284876e-002, -3.280400e-002, -3.276137e-002, -3.271631e-002, -3.266975e-002,
   -3.262341e-002, -3.257818e-002, -3.253365e-002, -3.248434e-002, -3.243188e-002, -3.237650e-002, -3.232121e-002, -3.226633e-002, -3.220718e-002,
   -3.214571e-002, -3.208198e-002, -3.201791e-002, -3.195090e-002, -3.187977e-002, -3.180300e-002, -3.172280e-002, -3.164116e-002, -3.155572e-002,
   -3.146735e-002, -3.137357e-002, -3.127847e-002, -3.118422e-002, -3.108368e-002, -3.097873e-002, -3.087175e-002, -3.076270e-002, -3.065118e-002,
   -3.053370e-002, -3.041047e-002, -3.028623e-002, -3.016156e-002, -3.003651e-002, -2.990797e-002, -2.977988e-002, -2.965398e-002, -2.952611e-002,
   -2.939309e-002, -2.925492e-002, -2.911300e-002, -2.897271e-002, -2.883175e-002, -2.868896e-002, -2.854478e-002, -2.839884e-002, -2.825371e-002,
   -2.810742e-002, -2.796095e-002, -2.781175e-002, -2.765748e-002, -2.750248e-002, -2.734364e-002, -2.718256e-002, -2.701869e-002, -2.685742e-002,
   -2.669690e-002, -2.653339e-002, -2.637057e-002, -2.620674e-002, -2.603931e-002, -2.586909e-002, -2.569720e-002, -2.552496e-002, -2.534904e-002,
   -2.517170e-002, -2.499340e-002, -2.481836e-002, -2.464383e-002, -2.446611e-002, -2.428726e-002, -2.410204e-002, -2.391778e-002, -2.373298e-002,
   -2.354938e-002, -2.336368e-002, -2.317681e-002, -2.298983e-002, -2.280452e-002, -2.262086e-002, -2.243574e-002, -2.224932e-002, -2.206124e-002,
   -2.187361e-002, -2.168629e-002, -2.149628e-002, -2.130444e-002, -2.111423e-002, -2.092539e-002, -2.073661e-002, -2.054704e-002, -2.035571e-002,
   -2.016589e-002, -1.997657e-002, -1.978525e-002, -1.959239e-002, -1.939691e-002, -1.920034e-002, -1.900579e-002, -1.881134e-002, -1.861693e-002,
   -1.842240e-002, -1.822638e-002, -1.803051e-002, -1.783656e-002, -1.764623e-002, -1.745772e-002, -1.726663e-002, -1.707309e-002, -1.687929e-002,
   -1.668741e-002, -1.649485e-002, -1.630447e-002, -1.611337e-002, -1.592193e-002, -1.572956e-002, -1.553841e-002, -1.534620e-002, -1.515653e-002,
   -1.496662e-002, -1.477267e-002, -1.457842e-002, -1.438401e-002, -1.418770e-002, -1.399272e-002, -1.379496e-002, -1.359669e-002, -1.340046e-002,
   -1.320370e-002, -1.300539e-002, -1.280573e-002, -1.260308e-002, -1.239963e-002, -1.219630e-002, -1.198908e-002, -1.177731e-002, -1.156688e-002,
   -1.135609e-002, -1.114344e-002, -1.092908e-002, -1.071463e-002, -1.049985e-002, -1.028499e-002, -1.006678e-002, -9.845976e-003, -9.624370e-003,
   -9.401041e-003, -9.175400e-003, -8.950493e-003, -8.722643e-003, -8.491283e-003, -8.259034e-003, -8.025257e-003, -7.789180e-003, -7.551850e-003,
   -7.311113e-003, -7.066043e-003, -6.818615e-003, -6.570490e-003, -6.322606e-003, -6.072834e-003, -5.820865e-003, -5.565984e-003, -5.309028e-003,
   -5.051837e-003, -4.791712e-003, -4.528116e-003, -4.262771e-003, -3.996271e-003, -3.728189e-003, -3.461617e-003, -3.195312e-003, -2.928175e-003,
   -2.661061e-003, -2.393332e-003, -2.125493e-003, -1.858081e-003, -1.590996e-003, -1.324668e-003, -1.058363e-003, -7.913172e-004, -5.221920e-004,
   -2.510189e-004, 2.140818e-005,  2.928121e-004,  5.630597e-004,  8.352630e-004,  1.108931e-003,  1.383521e-003,  1.657981e-003,  1.932709e-003,
   2.207605e-003,  2.482357e-003,  2.758673e-003,  3.037314e-003,  3.311569e-003,  3.585463e-003,  3.857855e-003,  4.131148e-003,  4.404711e-003,
   4.682437e-003,  4.962140e-003,  5.241502e-003,  5.520677e-003,  5.798921e-003,  6.076529e-003,  6.355233e-003,  6.630229e-003,  6.896276e-003,
   7.160813e-003,  7.423036e-003,  7.683619e-003,  7.942773e-003,  8.200177e-003,  8.456512e-003,  8.710720e-003,  8.964936e-003,  9.218669e-003,
   9.469419e-003,  9.718448e-003,  9.967114e-003,  1.021657e-002,  1.046084e-002,  1.069793e-002,  1.093269e-002,  1.116588e-002,  1.139857e-002,
   1.163240e-002,  1.186718e-002,  1.210047e-002,  1.233178e-002,  1.256112e-002,  1.278869e-002,  1.301435e-002,  1.324011e-002,  1.346778e-002,
   1.369427e-002,  1.391720e-002,  1.413625e-002,  1.435342e-002,  1.457140e-002,  1.478901e-002,  1.500581e-002,  1.521804e-002,  1.542812e-002,
   1.563485e-002,  1.583790e-002,  1.603386e-002,  1.622727e-002,  1.642084e-002,  1.661401e-002,  1.680573e-002,  1.699682e-002,  1.718835e-002,
   1.737690e-002,  1.756313e-002,  1.774984e-002,  1.793515e-002,  1.811611e-002,  1.829717e-002,  1.847575e-002,  1.865394e-002,  1.883276e-002,
   1.901329e-002,  1.919362e-002,  1.937381e-002,  1.955299e-002,  1.973262e-002,  1.991024e-002,  2.007569e-002,  2.023895e-002,  2.040218e-002,
   2.056510e-002,  2.072457e-002,  2.088419e-002,  2.104356e-002,  2.119746e-002,  2.135005e-002,  2.150264e-002,  2.165576e-002,  2.180790e-002,
   2.195855e-002,  2.210787e-002,  2.224657e-002,  2.237759e-002,  2.250815e-002,  2.263985e-002,  2.277238e-002,  2.290370e-002,  2.303282e-002,
   2.315917e-002,  2.328280e-002,  2.340484e-002,  2.352691e-002,  2.364822e-002,  2.376566e-002,  2.388233e-002,  2.399686e-002,  2.410843e-002,
   2.421724e-002,  2.432245e-002,  2.442169e-002,  2.451867e-002,  2.461635e-002,  2.471437e-002,  2.480897e-002,  2.490082e-002,  2.499110e-002,
   2.508133e-002,  2.517542e-002,  2.527088e-002,  2.536616e-002,  2.546041e-002,  2.555259e-002,  2.564398e-002,  2.573504e-002,  2.582530e-002,
   2.591610e-002,  2.600670e-002,  2.609049e-002,  2.616960e-002,  2.624690e-002,  2.632224e-002,  2.639638e-002,  2.646646e-002,  2.653611e-002,
   2.660697e-002,  2.667836e-002,  2.674905e-002,  2.681822e-002,  2.688619e-002,  2.695308e-002,  2.701991e-002,  2.708692e-002,  2.715228e-002,
   2.721881e-002,  2.728731e-002,  2.735443e-002,  2.741990e-002,  2.748351e-002,  2.754559e-002,  2.760754e-002,  2.766992e-002,  2.773132e-002,
   2.778697e-002,  2.784087e-002,  2.789418e-002,  2.794661e-002,  2.799862e-002,  2.805053e-002,  2.810131e-002,  2.815085e-002,  2.820139e-002,
   2.824903e-002,  2.829519e-002,  2.833650e-002,  2.837695e-002,  2.841817e-002,  2.846024e-002,  2.850330e-002,  2.854653e-002,  2.858834e-002,
   2.862776e-002,  2.866714e-002,  2.870822e-002,  2.874992e-002,  2.879280e-002,  2.883658e-002,  2.887837e-002,  2.891985e-002,  2.896213e-002,
   2.900452e-002,  2.904645e-002,  2.908751e-002,  2.912664e-002,  2.916125e-002,  2.919489e-002,  2.922734e-002,  2.925837e-002,  2.928688e-002,
   2.931367e-002,  2.933987e-002,  2.936466e-002,  2.938917e-002,  2.941494e-002,  2.943962e-002,  2.946136e-002,  2.948006e-002,  2.949563e-002,
   2.950960e-002,  2.952191e-002,  2.953362e-002,  2.954413e-002,  2.955414e-002,  2.956491e-002,  2.957439e-002,  2.957989e-002,  2.958568e-002,
   2.959031e-002,  2.959346e-002,  2.959619e-002,  2.960041e-002,  2.960541e-002,  2.961041e-002,  2.961507e-002,  2.962047e-002,  2.962507e-002,
   2.962887e-002,  2.963091e-002,  2.963218e-002,  2.963440e-002,  2.963310e-002,  2.963052e-002,  2.962576e-002,  2.961695e-002,  2.960482e-002,
   2.959002e-002,  2.957304e-002,  2.955240e-002,  2.953086e-002,  2.950836e-002,  2.948497e-002,  2.946018e-002,  2.943453e-002,  2.940795e-002,
   2.938030e-002,  2.935177e-002,  2.932053e-002,  2.928996e-002,  2.926032e-002,  2.923058e-002,  2.920033e-002,  2.916999e-002,  2.913908e-002,
   2.910708e-002,  2.907456e-002,  2.904135e-002,  2.900909e-002,  2.897787e-002,  2.894670e-002,  2.891464e-002,  2.888131e-002,  2.884690e-002,
   2.881171e-002,  2.877515e-002,  2.873658e-002,  2.869810e-002,  2.865913e-002,  2.861727e-002,  2.857394e-002,  2.852956e-002,  2.848188e-002,
   2.843185e-002,  2.838120e-002,  2.832874e-002,  2.827399e-002,  2.821993e-002,  2.816489e-002,  2.810958e-002,  2.805411e-002,  2.800055e-002,
   2.794712e-002,  2.789330e-002,  2.783867e-002,  2.778228e-002,  2.772642e-002,  2.767076e-002,  2.761538e-002,  2.755842e-002,  2.750172e-002,
   2.744443e-002,  2.738648e-002,  2.732786e-002,  2.726752e-002,  2.720471e-002,  2.714402e-002,  2.708276e-002,  2.701978e-002,  2.695388e-002,
   2.688552e-002,  2.681497e-002,  2.674168e-002,  2.666553e-002,  2.658529e-002,  2.650240e-002,  2.641919e-002,  2.633420e-002,  2.624774e-002,
   2.615760e-002,  2.606572e-002,  2.597198e-002,  2.587634e-002,  2.577769e-002,  2.567703e-002,  2.557585e-002,  2.547455e-002,  2.537420e-002,
   2.527359e-002,  2.517095e-002,  2.506483e-002,  2.495609e-002,  2.484646e-002,  2.473641e-002,  2.462477e-002,  2.451235e-002,  2.439961e-002,
   2.428628e-002,  2.417314e-002,  2.405808e-002,  2.394161e-002,  2.382471e-002,  2.370691e-002,  2.358810e-002,  2.346806e-002,  2.334681e-002,
   2.322358e-002,  2.309854e-002,  2.297210e-002,  2.284372e-002,  2.271237e-002,  2.258113e-002,  2.244906e-002,  2.231511e-002,  2.218007e-002,
   2.204387e-002,  2.190615e-002,  2.176667e-002,  2.162626e-002,  2.148471e-002,  2.133846e-002,  2.119118e-002,  2.104237e-002,  2.089317e-002,
   2.074246e-002,  2.058801e-002,  2.043430e-002,  2.027965e-002,  2.012410e-002,  1.996752e-002,  1.980653e-002,  1.964417e-002,  1.947994e-002,
   1.931414e-002,  1.914714e-002,  1.897797e-002,  1.880728e-002,  1.863435e-002,  1.845874e-002,  1.828167e-002,  1.809997e-002,  1.791451e-002,
   1.772691e-002,  1.753726e-002,  1.734495e-002,  1.714788e-002,  1.694687e-002,  1.674338e-002,  1.653714e-002,  1.632927e-002,  1.611793e-002,
   1.590216e-002,  1.568510e-002,  1.546762e-002,  1.524848e-002,  1.502823e-002,  1.480667e-002,  1.458427e-002,  1.435927e-002,  1.413336e-002,
   1.390664e-002,  1.367515e-002,  1.344395e-002,  1.321234e-002,  1.298018e-002,  1.274746e-002,  1.251421e-002,  1.228035e-002,  1.204704e-002,
   1.181207e-002,  1.157563e-002,  1.133152e-002,  1.108539e-002,  1.083813e-002,  1.058951e-002,  1.033983e-002,  1.008932e-002,  9.837875e-003,
   9.583791e-003,  9.327003e-003,  9.068603e-003,  8.805135e-003,  8.541302e-003,  8.276973e-003,  8.011151e-003,  7.741779e-003,  7.471056e-003,
   7.199198e-003,  6.926701e-003,  6.652117e-003,  6.372945e-003,  6.090283e-003,  5.804499e-003,  5.518835e-003,  5.233289e-003,  4.946827e-003,
   4.659788e-003,  4.373713e-003,  4.083638e-003,  3.791420e-003,  3.495903e-003,  3.187555e-003,  2.873031e-003,  2.557847e-003,  2.241773e-003,
   1.924788e-003,  1.606810e-003,  1.287795e-003,  9.675759e-004,  6.462152e-004,  3.236570e-004,  7.435108e-018},
  {0.000000e+000,  -6.469713e-002, -7.828328e-002, -8.686220e-002, -9.211825e-002, -9.558424e-002, -9.846409e-002, -1.007057e-001, -1.024699e-001,
   -1.037916e-001, -1.047760e-001, -1.054649e-001, -1.057462e-001, -1.056053e-001, -1.049179e-001, -1.037458e-001, -1.021393e-001, -1.002687e-001,
   -9.822223e-002, -9.594575e-002, -9.350405e-002, -9.096367e-002, -8.826829e-002, -8.553726e-002, -8.273321e-002, -7.986001e-002, -7.690865e-002,
   -7.387185e-002, -7.074680e-002, -6.755361e-002, -6.429751e-002, -6.099197e-002, -5.764445e-002, -5.425388e-002, -5.085381e-002, -4.744986e-002,
   -4.403984e-002, -4.058302e-002, -3.713389e-002, -3.370350e-002, -3.029566e-002, -2.686463e-002, -2.344809e-002, -2.008649e-002, -1.671963e-002,
   -1.337802e-002, -1.010702e-002, -6.864855e-003, -3.672138e-003, -5.307672e-004, 2.589418e-003,  5.674849e-003,  8.695555e-003,  1.171779e-002,
   1.464808e-002,  1.752246e-002,  2.036470e-002,  2.309187e-002,  2.575660e-002,  2.832696e-002,  3.079189e-002,  3.314843e-002,  3.544774e-002,
   3.764760e-002,  3.976008e-002,  4.179727e-002,  4.374745e-002,  4.559640e-002,  4.735952e-002,  4.903644e-002,  5.060058e-002,  5.208287e-002,
   5.348482e-002,  5.480818e-002,  5.602395e-002,  5.716275e-002,  5.821523e-002,  5.920252e-002,  6.010275e-002,  6.094844e-002,  6.173664e-002,
   6.243826e-002,  6.308983e-002,  6.368032e-002,  6.421476e-002,  6.469794e-002,  6.511787e-002,  6.548597e-002,  6.576099e-002,  6.598615e-002,
   6.614675e-002,  6.624009e-002,  6.624674e-002,  6.618259e-002,  6.602643e-002,  6.579915e-002,  6.550360e-002,  6.512106e-002,  6.463925e-002,
   6.409128e-002,  6.346120e-002,  6.275858e-002,  6.201425e-002,  6.120558e-002,  6.035688e-002,  5.946349e-002,  5.851048e-002,  5.750876e-002,
   5.646295e-002,  5.539168e-002,  5.424992e-002,  5.308774e-002,  5.189343e-002,  5.066878e-002,  4.939702e-002,  4.810207e-002,  4.677344e-002,
   4.542653e-002,  4.406433e-002,  4.265098e-002,  4.122814e-002,  3.978345e-002,  3.831821e-002,  3.683513e-002,  3.531468e-002,  3.378772e-002,
   3.224818e-002,  3.070666e-002,  2.914897e-002,  2.758195e-002,  2.601353e-002,  2.445871e-002,  2.290973e-002,  2.136340e-002,  1.982237e-002,
   1.829095e-002,  1.677156e-002,  1.525633e-002,  1.376226e-002,  1.226910e-002,  1.078235e-002,  9.318496e-003,  7.867929e-003,  6.432017e-003,
   5.003915e-003,  3.604318e-003,  2.223420e-003,  8.547227e-004,  -4.877055e-004, -1.807694e-003, -3.107970e-003, -4.385532e-003, -5.638788e-003,
   -6.866865e-003, -8.074734e-003, -9.267347e-003, -1.042628e-002, -1.155523e-002, -1.266292e-002, -1.374568e-002, -1.480350e-002, -1.582305e-002,
   -1.681563e-002, -1.776001e-002, -1.868603e-002, -1.958011e-002, -2.043513e-002, -2.125504e-002, -2.205138e-002, -2.282605e-002, -2.356869e-002,
   -2.428369e-002, -2.496682e-002, -2.561731e-002, -2.624393e-002, -2.684944e-002, -2.742411e-002, -2.797223e-002, -2.849773e-002, -2.900693e-002,
   -2.948752e-002, -2.994816e-002, -3.038768e-002, -3.081011e-002, -3.121545e-002, -3.160541e-002, -3.197178e-002, -3.232573e-002, -3.266658e-002,
   -3.298497e-002, -3.328772e-002, -3.357785e-002, -3.385232e-002, -3.411056e-002, -3.434806e-002, -3.457410e-002, -3.478713e-002, -3.498274e-002,
   -3.515363e-002, -3.531586e-002, -3.546732e-002, -3.561505e-002, -3.574698e-002, -3.587096e-002, -3.596673e-002, -3.606402e-002, -3.614986e-002,
   -3.623441e-002, -3.630137e-002, -3.636224e-002, -3.642192e-002, -3.646557e-002, -3.650864e-002, -3.652658e-002, -3.654059e-002, -3.653371e-002,
   -3.651568e-002, -3.650123e-002, -3.647878e-002, -3.645327e-002, -3.641473e-002, -3.637458e-002, -3.633287e-002, -3.628509e-002, -3.623413e-002,
   -3.617405e-002, -3.609516e-002, -3.601382e-002, -3.592722e-002, -3.584515e-002, -3.576005e-002, -3.566187e-002, -3.555786e-002, -3.543635e-002,
   -3.532140e-002, -3.520260e-002, -3.506985e-002, -3.493287e-002, -3.477655e-002, -3.460915e-002, -3.445059e-002, -3.428397e-002, -3.410934e-002,
   -3.392135e-002, -3.371533e-002, -3.350538e-002, -3.330485e-002, -3.308700e-002, -3.286704e-002, -3.263976e-002, -3.240353e-002, -3.215252e-002,
   -3.190454e-002, -3.165636e-002, -3.140870e-002, -3.114935e-002, -3.088873e-002, -3.062491e-002, -3.035330e-002, -3.008189e-002, -2.980032e-002,
   -2.950477e-002, -2.920876e-002, -2.890041e-002, -2.857632e-002, -2.825969e-002, -2.793609e-002, -2.761030e-002, -2.728419e-002, -2.694444e-002,
   -2.659894e-002, -2.625316e-002, -2.590819e-002, -2.555708e-002, -2.519867e-002, -2.482573e-002, -2.444520e-002, -2.405853e-002, -2.366800e-002,
   -2.327730e-002, -2.289013e-002, -2.249635e-002, -2.209150e-002, -2.167495e-002, -2.125765e-002, -2.083612e-002, -2.041710e-002, -2.000520e-002,
   -1.959938e-002, -1.919129e-002, -1.877985e-002, -1.835896e-002, -1.793262e-002, -1.751796e-002, -1.711021e-002, -1.671708e-002, -1.633344e-002,
   -1.594612e-002, -1.554789e-002, -1.514211e-002, -1.473306e-002, -1.433118e-002, -1.393662e-002, -1.355774e-002, -1.317637e-002, -1.279617e-002,
   -1.241989e-002, -1.203777e-002, -1.164872e-002, -1.125977e-002, -1.087416e-002, -1.050511e-002, -1.014183e-002, -9.779162e-003, -9.419219e-003,
   -9.068369e-003, -8.724870e-003, -8.378705e-003, -8.025508e-003, -7.678557e-003, -7.342223e-003, -7.004579e-003, -6.672211e-003, -6.340469e-003,
   -6.006833e-003, -5.667340e-003, -5.336685e-003, -5.008936e-003, -4.681159e-003, -4.362073e-003, -4.048104e-003, -3.733661e-003, -3.409438e-003,
   -3.093370e-003, -2.775665e-003, -2.451900e-003, -2.122110e-003, -1.808526e-003, -1.494753e-003, -1.172514e-003, -8.560255e-004, -5.530390e-004,
   -2.482669e-004, 6.327031e-005,  3.705023e-004,  6.780779e-004,  9.896990e-004,  1.303300e-003,  1.608933e-003,  1.903439e-003,  2.192033e-003,
   2.478485e-003,  2.758963e-003,  3.041980e-003,  3.327492e-003,  3.612473e-003,  3.893617e-003,  4.170845e-003,  4.443882e-003,  4.714857e-003,
   4.977444e-003,  5.232276e-003,  5.473099e-003,  5.719741e-003,  5.960384e-003,  6.197108e-003,  6.425966e-003,  6.652598e-003,  6.876645e-003,
   7.096168e-003,  7.316715e-003,  7.532865e-003,  7.745077e-003,  7.954218e-003,  8.159821e-003,  8.371581e-003,  8.576753e-003,  8.777826e-003,
   8.972151e-003,  9.174652e-003,  9.376912e-003,  9.576662e-003,  9.775730e-003,  9.973411e-003,  1.016606e-002,  1.035288e-002,  1.053215e-002,
   1.071271e-002,  1.089768e-002,  1.107173e-002,  1.123799e-002,  1.141147e-002,  1.159198e-002,  1.177428e-002,  1.195221e-002,  1.212903e-002,
   1.231008e-002,  1.249142e-002,  1.266480e-002,  1.283348e-002,  1.299771e-002,  1.316520e-002,  1.332222e-002,  1.347624e-002,  1.363001e-002,
   1.378710e-002,  1.393893e-002,  1.409555e-002,  1.425783e-002,  1.442263e-002,  1.458512e-002,  1.474156e-002,  1.489157e-002,  1.503672e-002,
   1.517820e-002,  1.531295e-002,  1.544401e-002,  1.557124e-002,  1.570071e-002,  1.582456e-002,  1.594279e-002,  1.606681e-002,  1.619073e-002,
   1.631032e-002,  1.642245e-002,  1.652711e-002,  1.663151e-002,  1.673808e-002,  1.684839e-002,  1.694630e-002,  1.704264e-002,  1.714222e-002,
   1.724219e-002,  1.734485e-002,  1.744845e-002,  1.755396e-002,  1.765652e-002,  1.775528e-002,  1.785925e-002,  1.796461e-002,  1.807811e-002,
   1.819162e-002,  1.830988e-002,  1.843336e-002,  1.855691e-002,  1.868156e-002,  1.879863e-002,  1.891709e-002,  1.903567e-002,  1.915606e-002,
   1.927826e-002,  1.940671e-002,  1.953632e-002,  1.966803e-002,  1.980208e-002,  1.993816e-002,  2.007503e-002,  2.021599e-002,  2.036183e-002,
   2.050835e-002,  2.064794e-002,  2.079284e-002,  2.093873e-002,  2.108389e-002,  2.121629e-002,  2.134323e-002,  2.147300e-002,  2.160443e-002,
   2.173438e-002,  2.186495e-002,  2.199561e-002,  2.212724e-002,  2.225363e-002,  2.237569e-002,  2.249110e-002,  2.260387e-002,  2.271555e-002,
   2.282435e-002,  2.293389e-002,  2.303817e-002,  2.313783e-002,  2.323866e-002,  2.334169e-002,  2.344180e-002,  2.353482e-002,  2.362114e-002,
   2.370497e-002,  2.378883e-002,  2.387323e-002,  2.395422e-002,  2.403218e-002,  2.410758e-002,  2.417310e-002,  2.423806e-002,  2.429789e-002,
   2.435348e-002,  2.440469e-002,  2.445107e-002,  2.449678e-002,  2.454035e-002,  2.457773e-002,  2.460996e-002,  2.463956e-002,  2.466377e-002,
   2.468411e-002,  2.469747e-002,  2.470441e-002,  2.470438e-002,  2.470047e-002,  2.468993e-002,  2.467398e-002,  2.466152e-002,  2.464754e-002,
   2.463338e-002,  2.462103e-002,  2.461048e-002,  2.460505e-002,  2.460307e-002,  2.460096e-002,  2.460043e-002,  2.460160e-002,  2.460665e-002,
   2.461550e-002,  2.462380e-002,  2.463099e-002,  2.463669e-002,  2.464766e-002,  2.465821e-002,  2.466327e-002,  2.466966e-002,  2.467323e-002,
   2.467568e-002,  2.467941e-002,  2.468133e-002,  2.468430e-002,  2.468566e-002,  2.468287e-002,  2.468217e-002,  2.468345e-002,  2.468323e-002,
   2.467766e-002,  2.466956e-002,  2.466029e-002,  2.465382e-002,  2.464682e-002,  2.463666e-002,  2.462295e-002,  2.460483e-002,  2.458508e-002,
   2.456382e-002,  2.454258e-002,  2.452160e-002,  2.449445e-002,  2.446215e-002,  2.442702e-002,  2.438685e-002,  2.434432e-002,  2.429725e-002,
   2.424789e-002,  2.419664e-002,  2.414239e-002,  2.408240e-002,  2.402071e-002,  2.395808e-002,  2.388684e-002,  2.381085e-002,  2.373556e-002,
   2.365988e-002,  2.358518e-002,  2.351202e-002,  2.343433e-002,  2.335242e-002,  2.326923e-002,  2.318460e-002,  2.310367e-002,  2.302928e-002,
   2.295453e-002,  2.287819e-002,  2.279826e-002,  2.271765e-002,  2.263280e-002,  2.254679e-002,  2.245907e-002,  2.236747e-002,  2.227408e-002,
   2.217659e-002,  2.207895e-002,  2.197686e-002,  2.186393e-002,  2.174706e-002,  2.162682e-002,  2.150253e-002,  2.137813e-002,  2.124852e-002,
   2.111178e-002,  2.097042e-002,  2.082634e-002,  2.067989e-002,  2.052427e-002,  2.036544e-002,  2.020594e-002,  2.004695e-002,  1.988641e-002,
   1.972133e-002,  1.955308e-002,  1.938313e-002,  1.920888e-002,  1.903272e-002,  1.885401e-002,  1.867309e-002,  1.848854e-002,  1.829809e-002,
   1.810801e-002,  1.791995e-002,  1.773515e-002,  1.754897e-002,  1.736490e-002,  1.718336e-002,  1.700188e-002,  1.681903e-002,  1.663972e-002,
   1.646311e-002,  1.629235e-002,  1.612415e-002,  1.595575e-002,  1.578185e-002,  1.560191e-002,  1.542351e-002,  1.524853e-002,  1.507342e-002,
   1.490000e-002,  1.472524e-002,  1.454808e-002,  1.436873e-002,  1.418834e-002,  1.400464e-002,  1.382014e-002,  1.363393e-002,  1.344717e-002,
   1.325962e-002,  1.306770e-002,  1.287641e-002,  1.268371e-002,  1.248988e-002,  1.229512e-002,  1.209297e-002,  1.188538e-002,  1.168147e-002,
   1.147991e-002,  1.127749e-002,  1.107289e-002,  1.086519e-002,  1.065663e-002,  1.044708e-002,  1.023466e-002,  1.001842e-002,  9.797728e-003,
   9.575952e-003,  9.353547e-003,  9.130139e-003,  8.906888e-003,  8.680285e-003,  8.448413e-003,  8.210929e-003,  7.970192e-003,  7.728476e-003,
   7.485796e-003,  7.241040e-003,  6.994088e-003,  6.743012e-003,  6.486717e-003,  6.228414e-003,  5.965036e-003,  5.703174e-003,  5.440872e-003,
   5.178946e-003,  4.915254e-003,  4.649898e-003,  4.385245e-003,  4.119458e-003,  3.855736e-003,  3.593426e-003,  3.331036e-003,  3.070594e-003,
   2.810871e-003,  2.551814e-003,  2.294389e-003,  2.038227e-003,  1.784816e-003,  1.536631e-003,  1.290172e-003,  1.044451e-003,  8.014830e-004,
   5.612823e-004,  3.223942e-004,  8.606447e-005,  -1.492419e-004, -3.836474e-004, -6.161727e-004, -8.459682e-004, -1.072967e-003, -1.297765e-003,
   -1.521848e-003, -1.744353e-003, -1.967006e-003, -2.189597e-003, -2.412024e-003, -2.634081e-003, -2.860468e-003, -3.088981e-003, -3.318789e-003,
   -3.549015e-003, -3.781653e-003, -4.016864e-003, -4.253058e-003, -4.490186e-003, -4.729270e-003, -4.970168e-003, -5.211515e-003, -5.453856e-003,
   -5.702097e-003, -5.950879e-003, -6.198840e-003, -6.446401e-003, -6.696393e-003, -6.948213e-003, -7.203690e-003, -7.461122e-003, -7.718444e-003,
   -7.974375e-003, -8.228753e-003, -8.480625e-003, -8.735986e-003, -8.991849e-003, -9.247726e-003, -9.505388e-003, -9.764156e-003, -1.002380e-002,
   -1.028405e-002, -1.054084e-002, -1.079839e-002, -1.105724e-002, -1.131689e-002, -1.157669e-002, -1.183838e-002, -1.210115e-002, -1.236222e-002,
   -1.262037e-002, -1.288148e-002, -1.314344e-002, -1.340458e-002, -1.366718e-002, -1.393092e-002, -1.419661e-002, -1.446416e-002, -1.472882e-002,
   -1.499741e-002, -1.527085e-002, -1.554702e-002, -1.582706e-002, -1.610954e-002, -1.639179e-002, -1.667363e-002, -1.695181e-002, -1.722961e-002,
   -1.751060e-002, -1.779443e-002, -1.807916e-002, -1.836610e-002, -1.865573e-002, -1.895005e-002, -1.924631e-002, -1.953794e-002, -1.982801e-002,
   -2.011786e-002, -2.040675e-002, -2.069546e-002, -2.098438e-002, -2.127256e-002, -2.155927e-002, -2.184541e-002, -2.213186e-002, -2.241507e-002,
   -2.269731e-002, -2.297683e-002, -2.325343e-002, -2.352645e-002, -2.379552e-002, -2.406015e-002, -2.432153e-002, -2.458049e-002, -2.483710e-002,
   -2.509053e-002, -2.534055e-002, -2.558961e-002, -2.583631e-002, -2.608061e-002, -2.632558e-002, -2.656768e-002, -2.680694e-002, -2.704260e-002,
   -2.727655e-002, -2.750937e-002, -2.774004e-002, -2.797067e-002, -2.820135e-002, -2.843305e-002, -2.866541e-002, -2.889548e-002, -2.912432e-002,
   -2.935349e-002, -2.958233e-002, -2.981045e-002, -3.003581e-002, -3.025792e-002, -3.047710e-002, -3.069430e-002, -3.090894e-002, -3.112030e-002,
   -3.132802e-002, -3.152953e-002, -3.172998e-002, -3.192716e-002, -3.212286e-002, -3.231720e-002, -3.250905e-002, -3.269861e-002, -3.288566e-002,
   -3.307003e-002, -3.325347e-002, -3.343313e-002, -3.361087e-002, -3.378396e-002, -3.395387e-002, -3.412284e-002, -3.429113e-002, -3.445767e-002,
   -3.462374e-002, -3.479154e-002, -3.495918e-002, -3.512264e-002, -3.528609e-002, -3.544544e-002, -3.560309e-002, -3.575832e-002, -3.591354e-002,
   -3.606808e-002, -3.622087e-002, -3.637071e-002, -3.651832e-002, -3.665980e-002, -3.679747e-002, -3.693382e-002, -3.706887e-002, -3.720216e-002,
   -3.733594e-002, -3.747021e-002, -3.760209e-002, -3.773188e-002, -3.786154e-002, -3.798599e-002, -3.810754e-002, -3.822909e-002, -3.835180e-002,
   -3.847460e-002, -3.859646e-002, -3.871935e-002, -3.884211e-002, -3.896610e-002, -3.909227e-002, -3.921192e-002, -3.932457e-002, -3.943722e-002,
   -3.955001e-002, -3.966218e-002, -3.977233e-002, -3.988096e-002, -3.998759e-002, -4.009208e-002, -4.019456e-002, -4.029081e-002, -4.037704e-002,
   -4.045696e-002, -4.052301e-002, -4.058132e-002, -4.063269e-002, -4.067976e-002, -4.072108e-002, -4.075773e-002, -4.079054e-002, -4.081888e-002,
   -4.083108e-002, -4.083847e-002, -4.084045e-002, -4.083695e-002, -4.082632e-002, -4.080907e-002, -4.078653e-002, -4.075970e-002, -4.073380e-002,
   -4.070558e-002, -4.066605e-002, -4.062168e-002, -4.057635e-002, -4.053042e-002, -4.048439e-002, -4.043798e-002, -4.038752e-002, -4.033951e-002,
   -4.029268e-002, -4.024423e-002, -4.018799e-002, -4.012350e-002, -4.005710e-002, -3.998893e-002, -3.991869e-002, -3.984632e-002, -3.977418e-002,
   -3.970271e-002, -3.962869e-002, -3.955072e-002, -3.946492e-002, -3.936503e-002, -3.926086e-002, -3.915602e-002, -3.904906e-002, -3.894186e-002,
   -3.883076e-002, -3.871626e-002, -3.860040e-002, -3.848227e-002, -3.835984e-002, -3.821386e-002, -3.806576e-002, -3.791635e-002, -3.776568e-002,
   -3.761430e-002, -3.745988e-002, -3.730235e-002, -3.714267e-002, -3.698171e-002, -3.681943e-002, -3.663804e-002, -3.645160e-002, -3.626004e-002,
   -3.606420e-002, -3.586515e-002, -3.566253e-002, -3.545444e-002, -3.524196e-002, -3.502434e-002, -3.479720e-002, -3.454854e-002, -3.428425e-002,
   -3.401370e-002, -3.373672e-002, -3.345306e-002, -3.315869e-002, -3.285711e-002, -3.254918e-002, -3.223500e-002, -3.191521e-002, -3.158003e-002,
   -3.122345e-002, -3.086254e-002, -3.049347e-002, -3.012136e-002, -2.974533e-002, -2.936611e-002, -2.898553e-002, -2.859750e-002, -2.820706e-002,
   -2.781376e-002, -2.739560e-002, -2.697754e-002, -2.656104e-002, -2.614437e-002, -2.572719e-002, -2.530948e-002, -2.488978e-002, -2.446722e-002,
   -2.404288e-002, -2.361898e-002, -2.315664e-002, -2.268684e-002, -2.221551e-002, -2.174211e-002, -2.126660e-002, -2.078944e-002, -2.031042e-002,
   -1.983102e-002, -1.934786e-002, -1.886225e-002, -1.834936e-002, -1.782041e-002, -1.728978e-002, -1.675420e-002, -1.620606e-002, -1.565660e-002,
   -1.510645e-002, -1.455489e-002, -1.400285e-002, -1.344636e-002, -1.287052e-002, -1.227259e-002, -1.167410e-002, -1.107524e-002, -1.047727e-002,
   -9.877835e-003, -9.273231e-003, -8.655532e-003, -8.031998e-003, -7.408098e-003, -6.768808e-003, -6.094122e-003, -5.420056e-003, -4.746569e-003,
   -4.072105e-003, -3.396666e-003, -2.720035e-003, -2.041980e-003, -1.362527e-003, -6.818454e-004, -8.441329e-018},
  {0.000000e+000,  -9.303034e-002, -1.043270e-001, -1.089305e-001, -1.112771e-001, -1.122107e-001, -1.115387e-001, -1.098958e-001, -1.077653e-001,
   -1.051520e-001, -1.020536e-001, -9.863098e-002, -9.495198e-002, -9.115456e-002, -8.731258e-002, -8.346059e-002, -7.950756e-002, -7.544519e-002,
   -7.124775e-002, -6.703300e-002, -6.278051e-002, -5.854203e-002, -5.428164e-002, -5.000572e-002, -4.573679e-002, -4.148641e-002, -3.723481e-002,
   -3.300679e-002, -2.877581e-002, -2.457002e-002, -2.041787e-002, -1.635034e-002, -1.237288e-002, -8.480525e-003, -4.738316e-003, -1.119081e-003,
   2.362968e-003,  5.698824e-003,  8.898447e-003,  1.196393e-002,  1.487221e-002,  1.762636e-002,  2.027874e-002,  2.275033e-002,  2.510044e-002,
   2.731678e-002,  2.936266e-002,  3.128832e-002,  3.306548e-002,  3.472033e-002,  3.624400e-002,  3.759164e-002,  3.879899e-002,  3.989232e-002,
   4.084855e-002,  4.171747e-002,  4.254545e-002,  4.328453e-002,  4.397328e-002,  4.464648e-002,  4.525405e-002,  4.586957e-002,  4.648785e-002,
   4.703341e-002,  4.750380e-002,  4.792682e-002,  4.829667e-002,  4.859971e-002,  4.886785e-002,  4.908528e-002,  4.920737e-002,  4.928087e-002,
   4.932687e-002,  4.932539e-002,  4.923916e-002,  4.911107e-002,  4.893566e-002,  4.870492e-002,  4.839777e-002,  4.805972e-002,  4.765583e-002,
   4.716266e-002,  4.660307e-002,  4.600542e-002,  4.529323e-002,  4.451696e-002,  4.369199e-002,  4.277729e-002,  4.177616e-002,  4.073652e-002,
   3.962325e-002,  3.847811e-002,  3.722188e-002,  3.592511e-002,  3.456954e-002,  3.314710e-002,  3.167329e-002,  3.015168e-002,  2.855270e-002,
   2.692613e-002,  2.527488e-002,  2.356581e-002,  2.184884e-002,  2.009119e-002,  1.831962e-002,  1.652453e-002,  1.469347e-002,  1.285258e-002,
   1.099660e-002,  9.148225e-003,  7.268883e-003,  5.408934e-003,  3.540035e-003,  1.693736e-003,  -1.236256e-004, -1.905663e-003, -3.687461e-003,
   -5.447510e-003, -7.154115e-003, -8.863895e-003, -1.051590e-002, -1.215173e-002, -1.375109e-002, -1.530053e-002, -1.681718e-002, -1.828086e-002,
   -1.970373e-002, -2.109478e-002, -2.244971e-002, -2.377175e-002, -2.506424e-002, -2.632043e-002, -2.752982e-002, -2.868364e-002, -2.978081e-002,
   -3.081732e-002, -3.181841e-002, -3.279818e-002, -3.371280e-002, -3.459856e-002, -3.546493e-002, -3.628787e-002, -3.703949e-002, -3.776670e-002,
   -3.846436e-002, -3.912116e-002, -3.975772e-002, -4.038634e-002, -4.098569e-002, -4.153772e-002, -4.205998e-002, -4.257041e-002, -4.306705e-002,
   -4.355096e-002, -4.401686e-002, -4.447502e-002, -4.487894e-002, -4.525036e-002, -4.562979e-002, -4.598490e-002, -4.634284e-002, -4.668134e-002,
   -4.696885e-002, -4.723291e-002, -4.749072e-002, -4.774066e-002, -4.796676e-002, -4.814433e-002, -4.829204e-002, -4.844392e-002, -4.857639e-002,
   -4.868928e-002, -4.873343e-002, -4.876303e-002, -4.878049e-002, -4.878612e-002, -4.870593e-002, -4.858596e-002, -4.845367e-002, -4.831608e-002,
   -4.807066e-002, -4.780161e-002, -4.750407e-002, -4.713799e-002, -4.671949e-002, -4.627722e-002, -4.575552e-002, -4.518642e-002, -4.459805e-002,
   -4.389375e-002, -4.316171e-002, -4.236791e-002, -4.150750e-002, -4.061161e-002, -3.961851e-002, -3.860121e-002, -3.749940e-002, -3.638053e-002,
   -3.518935e-002, -3.397700e-002, -3.272644e-002, -3.146315e-002, -3.017875e-002, -2.888053e-002, -2.757329e-002, -2.625708e-002, -2.496456e-002,
   -2.366403e-002, -2.238617e-002, -2.110061e-002, -1.985026e-002, -1.859525e-002, -1.739433e-002, -1.618445e-002, -1.500915e-002, -1.384491e-002,
   -1.269358e-002, -1.158436e-002, -1.048297e-002, -9.424129e-003, -8.367092e-003, -7.325523e-003, -6.320015e-003, -5.322653e-003, -4.352684e-003,
   -3.392985e-003, -2.433504e-003, -1.502217e-003, -5.995891e-004, 2.893460e-004,  1.154213e-003,  2.014878e-003,  2.881001e-003,  3.732345e-003,
   4.538165e-003,  5.336501e-003,  6.127824e-003,  6.885954e-003,  7.658883e-003,  8.429773e-003,  9.159087e-003,  9.879434e-003,  1.058440e-002,
   1.129046e-002,  1.198059e-002,  1.265760e-002,  1.330774e-002,  1.395927e-002,  1.457827e-002,  1.518631e-002,  1.579176e-002,  1.640320e-002,
   1.697146e-002,  1.753342e-002,  1.808937e-002,  1.864566e-002,  1.916627e-002,  1.968177e-002,  2.019282e-002,  2.068944e-002,  2.116874e-002,
   2.164423e-002,  2.210696e-002,  2.255649e-002,  2.300955e-002,  2.343174e-002,  2.384105e-002,  2.424369e-002,  2.463825e-002,  2.501927e-002,
   2.537309e-002,  2.571329e-002,  2.603680e-002,  2.634311e-002,  2.663341e-002,  2.691613e-002,  2.718778e-002,  2.744777e-002,  2.768991e-002,
   2.789870e-002,  2.807986e-002,  2.825501e-002,  2.842605e-002,  2.860068e-002,  2.875888e-002,  2.889413e-002,  2.901452e-002,  2.912205e-002,
   2.921247e-002,  2.929385e-002,  2.937240e-002,  2.945516e-002,  2.953591e-002,  2.959643e-002,  2.964768e-002,  2.967629e-002,  2.969223e-002,
   2.971112e-002,  2.973641e-002,  2.976402e-002,  2.978845e-002,  2.980206e-002,  2.981243e-002,  2.980830e-002,  2.980673e-002,  2.979774e-002,
   2.977557e-002,  2.976568e-002,  2.975920e-002,  2.975318e-002,  2.975866e-002,  2.974631e-002,  2.972254e-002,  2.970313e-002,  2.968283e-002,
   2.965906e-002,  2.963541e-002,  2.961749e-002,  2.961489e-002,  2.961390e-002,  2.959442e-002,  2.956762e-002,  2.954296e-002,  2.951549e-002,
   2.948730e-002,  2.946392e-002,  2.943189e-002,  2.940184e-002,  2.936614e-002,  2.931923e-002,  2.926116e-002,  2.919633e-002,  2.914288e-002,
   2.909262e-002,  2.904035e-002,  2.898404e-002,  2.892859e-002,  2.886306e-002,  2.879542e-002,  2.872363e-002,  2.865928e-002,  2.859319e-002,
   2.852168e-002,  2.844157e-002,  2.836134e-002,  2.828691e-002,  2.821710e-002,  2.814341e-002,  2.805664e-002,  2.795905e-002,  2.785542e-002,
   2.774758e-002,  2.763816e-002,  2.753532e-002,  2.744040e-002,  2.733492e-002,  2.724073e-002,  2.714756e-002,  2.705893e-002,  2.696322e-002,
   2.686550e-002,  2.675897e-002,  2.663641e-002,  2.651716e-002,  2.640664e-002,  2.630038e-002,  2.619243e-002,  2.607988e-002,  2.597174e-002,
   2.585216e-002,  2.573069e-002,  2.559872e-002,  2.546299e-002,  2.532555e-002,  2.518761e-002,  2.504809e-002,  2.489045e-002,  2.472366e-002,
   2.455824e-002,  2.439427e-002,  2.422145e-002,  2.405232e-002,  2.388095e-002,  2.369445e-002,  2.349408e-002,  2.329504e-002,  2.308756e-002,
   2.287485e-002,  2.265870e-002,  2.243203e-002,  2.219888e-002,  2.196137e-002,  2.171924e-002,  2.147157e-002,  2.122252e-002,  2.097307e-002,
   2.072168e-002,  2.046219e-002,  2.020029e-002,  1.992333e-002,  1.963633e-002,  1.934764e-002,  1.905203e-002,  1.875611e-002,  1.845532e-002,
   1.815623e-002,  1.785154e-002,  1.754728e-002,  1.725372e-002,  1.696278e-002,  1.666208e-002,  1.636052e-002,  1.605885e-002,  1.575126e-002,
   1.543698e-002,  1.511962e-002,  1.479998e-002,  1.448403e-002,  1.417573e-002,  1.387004e-002,  1.355709e-002,  1.324904e-002,  1.295061e-002,
   1.265536e-002,  1.235077e-002,  1.204275e-002,  1.173761e-002,  1.143932e-002,  1.114628e-002,  1.084266e-002,  1.053770e-002,  1.023308e-002,
   9.930177e-003,  9.626567e-003,  9.322103e-003,  9.014777e-003,  8.704896e-003,  8.396409e-003,  8.091276e-003,  7.785713e-003,  7.486422e-003,
   7.185851e-003,  6.881343e-003,  6.565880e-003,  6.247711e-003,  5.930411e-003,  5.602225e-003,  5.270708e-003,  4.935523e-003,  4.597738e-003,
   4.252543e-003,  3.908867e-003,  3.560984e-003,  3.202739e-003,  2.842120e-003,  2.473756e-003,  2.107328e-003,  1.740755e-003,  1.375019e-003,
   1.013677e-003,  6.468577e-004,  2.801418e-004,  -9.032403e-005, -4.715020e-004, -8.635331e-004, -1.265031e-003, -1.663909e-003, -2.054582e-003,
   -2.436957e-003, -2.817296e-003, -3.193600e-003, -3.567967e-003, -3.939406e-003, -4.309288e-003, -4.694035e-003, -5.079178e-003, -5.461835e-003,
   -5.836651e-003, -6.207453e-003, -6.577243e-003, -6.946944e-003, -7.310163e-003, -7.671361e-003, -8.024875e-003, -8.373197e-003, -8.732091e-003,
   -9.092484e-003, -9.449519e-003, -9.793405e-003, -1.012953e-002, -1.046076e-002, -1.078905e-002, -1.111630e-002, -1.143436e-002, -1.175081e-002,
   -1.206400e-002, -1.237265e-002, -1.268433e-002, -1.299383e-002, -1.329012e-002, -1.358470e-002, -1.387121e-002, -1.415897e-002, -1.444438e-002,
   -1.471914e-002, -1.498634e-002, -1.525164e-002, -1.551813e-002, -1.578291e-002, -1.603966e-002, -1.629817e-002, -1.655223e-002, -1.681210e-002,
   -1.707526e-002, -1.734172e-002, -1.760486e-002, -1.786187e-002, -1.811735e-002, -1.837155e-002, -1.862751e-002, -1.888750e-002, -1.913764e-002,
   -1.937964e-002, -1.962844e-002, -1.988251e-002, -2.014016e-002, -2.039957e-002, -2.064958e-002, -2.090213e-002, -2.115651e-002, -2.141170e-002,
   -2.166483e-002, -2.191784e-002, -2.216633e-002, -2.240626e-002, -2.263723e-002, -2.286913e-002, -2.310855e-002, -2.335650e-002, -2.359114e-002,
   -2.381785e-002, -2.404510e-002, -2.427410e-002, -2.450184e-002, -2.473072e-002, -2.495013e-002, -2.516223e-002, -2.537511e-002, -2.558991e-002,
   -2.580201e-002, -2.601053e-002, -2.621077e-002, -2.640861e-002, -2.660771e-002, -2.679730e-002, -2.698717e-002, -2.717737e-002, -2.736315e-002,
   -2.753237e-002, -2.769801e-002, -2.786297e-002, -2.802723e-002, -2.818645e-002, -2.834224e-002, -2.849099e-002, -2.864086e-002, -2.879140e-002,
   -2.893860e-002, -2.908796e-002, -2.924236e-002, -2.939318e-002, -2.954162e-002, -2.969246e-002, -2.983721e-002, -2.997453e-002, -3.010417e-002,
   -3.023105e-002, -3.035269e-002, -3.046869e-002, -3.058286e-002, -3.069480e-002, -3.080807e-002, -3.092121e-002, -3.102877e-002, -3.112530e-002,
   -3.122324e-002, -3.131739e-002, -3.140554e-002, -3.148672e-002, -3.156605e-002, -3.163701e-002, -3.170708e-002, -3.176903e-002, -3.182474e-002,
   -3.187429e-002, -3.192084e-002, -3.196329e-002, -3.199648e-002, -3.201448e-002, -3.202499e-002, -3.202130e-002, -3.201297e-002, -3.200232e-002,
   -3.199325e-002, -3.198028e-002, -3.196750e-002, -3.195689e-002, -3.194324e-002, -3.192755e-002, -3.191414e-002, -3.189178e-002, -3.185126e-002,
   -3.181082e-002, -3.176886e-002, -3.172515e-002, -3.168396e-002, -3.164452e-002, -3.160541e-002, -3.156385e-002, -3.152518e-002, -3.148691e-002,
   -3.144838e-002, -3.141128e-002, -3.137727e-002, -3.134623e-002, -3.130302e-002, -3.125093e-002, -3.119797e-002, -3.114230e-002, -3.108608e-002,
   -3.102881e-002, -3.097350e-002, -3.091716e-002, -3.086050e-002, -3.079957e-002, -3.073195e-002, -3.066171e-002, -3.058957e-002, -3.051443e-002,
   -3.043771e-002, -3.035529e-002, -3.026525e-002, -3.017571e-002, -3.009037e-002, -3.000084e-002, -2.989992e-002, -2.978251e-002, -2.965803e-002,
   -2.952848e-002, -2.939706e-002, -2.926392e-002, -2.912811e-002, -2.899045e-002, -2.885192e-002, -2.870888e-002, -2.856516e-002, -2.841528e-002,
   -2.825869e-002, -2.809769e-002, -2.792968e-002, -2.775836e-002, -2.758246e-002, -2.740393e-002, -2.722410e-002, -2.704723e-002, -2.687288e-002,
   -2.668815e-002, -2.649755e-002, -2.630461e-002, -2.610554e-002, -2.590675e-002, -2.570347e-002, -2.548978e-002, -2.526934e-002, -2.504801e-002,
   -2.482454e-002, -2.458784e-002, -2.435185e-002, -2.411539e-002, -2.387697e-002, -2.364078e-002, -2.340161e-002, -2.316548e-002, -2.293494e-002,
   -2.270383e-002, -2.247407e-002, -2.223858e-002, -2.200098e-002, -2.177069e-002, -2.154047e-002, -2.131269e-002, -2.108827e-002, -2.086330e-002,
   -2.064155e-002, -2.041804e-002, -2.019518e-002, -1.996611e-002, -1.972738e-002, -1.948897e-002, -1.925106e-002, -1.901025e-002, -1.876611e-002,
   -1.852013e-002, -1.827487e-002, -1.802381e-002, -1.777121e-002, -1.752035e-002, -1.726326e-002, -1.699705e-002, -1.672726e-002, -1.645387e-002,
   -1.618160e-002, -1.591490e-002, -1.565007e-002, -1.538311e-002, -1.511497e-002, -1.484433e-002, -1.456734e-002, -1.428777e-002, -1.400771e-002,
   -1.372098e-002, -1.343347e-002, -1.314654e-002, -1.285959e-002, -1.256813e-002, -1.227279e-002, -1.197082e-002, -1.166110e-002, -1.134470e-002,
   -1.102884e-002, -1.071234e-002, -1.039400e-002, -1.006862e-002, -9.738795e-003, -9.403636e-003, -9.069431e-003, -8.730534e-003, -8.388891e-003,
   -8.043898e-003, -7.701344e-003, -7.356372e-003, -7.013856e-003, -6.672303e-003, -6.330828e-003, -5.985169e-003, -5.638881e-003, -5.292245e-003,
   -4.938486e-003, -4.579355e-003, -4.217080e-003, -3.849978e-003, -3.483144e-003, -3.117564e-003, -2.752181e-003, -2.388346e-003, -2.022805e-003,
   -1.650467e-003, -1.269718e-003, -8.767821e-004, -4.776649e-004, -7.623562e-005, 3.258055e-004,  7.280977e-004,  1.135383e-003,  1.547792e-003,
   1.960457e-003,  2.375741e-003,  2.790709e-003,  3.212097e-003,  3.639058e-003,  4.070175e-003,  4.503332e-003,  4.939710e-003,  5.376668e-003,
   5.813535e-003,  6.250691e-003,  6.688689e-003,  7.126667e-003,  7.570752e-003,  8.013479e-003,  8.453302e-003,  8.890125e-003,  9.323666e-003,
   9.755337e-003,  1.018191e-002,  1.060611e-002,  1.102831e-002,  1.144729e-002,  1.186491e-002,  1.228139e-002,  1.269406e-002,  1.309953e-002,
   1.350055e-002,  1.389704e-002,  1.428958e-002,  1.467723e-002,  1.506192e-002,  1.543798e-002,  1.581033e-002,  1.617856e-002,  1.654549e-002,
   1.691711e-002,  1.729144e-002,  1.766769e-002,  1.804705e-002,  1.842600e-002,  1.880228e-002,  1.917798e-002,  1.955398e-002,  1.992866e-002,
   2.030387e-002,  2.068121e-002,  2.105847e-002,  2.143718e-002,  2.181898e-002,  2.219875e-002,  2.257561e-002,  2.294921e-002,  2.331925e-002,
   2.368520e-002,  2.405139e-002,  2.441641e-002,  2.478315e-002,  2.514632e-002,  2.550537e-002,  2.585931e-002,  2.620706e-002,  2.655227e-002,
   2.689664e-002,  2.723573e-002,  2.757378e-002,  2.791125e-002,  2.824600e-002,  2.857588e-002,  2.890035e-002,  2.922019e-002,  2.953738e-002,
   2.985432e-002,  3.017367e-002,  3.049323e-002,  3.080744e-002,  3.112068e-002,  3.143420e-002,  3.174726e-002,  3.206202e-002,  3.237597e-002,
   3.268740e-002,  3.299781e-002,  3.330954e-002,  3.362071e-002,  3.392253e-002,  3.422280e-002,  3.452093e-002,  3.481696e-002,  3.511222e-002,
   3.541007e-002,  3.570758e-002,  3.601007e-002,  3.631795e-002,  3.662938e-002,  3.693097e-002,  3.722511e-002,  3.751877e-002,  3.780648e-002,
   3.809330e-002,  3.837956e-002,  3.866794e-002,  3.895995e-002,  3.925160e-002,  3.954178e-002,  3.982581e-002,  4.009569e-002,  4.036354e-002,
   4.062970e-002,  4.089329e-002,  4.115284e-002,  4.141196e-002,  4.167269e-002,  4.192832e-002,  4.217854e-002,  4.241650e-002,  4.263374e-002,
   4.284403e-002,  4.304530e-002,  4.324117e-002,  4.343132e-002,  4.361932e-002,  4.380622e-002,  4.399112e-002,  4.416706e-002,  4.433391e-002,
   4.447581e-002,  4.461209e-002,  4.474297e-002,  4.486815e-002,  4.498548e-002,  4.510444e-002,  4.521904e-002,  4.532946e-002,  4.543084e-002,
   4.552715e-002,  4.560322e-002,  4.567231e-002,  4.574352e-002,  4.581284e-002,  4.588116e-002,  4.595273e-002,  4.602118e-002,  4.608709e-002,
   4.615217e-002,  4.621767e-002,  4.626827e-002,  4.630312e-002,  4.633656e-002,  4.636755e-002,  4.639629e-002,  4.642355e-002,  4.644679e-002,
   4.646587e-002,  4.647318e-002,  4.647298e-002,  4.645929e-002,  4.642001e-002,  4.637724e-002,  4.632851e-002,  4.627617e-002,  4.621972e-002,
   4.616037e-002,  4.609914e-002,  4.603108e-002,  4.595954e-002,  4.588228e-002,  4.576596e-002,  4.564738e-002,  4.552689e-002,  4.540092e-002,
   4.527560e-002,  4.515920e-002,  4.503993e-002,  4.491476e-002,  4.478820e-002,  4.466109e-002,  4.449835e-002,  4.432483e-002,  4.414532e-002,
   4.395967e-002,  4.377069e-002,  4.358043e-002,  4.338869e-002,  4.319033e-002,  4.298494e-002,  4.277253e-002,  4.252574e-002,  4.225473e-002,
   4.197675e-002,  4.169117e-002,  4.139794e-002,  4.109385e-002,  4.078462e-002,  4.046842e-002,  4.014334e-002,  3.981247e-002,  3.945714e-002,
   3.906555e-002,  3.866814e-002,  3.826758e-002,  3.786155e-002,  3.744989e-002,  3.703492e-002,  3.661620e-002,  3.618247e-002,  3.574338e-002,
   3.529116e-002,  3.478797e-002,  3.428280e-002,  3.377420e-002,  3.326453e-002,  3.275462e-002,  3.224466e-002,  3.173934e-002,  3.123526e-002,
   3.072762e-002,  3.021816e-002,  2.964021e-002,  2.905079e-002,  2.846012e-002,  2.786797e-002,  2.727414e-002,  2.667884e-002,  2.608199e-002,
   2.548819e-002,  2.488706e-002,  2.428204e-002,  2.362702e-002,  2.295218e-002,  2.227662e-002,  2.159595e-002,  2.090188e-002,  2.020631e-002,
   1.950435e-002,  1.880100e-002,  1.810477e-002,  1.740962e-002,  1.667748e-002,  1.590205e-002,  1.512578e-002,  1.434887e-002,  1.356570e-002,
   1.277875e-002,  1.199463e-002,  1.119623e-002,  1.039175e-002,  9.595671e-003,  8.791325e-003,  7.919921e-003,  7.045715e-003,  6.167517e-003,
   5.288726e-003,  4.409267e-003,  3.529053e-003,  2.647947e-003,  1.765928e-003,  8.832766e-004,  4.011034e-018},
  {0.000000e+000,  -4.942774e-002, -5.620194e-002, -6.033508e-002, -5.956883e-002, -5.694401e-002, -5.641818e-002, -5.612780e-002, -5.565626e-002,
   -5.512035e-002, -5.483838e-002, -5.472761e-002, -5.432260e-002, -5.318601e-002, -5.067231e-002, -4.704666e-002, -4.284764e-002, -3.838921e-002,
   -3.397954e-002, -2.923316e-002, -2.429448e-002, -1.937010e-002, -1.465969e-002, -1.029320e-002, -6.031593e-003, -1.927065e-003, 1.963398e-003,
   5.518040e-003,  8.619470e-003,  1.143255e-002,  1.404786e-002,  1.645029e-002,  1.860436e-002,  2.056524e-002,  2.248132e-002,  2.437502e-002,
   2.627858e-002,  2.807497e-002,  2.982601e-002,  3.151945e-002,  3.316860e-002,  3.468624e-002,  3.622281e-002,  3.772091e-002,  3.912694e-002,
   4.043210e-002,  4.170604e-002,  4.286968e-002,  4.383504e-002,  4.481109e-002,  4.576937e-002,  4.675407e-002,  4.790732e-002,  4.898121e-002,
   5.000870e-002,  5.093195e-002,  5.167297e-002,  5.217184e-002,  5.227566e-002,  5.205385e-002,  5.131330e-002,  5.008573e-002,  4.855362e-002,
   4.685183e-002,  4.493919e-002,  4.285717e-002,  4.068231e-002,  3.840300e-002,  3.606937e-002,  3.367056e-002,  3.120329e-002,  2.870178e-002,
   2.623596e-002,  2.376192e-002,  2.130460e-002,  1.887164e-002,  1.651063e-002,  1.418260e-002,  1.188893e-002,  9.681037e-003,  7.517575e-003,
   5.432591e-003,  3.391561e-003,  1.538631e-003,  -2.844528e-004, -2.015985e-003, -3.620587e-003, -5.208189e-003, -6.690715e-003, -8.090300e-003,
   -9.482404e-003, -1.076560e-002, -1.206911e-002, -1.334254e-002, -1.455664e-002, -1.580701e-002, -1.704343e-002, -1.825500e-002, -1.951005e-002,
   -2.078845e-002, -2.204449e-002, -2.325520e-002, -2.438905e-002, -2.545315e-002, -2.642558e-002, -2.733950e-002, -2.818972e-002, -2.892898e-002,
   -2.958445e-002, -3.017323e-002, -3.072878e-002, -3.121372e-002, -3.166043e-002, -3.205790e-002, -3.240439e-002, -3.272266e-002, -3.304446e-002,
   -3.336613e-002, -3.367364e-002, -3.402521e-002, -3.438424e-002, -3.481048e-002, -3.524815e-002, -3.569441e-002, -3.614043e-002, -3.658523e-002,
   -3.702793e-002, -3.746327e-002, -3.790564e-002, -3.835358e-002, -3.879603e-002, -3.924533e-002, -3.966620e-002, -4.009375e-002, -4.051143e-002,
   -4.088426e-002, -4.125696e-002, -4.163597e-002, -4.201228e-002, -4.239476e-002, -4.277260e-002, -4.312579e-002, -4.338952e-002, -4.366793e-002,
   -4.396312e-002, -4.420515e-002, -4.442900e-002, -4.464002e-002, -4.482948e-002, -4.495943e-002, -4.503289e-002, -4.506701e-002, -4.506025e-002,
   -4.501793e-002, -4.494139e-002, -4.483739e-002, -4.463975e-002, -4.437333e-002, -4.408866e-002, -4.375725e-002, -4.338542e-002, -4.296531e-002,
   -4.241919e-002, -4.182143e-002, -4.117225e-002, -4.050738e-002, -3.977809e-002, -3.895029e-002, -3.804492e-002, -3.709414e-002, -3.609185e-002,
   -3.504401e-002, -3.386098e-002, -3.263345e-002, -3.139147e-002, -3.011820e-002, -2.872601e-002, -2.728554e-002, -2.583946e-002, -2.438591e-002,
   -2.279293e-002, -2.118350e-002, -1.958839e-002, -1.792443e-002, -1.623116e-002, -1.453449e-002, -1.277259e-002, -1.098264e-002, -9.226227e-003,
   -7.382607e-003, -5.560485e-003, -3.718502e-003, -1.842124e-003, -5.982263e-006, 1.884596e-003,  3.715761e-003,  5.609214e-003,  7.455636e-003,
   9.339029e-003,  1.119537e-002,  1.304122e-002,  1.484337e-002,  1.661710e-002,  1.836591e-002,  2.006511e-002,  2.174788e-002,  2.335466e-002,
   2.494083e-002,  2.643510e-002,  2.791140e-002,  2.929740e-002,  3.065722e-002,  3.191392e-002,  3.314456e-002,  3.430343e-002,  3.540971e-002,
   3.646118e-002,  3.743421e-002,  3.839122e-002,  3.926222e-002,  4.011405e-002,  4.093749e-002,  4.168461e-002,  4.242333e-002,  4.308857e-002,
   4.372123e-002,  4.433603e-002,  4.488468e-002,  4.539105e-002,  4.588555e-002,  4.632587e-002,  4.674220e-002,  4.714128e-002,  4.748918e-002,
   4.778586e-002,  4.806970e-002,  4.833884e-002,  4.855142e-002,  4.875623e-002,  4.894397e-002,  4.907882e-002,  4.918094e-002,  4.926698e-002,
   4.934852e-002,  4.937562e-002,  4.939142e-002,  4.939379e-002,  4.937365e-002,  4.930145e-002,  4.922329e-002,  4.913717e-002,  4.905406e-002,
   4.891887e-002,  4.877922e-002,  4.864691e-002,  4.850716e-002,  4.832685e-002,  4.816567e-002,  4.799680e-002,  4.783320e-002,  4.765780e-002,
   4.745879e-002,  4.725898e-002,  4.705580e-002,  4.684707e-002,  4.661899e-002,  4.639545e-002,  4.617675e-002,  4.595969e-002,  4.572458e-002,
   4.547079e-002,  4.523614e-002,  4.501944e-002,  4.481294e-002,  4.460572e-002,  4.441004e-002,  4.421824e-002,  4.403754e-002,  4.386717e-002,
   4.368081e-002,  4.349568e-002,  4.332300e-002,  4.315284e-002,  4.298348e-002,  4.280567e-002,  4.261786e-002,  4.241911e-002,  4.223286e-002,
   4.205297e-002,  4.185197e-002,  4.164386e-002,  4.143250e-002,  4.122115e-002,  4.099980e-002,  4.077129e-002,  4.053252e-002,  4.028345e-002,
   4.003343e-002,  3.976313e-002,  3.947468e-002,  3.916118e-002,  3.882683e-002,  3.847438e-002,  3.810547e-002,  3.772306e-002,  3.730540e-002,
   3.685602e-002,  3.638464e-002,  3.589005e-002,  3.536914e-002,  3.482636e-002,  3.425109e-002,  3.364158e-002,  3.301847e-002,  3.234993e-002,
   3.164629e-002,  3.092118e-002,  3.014186e-002,  2.933030e-002,  2.851492e-002,  2.767072e-002,  2.679345e-002,  2.590840e-002,  2.500243e-002,
   2.404951e-002,  2.306575e-002,  2.209714e-002,  2.112626e-002,  2.015158e-002,  1.917142e-002,  1.818766e-002,  1.719707e-002,  1.618570e-002,
   1.519512e-002,  1.419316e-002,  1.317726e-002,  1.215139e-002,  1.114372e-002,  1.012906e-002,  9.111430e-003,  8.106138e-003,  7.095371e-003,
   6.057204e-003,  5.009886e-003,  3.978694e-003,  2.942915e-003,  1.905639e-003,  8.895909e-004,  -1.320180e-004, -1.177145e-003, -2.230970e-003,
   -3.260533e-003, -4.289462e-003, -5.321955e-003, -6.345175e-003, -7.371445e-003, -8.383436e-003, -9.392233e-003, -1.039225e-002, -1.138916e-002,
   -1.238843e-002, -1.339274e-002, -1.437815e-002, -1.536229e-002, -1.633839e-002, -1.730141e-002, -1.823734e-002, -1.917128e-002, -2.011388e-002,
   -2.105184e-002, -2.196640e-002, -2.288619e-002, -2.380939e-002, -2.471618e-002, -2.559052e-002, -2.646637e-002, -2.735472e-002, -2.822763e-002,
   -2.907988e-002, -2.992485e-002, -3.076427e-002, -3.158522e-002, -3.238191e-002, -3.318139e-002, -3.397746e-002, -3.474015e-002, -3.547172e-002,
   -3.619741e-002, -3.691719e-002, -3.762212e-002, -3.828962e-002, -3.896476e-002, -3.963787e-002, -4.028500e-002, -4.090150e-002, -4.150252e-002,
   -4.209054e-002, -4.266695e-002, -4.320766e-002, -4.374175e-002, -4.427590e-002, -4.479413e-002, -4.526666e-002, -4.573208e-002, -4.618809e-002,
   -4.663705e-002, -4.705281e-002, -4.747072e-002, -4.787753e-002, -4.827656e-002, -4.865137e-002, -4.900735e-002, -4.935996e-002, -4.970447e-002,
   -5.003527e-002, -5.033950e-002, -5.064212e-002, -5.093999e-002, -5.122976e-002, -5.149338e-002, -5.174827e-002, -5.199781e-002, -5.223649e-002,
   -5.245069e-002, -5.267392e-002, -5.289036e-002, -5.308399e-002, -5.323626e-002, -5.335505e-002, -5.344816e-002, -5.351148e-002, -5.354967e-002,
   -5.354666e-002, -5.353814e-002, -5.351493e-002, -5.347344e-002, -5.342013e-002, -5.334387e-002, -5.325380e-002, -5.315332e-002, -5.302734e-002,
   -5.286562e-002, -5.268859e-002, -5.251739e-002, -5.232002e-002, -5.209273e-002, -5.184579e-002, -5.159129e-002, -5.132721e-002, -5.104986e-002,
   -5.074819e-002, -5.043375e-002, -5.010742e-002, -4.977912e-002, -4.944048e-002, -4.907736e-002, -4.869887e-002, -4.830468e-002, -4.790432e-002,
   -4.748158e-002, -4.702665e-002, -4.656120e-002, -4.608877e-002, -4.562646e-002, -4.514820e-002, -4.466099e-002, -4.417314e-002, -4.367368e-002,
   -4.316069e-002, -4.263195e-002, -4.210386e-002, -4.157405e-002, -4.103127e-002, -4.047939e-002, -3.993559e-002, -3.939004e-002, -3.883940e-002,
   -3.828306e-002, -3.773155e-002, -3.717403e-002, -3.661549e-002, -3.605951e-002, -3.551314e-002, -3.496430e-002, -3.440647e-002, -3.386595e-002,
   -3.333983e-002, -3.282090e-002, -3.229771e-002, -3.175423e-002, -3.122185e-002, -3.069928e-002, -3.018090e-002, -2.967027e-002, -2.916218e-002,
   -2.866019e-002, -2.816653e-002, -2.768821e-002, -2.722911e-002, -2.676853e-002, -2.631747e-002, -2.587422e-002, -2.543550e-002, -2.500765e-002,
   -2.458189e-002, -2.415671e-002, -2.374382e-002, -2.334658e-002, -2.295395e-002, -2.256492e-002, -2.220331e-002, -2.185116e-002, -2.150136e-002,
   -2.114806e-002, -2.077344e-002, -2.039209e-002, -2.001069e-002, -1.962643e-002, -1.924048e-002, -1.885211e-002, -1.846616e-002, -1.808152e-002,
   -1.768378e-002, -1.729128e-002, -1.690856e-002, -1.651797e-002, -1.611085e-002, -1.569417e-002, -1.526706e-002, -1.484520e-002, -1.442802e-002,
   -1.399961e-002, -1.356751e-002, -1.313351e-002, -1.269229e-002, -1.223855e-002, -1.177302e-002, -1.130890e-002, -1.084769e-002, -1.038641e-002,
   -9.920370e-003, -9.459815e-003, -8.997027e-003, -8.539077e-003, -8.080995e-003, -7.620812e-003, -7.154236e-003, -6.685203e-003, -6.201714e-003,
   -5.700616e-003, -5.192633e-003, -4.689251e-003, -4.188658e-003, -3.691479e-003, -3.183011e-003, -2.668322e-003, -2.151657e-003, -1.628537e-003,
   -1.086054e-003, -5.227901e-004, 4.565609e-005,  6.164596e-004,  1.178995e-003,  1.747960e-003,  2.329319e-003,  2.914850e-003,  3.498697e-003,
   4.084484e-003,  4.669223e-003,  5.253026e-003,  5.845171e-003,  6.442419e-003,  7.038177e-003,  7.633871e-003,  8.226937e-003,  8.821689e-003,
   9.420432e-003,  1.002058e-002,  1.061902e-002,  1.121747e-002,  1.181805e-002,  1.241627e-002,  1.301694e-002,  1.362216e-002,  1.421938e-002,
   1.478960e-002,  1.535054e-002,  1.590619e-002,  1.645529e-002,  1.700278e-002,  1.754731e-002,  1.808484e-002,  1.861915e-002,  1.915513e-002,
   1.970014e-002,  2.024049e-002,  2.077330e-002,  2.130200e-002,  2.180283e-002,  2.229387e-002,  2.279252e-002,  2.328979e-002,  2.378641e-002,
   2.427753e-002,  2.475956e-002,  2.523740e-002,  2.572076e-002,  2.620044e-002,  2.668112e-002,  2.715737e-002,  2.760834e-002,  2.801831e-002,
   2.842659e-002,  2.883425e-002,  2.923489e-002,  2.962492e-002,  3.000631e-002,  3.038162e-002,  3.075594e-002,  3.113703e-002,  3.151418e-002,
   3.188319e-002,  3.224468e-002,  3.259722e-002,  3.294979e-002,  3.327500e-002,  3.356624e-002,  3.385194e-002,  3.413390e-002,  3.441647e-002,
   3.469609e-002,  3.497764e-002,  3.525620e-002,  3.553041e-002,  3.580024e-002,  3.606073e-002,  3.631222e-002,  3.655632e-002,  3.679405e-002,
   3.702437e-002,  3.724145e-002,  3.744400e-002,  3.763503e-002,  3.780758e-002,  3.797359e-002,  3.811815e-002,  3.824159e-002,  3.835526e-002,
   3.845868e-002,  3.854784e-002,  3.861961e-002,  3.868151e-002,  3.872866e-002,  3.875724e-002,  3.877605e-002,  3.878833e-002,  3.879805e-002,
   3.880025e-002,  3.879599e-002,  3.878468e-002,  3.876084e-002,  3.873342e-002,  3.870528e-002,  3.867295e-002,  3.863528e-002,  3.858880e-002,
   3.853180e-002,  3.846744e-002,  3.839832e-002,  3.832864e-002,  3.826046e-002,  3.819760e-002,  3.810429e-002,  3.800899e-002,  3.791874e-002,
   3.782892e-002,  3.772060e-002,  3.761236e-002,  3.750538e-002,  3.739747e-002,  3.728814e-002,  3.717441e-002,  3.705464e-002,  3.693168e-002,
   3.681214e-002,  3.669692e-002,  3.656380e-002,  3.640993e-002,  3.624536e-002,  3.607313e-002,  3.589502e-002,  3.571964e-002,  3.554758e-002,
   3.537479e-002,  3.520112e-002,  3.502661e-002,  3.484793e-002,  3.464983e-002,  3.444898e-002,  3.424778e-002,  3.404516e-002,  3.384146e-002,
   3.364158e-002,  3.343987e-002,  3.323213e-002,  3.302314e-002,  3.281397e-002,  3.259222e-002,  3.236374e-002,  3.212910e-002,  3.189317e-002,
   3.165666e-002,  3.141257e-002,  3.116749e-002,  3.092317e-002,  3.067598e-002,  3.042475e-002,  3.016504e-002,  2.989867e-002,  2.962749e-002,
   2.935065e-002,  2.906138e-002,  2.876405e-002,  2.846271e-002,  2.816342e-002,  2.786495e-002,  2.757206e-002,  2.727151e-002,  2.696350e-002,
   2.664963e-002,  2.633198e-002,  2.601260e-002,  2.569912e-002,  2.538470e-002,  2.507121e-002,  2.476143e-002,  2.445594e-002,  2.414133e-002,
   2.382350e-002,  2.349838e-002,  2.317493e-002,  2.285167e-002,  2.253187e-002,  2.221263e-002,  2.189212e-002,  2.157099e-002,  2.124493e-002,
   2.090486e-002,  2.055575e-002,  2.020317e-002,  1.984898e-002,  1.949519e-002,  1.913724e-002,  1.877502e-002,  1.840690e-002,  1.803390e-002,
   1.765454e-002,  1.728018e-002,  1.689616e-002,  1.651421e-002,  1.613230e-002,  1.574839e-002,  1.536175e-002,  1.497380e-002,  1.458848e-002,
   1.420760e-002,  1.382438e-002,  1.343259e-002,  1.303983e-002,  1.265022e-002,  1.227147e-002,  1.188726e-002,  1.150222e-002,  1.112043e-002,
   1.073746e-002,  1.035444e-002,  9.974270e-003,  9.594954e-003,  9.200553e-003,  8.800720e-003,  8.400698e-003,  8.004350e-003,  7.608551e-003,
   7.216144e-003,  6.821407e-003,  6.426434e-003,  6.029861e-003,  5.628536e-003,  5.233361e-003,  4.845306e-003,  4.463979e-003,  4.083287e-003,
   3.705020e-003,  3.327617e-003,  2.951562e-003,  2.576235e-003,  2.205662e-003,  1.838341e-003,  1.474079e-003,  1.108195e-003,  7.421916e-004,
   3.808521e-004,  2.287793e-005,  -3.265042e-004, -6.716933e-004, -1.008671e-003, -1.340826e-003, -1.668361e-003, -1.995238e-003, -2.317955e-003,
   -2.635013e-003, -2.951551e-003, -3.266539e-003, -3.587078e-003, -3.920640e-003, -4.254221e-003, -4.585536e-003, -4.916072e-003, -5.249222e-003,
   -5.584866e-003, -5.923222e-003, -6.261374e-003, -6.602499e-003, -6.942125e-003, -7.277854e-003, -7.612200e-003, -7.946726e-003, -8.279381e-003,
   -8.611686e-003, -8.946173e-003, -9.271993e-003, -9.597305e-003, -9.926970e-003, -1.025736e-002, -1.058713e-002, -1.091496e-002, -1.123693e-002,
   -1.154777e-002, -1.185163e-002, -1.215326e-002, -1.244934e-002, -1.274713e-002, -1.304510e-002, -1.334134e-002, -1.363490e-002, -1.392559e-002,
   -1.421481e-002, -1.450545e-002, -1.479699e-002, -1.509105e-002, -1.538179e-002, -1.567328e-002, -1.596203e-002, -1.625159e-002, -1.654580e-002,
   -1.684388e-002, -1.714350e-002, -1.744390e-002, -1.774144e-002, -1.803897e-002, -1.832986e-002, -1.861655e-002, -1.890207e-002, -1.919060e-002,
   -1.947551e-002, -1.975853e-002, -2.003435e-002, -2.030911e-002, -2.058764e-002, -2.087049e-002, -2.114509e-002, -2.140793e-002, -2.166401e-002,
   -2.191575e-002, -2.216553e-002, -2.241441e-002, -2.266377e-002, -2.291306e-002, -2.316472e-002, -2.341229e-002, -2.365436e-002, -2.387535e-002,
   -2.409555e-002, -2.431321e-002, -2.452835e-002, -2.474030e-002, -2.494991e-002, -2.515961e-002, -2.536702e-002, -2.557086e-002, -2.576876e-002,
   -2.594413e-002, -2.611726e-002, -2.628871e-002, -2.645848e-002, -2.662294e-002, -2.678332e-002, -2.694499e-002, -2.710695e-002, -2.726485e-002,
   -2.742393e-002, -2.756317e-002, -2.769724e-002, -2.783294e-002, -2.796886e-002, -2.810566e-002, -2.824310e-002, -2.838025e-002, -2.851599e-002,
   -2.865608e-002, -2.879542e-002, -2.891674e-002, -2.902496e-002, -2.913312e-002, -2.924063e-002, -2.934805e-002, -2.945552e-002, -2.955898e-002,
   -2.965715e-002, -2.975098e-002, -2.984358e-002, -2.992523e-002, -2.998339e-002, -3.004271e-002, -3.009951e-002, -3.015406e-002, -3.019989e-002,
   -3.024388e-002, -3.028488e-002, -3.031982e-002, -3.035221e-002, -3.037962e-002, -3.036888e-002, -3.035598e-002, -3.033809e-002, -3.031826e-002,
   -3.029319e-002, -3.027401e-002, -3.026247e-002, -3.025223e-002, -3.024180e-002, -3.023034e-002, -3.018051e-002, -3.012447e-002, -3.006679e-002,
   -3.000334e-002, -2.993978e-002, -2.987663e-002, -2.981411e-002, -2.974799e-002, -2.967617e-002, -2.960237e-002, -2.949654e-002, -2.936942e-002,
   -2.923805e-002, -2.910164e-002, -2.896236e-002, -2.881608e-002, -2.866542e-002, -2.851460e-002, -2.835908e-002, -2.820026e-002, -2.801855e-002,
   -2.780135e-002, -2.757821e-002, -2.735127e-002, -2.711877e-002, -2.688338e-002, -2.664550e-002, -2.640613e-002, -2.616013e-002, -2.591142e-002,
   -2.565332e-002, -2.534148e-002, -2.501931e-002, -2.469332e-002, -2.436732e-002, -2.404210e-002, -2.371715e-002, -2.339278e-002, -2.307412e-002,
   -2.275437e-002, -2.243056e-002, -2.204322e-002, -2.164620e-002, -2.125142e-002, -2.085845e-002, -2.046642e-002, -2.007482e-002, -1.968302e-002,
   -1.928721e-002, -1.888776e-002, -1.848611e-002, -1.803246e-002, -1.755346e-002, -1.707420e-002, -1.659252e-002, -1.610423e-002, -1.561354e-002,
   -1.511842e-002, -1.462232e-002, -1.412584e-002, -1.362301e-002, -1.307952e-002, -1.248736e-002, -1.189278e-002, -1.129640e-002, -1.069338e-002,
   -1.008949e-002, -9.484904e-003, -8.873625e-003, -8.260552e-003, -7.650085e-003, -7.016932e-003, -6.315541e-003, -5.610504e-003, -4.902638e-003,
   -4.196229e-003, -3.491864e-003, -2.789194e-003, -2.088697e-003, -1.390051e-003, -6.939679e-004, 7.302615e-018},
  {0.000000e+000,  1.648656e-001,  1.665361e-001,  1.587156e-001,  1.482945e-001,  1.367121e-001,  1.248286e-001,  1.123901e-001,  1.003328e-001,
   8.868965e-002,  7.747023e-002,  6.684091e-002,  5.697325e-002,  4.802379e-002,  3.948657e-002,  3.107607e-002,  2.273036e-002,  1.463456e-002,
   7.107590e-003,  3.194369e-004,  -5.674128e-003, -1.068986e-002, -1.490075e-002, -1.856333e-002, -2.140829e-002, -2.369741e-002, -2.582885e-002,
   -2.797068e-002, -3.036549e-002, -3.301093e-002, -3.583747e-002, -3.874029e-002, -4.151691e-002, -4.409961e-002, -4.654450e-002, -4.871264e-002,
   -5.055134e-002, -5.199464e-002, -5.342826e-002, -5.483972e-002, -5.610964e-002, -5.707460e-002, -5.788090e-002, -5.844096e-002, -5.862796e-002,
   -5.841032e-002, -5.776606e-002, -5.671255e-002, -5.530392e-002, -5.367291e-002, -5.185020e-002, -4.960074e-002, -4.698220e-002, -4.393180e-002,
   -4.064743e-002, -3.711994e-002, -3.339834e-002, -2.964691e-002, -2.581521e-002, -2.207445e-002, -1.846601e-002, -1.502998e-002, -1.155335e-002,
   -8.126644e-003, -4.756059e-003, -1.400728e-003, 1.962585e-003,  5.239039e-003,  8.424385e-003,  1.154155e-002,  1.452822e-002,  1.738345e-002,
   2.007916e-002,  2.267727e-002,  2.507508e-002,  2.724398e-002,  2.918630e-002,  3.097799e-002,  3.251732e-002,  3.378478e-002,  3.479866e-002,
   3.553151e-002,  3.607182e-002,  3.634344e-002,  3.642145e-002,  3.636087e-002,  3.614136e-002,  3.580433e-002,  3.526922e-002,  3.470799e-002,
   3.413901e-002,  3.350797e-002,  3.284612e-002,  3.219442e-002,  3.155684e-002,  3.097272e-002,  3.048014e-002,  3.007404e-002,  2.974699e-002,
   2.953383e-002,  2.933729e-002,  2.911774e-002,  2.896211e-002,  2.881185e-002,  2.870212e-002,  2.861064e-002,  2.853348e-002,  2.851805e-002,
   2.856296e-002,  2.866926e-002,  2.866844e-002,  2.870975e-002,  2.878630e-002,  2.887089e-002,  2.890231e-002,  2.888916e-002,  2.880110e-002,
   2.868867e-002,  2.852794e-002,  2.823901e-002,  2.785424e-002,  2.738615e-002,  2.681202e-002,  2.619428e-002,  2.553211e-002,  2.482031e-002,
   2.403611e-002,  2.320999e-002,  2.231290e-002,  2.137543e-002,  2.035766e-002,  1.928418e-002,  1.815463e-002,  1.690966e-002,  1.558195e-002,
   1.415801e-002,  1.263356e-002,  1.102963e-002,  9.399969e-003,  7.696888e-003,  5.979689e-003,  4.227131e-003,  2.499382e-003,  8.100498e-004,
   -9.187090e-004, -2.584860e-003, -4.211633e-003, -5.814482e-003, -7.312234e-003, -8.750723e-003, -1.008900e-002, -1.132133e-002, -1.245027e-002,
   -1.345079e-002, -1.439867e-002, -1.531712e-002, -1.616317e-002, -1.693821e-002, -1.768208e-002, -1.840368e-002, -1.909185e-002, -1.975477e-002,
   -2.033744e-002, -2.081399e-002, -2.126617e-002, -2.172850e-002, -2.213712e-002, -2.249120e-002, -2.279416e-002, -2.307447e-002, -2.332246e-002,
   -2.356600e-002, -2.376032e-002, -2.391474e-002, -2.406796e-002, -2.420042e-002, -2.427748e-002, -2.432112e-002, -2.436340e-002, -2.440945e-002,
   -2.438278e-002, -2.435546e-002, -2.431735e-002, -2.425829e-002, -2.414404e-002, -2.403202e-002, -2.386826e-002, -2.370082e-002, -2.356622e-002,
   -2.336001e-002, -2.315214e-002, -2.292051e-002, -2.268686e-002, -2.246260e-002, -2.220474e-002, -2.197391e-002, -2.173555e-002, -2.152616e-002,
   -2.130609e-002, -2.114136e-002, -2.099700e-002, -2.089786e-002, -2.081976e-002, -2.075867e-002, -2.072316e-002, -2.070624e-002, -2.071699e-002,
   -2.072785e-002, -2.076722e-002, -2.082479e-002, -2.093703e-002, -2.105672e-002, -2.120003e-002, -2.133434e-002, -2.150244e-002, -2.168458e-002,
   -2.189217e-002, -2.212635e-002, -2.237097e-002, -2.263425e-002, -2.289521e-002, -2.315157e-002, -2.341235e-002, -2.368894e-002, -2.397271e-002,
   -2.425522e-002, -2.452157e-002, -2.478456e-002, -2.505032e-002, -2.530129e-002, -2.555797e-002, -2.581819e-002, -2.603833e-002, -2.625279e-002,
   -2.647385e-002, -2.667508e-002, -2.686011e-002, -2.704261e-002, -2.719508e-002, -2.733054e-002, -2.745848e-002, -2.756610e-002, -2.763009e-002,
   -2.767220e-002, -2.769987e-002, -2.770107e-002, -2.767007e-002, -2.760205e-002, -2.750579e-002, -2.735505e-002, -2.716490e-002, -2.693854e-002,
   -2.668225e-002, -2.638386e-002, -2.607343e-002, -2.573004e-002, -2.535863e-002, -2.498160e-002, -2.456642e-002, -2.412605e-002, -2.367505e-002,
   -2.319377e-002, -2.268316e-002, -2.213112e-002, -2.155380e-002, -2.097018e-002, -2.036167e-002, -1.974150e-002, -1.909899e-002, -1.842746e-002,
   -1.772967e-002, -1.698337e-002, -1.619778e-002, -1.538115e-002, -1.454251e-002, -1.365695e-002, -1.273126e-002, -1.175674e-002, -1.074279e-002,
   -9.707857e-003, -8.649348e-003, -7.556388e-003, -6.432324e-003, -5.281657e-003, -4.109176e-003, -2.902809e-003, -1.669971e-003, -4.117346e-004,
   8.621738e-004,  2.148278e-003,  3.458079e-003,  4.785930e-003,  6.133727e-003,  7.489635e-003,  8.865912e-003,  1.023105e-002,  1.158935e-002,
   1.296441e-002,  1.434801e-002,  1.574195e-002,  1.713846e-002,  1.852877e-002,  1.991088e-002,  2.126416e-002,  2.261031e-002,  2.397137e-002,
   2.531392e-002,  2.665901e-002,  2.798396e-002,  2.928033e-002,  3.054636e-002,  3.178414e-002,  3.300126e-002,  3.417977e-002,  3.534837e-002,
   3.650872e-002,  3.762551e-002,  3.870045e-002,  3.976638e-002,  4.077133e-002,  4.173600e-002,  4.266960e-002,  4.355760e-002,  4.438432e-002,
   4.514259e-002,  4.589849e-002,  4.662923e-002,  4.733018e-002,  4.801000e-002,  4.867431e-002,  4.931472e-002,  4.993573e-002,  5.052049e-002,
   5.106986e-002,  5.160527e-002,  5.211652e-002,  5.260214e-002,  5.304062e-002,  5.346881e-002,  5.387821e-002,  5.420717e-002,  5.449126e-002,
   5.474501e-002,  5.494970e-002,  5.511051e-002,  5.524536e-002,  5.535545e-002,  5.541000e-002,  5.541096e-002,  5.536532e-002,  5.530058e-002,
   5.517370e-002,  5.502575e-002,  5.487469e-002,  5.469684e-002,  5.447889e-002,  5.422841e-002,  5.394265e-002,  5.359705e-002,  5.323359e-002,
   5.286278e-002,  5.249040e-002,  5.208851e-002,  5.166377e-002,  5.124845e-002,  5.078865e-002,  5.028231e-002,  4.975251e-002,  4.920314e-002,
   4.862747e-002,  4.804810e-002,  4.746467e-002,  4.687119e-002,  4.622861e-002,  4.555613e-002,  4.486221e-002,  4.416155e-002,  4.344962e-002,
   4.270468e-002,  4.197747e-002,  4.125476e-002,  4.051170e-002,  3.976138e-002,  3.900479e-002,  3.822912e-002,  3.743441e-002,  3.663669e-002,
   3.585483e-002,  3.509600e-002,  3.431744e-002,  3.353552e-002,  3.276933e-002,  3.200522e-002,  3.124753e-002,  3.048262e-002,  2.971426e-002,
   2.897447e-002,  2.824838e-002,  2.750587e-002,  2.677799e-002,  2.606182e-002,  2.536254e-002,  2.464162e-002,  2.395793e-002,  2.330333e-002,
   2.267578e-002,  2.203233e-002,  2.138238e-002,  2.074968e-002,  2.013979e-002,  1.952581e-002,  1.889132e-002,  1.823326e-002,  1.758423e-002,
   1.692307e-002,  1.623585e-002,  1.551742e-002,  1.480768e-002,  1.409884e-002,  1.340131e-002,  1.271451e-002,  1.202882e-002,  1.135416e-002,
   1.067201e-002,  9.968630e-003,  9.247445e-003,  8.509544e-003,  7.775959e-003,  7.038999e-003,  6.280407e-003,  5.523698e-003,  4.777245e-003,
   4.030875e-003,  3.290009e-003,  2.543304e-003,  1.789783e-003,  1.011804e-003,  2.362518e-004,  -5.346216e-004, -1.316201e-003, -2.105008e-003,
   -2.886694e-003, -3.658983e-003, -4.446426e-003, -5.240270e-003, -6.035550e-003, -6.841524e-003, -7.655121e-003, -8.459005e-003, -9.266256e-003,
   -1.009471e-002, -1.091878e-002, -1.173407e-002, -1.254942e-002, -1.335987e-002, -1.418019e-002, -1.497996e-002, -1.576961e-002, -1.657450e-002,
   -1.737380e-002, -1.818221e-002, -1.897833e-002, -1.976453e-002, -2.054819e-002, -2.133598e-002, -2.212494e-002, -2.290213e-002, -2.365877e-002,
   -2.439701e-002, -2.513541e-002, -2.589567e-002, -2.664362e-002, -2.738065e-002, -2.811278e-002, -2.886028e-002, -2.959162e-002, -3.031390e-002,
   -3.103428e-002, -3.175000e-002, -3.245801e-002, -3.316228e-002, -3.384967e-002, -3.453199e-002, -3.519807e-002, -3.586001e-002, -3.652391e-002,
   -3.718030e-002, -3.782117e-002, -3.843542e-002, -3.904701e-002, -3.965390e-002, -4.024772e-002, -4.082225e-002, -4.137917e-002, -4.192935e-002,
   -4.246910e-002, -4.300001e-002, -4.352846e-002, -4.404700e-002, -4.453667e-002, -4.500289e-002, -4.544391e-002, -4.587197e-002, -4.627895e-002,
   -4.666678e-002, -4.703594e-002, -4.739371e-002, -4.774283e-002, -4.808899e-002, -4.841911e-002, -4.874365e-002, -4.905338e-002, -4.935911e-002,
   -4.966440e-002, -4.996350e-002, -5.024957e-002, -5.050456e-002, -5.074863e-002, -5.098292e-002, -5.120698e-002, -5.142354e-002, -5.161209e-002,
   -5.178359e-002, -5.195647e-002, -5.212073e-002, -5.227669e-002, -5.241440e-002, -5.252967e-002, -5.264015e-002, -5.273358e-002, -5.281561e-002,
   -5.289321e-002, -5.296201e-002, -5.300858e-002, -5.303278e-002, -5.303784e-002, -5.302831e-002, -5.300271e-002, -5.296007e-002, -5.289239e-002,
   -5.280832e-002, -5.271210e-002, -5.260884e-002, -5.249797e-002, -5.238561e-002, -5.224753e-002, -5.208700e-002, -5.190544e-002, -5.170276e-002,
   -5.148356e-002, -5.125040e-002, -5.098638e-002, -5.070225e-002, -5.040520e-002, -5.007878e-002, -4.973669e-002, -4.937999e-002, -4.901314e-002,
   -4.860741e-002, -4.817192e-002, -4.771127e-002, -4.723127e-002, -4.673206e-002, -4.621924e-002, -4.568841e-002, -4.514000e-002, -4.457640e-002,
   -4.400028e-002, -4.341116e-002, -4.280731e-002, -4.219416e-002, -4.157232e-002, -4.092678e-002, -4.025705e-002, -3.956513e-002, -3.885764e-002,
   -3.815207e-002, -3.743736e-002, -3.671728e-002, -3.598237e-002, -3.524156e-002, -3.449909e-002, -3.376225e-002, -3.302115e-002, -3.225729e-002,
   -3.147250e-002, -3.067132e-002, -2.987300e-002, -2.909771e-002, -2.831407e-002, -2.751718e-002, -2.670992e-002, -2.589341e-002, -2.505947e-002,
   -2.422223e-002, -2.339326e-002, -2.255378e-002, -2.168102e-002, -2.083297e-002, -1.998217e-002, -1.911538e-002, -1.824876e-002, -1.738020e-002,
   -1.650432e-002, -1.561513e-002, -1.473073e-002, -1.385448e-002, -1.296939e-002, -1.208226e-002, -1.117867e-002, -1.029849e-002, -9.443680e-003,
   -8.587966e-003, -7.731475e-003, -6.874128e-003, -6.026714e-003, -5.182423e-003, -4.338335e-003, -3.494409e-003, -2.646398e-003, -1.786433e-003,
   -9.332632e-004, -8.711178e-005, 7.550747e-004,  1.603341e-003,  2.435620e-003,  3.211347e-003,  3.983251e-003,  4.751629e-003,  5.523783e-003,
   6.307042e-003,  7.080800e-003,  7.847702e-003,  8.614441e-003,  9.387861e-003,  1.015561e-002,  1.090676e-002,  1.164601e-002,  1.238417e-002,
   1.312293e-002,  1.386531e-002,  1.460412e-002,  1.533420e-002,  1.605149e-002,  1.676201e-002,  1.744608e-002,  1.809224e-002,  1.872866e-002,
   1.935607e-002,  1.995618e-002,  2.049669e-002,  2.100994e-002,  2.151096e-002,  2.199572e-002,  2.247969e-002,  2.296158e-002,  2.344297e-002,
   2.392009e-002,  2.438694e-002,  2.485870e-002,  2.531045e-002,  2.573474e-002,  2.616205e-002,  2.655987e-002,  2.693471e-002,  2.731010e-002,
   2.769128e-002,  2.805704e-002,  2.841248e-002,  2.877477e-002,  2.913777e-002,  2.950030e-002,  2.977982e-002,  3.004592e-002,  3.031101e-002,
   3.057765e-002,  3.084844e-002,  3.112298e-002,  3.139820e-002,  3.162949e-002,  3.185257e-002,  3.208182e-002,  3.230989e-002,  3.253178e-002,
   3.275634e-002,  3.297829e-002,  3.313283e-002,  3.323217e-002,  3.332072e-002,  3.341181e-002,  3.349416e-002,  3.356566e-002,  3.363237e-002,
   3.370015e-002,  3.377932e-002,  3.386042e-002,  3.394486e-002,  3.403215e-002,  3.406932e-002,  3.409846e-002,  3.413776e-002,  3.418040e-002,
   3.422501e-002,  3.424525e-002,  3.422114e-002,  3.417634e-002,  3.413455e-002,  3.408325e-002,  3.401298e-002,  3.392511e-002,  3.383990e-002,
   3.375620e-002,  3.367675e-002,  3.358883e-002,  3.349950e-002,  3.340714e-002,  3.331938e-002,  3.323020e-002,  3.314692e-002,  3.305986e-002,
   3.297870e-002,  3.289542e-002,  3.274754e-002,  3.256955e-002,  3.239759e-002,  3.222514e-002,  3.206015e-002,  3.185798e-002,  3.163931e-002,
   3.142029e-002,  3.120606e-002,  3.099147e-002,  3.078312e-002,  3.058375e-002,  3.039738e-002,  3.020910e-002,  3.002362e-002,  2.981420e-002,
   2.960401e-002,  2.938910e-002,  2.917766e-002,  2.897555e-002,  2.877144e-002,  2.856065e-002,  2.835637e-002,  2.815078e-002,  2.793368e-002,
   2.769597e-002,  2.746005e-002,  2.722942e-002,  2.699053e-002,  2.675156e-002,  2.650981e-002,  2.625312e-002,  2.597252e-002,  2.569708e-002,
   2.540580e-002,  2.511809e-002,  2.479944e-002,  2.448592e-002,  2.417578e-002,  2.387068e-002,  2.356427e-002,  2.325824e-002,  2.295043e-002,
   2.263333e-002,  2.232220e-002,  2.202341e-002,  2.173364e-002,  2.144986e-002,  2.116938e-002,  2.086964e-002,  2.057378e-002,  2.028044e-002,
   1.998937e-002,  1.969730e-002,  1.940195e-002,  1.909499e-002,  1.877959e-002,  1.846487e-002,  1.815038e-002,  1.783068e-002,  1.750917e-002,
   1.718671e-002,  1.686427e-002,  1.654390e-002,  1.623152e-002,  1.592384e-002,  1.561504e-002,  1.530114e-002,  1.498188e-002,  1.465636e-002,
   1.433815e-002,  1.403352e-002,  1.373639e-002,  1.342216e-002,  1.309391e-002,  1.275781e-002,  1.242559e-002,  1.207810e-002,  1.173428e-002,
   1.140391e-002,  1.108416e-002,  1.077798e-002,  1.048570e-002,  1.020012e-002,  9.921276e-003,  9.644519e-003,  9.369857e-003,  9.098682e-003,
   8.832246e-003,  8.574583e-003,  8.325964e-003,  8.081838e-003,  7.824745e-003,  7.566522e-003,  7.304365e-003,  7.025837e-003,  6.736105e-003,
   6.452535e-003,  6.173803e-003,  5.874006e-003,  5.565829e-003,  5.253627e-003,  4.936111e-003,  4.619931e-003,  4.308389e-003,  3.997063e-003,
   3.688517e-003,  3.384718e-003,  3.085927e-003,  2.790003e-003,  2.490607e-003,  2.193412e-003,  1.900456e-003,  1.610615e-003,  1.322726e-003,
   1.037343e-003,  7.594792e-004,  4.910713e-004,  2.356175e-004,  -1.957448e-005, -2.714582e-004, -5.211445e-004, -7.739405e-004, -1.036034e-003,
   -1.301894e-003, -1.563699e-003, -1.819830e-003, -2.077159e-003, -2.332951e-003, -2.612326e-003, -2.895497e-003, -3.177904e-003, -3.472516e-003,
   -3.769982e-003, -4.063370e-003, -4.352682e-003, -4.642165e-003, -4.926231e-003, -5.204860e-003, -5.470016e-003, -5.730434e-003, -5.995383e-003,
   -6.259866e-003, -6.523060e-003, -6.781593e-003, -7.027385e-003, -7.271532e-003, -7.527287e-003, -7.778510e-003, -8.016796e-003, -8.255041e-003,
   -8.493239e-003, -8.731262e-003, -8.963758e-003, -9.185029e-003, -9.395365e-003, -9.600169e-003, -9.808688e-003, -1.001340e-002, -1.021733e-002,
   -1.041848e-002, -1.061300e-002, -1.080893e-002, -1.100560e-002, -1.119920e-002, -1.138785e-002, -1.157160e-002, -1.175489e-002, -1.193350e-002,
   -1.210295e-002, -1.227393e-002, -1.244484e-002, -1.261508e-002, -1.278251e-002, -1.294720e-002, -1.310460e-002, -1.325741e-002, -1.341275e-002,
   -1.356422e-002, -1.370696e-002, -1.385329e-002, -1.399826e-002, -1.414139e-002, -1.428106e-002, -1.441340e-002, -1.454424e-002, -1.468369e-002,
   -1.482951e-002, -1.497436e-002, -1.511291e-002, -1.523863e-002, -1.536186e-002, -1.548562e-002, -1.560976e-002, -1.573294e-002, -1.586050e-002,
   -1.599093e-002, -1.611575e-002, -1.623399e-002, -1.634727e-002, -1.644925e-002, -1.655056e-002, -1.665475e-002, -1.676844e-002, -1.689201e-002,
   -1.701580e-002, -1.713525e-002, -1.725052e-002, -1.736236e-002, -1.746980e-002, -1.755745e-002, -1.764517e-002, -1.773411e-002, -1.781477e-002,
   -1.789968e-002, -1.798563e-002, -1.806995e-002, -1.815155e-002, -1.823102e-002, -1.831059e-002, -1.837418e-002, -1.842858e-002, -1.847832e-002,
   -1.852947e-002, -1.858231e-002, -1.863194e-002, -1.867564e-002, -1.871700e-002, -1.875366e-002, -1.878402e-002, -1.880018e-002, -1.880857e-002,
   -1.881712e-002, -1.882766e-002, -1.884144e-002, -1.885651e-002, -1.885886e-002, -1.884915e-002, -1.883217e-002, -1.881215e-002, -1.878209e-002,
   -1.873678e-002, -1.869086e-002, -1.864542e-002, -1.859411e-002, -1.853495e-002, -1.847190e-002, -1.840220e-002, -1.831816e-002, -1.822767e-002,
   -1.813060e-002, -1.801172e-002, -1.788443e-002, -1.775050e-002, -1.761483e-002, -1.747844e-002, -1.734003e-002, -1.719173e-002, -1.703209e-002,
   -1.686579e-002, -1.669635e-002, -1.649078e-002, -1.628269e-002, -1.607659e-002, -1.587214e-002, -1.566752e-002, -1.546166e-002, -1.525455e-002,
   -1.503455e-002, -1.478548e-002, -1.452899e-002, -1.425048e-002, -1.396035e-002, -1.366830e-002, -1.337109e-002, -1.306368e-002, -1.275516e-002,
   -1.243027e-002, -1.210254e-002, -1.175701e-002, -1.137430e-002, -1.096938e-002, -1.054174e-002, -1.010800e-002, -9.668676e-003, -9.208381e-003,
   -8.736989e-003, -8.262726e-003, -7.778388e-003, -7.290102e-003, -6.785662e-003, -6.208459e-003, -5.604584e-003, -4.990339e-003, -4.363681e-003,
   -3.737213e-003, -3.111566e-003, -2.486590e-003, -1.863048e-003, -1.240486e-003, -6.196939e-004, -1.779836e-017},
  {0.000000e+000,  1.502618e-001,  1.494584e-001,  1.430128e-001,  1.382886e-001,  1.342618e-001,  1.274038e-001,  1.198531e-001,  1.116745e-001,
   1.029250e-001,  9.320480e-002,  8.278434e-002,  7.194458e-002,  6.109329e-002,  5.131315e-002,  4.285204e-002,  3.544078e-002,  2.829305e-002,
   2.092176e-002,  1.369301e-002,  6.502255e-003,  -8.276016e-004, -7.964621e-003, -1.509358e-002, -2.246249e-002, -2.971735e-002, -3.654769e-002,
   -4.260653e-002, -4.772251e-002, -5.194169e-002, -5.541601e-002, -5.829437e-002, -6.056519e-002, -6.236312e-002, -6.384026e-002, -6.505423e-002,
   -6.609224e-002, -6.669607e-002, -6.691516e-002, -6.685879e-002, -6.652929e-002, -6.568700e-002, -6.463312e-002, -6.343984e-002, -6.202305e-002,
   -6.046732e-002, -5.893315e-002, -5.740302e-002, -5.566495e-002, -5.387634e-002, -5.186860e-002, -4.975779e-002, -4.775799e-002, -4.562893e-002,
   -4.352805e-002, -4.137753e-002, -3.912613e-002, -3.682632e-002, -3.439250e-002, -3.194815e-002, -2.930056e-002, -2.656167e-002, -2.379128e-002,
   -2.098688e-002, -1.814850e-002, -1.536356e-002, -1.261164e-002, -9.868152e-003, -7.173675e-003, -4.525448e-003, -1.965084e-003, 6.168254e-004,
   3.162284e-003,  5.707233e-003,  8.195772e-003,  1.068451e-002,  1.314364e-002,  1.564131e-002,  1.818456e-002,  2.084022e-002,  2.356551e-002,
   2.624975e-002,  2.904896e-002,  3.188372e-002,  3.478474e-002,  3.770818e-002,  4.064820e-002,  4.359833e-002,  4.634738e-002,  4.909670e-002,
   5.182554e-002,  5.439479e-002,  5.680792e-002,  5.902445e-002,  6.099067e-002,  6.269302e-002,  6.421239e-002,  6.544923e-002,  6.624927e-002,
   6.681713e-002,  6.712631e-002,  6.726487e-002,  6.728269e-002,  6.704739e-002,  6.663485e-002,  6.611592e-002,  6.533447e-002,  6.431141e-002,
   6.308573e-002,  6.175877e-002,  6.017576e-002,  5.847610e-002,  5.666525e-002,  5.469120e-002,  5.264451e-002,  5.057616e-002,  4.835811e-002,
   4.606366e-002,  4.371613e-002,  4.122858e-002,  3.877405e-002,  3.628604e-002,  3.372210e-002,  3.113418e-002,  2.848793e-002,  2.586313e-002,
   2.314775e-002,  2.041119e-002,  1.765324e-002,  1.487305e-002,  1.213176e-002,  9.380706e-003,  6.632160e-003,  3.951821e-003,  1.410248e-003,
   -1.076965e-003, -3.498997e-003, -5.916821e-003, -8.197745e-003, -1.046101e-002, -1.269171e-002, -1.485863e-002, -1.688913e-002, -1.884015e-002,
   -2.078778e-002, -2.267046e-002, -2.456608e-002, -2.648875e-002, -2.832836e-002, -3.014256e-002, -3.188720e-002, -3.363371e-002, -3.542073e-002,
   -3.720799e-002, -3.900214e-002, -4.077968e-002, -4.242680e-002, -4.399767e-002, -4.555023e-002, -4.707265e-002, -4.851820e-002, -4.998965e-002,
   -5.133481e-002, -5.257725e-002, -5.383985e-002, -5.509882e-002, -5.631151e-002, -5.737942e-002, -5.833593e-002, -5.927504e-002, -6.015817e-002,
   -6.097732e-002, -6.158503e-002, -6.209689e-002, -6.255621e-002, -6.299116e-002, -6.325338e-002, -6.337238e-002, -6.346345e-002, -6.351750e-002,
   -6.329521e-002, -6.299696e-002, -6.269109e-002, -6.218936e-002, -6.156519e-002, -6.086646e-002, -5.996721e-002, -5.895799e-002, -5.793210e-002,
   -5.661305e-002, -5.521785e-002, -5.371145e-002, -5.203058e-002, -5.033116e-002, -4.837816e-002, -4.639728e-002, -4.416284e-002, -4.188589e-002,
   -3.941294e-002, -3.689078e-002, -3.423520e-002, -3.152978e-002, -2.875980e-002, -2.596427e-002, -2.318996e-002, -2.043350e-002, -1.773289e-002,
   -1.501457e-002, -1.237982e-002, -9.745071e-003, -7.229239e-003, -4.708208e-003, -2.320967e-003, 8.070091e-005,  2.348366e-003,  4.591811e-003,
   6.764018e-003,  8.850274e-003,  1.093949e-002,  1.288259e-002,  1.482072e-002,  1.670620e-002,  1.849338e-002,  2.026930e-002,  2.195358e-002,
   2.358069e-002,  2.521621e-002,  2.674060e-002,  2.821928e-002,  2.967623e-002,  3.102724e-002,  3.234031e-002,  3.364976e-002,  3.489012e-002,
   3.605705e-002,  3.720929e-002,  3.832424e-002,  3.933046e-002,  4.032283e-002,  4.129232e-002,  4.218216e-002,  4.300282e-002,  4.382003e-002,
   4.460349e-002,  4.526021e-002,  4.588554e-002,  4.650034e-002,  4.707632e-002,  4.756497e-002,  4.802367e-002,  4.843365e-002,  4.881548e-002,
   4.910217e-002,  4.937479e-002,  4.963733e-002,  4.988234e-002,  5.005874e-002,  5.020310e-002,  5.034665e-002,  5.049171e-002,  5.058967e-002,
   5.064064e-002,  5.068562e-002,  5.073603e-002,  5.075845e-002,  5.072401e-002,  5.067237e-002,  5.058246e-002,  5.046650e-002,  5.031505e-002,
   5.009900e-002,  4.984151e-002,  4.953146e-002,  4.916712e-002,  4.871084e-002,  4.821376e-002,  4.768106e-002,  4.711512e-002,  4.652647e-002,
   4.585785e-002,  4.514133e-002,  4.439439e-002,  4.361535e-002,  4.280429e-002,  4.192881e-002,  4.102300e-002,  4.009239e-002,  3.913833e-002,
   3.815946e-002,  3.713070e-002,  3.606890e-002,  3.499174e-002,  3.389942e-002,  3.279640e-002,  3.168237e-002,  3.051263e-002,  2.933234e-002,
   2.815132e-002,  2.695674e-002,  2.575655e-002,  2.450979e-002,  2.324600e-002,  2.198786e-002,  2.073296e-002,  1.945922e-002,  1.819424e-002,
   1.690579e-002,  1.560894e-002,  1.430015e-002,  1.299360e-002,  1.169695e-002,  1.037968e-002,  9.068149e-003,  7.741817e-003,  6.415321e-003,
   5.105502e-003,  3.819000e-003,  2.531463e-003,  1.269096e-003,  2.384484e-005,  -1.193432e-003, -2.386539e-003, -3.560392e-003, -4.718147e-003,
   -5.815072e-003, -6.866752e-003, -7.887419e-003, -8.907708e-003, -9.933379e-003, -1.095651e-002, -1.197075e-002, -1.296265e-002, -1.390421e-002,
   -1.481505e-002, -1.571800e-002, -1.662590e-002, -1.752483e-002, -1.842051e-002, -1.930908e-002, -2.015003e-002, -2.094065e-002, -2.171573e-002,
   -2.250890e-002, -2.327995e-002, -2.402365e-002, -2.473761e-002, -2.542798e-002, -2.608625e-002, -2.671729e-002, -2.732652e-002, -2.791842e-002,
   -2.848333e-002, -2.903645e-002, -2.955853e-002, -3.003906e-002, -3.051089e-002, -3.095459e-002, -3.137805e-002, -3.176411e-002, -3.212434e-002,
   -3.247152e-002, -3.278630e-002, -3.309353e-002, -3.339251e-002, -3.366102e-002, -3.388245e-002, -3.407782e-002, -3.427637e-002, -3.445911e-002,
   -3.466297e-002, -3.481982e-002, -3.496659e-002, -3.511681e-002, -3.523699e-002, -3.530970e-002, -3.536507e-002, -3.544618e-002, -3.551390e-002,
   -3.557507e-002, -3.561826e-002, -3.565932e-002, -3.567753e-002, -3.568320e-002, -3.567384e-002, -3.567145e-002, -3.566303e-002, -3.565306e-002,
   -3.564454e-002, -3.561138e-002, -3.555141e-002, -3.548285e-002, -3.544837e-002, -3.542393e-002, -3.537955e-002, -3.532114e-002, -3.525028e-002,
   -3.517465e-002, -3.508291e-002, -3.497593e-002, -3.490447e-002, -3.483494e-002, -3.477417e-002, -3.471751e-002, -3.466583e-002, -3.460672e-002,
   -3.456024e-002, -3.448910e-002, -3.443390e-002, -3.435854e-002, -3.427583e-002, -3.417394e-002, -3.407909e-002, -3.397054e-002, -3.384070e-002,
   -3.369647e-002, -3.355718e-002, -3.340723e-002, -3.323516e-002, -3.303598e-002, -3.279781e-002, -3.254387e-002, -3.228604e-002, -3.201505e-002,
   -3.171318e-002, -3.142293e-002, -3.114209e-002, -3.082772e-002, -3.045841e-002, -3.005733e-002, -2.964362e-002, -2.917462e-002, -2.867504e-002,
   -2.813418e-002, -2.760626e-002, -2.707090e-002, -2.652276e-002, -2.593222e-002, -2.531618e-002, -2.469594e-002, -2.407103e-002, -2.343334e-002,
   -2.277295e-002, -2.207018e-002, -2.138198e-002, -2.069594e-002, -1.998571e-002, -1.925349e-002, -1.849806e-002, -1.773696e-002, -1.696485e-002,
   -1.618180e-002, -1.539289e-002, -1.459834e-002, -1.381856e-002, -1.303101e-002, -1.221188e-002, -1.137027e-002, -1.050989e-002, -9.626323e-003,
   -8.732401e-003, -7.834357e-003, -6.930994e-003, -6.020929e-003, -5.141985e-003, -4.256497e-003, -3.361107e-003, -2.465532e-003, -1.556973e-003,
   -6.467956e-004, 2.871382e-004,  1.237592e-003,  2.190082e-003,  3.133055e-003,  4.074881e-003,  4.983417e-003,  5.889459e-003,  6.791265e-003,
   7.673202e-003,  8.542332e-003,  9.408963e-003,  1.026319e-002,  1.110473e-002,  1.194347e-002,  1.279316e-002,  1.365171e-002,  1.447525e-002,
   1.527256e-002,  1.605954e-002,  1.683167e-002,  1.758684e-002,  1.831307e-002,  1.902876e-002,  1.972684e-002,  2.041050e-002,  2.108935e-002,
   2.173923e-002,  2.237265e-002,  2.297090e-002,  2.354096e-002,  2.412886e-002,  2.471794e-002,  2.527551e-002,  2.581197e-002,  2.633118e-002,
   2.683890e-002,  2.733438e-002,  2.780126e-002,  2.824413e-002,  2.865447e-002,  2.904084e-002,  2.937105e-002,  2.968539e-002,  2.998415e-002,
   3.027428e-002,  3.054532e-002,  3.079764e-002,  3.106455e-002,  3.132506e-002,  3.156960e-002,  3.180857e-002,  3.205375e-002,  3.228896e-002,
   3.252091e-002,  3.271934e-002,  3.289472e-002,  3.307206e-002,  3.324106e-002,  3.339448e-002,  3.353456e-002,  3.366045e-002,  3.377804e-002,
   3.389761e-002,  3.401727e-002,  3.413144e-002,  3.425254e-002,  3.437081e-002,  3.448903e-002,  3.459243e-002,  3.467257e-002,  3.474069e-002,
   3.480717e-002,  3.486153e-002,  3.491283e-002,  3.494985e-002,  3.497361e-002,  3.497508e-002,  3.495995e-002,  3.492369e-002,  3.485748e-002,
   3.476868e-002,  3.467043e-002,  3.455774e-002,  3.441120e-002,  3.423531e-002,  3.406846e-002,  3.389805e-002,  3.372093e-002,  3.352094e-002,
   3.330048e-002,  3.306500e-002,  3.281435e-002,  3.255679e-002,  3.229502e-002,  3.203285e-002,  3.176566e-002,  3.149615e-002,  3.120929e-002,
   3.091477e-002,  3.059739e-002,  3.026246e-002,  2.991732e-002,  2.955209e-002,  2.916415e-002,  2.875910e-002,  2.835779e-002,  2.796257e-002,
   2.755974e-002,  2.714536e-002,  2.672353e-002,  2.629519e-002,  2.584748e-002,  2.538733e-002,  2.492165e-002,  2.444579e-002,  2.396350e-002,
   2.343459e-002,  2.287924e-002,  2.232696e-002,  2.178998e-002,  2.125035e-002,  2.070484e-002,  2.015387e-002,  1.959821e-002,  1.904552e-002,
   1.848591e-002,  1.791866e-002,  1.735488e-002,  1.678414e-002,  1.623217e-002,  1.568497e-002,  1.513833e-002,  1.459029e-002,  1.404801e-002,
   1.349753e-002,  1.293772e-002,  1.237014e-002,  1.180083e-002,  1.122481e-002,  1.064271e-002,  1.005560e-002,  9.476598e-003,  8.896534e-003,
   8.304817e-003,  7.710918e-003,  7.115831e-003,  6.518919e-003,  5.918190e-003,  5.315373e-003,  4.709568e-003,  4.090631e-003,  3.465813e-003,
   2.846576e-003,  2.226961e-003,  1.601896e-003,  9.867563e-004,  3.745772e-004,  -2.105205e-004, -7.933030e-004, -1.371328e-003, -1.940325e-003,
   -2.511783e-003, -3.076740e-003, -3.647312e-003, -4.213629e-003, -4.768049e-003, -5.306119e-003, -5.828920e-003, -6.336394e-003, -6.832906e-003,
   -7.320921e-003, -7.797977e-003, -8.274190e-003, -8.748236e-003, -9.233121e-003, -9.707003e-003, -1.015312e-002, -1.057526e-002, -1.099189e-002,
   -1.140492e-002, -1.180347e-002, -1.215806e-002, -1.249829e-002, -1.283284e-002, -1.316834e-002, -1.350417e-002, -1.383645e-002, -1.416119e-002,
   -1.448808e-002, -1.481028e-002, -1.513343e-002, -1.544453e-002, -1.573912e-002, -1.603154e-002, -1.630950e-002, -1.658602e-002, -1.687403e-002,
   -1.715366e-002, -1.742182e-002, -1.768665e-002, -1.795419e-002, -1.821771e-002, -1.846527e-002, -1.864034e-002, -1.877560e-002, -1.891428e-002,
   -1.905052e-002, -1.918990e-002, -1.932156e-002, -1.944473e-002, -1.953402e-002, -1.962136e-002, -1.971149e-002, -1.980488e-002, -1.989959e-002,
   -1.999073e-002, -2.008237e-002, -2.012979e-002, -2.014827e-002, -2.018234e-002, -2.021430e-002, -2.025566e-002, -2.030232e-002, -2.035800e-002,
   -2.041849e-002, -2.047975e-002, -2.053755e-002, -2.059503e-002, -2.066297e-002, -2.070026e-002, -2.073074e-002, -2.076274e-002, -2.079700e-002,
   -2.081766e-002, -2.081751e-002, -2.078707e-002, -2.074217e-002, -2.068854e-002, -2.061840e-002, -2.053394e-002, -2.044232e-002, -2.034929e-002,
   -2.025436e-002, -2.016599e-002, -2.008360e-002, -2.000049e-002, -1.992195e-002, -1.984999e-002, -1.977996e-002, -1.970968e-002, -1.963963e-002,
   -1.957092e-002, -1.951273e-002, -1.941598e-002, -1.930148e-002, -1.919344e-002, -1.909173e-002, -1.898761e-002, -1.885601e-002, -1.871118e-002,
   -1.856783e-002, -1.841840e-002, -1.826673e-002, -1.811925e-002, -1.797291e-002, -1.782092e-002, -1.766494e-002, -1.750164e-002, -1.733041e-002,
   -1.715757e-002, -1.699718e-002, -1.684047e-002, -1.668598e-002, -1.652583e-002, -1.636523e-002, -1.620326e-002, -1.604395e-002, -1.588348e-002,
   -1.571252e-002, -1.554306e-002, -1.537691e-002, -1.521382e-002, -1.505256e-002, -1.489495e-002, -1.472986e-002, -1.454640e-002, -1.435792e-002,
   -1.415967e-002, -1.395707e-002, -1.372492e-002, -1.349921e-002, -1.327217e-002, -1.304305e-002, -1.281467e-002, -1.258340e-002, -1.235459e-002,
   -1.212523e-002, -1.190113e-002, -1.168102e-002, -1.145324e-002, -1.121639e-002, -1.097750e-002, -1.073424e-002, -1.049076e-002, -1.024075e-002,
   -9.991022e-003, -9.742739e-003, -9.494931e-003, -9.245145e-003, -8.995961e-003, -8.752816e-003, -8.512593e-003, -8.277541e-003, -8.049587e-003,
   -7.826348e-003, -7.608062e-003, -7.396156e-003, -7.185370e-003, -6.980983e-003, -6.777299e-003, -6.577432e-003, -6.382538e-003, -6.191508e-003,
   -6.003896e-003, -5.816081e-003, -5.627869e-003, -5.427195e-003, -5.222663e-003, -5.037527e-003, -4.855783e-003, -4.649402e-003, -4.440233e-003,
   -4.232805e-003, -4.024880e-003, -3.807483e-003, -3.588480e-003, -3.361602e-003, -3.132096e-003, -2.905517e-003, -2.679254e-003, -2.452608e-003,
   -2.227449e-003, -2.008791e-003, -1.790952e-003, -1.573746e-003, -1.361542e-003, -1.157087e-003, -9.609823e-004, -7.674150e-004, -5.797771e-004,
   -3.990046e-004, -2.239958e-004, -4.439211e-005, 1.396298e-004,  3.222211e-004,  5.008715e-004,  6.779647e-004,  8.601898e-004,  1.042781e-003,
   1.220758e-003,  1.381251e-003,  1.538930e-003,  1.693212e-003,  1.843456e-003,  1.997282e-003,  2.155009e-003,  2.317536e-003,  2.481689e-003,
   2.649820e-003,  2.819629e-003,  2.990812e-003,  3.162751e-003,  3.331905e-003,  3.507244e-003,  3.683785e-003,  3.861910e-003,  4.030485e-003,
   4.198306e-003,  4.364774e-003,  4.524752e-003,  4.680467e-003,  4.821825e-003,  4.974119e-003,  5.126121e-003,  5.275984e-003,  5.445741e-003,
   5.614988e-003,  5.783175e-003,  5.947920e-003,  6.113995e-003,  6.273493e-003,  6.426155e-003,  6.586598e-003,  6.749856e-003,  6.902632e-003,
   7.059211e-003,  7.218763e-003,  7.379529e-003,  7.536365e-003,  7.705722e-003,  7.882556e-003,  8.061374e-003,  8.239117e-003,  8.422710e-003,
   8.610220e-003,  8.796941e-003,  8.987158e-003,  9.176041e-003,  9.359229e-003,  9.540617e-003,  9.712234e-003,  9.883348e-003,  1.004536e-002,
   1.020352e-002,  1.036267e-002,  1.051669e-002,  1.066336e-002,  1.079316e-002,  1.091487e-002,  1.102950e-002,  1.114212e-002,  1.125885e-002,
   1.136107e-002,  1.145830e-002,  1.155206e-002,  1.164214e-002,  1.172806e-002,  1.180849e-002,  1.188952e-002,  1.196905e-002,  1.204584e-002,
   1.211635e-002,  1.217674e-002,  1.223541e-002,  1.229263e-002,  1.234995e-002,  1.240863e-002,  1.246192e-002,  1.251184e-002,  1.256242e-002,
   1.261874e-002,  1.267709e-002,  1.272766e-002,  1.277669e-002,  1.282692e-002,  1.287511e-002,  1.292109e-002,  1.296405e-002,  1.300595e-002,
   1.304837e-002,  1.309052e-002,  1.313521e-002,  1.317410e-002,  1.320113e-002,  1.322924e-002,  1.325429e-002,  1.328400e-002,  1.332435e-002,
   1.338605e-002,  1.345960e-002,  1.352992e-002,  1.360079e-002,  1.367062e-002,  1.372020e-002,  1.376942e-002,  1.381755e-002,  1.387327e-002,
   1.393805e-002,  1.400128e-002,  1.405127e-002,  1.409417e-002,  1.413538e-002,  1.417545e-002,  1.419578e-002,  1.421460e-002,  1.422852e-002,
   1.423914e-002,  1.424496e-002,  1.424318e-002,  1.423454e-002,  1.422075e-002,  1.420547e-002,  1.419162e-002,  1.415933e-002,  1.411267e-002,
   1.406270e-002,  1.400903e-002,  1.395095e-002,  1.388625e-002,  1.381661e-002,  1.374747e-002,  1.367476e-002,  1.360097e-002,  1.351428e-002,
   1.340822e-002,  1.330277e-002,  1.319812e-002,  1.309727e-002,  1.300067e-002,  1.290355e-002,  1.280535e-002,  1.270370e-002,  1.260333e-002,
   1.250062e-002,  1.237286e-002,  1.226199e-002,  1.215275e-002,  1.204196e-002,  1.192944e-002,  1.181639e-002,  1.169824e-002,  1.156265e-002,
   1.142394e-002,  1.128725e-002,  1.111601e-002,  1.093656e-002,  1.075112e-002,  1.055972e-002,  1.036437e-002,  1.016662e-002,  9.966574e-003,
   9.764344e-003,  9.564577e-003,  9.363137e-003,  9.134555e-003,  8.895172e-003,  8.654333e-003,  8.410100e-003,  8.156153e-003,  7.901157e-003,
   7.657088e-003,  7.412666e-003,  7.162834e-003,  6.905823e-003,  6.633215e-003,  6.343749e-003,  6.058495e-003,  5.776984e-003,  5.509354e-003,
   5.244486e-003,  4.976913e-003,  4.696457e-003,  4.408548e-003,  4.108398e-003,  3.771421e-003,  3.395763e-003,  3.026870e-003,  2.665420e-003,
   2.300077e-003,  1.929931e-003,  1.555189e-003,  1.174700e-003,  7.890409e-004,  3.971999e-004,  -4.543580e-018},
  {0.000000e+000,  2.582338e-002,  2.788695e-002,  3.015120e-002,  1.992367e-002,  6.122007e-003,  1.873491e-003,  1.551893e-003,  1.851705e-003,
   2.831383e-003,  5.649215e-003,  9.446452e-003,  1.257734e-002,  1.404221e-002,  1.265673e-002,  9.201761e-003,  5.724363e-003,  3.914090e-003,
   3.643757e-003,  2.951421e-003,  1.069848e-003,  -2.419836e-003, -6.426817e-003, -1.023838e-002, -1.385503e-002, -1.724476e-002, -2.030696e-002,
   -2.291385e-002, -2.487775e-002, -2.614447e-002, -2.663786e-002, -2.650462e-002, -2.580013e-002, -2.461288e-002, -2.313307e-002, -2.146232e-002,
   -1.965955e-002, -1.744552e-002, -1.463732e-002, -1.140667e-002, -7.972878e-003, -4.575456e-003, -1.313533e-003, 1.588777e-003,  3.999687e-003,
   5.835754e-003,  6.927453e-003,  7.243991e-003,  7.317584e-003,  7.073351e-003,  6.257333e-003,  4.874401e-003,  3.121776e-003,  1.038513e-003,
   -1.218678e-003, -3.454468e-003, -5.575850e-003, -7.444446e-003, -8.954404e-003, -9.935053e-003, -1.031070e-002, -9.867237e-003, -8.816129e-003,
   -7.373982e-003, -5.672227e-003, -3.845725e-003, -1.813834e-003, 3.513706e-004,  2.673189e-003,  5.083045e-003,  7.527808e-003,  1.002128e-002,
   1.260762e-002,  1.524348e-002,  1.786674e-002,  2.050779e-002,  2.313621e-002,  2.573596e-002,  2.833679e-002,  3.108054e-002,  3.380981e-002,
   3.642909e-002,  3.899303e-002,  4.142137e-002,  4.348831e-002,  4.530173e-002,  4.694105e-002,  4.820910e-002,  4.915036e-002,  4.982978e-002,
   5.018315e-002,  5.023589e-002,  4.980763e-002,  4.905758e-002,  4.796739e-002,  4.640574e-002,  4.444484e-002,  4.207434e-002,  3.928124e-002,
   3.635617e-002,  3.336321e-002,  3.010738e-002,  2.671548e-002,  2.312237e-002,  1.937084e-002,  1.547951e-002,  1.141165e-002,  7.274858e-003,
   3.033589e-003,  -1.220267e-003, -5.534770e-003, -9.847984e-003, -1.415600e-002, -1.834604e-002, -2.239824e-002, -2.637304e-002, -3.025736e-002,
   -3.398421e-002, -3.748769e-002, -4.081280e-002, -4.393477e-002, -4.686695e-002, -4.953000e-002, -5.187861e-002, -5.394374e-002, -5.574413e-002,
   -5.728003e-002, -5.858608e-002, -5.961233e-002, -6.040203e-002, -6.099119e-002, -6.134030e-002, -6.140432e-002, -6.106806e-002, -6.028717e-002,
   -5.908612e-002, -5.758131e-002, -5.579794e-002, -5.366737e-002, -5.135445e-002, -4.887707e-002, -4.625764e-002, -4.342870e-002, -4.054161e-002,
   -3.765350e-002, -3.472359e-002, -3.186216e-002, -2.911793e-002, -2.650080e-002, -2.398324e-002, -2.159563e-002, -1.946005e-002, -1.759561e-002,
   -1.603332e-002, -1.476296e-002, -1.354104e-002, -1.230068e-002, -1.108787e-002, -9.978465e-003, -8.980276e-003, -8.103006e-003, -7.298285e-003,
   -6.463383e-003, -5.695816e-003, -5.031625e-003, -4.555449e-003, -4.164841e-003, -3.788624e-003, -3.434260e-003, -3.225064e-003, -3.142920e-003,
   -3.208623e-003, -3.257603e-003, -3.399448e-003, -3.636708e-003, -3.937849e-003, -4.162655e-003, -4.428913e-003, -4.778235e-003, -5.185898e-003,
   -5.409569e-003, -5.634282e-003, -5.892079e-003, -6.062179e-003, -6.160839e-003, -6.230034e-003, -6.141727e-003, -5.946886e-003, -5.718027e-003,
   -5.266735e-003, -4.730247e-003, -4.026396e-003, -3.133571e-003, -2.145805e-003, -8.841697e-004, 4.460122e-004,  1.962817e-003,  3.519369e-003,
   5.228009e-003,  6.988262e-003,  8.859223e-003,  1.078435e-002,  1.276813e-002,  1.476935e-002,  1.679453e-002,  1.885455e-002,  2.088238e-002,
   2.293859e-002,  2.493055e-002,  2.693966e-002,  2.883856e-002,  3.074620e-002,  3.254727e-002,  3.437391e-002,  3.610964e-002,  3.782007e-002,
   3.946395e-002,  4.101541e-002,  4.256785e-002,  4.401362e-002,  4.546050e-002,  4.685832e-002,  4.814837e-002,  4.942355e-002,  5.059405e-002,
   5.171846e-002,  5.282062e-002,  5.381627e-002,  5.475877e-002,  5.566143e-002,  5.646076e-002,  5.720148e-002,  5.790035e-002,  5.850898e-002,
   5.901851e-002,  5.948157e-002,  5.988680e-002,  6.016002e-002,  6.038337e-002,  6.053420e-002,  6.057080e-002,  6.051355e-002,  6.037638e-002,
   6.015988e-002,  5.980726e-002,  5.936905e-002,  5.885350e-002,  5.823953e-002,  5.747670e-002,  5.662954e-002,  5.568238e-002,  5.464153e-002,
   5.345658e-002,  5.220852e-002,  5.092240e-002,  4.958150e-002,  4.812957e-002,  4.663464e-002,  4.510249e-002,  4.353549e-002,  4.190036e-002,
   4.019099e-002,  3.843812e-002,  3.664865e-002,  3.481497e-002,  3.292826e-002,  3.101100e-002,  2.906868e-002,  2.709568e-002,  2.507404e-002,
   2.299438e-002,  2.090159e-002,  1.879844e-002,  1.667227e-002,  1.449982e-002,  1.228980e-002,  1.006114e-002,  7.834112e-003,  5.600179e-003,
   3.342738e-003,  1.067792e-003,  -1.203849e-003, -3.480048e-003, -5.753192e-003, -8.040342e-003, -1.033072e-002, -1.260687e-002, -1.485605e-002,
   -1.708884e-002, -1.932198e-002, -2.153992e-002, -2.374419e-002, -2.592434e-002, -2.807872e-002, -3.020181e-002, -3.231914e-002, -3.438478e-002,
   -3.640979e-002, -3.841246e-002, -4.038254e-002, -4.233059e-002, -4.424713e-002, -4.610782e-002, -4.789066e-002, -4.962434e-002, -5.132563e-002,
   -5.299403e-002, -5.459660e-002, -5.613912e-002, -5.761421e-002, -5.899103e-002, -6.030601e-002, -6.157000e-002, -6.275918e-002, -6.387614e-002,
   -6.492458e-002, -6.588903e-002, -6.676407e-002, -6.755520e-002, -6.828829e-002, -6.896337e-002, -6.957697e-002, -7.012728e-002, -7.063573e-002,
   -7.107170e-002, -7.145046e-002, -7.176842e-002, -7.202866e-002, -7.224724e-002, -7.241784e-002, -7.254152e-002, -7.262095e-002, -7.263374e-002,
   -7.256884e-002, -7.246964e-002, -7.232437e-002, -7.213061e-002, -7.187811e-002, -7.157505e-002, -7.116766e-002, -7.063421e-002, -6.999795e-002,
   -6.930333e-002, -6.851589e-002, -6.761833e-002, -6.664138e-002, -6.560128e-002, -6.445090e-002, -6.324399e-002, -6.195046e-002, -6.058348e-002,
   -5.913489e-002, -5.762982e-002, -5.607133e-002, -5.444229e-002, -5.276641e-002, -5.103873e-002, -4.928213e-002, -4.745380e-002, -4.556179e-002,
   -4.362721e-002, -4.166393e-002, -3.966141e-002, -3.762823e-002, -3.554553e-002, -3.345927e-002, -3.134624e-002, -2.920581e-002, -2.701512e-002,
   -2.481717e-002, -2.259149e-002, -2.034948e-002, -1.809695e-002, -1.585847e-002, -1.360849e-002, -1.136313e-002, -9.135985e-003, -6.906143e-003,
   -4.648397e-003, -2.403261e-003, -1.620247e-004, 2.051146e-003,  4.246357e-003,  6.409294e-003,  8.536767e-003,  1.065861e-002,  1.276302e-002,
   1.484251e-002,  1.690199e-002,  1.893074e-002,  2.093150e-002,  2.286372e-002,  2.473345e-002,  2.657574e-002,  2.838702e-002,  3.013479e-002,
   3.184725e-002,  3.350079e-002,  3.507956e-002,  3.657114e-002,  3.802480e-002,  3.942060e-002,  4.074637e-002,  4.200214e-002,  4.318976e-002,
   4.429811e-002,  4.531892e-002,  4.624901e-002,  4.715347e-002,  4.803189e-002,  4.890701e-002,  4.976844e-002,  5.060156e-002,  5.140311e-002,
   5.218886e-002,  5.295747e-002,  5.365133e-002,  5.430922e-002,  5.492732e-002,  5.554098e-002,  5.613254e-002,  5.669940e-002,  5.723183e-002,
   5.772675e-002,  5.819009e-002,  5.860019e-002,  5.891647e-002,  5.917831e-002,  5.939426e-002,  5.955203e-002,  5.964731e-002,  5.968833e-002,
   5.969862e-002,  5.963703e-002,  5.948914e-002,  5.928945e-002,  5.901539e-002,  5.869905e-002,  5.832790e-002,  5.790845e-002,  5.745916e-002,
   5.698327e-002,  5.645336e-002,  5.585263e-002,  5.522002e-002,  5.456399e-002,  5.386684e-002,  5.310711e-002,  5.231428e-002,  5.148238e-002,
   5.063449e-002,  4.976438e-002,  4.886258e-002,  4.791742e-002,  4.695486e-002,  4.597573e-002,  4.496933e-002,  4.393220e-002,  4.284279e-002,
   4.175212e-002,  4.065589e-002,  3.953443e-002,  3.840069e-002,  3.723112e-002,  3.605475e-002,  3.486881e-002,  3.367353e-002,  3.247582e-002,
   3.128344e-002,  3.008618e-002,  2.885326e-002,  2.761403e-002,  2.637146e-002,  2.513492e-002,  2.388366e-002,  2.263708e-002,  2.139103e-002,
   2.014758e-002,  1.890976e-002,  1.768721e-002,  1.647237e-002,  1.526169e-002,  1.405306e-002,  1.286517e-002,  1.169275e-002,  1.051736e-002,
   9.343780e-003,  8.187537e-003,  7.059036e-003,  5.959319e-003,  4.881003e-003,  3.827071e-003,  2.803146e-003,  1.803574e-003,  8.336306e-004,
   -1.112889e-004, -1.029277e-003, -1.942344e-003, -2.836194e-003, -3.677700e-003, -4.485395e-003, -5.262823e-003, -6.004349e-003, -6.702482e-003,
   -7.349067e-003, -7.943895e-003, -8.494786e-003, -9.000597e-003, -9.459769e-003, -9.866974e-003, -1.025754e-002, -1.063083e-002, -1.099423e-002,
   -1.135477e-002, -1.172834e-002, -1.209433e-002, -1.244451e-002, -1.278519e-002, -1.312057e-002, -1.345353e-002, -1.378238e-002, -1.410562e-002,
   -1.440929e-002, -1.472319e-002, -1.504577e-002, -1.535873e-002, -1.568911e-002, -1.601979e-002, -1.634087e-002, -1.665018e-002, -1.695646e-002,
   -1.725807e-002, -1.756278e-002, -1.785997e-002, -1.814962e-002, -1.842431e-002, -1.869064e-002, -1.897816e-002, -1.928970e-002, -1.959482e-002,
   -1.989242e-002, -2.018911e-002, -2.047715e-002, -2.076220e-002, -2.104346e-002, -2.132549e-002, -2.160666e-002, -2.187249e-002, -2.215183e-002,
   -2.244255e-002, -2.273536e-002, -2.302519e-002, -2.332048e-002, -2.362422e-002, -2.392241e-002, -2.421397e-002, -2.450256e-002, -2.478739e-002,
   -2.506222e-002, -2.534028e-002, -2.560466e-002, -2.586774e-002, -2.613478e-002, -2.640197e-002, -2.666248e-002, -2.691659e-002, -2.716008e-002,
   -2.740416e-002, -2.767136e-002, -2.795510e-002, -2.822781e-002, -2.849630e-002, -2.874778e-002, -2.898433e-002, -2.922457e-002, -2.945505e-002,
   -2.967060e-002, -2.988182e-002, -3.007252e-002, -3.025605e-002, -3.043270e-002, -3.060505e-002, -3.077101e-002, -3.093089e-002, -3.109494e-002,
   -3.125094e-002, -3.140677e-002, -3.155636e-002, -3.167006e-002, -3.177725e-002, -3.188191e-002, -3.198533e-002, -3.209000e-002, -3.219402e-002,
   -3.228849e-002, -3.237911e-002, -3.246861e-002, -3.253237e-002, -3.253422e-002, -3.250458e-002, -3.246226e-002, -3.241514e-002, -3.236453e-002,
   -3.232251e-002, -3.228404e-002, -3.223931e-002, -3.218492e-002, -3.211922e-002, -3.203205e-002, -3.192054e-002, -3.176521e-002, -3.156059e-002,
   -3.134152e-002, -3.111350e-002, -3.087894e-002, -3.063793e-002, -3.038738e-002, -3.012938e-002, -2.986057e-002, -2.956141e-002, -2.923532e-002,
   -2.890091e-002, -2.855211e-002, -2.819847e-002, -2.783067e-002, -2.743875e-002, -2.698010e-002, -2.651385e-002, -2.603993e-002, -2.554995e-002,
   -2.503188e-002, -2.449559e-002, -2.394813e-002, -2.338839e-002, -2.281920e-002, -2.225099e-002, -2.167806e-002, -2.109607e-002, -2.050371e-002,
   -1.990144e-002, -1.929286e-002, -1.867887e-002, -1.806404e-002, -1.745847e-002, -1.683969e-002, -1.619093e-002, -1.549554e-002, -1.478858e-002,
   -1.406755e-002, -1.335079e-002, -1.267159e-002, -1.198672e-002, -1.129643e-002, -1.059907e-002, -9.898953e-003, -9.196647e-003, -8.498074e-003,
   -7.794314e-003, -7.095248e-003, -6.396417e-003, -5.727504e-003, -5.095640e-003, -4.460635e-003, -3.838829e-003, -3.227981e-003, -2.620730e-003,
   -2.017433e-003, -1.420021e-003, -8.220225e-004, -2.187297e-004, 3.900817e-004,  1.000093e-003,  1.582605e-003,  2.126356e-003,  2.676725e-003,
   3.241377e-003,  3.804041e-003,  4.371819e-003,  4.942579e-003,  5.484599e-003,  6.031348e-003,  6.583482e-003,  7.143376e-003,  7.714608e-003,
   8.292779e-003,  8.879410e-003,  9.377144e-003,  9.798808e-003,  1.020809e-002,  1.062327e-002,  1.104663e-002,  1.147767e-002,  1.191842e-002,
   1.236953e-002,  1.282603e-002,  1.328764e-002,  1.375019e-002,  1.421328e-002,  1.466225e-002,  1.511258e-002,  1.556932e-002,  1.602989e-002,
   1.648278e-002,  1.690894e-002,  1.727076e-002,  1.760933e-002,  1.795406e-002,  1.829887e-002,  1.867353e-002,  1.903998e-002,  1.940619e-002,
   1.977776e-002,  2.014896e-002,  2.051914e-002,  2.088825e-002,  2.125882e-002,  2.162986e-002,  2.199536e-002,  2.235992e-002,  2.272515e-002,
   2.309407e-002,  2.346409e-002,  2.377533e-002,  2.405118e-002,  2.432890e-002,  2.460762e-002,  2.489001e-002,  2.512178e-002,  2.532171e-002,
   2.551999e-002,  2.571579e-002,  2.590933e-002,  2.610171e-002,  2.629283e-002,  2.648123e-002,  2.667615e-002,  2.687626e-002,  2.706187e-002,
   2.723278e-002,  2.739052e-002,  2.754781e-002,  2.770775e-002,  2.786157e-002,  2.800788e-002,  2.815196e-002,  2.829371e-002,  2.841866e-002,
   2.850806e-002,  2.859112e-002,  2.867208e-002,  2.875144e-002,  2.882869e-002,  2.890365e-002,  2.896650e-002,  2.900974e-002,  2.904810e-002,
   2.910987e-002,  2.917881e-002,  2.917776e-002,  2.916975e-002,  2.915829e-002,  2.914576e-002,  2.912872e-002,  2.910170e-002,  2.906646e-002,
   2.901714e-002,  2.896276e-002,  2.889193e-002,  2.881246e-002,  2.873334e-002,  2.865144e-002,  2.855451e-002,  2.845170e-002,  2.834675e-002,
   2.823901e-002,  2.812772e-002,  2.801081e-002,  2.787629e-002,  2.771456e-002,  2.754716e-002,  2.737634e-002,  2.720424e-002,  2.703163e-002,
   2.685442e-002,  2.667217e-002,  2.648514e-002,  2.629500e-002,  2.610084e-002,  2.591180e-002,  2.571996e-002,  2.551914e-002,  2.530547e-002,
   2.509024e-002,  2.487238e-002,  2.464957e-002,  2.440947e-002,  2.415352e-002,  2.388243e-002,  2.360648e-002,  2.328907e-002,  2.296099e-002,
   2.262688e-002,  2.228336e-002,  2.193198e-002,  2.157621e-002,  2.122087e-002,  2.085911e-002,  2.049128e-002,  2.011490e-002,  1.973083e-002,
   1.933753e-002,  1.893406e-002,  1.852277e-002,  1.810294e-002,  1.766812e-002,  1.722695e-002,  1.678013e-002,  1.630866e-002,  1.582072e-002,
   1.533606e-002,  1.485178e-002,  1.436312e-002,  1.389237e-002,  1.342056e-002,  1.295249e-002,  1.248761e-002,  1.202538e-002,  1.156448e-002,
   1.110221e-002,  1.063403e-002,  1.016925e-002,  9.705857e-003,  9.241361e-003,  8.780186e-003,  8.320196e-003,  7.861386e-003,  7.404690e-003,
   6.948702e-003,  6.492689e-003,  6.035016e-003,  5.588828e-003,  5.144262e-003,  4.700165e-003,  4.260471e-003,  3.820413e-003,  3.378009e-003,
   2.936965e-003,  2.496685e-003,  2.056279e-003,  1.616401e-003,  1.191256e-003,  7.536394e-004,  3.129552e-004,  -1.289709e-004, -5.984666e-004,
   -1.068986e-003, -1.540534e-003, -2.018044e-003, -2.500498e-003, -2.979633e-003, -3.446692e-003, -3.905171e-003, -4.363551e-003, -4.831924e-003,
   -5.299494e-003, -5.768363e-003, -6.238863e-003, -6.713220e-003, -7.188559e-003, -7.681969e-003, -8.167602e-003, -8.632872e-003, -9.094300e-003,
   -9.556350e-003, -1.001708e-002, -1.047489e-002, -1.093133e-002, -1.138558e-002, -1.183474e-002, -1.227822e-002, -1.271034e-002, -1.311342e-002,
   -1.351145e-002, -1.389745e-002, -1.427333e-002, -1.464059e-002, -1.500170e-002, -1.535901e-002, -1.571338e-002, -1.606026e-002, -1.639657e-002,
   -1.669678e-002, -1.699257e-002, -1.728501e-002, -1.757322e-002, -1.785175e-002, -1.812491e-002, -1.839617e-002, -1.866475e-002, -1.893234e-002,
   -1.920176e-002, -1.944210e-002, -1.968713e-002, -1.993595e-002, -2.018648e-002, -2.043727e-002, -2.069106e-002, -2.094287e-002, -2.118790e-002,
   -2.142222e-002, -2.165966e-002, -2.187858e-002, -2.207911e-002, -2.228202e-002, -2.248486e-002, -2.268916e-002, -2.289575e-002, -2.310060e-002,
   -2.330430e-002, -2.349982e-002, -2.369265e-002, -2.387126e-002, -2.401661e-002, -2.416483e-002, -2.431245e-002, -2.446701e-002, -2.462648e-002,
   -2.480247e-002, -2.498029e-002, -2.515447e-002, -2.532875e-002, -2.549896e-002, -2.561131e-002, -2.572436e-002, -2.583953e-002, -2.595272e-002,
   -2.606886e-002, -2.620108e-002, -2.634142e-002, -2.648246e-002, -2.662419e-002, -2.676823e-002, -2.686031e-002, -2.693937e-002, -2.701250e-002,
   -2.707716e-002, -2.713994e-002, -2.720194e-002, -2.726222e-002, -2.731722e-002, -2.736718e-002, -2.741234e-002, -2.740787e-002, -2.736974e-002,
   -2.732665e-002, -2.727741e-002, -2.722798e-002, -2.717501e-002, -2.711777e-002, -2.705342e-002, -2.698006e-002, -2.690410e-002, -2.679515e-002,
   -2.663376e-002, -2.646899e-002, -2.630447e-002, -2.613991e-002, -2.597426e-002, -2.580972e-002, -2.564703e-002, -2.546739e-002, -2.528640e-002,
   -2.509463e-002, -2.482749e-002, -2.455954e-002, -2.429094e-002, -2.402580e-002, -2.376498e-002, -2.350641e-002, -2.325066e-002, -2.300422e-002,
   -2.275431e-002, -2.250732e-002, -2.215493e-002, -2.178699e-002, -2.142203e-002, -2.105955e-002, -2.069899e-002, -2.034095e-002, -1.998511e-002,
   -1.963402e-002, -1.927448e-002, -1.891150e-002, -1.847149e-002, -1.799834e-002, -1.752812e-002, -1.705416e-002, -1.656324e-002, -1.607551e-002,
   -1.558619e-002, -1.509975e-002, -1.461906e-002, -1.412681e-002, -1.357825e-002, -1.296390e-002, -1.235324e-002, -1.174679e-002, -1.114098e-002,
   -1.053527e-002, -9.935998e-003, -9.318518e-003, -8.696637e-003, -8.082559e-003, -7.425515e-003, -6.664508e-003, -5.906687e-003, -5.151437e-003,
   -4.401025e-003, -3.655789e-003, -2.915332e-003, -2.179478e-003, -1.448199e-003, -7.217395e-004, -2.567240e-018},
  {0.000000e+000,  1.994115e-001,  1.800203e-001,  1.545653e-001,  1.299366e-001,  1.062012e-001,  8.457450e-002,  6.488222e-002,  4.582496e-002,
   2.772342e-002,  1.092794e-002,  -4.723545e-003, -1.888470e-002, -3.061054e-002, -4.022590e-002, -4.805896e-002, -5.397992e-002, -5.710701e-002,
   -5.818212e-002, -5.794322e-002, -5.703980e-002, -5.625454e-002, -5.561314e-002, -5.507816e-002, -5.383257e-002, -5.228108e-002, -5.080053e-002,
   -4.990720e-002, -5.017243e-002, -5.112138e-002, -5.221414e-002, -5.336463e-002, -5.449491e-002, -5.540424e-002, -5.577496e-002, -5.544910e-002,
   -5.427255e-002, -5.230961e-002, -4.962822e-002, -4.633362e-002, -4.256385e-002, -3.847006e-002, -3.396507e-002, -2.927351e-002, -2.439569e-002,
   -1.943869e-002, -1.452581e-002, -9.778460e-003, -5.048164e-003, -1.867567e-004, 4.743900e-003,  1.024199e-002,  1.640414e-002,  2.289655e-002,
   2.956801e-002,  3.630103e-002,  4.300259e-002,  4.937217e-002,  5.518242e-002,  6.034856e-002,  6.452966e-002,  6.779443e-002,  7.070444e-002,
   7.335252e-002,  7.567860e-002,  7.753827e-002,  7.907946e-002,  8.048497e-002,  8.177406e-002,  8.263777e-002,  8.302860e-002,  8.322929e-002,
   8.325761e-002,  8.290563e-002,  8.207983e-002,  8.113907e-002,  7.997070e-002,  7.841454e-002,  7.645719e-002,  7.443928e-002,  7.219326e-002,
   6.950285e-002,  6.676136e-002,  6.401585e-002,  6.073379e-002,  5.721529e-002,  5.361167e-002,  4.957851e-002,  4.550726e-002,  4.119757e-002,
   3.645610e-002,  3.165577e-002,  2.635704e-002,  2.113759e-002,  1.574249e-002,  1.002620e-002,  4.174248e-003,  -1.853029e-003, -7.871257e-003,
   -1.396751e-002, -2.000963e-002, -2.602361e-002, -3.180849e-002, -3.738520e-002, -4.274972e-002, -4.784664e-002, -5.247224e-002, -5.661126e-002,
   -6.049407e-002, -6.402261e-002, -6.701596e-002, -6.961977e-002, -7.210251e-002, -7.405991e-002, -7.591641e-002, -7.747944e-002, -7.872568e-002,
   -7.978812e-002, -8.066890e-002, -8.138986e-002, -8.189995e-002, -8.244012e-002, -8.279679e-002, -8.292167e-002, -8.292392e-002, -8.268926e-002,
   -8.217472e-002, -8.144679e-002, -8.054291e-002, -7.942496e-002, -7.812349e-002, -7.659656e-002, -7.481911e-002, -7.290770e-002, -7.088981e-002,
   -6.854076e-002, -6.606341e-002, -6.348505e-002, -6.069982e-002, -5.779689e-002, -5.491708e-002, -5.183715e-002, -4.871784e-002, -4.574789e-002,
   -4.267877e-002, -3.950965e-002, -3.634840e-002, -3.313373e-002, -3.010130e-002, -2.696456e-002, -2.397643e-002, -2.114233e-002, -1.828296e-002,
   -1.541789e-002, -1.265875e-002, -9.858510e-003, -7.186767e-003, -4.550681e-003, -1.879534e-003, 7.951079e-004,  3.408193e-003,  6.183411e-003,
   8.915607e-003,  1.160468e-002,  1.434871e-002,  1.722379e-002,  2.016723e-002,  2.305516e-002,  2.589494e-002,  2.867486e-002,  3.144102e-002,
   3.430633e-002,  3.705611e-002,  3.971557e-002,  4.232671e-002,  4.498104e-002,  4.750010e-002,  4.985911e-002,  5.215897e-002,  5.443794e-002,
   5.650808e-002,  5.849790e-002,  6.038815e-002,  6.207193e-002,  6.355134e-002,  6.496431e-002,  6.615325e-002,  6.713388e-002,  6.805462e-002,
   6.856693e-002,  6.898120e-002,  6.919332e-002,  6.918685e-002,  6.901046e-002,  6.851246e-002,  6.787536e-002,  6.697997e-002,  6.590996e-002,
   6.453573e-002,  6.300738e-002,  6.128590e-002,  5.939574e-002,  5.747478e-002,  5.545459e-002,  5.347508e-002,  5.145667e-002,  4.943969e-002,
   4.738949e-002,  4.538466e-002,  4.335512e-002,  4.143163e-002,  3.944634e-002,  3.750252e-002,  3.558318e-002,  3.374665e-002,  3.195876e-002,
   3.016734e-002,  2.841343e-002,  2.659634e-002,  2.495524e-002,  2.329459e-002,  2.163580e-002,  1.999798e-002,  1.832130e-002,  1.668069e-002,
   1.511285e-002,  1.352915e-002,  1.196980e-002,  1.042156e-002,  8.812893e-003,  7.276352e-003,  5.816718e-003,  4.300734e-003,  2.831803e-003,
   1.382030e-003,  -8.584407e-005, -1.522037e-003, -2.899761e-003, -4.235273e-003, -5.575000e-003, -6.914166e-003, -8.216285e-003, -9.569998e-003,
   -1.091799e-002, -1.213511e-002, -1.335990e-002, -1.462280e-002, -1.587424e-002, -1.707880e-002, -1.830529e-002, -1.950721e-002, -2.066613e-002,
   -2.179987e-002, -2.294531e-002, -2.406942e-002, -2.516915e-002, -2.621419e-002, -2.721940e-002, -2.819383e-002, -2.917306e-002, -3.005866e-002,
   -3.087541e-002, -3.166449e-002, -3.245383e-002, -3.318760e-002, -3.383592e-002, -3.446329e-002, -3.503471e-002, -3.557826e-002, -3.604683e-002,
   -3.643831e-002, -3.671976e-002, -3.689451e-002, -3.695002e-002, -3.685698e-002, -3.668621e-002, -3.641659e-002, -3.607950e-002, -3.566249e-002,
   -3.512920e-002, -3.454340e-002, -3.392062e-002, -3.322512e-002, -3.244180e-002, -3.156596e-002, -3.064623e-002, -2.970363e-002, -2.873052e-002,
   -2.772481e-002, -2.666664e-002, -2.554997e-002, -2.440148e-002, -2.322167e-002, -2.208665e-002, -2.089837e-002, -1.968317e-002, -1.846749e-002,
   -1.722797e-002, -1.599427e-002, -1.479363e-002, -1.357495e-002, -1.239061e-002, -1.117971e-002, -9.989264e-003, -8.805567e-003, -7.694404e-003,
   -6.612748e-003, -5.549787e-003, -4.500399e-003, -3.486171e-003, -2.464558e-003, -1.498954e-003, -5.846051e-004, 2.768073e-004,  1.064311e-003,
   1.770394e-003,  2.392970e-003,  2.977479e-003,  3.465503e-003,  3.890226e-003,  4.211557e-003,  4.426568e-003,  4.558136e-003,  4.627256e-003,
   4.601091e-003,  4.490713e-003,  4.358354e-003,  4.239949e-003,  4.078649e-003,  3.891331e-003,  3.703991e-003,  3.485885e-003,  3.256289e-003,
   3.030036e-003,  2.778938e-003,  2.542953e-003,  2.361275e-003,  2.156343e-003,  1.893464e-003,  1.614705e-003,  1.372374e-003,  1.136471e-003,
   9.298647e-004,  7.181386e-004,  5.421042e-004,  4.016982e-004,  2.055644e-004,  4.693864e-005,  -8.816619e-005, -2.384021e-004, -3.908703e-004,
   -5.145917e-004, -6.438117e-004, -7.884539e-004, -9.246930e-004, -1.011938e-003, -1.033255e-003, -1.048758e-003, -1.041810e-003, -1.053986e-003,
   -1.106793e-003, -1.210031e-003, -1.325548e-003, -1.437410e-003, -1.497819e-003, -1.491852e-003, -1.480585e-003, -1.470560e-003, -1.434580e-003,
   -1.377257e-003, -1.381436e-003, -1.394461e-003, -1.423218e-003, -1.418667e-003, -1.316771e-003, -1.202684e-003, -1.075200e-003, -9.376969e-004,
   -8.280971e-004, -7.796047e-004, -7.302366e-004, -6.624544e-004, -6.092372e-004, -5.252831e-004, -4.008807e-004, -2.414486e-004, -9.781290e-005,
   3.044945e-005,  8.284647e-005,  1.305904e-004,  1.623638e-004,  1.853695e-004,  2.317645e-004,  3.045913e-004,  3.990136e-004,  4.987041e-004,
   6.220249e-004,  7.118130e-004,  7.676574e-004,  8.099047e-004,  8.294054e-004,  8.377904e-004,  8.822233e-004,  9.177472e-004,  9.379131e-004,
   9.440616e-004,  9.810649e-004,  1.103409e-003,  1.176540e-003,  1.223098e-003,  1.259795e-003,  1.292701e-003,  1.335389e-003,  1.338652e-003,
   1.339449e-003,  1.381085e-003,  1.488194e-003,  1.577164e-003,  1.630007e-003,  1.662634e-003,  1.693413e-003,  1.728487e-003,  1.728010e-003,
   1.739054e-003,  1.765114e-003,  1.808860e-003,  1.860458e-003,  1.908194e-003,  1.959702e-003,  1.989123e-003,  1.976282e-003,  1.948353e-003,
   1.938278e-003,  1.933186e-003,  1.959555e-003,  1.984207e-003,  2.007310e-003,  2.026893e-003,  2.054498e-003,  2.087436e-003,  2.153807e-003,
   2.193039e-003,  2.173026e-003,  2.168770e-003,  2.171189e-003,  2.227901e-003,  2.244870e-003,  2.249290e-003,  2.244648e-003,  2.240134e-003,
   2.243374e-003,  2.223341e-003,  2.195735e-003,  2.194777e-003,  2.192997e-003,  2.156069e-003,  2.079016e-003,  1.971312e-003,  1.890285e-003,
   1.849775e-003,  1.811996e-003,  1.747163e-003,  1.654081e-003,  1.586662e-003,  1.509017e-003,  1.407003e-003,  1.287489e-003,  1.156615e-003,
   1.029739e-003,  8.725774e-004,  7.514670e-004,  6.310717e-004,  4.668026e-004,  3.296253e-004,  2.472284e-004,  1.780564e-004,  9.813202e-005,
   7.024856e-006,  -8.364791e-005, -1.638346e-004, -2.404041e-004, -3.261619e-004, -4.043435e-004, -4.712044e-004, -5.911881e-004, -6.915854e-004,
   -7.744435e-004, -8.497977e-004, -9.347223e-004, -1.002663e-003, -1.062698e-003, -1.103743e-003, -1.166452e-003, -1.255231e-003, -1.361254e-003,
   -1.447649e-003, -1.520915e-003, -1.574976e-003, -1.624774e-003, -1.682619e-003, -1.773881e-003, -1.863953e-003, -1.949136e-003, -2.033017e-003,
   -2.107201e-003, -2.189812e-003, -2.275609e-003, -2.340071e-003, -2.386362e-003, -2.436182e-003, -2.468430e-003, -2.505986e-003, -2.522184e-003,
   -2.528802e-003, -2.534709e-003, -2.542867e-003, -2.564423e-003, -2.597663e-003, -2.625108e-003, -2.651275e-003, -2.675466e-003, -2.695150e-003,
   -2.700661e-003, -2.680944e-003, -2.636909e-003, -2.583672e-003, -2.532316e-003, -2.494897e-003, -2.484584e-003, -2.458162e-003, -2.437826e-003,
   -2.417717e-003, -2.403159e-003, -2.387185e-003, -2.392382e-003, -2.406272e-003, -2.431643e-003, -2.437993e-003, -2.413190e-003, -2.381726e-003,
   -2.339674e-003, -2.310178e-003, -2.261447e-003, -2.199916e-003, -2.118498e-003, -2.026408e-003, -1.914556e-003, -1.771726e-003, -1.595517e-003,
   -1.386857e-003, -1.158363e-003, -9.254445e-004, -6.746435e-004, -4.075848e-004, -1.382223e-004, 1.566729e-004,  4.775807e-004,  8.081464e-004,
   1.152529e-003,  1.524407e-003,  1.907760e-003,  2.300949e-003,  2.688409e-003,  3.080793e-003,  3.476256e-003,  3.890289e-003,  4.314994e-003,
   4.753486e-003,  5.211753e-003,  5.687781e-003,  6.179677e-003,  6.675471e-003,  7.169366e-003,  7.652750e-003,  8.130249e-003,  8.621879e-003,
   9.142344e-003,  9.666380e-003,  1.020179e-002,  1.075643e-002,  1.131664e-002,  1.188455e-002,  1.247185e-002,  1.306803e-002,  1.366827e-002,
   1.425815e-002,  1.484815e-002,  1.543804e-002,  1.603555e-002,  1.663695e-002,  1.721990e-002,  1.779312e-002,  1.836562e-002,  1.892609e-002,
   1.949438e-002,  2.007326e-002,  2.062172e-002,  2.111005e-002,  2.160011e-002,  2.209030e-002,  2.259632e-002,  2.309821e-002,  2.358284e-002,
   2.405531e-002,  2.451988e-002,  2.497966e-002,  2.542588e-002,  2.583990e-002,  2.624814e-002,  2.663117e-002,  2.699270e-002,  2.732745e-002,
   2.764841e-002,  2.795764e-002,  2.826967e-002,  2.857269e-002,  2.885510e-002,  2.911152e-002,  2.935808e-002,  2.958524e-002,  2.975768e-002,
   2.991022e-002,  3.009176e-002,  3.026225e-002,  3.040200e-002,  3.050378e-002,  3.059241e-002,  3.066170e-002,  3.070899e-002,  3.072240e-002,
   3.067765e-002,  3.059507e-002,  3.048192e-002,  3.033001e-002,  3.015391e-002,  2.994818e-002,  2.971085e-002,  2.942712e-002,  2.909253e-002,
   2.872605e-002,  2.830716e-002,  2.784749e-002,  2.735425e-002,  2.683947e-002,  2.628566e-002,  2.569121e-002,  2.508597e-002,  2.446298e-002,
   2.381813e-002,  2.315801e-002,  2.252099e-002,  2.185049e-002,  2.113087e-002,  2.037404e-002,  1.959958e-002,  1.883099e-002,  1.807093e-002,
   1.729770e-002,  1.652498e-002,  1.573159e-002,  1.495137e-002,  1.421379e-002,  1.346815e-002,  1.273341e-002,  1.201557e-002,  1.129502e-002,
   1.057152e-002,  9.848899e-003,  9.129448e-003,  8.397180e-003,  7.642661e-003,  6.912411e-003,  6.261204e-003,  5.593916e-003,  4.907036e-003,
   4.229196e-003,  3.540967e-003,  2.843428e-003,  2.145019e-003,  1.479969e-003,  8.144344e-004,  1.216311e-004,  -5.833074e-004, -1.273385e-003,
   -1.970200e-003, -2.678760e-003, -3.305254e-003, -3.870133e-003, -4.422037e-003, -4.977046e-003, -5.525795e-003, -6.075219e-003, -6.630161e-003,
   -7.192632e-003, -7.760078e-003, -8.326019e-003, -8.906654e-003, -9.505481e-003, -1.003924e-002, -1.057216e-002, -1.110722e-002, -1.164026e-002,
   -1.218242e-002, -1.270181e-002, -1.319003e-002, -1.365166e-002, -1.410855e-002, -1.455369e-002, -1.500198e-002, -1.545054e-002, -1.590635e-002,
   -1.637174e-002, -1.683438e-002, -1.729068e-002, -1.775106e-002, -1.821105e-002, -1.867706e-002, -1.912882e-002, -1.956989e-002, -2.000570e-002,
   -2.047037e-002, -2.094902e-002, -2.135494e-002, -2.171667e-002, -2.206925e-002, -2.241727e-002, -2.275526e-002, -2.304135e-002, -2.331169e-002,
   -2.358582e-002, -2.385427e-002, -2.411570e-002, -2.437681e-002, -2.465152e-002, -2.494976e-002, -2.524366e-002, -2.553070e-002, -2.580825e-002,
   -2.607810e-002, -2.632767e-002, -2.657636e-002, -2.684301e-002, -2.709067e-002, -2.732745e-002, -2.757891e-002, -2.783068e-002, -2.806875e-002,
   -2.827531e-002, -2.846376e-002, -2.864872e-002, -2.881077e-002, -2.896882e-002, -2.912747e-002, -2.927044e-002, -2.938489e-002, -2.949837e-002,
   -2.958264e-002, -2.966053e-002, -2.969128e-002, -2.972274e-002, -2.975694e-002, -2.978394e-002, -2.980791e-002, -2.982642e-002, -2.982843e-002,
   -2.981198e-002, -2.978656e-002, -2.975477e-002, -2.973172e-002, -2.970673e-002, -2.968467e-002, -2.965510e-002, -2.961405e-002, -2.955663e-002,
   -2.948887e-002, -2.941371e-002, -2.932945e-002, -2.922619e-002, -2.911933e-002, -2.900568e-002, -2.887813e-002, -2.874517e-002, -2.859753e-002,
   -2.844296e-002, -2.828284e-002, -2.812081e-002, -2.796222e-002, -2.781061e-002, -2.763165e-002, -2.743285e-002, -2.721977e-002, -2.699281e-002,
   -2.676430e-002, -2.653488e-002, -2.631279e-002, -2.607819e-002, -2.582505e-002, -2.555764e-002, -2.529125e-002, -2.498855e-002, -2.467981e-002,
   -2.437210e-002, -2.406614e-002, -2.378183e-002, -2.352124e-002, -2.325633e-002, -2.298571e-002, -2.270701e-002, -2.241807e-002, -2.212651e-002,
   -2.183469e-002, -2.154408e-002, -2.125230e-002, -2.096461e-002, -2.066675e-002, -2.035571e-002, -2.002522e-002, -1.965941e-002, -1.926862e-002,
   -1.886961e-002, -1.846221e-002, -1.803678e-002, -1.759340e-002, -1.714963e-002, -1.669965e-002, -1.624895e-002, -1.579296e-002, -1.533473e-002,
   -1.487257e-002, -1.440648e-002, -1.394547e-002, -1.349306e-002, -1.303329e-002, -1.256285e-002, -1.209812e-002, -1.163973e-002, -1.118525e-002,
   -1.073190e-002, -1.028767e-002, -9.853180e-003, -9.444167e-003, -9.038903e-003, -8.646198e-003, -8.249178e-003, -7.837462e-003, -7.416346e-003,
   -6.988440e-003, -6.551874e-003, -6.112431e-003, -5.675586e-003, -5.254285e-003, -4.810506e-003, -4.366722e-003, -3.922109e-003, -3.447888e-003,
   -2.980728e-003, -2.515324e-003, -2.035227e-003, -1.534855e-003, -1.046957e-003, -5.773481e-004, -1.078402e-004, 3.594199e-004,  8.382999e-004,
   1.313792e-003,  1.788263e-003,  2.258657e-003,  2.716756e-003,  3.174055e-003,  3.641204e-003,  4.096444e-003,  4.524308e-003,  4.949731e-003,
   5.373405e-003,  5.795411e-003,  6.223141e-003,  6.644972e-003,  7.065756e-003,  7.464499e-003,  7.858962e-003,  8.237450e-003,  8.589952e-003,
   8.945863e-003,  9.300365e-003,  9.666188e-003,  1.004092e-002,  1.042301e-002,  1.080405e-002,  1.117096e-002,  1.153361e-002,  1.190375e-002,
   1.223310e-002,  1.256484e-002,  1.289871e-002,  1.323478e-002,  1.358060e-002,  1.394978e-002,  1.431581e-002,  1.467376e-002,  1.502842e-002,
   1.538847e-002,  1.571083e-002,  1.603173e-002,  1.634546e-002,  1.666260e-002,  1.699210e-002,  1.731944e-002,  1.763995e-002,  1.796294e-002,
   1.828430e-002,  1.861413e-002,  1.891148e-002,  1.918801e-002,  1.946620e-002,  1.974920e-002,  2.003498e-002,  2.032269e-002,  2.060757e-002,
   2.089902e-002,  2.118249e-002,  2.147054e-002,  2.173628e-002,  2.195179e-002,  2.217109e-002,  2.239403e-002,  2.262547e-002,  2.286194e-002,
   2.309923e-002,  2.334493e-002,  2.358237e-002,  2.381620e-002,  2.404114e-002,  2.418968e-002,  2.434190e-002,  2.449639e-002,  2.466359e-002,
   2.486284e-002,  2.507680e-002,  2.528531e-002,  2.549299e-002,  2.570084e-002,  2.591056e-002,  2.604882e-002,  2.618800e-002,  2.632532e-002,
   2.646491e-002,  2.661001e-002,  2.675594e-002,  2.688870e-002,  2.701337e-002,  2.714179e-002,  2.728166e-002,  2.736228e-002,  2.740784e-002,
   2.745358e-002,  2.750195e-002,  2.755637e-002,  2.761526e-002,  2.766599e-002,  2.769690e-002,  2.771925e-002,  2.774145e-002,  2.772148e-002,
   2.763421e-002,  2.754580e-002,  2.746702e-002,  2.739504e-002,  2.732600e-002,  2.725186e-002,  2.716142e-002,  2.704823e-002,  2.692614e-002,
   2.677919e-002,  2.652559e-002,  2.627190e-002,  2.602732e-002,  2.578227e-002,  2.553829e-002,  2.530127e-002,  2.508215e-002,  2.485323e-002,
   2.461848e-002,  2.439795e-002,  2.406492e-002,  2.372369e-002,  2.338799e-002,  2.305694e-002,  2.273056e-002,  2.240680e-002,  2.208303e-002,
   2.175864e-002,  2.141452e-002,  2.106455e-002,  2.061398e-002,  2.012728e-002,  1.964071e-002,  1.915317e-002,  1.865905e-002,  1.816798e-002,
   1.769839e-002,  1.722646e-002,  1.673997e-002,  1.620857e-002,  1.559720e-002,  1.489314e-002,  1.418567e-002,  1.347678e-002,  1.278654e-002,
   1.209855e-002,  1.142005e-002,  1.073145e-002,  1.004071e-002,  9.344574e-003,  8.571980e-003,  7.670828e-003,  6.788875e-003,  5.927109e-003,
   5.068001e-003,  4.212475e-003,  3.360459e-003,  2.513387e-003,  1.670471e-003,  8.330329e-004,  -3.150190e-017},
  {0.000000e+000,  2.616309e-001,  2.187042e-001,  1.748157e-001,  1.417391e-001,  1.150747e-001,  8.688658e-002,  6.075912e-002,  3.646030e-002,
   1.351882e-002,  -8.209922e-003, -2.886362e-002, -4.766997e-002, -6.452617e-002, -7.749161e-002, -8.697334e-002, -9.373771e-002, -9.940247e-002,
   -1.046593e-001, -1.083829e-001, -1.105832e-001, -1.117065e-001, -1.115141e-001, -1.105643e-001, -1.090158e-001, -1.067233e-001, -1.030868e-001,
   -9.781883e-002, -9.039628e-002, -8.085284e-002, -6.991689e-002, -5.785499e-002, -4.543213e-002, -3.286415e-002, -2.012794e-002, -7.606798e-003,
   4.347646e-003,  1.524646e-002,  2.574387e-002,  3.608154e-002,  4.608898e-002,  5.483372e-002,  6.345248e-002,  7.156473e-002,  7.881243e-002,
   8.527163e-002,  9.114060e-002,  9.636036e-002,  1.003114e-001,  1.040243e-001,  1.070431e-001,  1.086666e-001,  1.093005e-001,  1.084687e-001,
   1.065810e-001,  1.037056e-001,  1.000408e-001,  9.550326e-002,  9.029829e-002,  8.517134e-002,  7.922808e-002,  7.320034e-002,  6.681099e-002,
   5.971452e-002,  5.216704e-002,  4.456903e-002,  3.666625e-002,  2.850437e-002,  2.035880e-002,  1.231888e-002,  4.545512e-003,  -3.166212e-003,
   -1.053504e-002, -1.769757e-002, -2.434263e-002, -3.059878e-002, -3.629133e-002, -4.149259e-002, -4.613754e-002, -5.029473e-002, -5.400154e-002,
   -5.679247e-002, -5.925371e-002, -6.098967e-002, -6.227302e-002, -6.300515e-002, -6.324049e-002, -6.323603e-002, -6.252300e-002, -6.155722e-002,
   -6.043528e-002, -5.889734e-002, -5.721450e-002, -5.529738e-002, -5.307543e-002, -5.065763e-002, -4.849789e-002, -4.620116e-002, -4.371069e-002,
   -4.139970e-002, -3.915118e-002, -3.688204e-002, -3.472676e-002, -3.240213e-002, -3.007064e-002, -2.801528e-002, -2.602072e-002, -2.412263e-002,
   -2.228238e-002, -2.071468e-002, -1.904888e-002, -1.755147e-002, -1.614635e-002, -1.473501e-002, -1.328342e-002, -1.202087e-002, -1.066777e-002,
   -9.281785e-003, -7.742223e-003, -5.960808e-003, -4.257935e-003, -2.422493e-003, -3.195274e-004, 1.796373e-003,  3.828922e-003,  5.601601e-003,
   7.425616e-003,  9.215458e-003,  1.106508e-002,  1.283224e-002,  1.448997e-002,  1.617500e-002,  1.783639e-002,  1.944480e-002,  2.086413e-002,
   2.222284e-002,  2.349670e-002,  2.486960e-002,  2.604883e-002,  2.717056e-002,  2.830369e-002,  2.933500e-002,  3.015436e-002,  3.085847e-002,
   3.161770e-002,  3.220586e-002,  3.279920e-002,  3.342561e-002,  3.381156e-002,  3.412947e-002,  3.437861e-002,  3.457182e-002,  3.473040e-002,
   3.475502e-002,  3.469529e-002,  3.466792e-002,  3.451209e-002,  3.423636e-002,  3.394094e-002,  3.356073e-002,  3.308630e-002,  3.266903e-002,
   3.204367e-002,  3.120684e-002,  3.039136e-002,  2.953746e-002,  2.864049e-002,  2.758818e-002,  2.647184e-002,  2.538506e-002,  2.434684e-002,
   2.332702e-002,  2.209125e-002,  2.085895e-002,  1.967308e-002,  1.858240e-002,  1.731540e-002,  1.599940e-002,  1.474620e-002,  1.357118e-002,
   1.207677e-002,  1.065390e-002,  9.352745e-003,  7.894652e-003,  6.400186e-003,  4.870625e-003,  3.202870e-003,  1.529805e-003,  3.449278e-006,
   -1.866329e-003, -3.732043e-003, -5.676562e-003, -7.703822e-003, -9.642500e-003, -1.182382e-002, -1.392094e-002, -1.620490e-002, -1.833710e-002,
   -2.043938e-002, -2.239789e-002, -2.430849e-002, -2.611203e-002, -2.794738e-002, -2.976166e-002, -3.143381e-002, -3.301074e-002, -3.445158e-002,
   -3.590805e-002, -3.713095e-002, -3.831127e-002, -3.922851e-002, -4.008871e-002, -4.073530e-002, -4.131773e-002, -4.168150e-002, -4.192563e-002,
   -4.203134e-002, -4.201026e-002, -4.200734e-002, -4.172996e-002, -4.140786e-002, -4.095624e-002, -4.035322e-002, -3.973137e-002, -3.894405e-002,
   -3.810126e-002, -3.720283e-002, -3.614239e-002, -3.504046e-002, -3.396816e-002, -3.271543e-002, -3.142777e-002, -3.012944e-002, -2.872402e-002,
   -2.730413e-002, -2.590909e-002, -2.447171e-002, -2.291314e-002, -2.133224e-002, -1.975593e-002, -1.819254e-002, -1.656962e-002, -1.503513e-002,
   -1.345689e-002, -1.174644e-002, -1.005234e-002, -8.510246e-003, -6.953671e-003, -5.323991e-003, -3.747955e-003, -2.126349e-003, -4.840920e-004,
   1.115175e-003,  2.650654e-003,  4.186460e-003,  5.705632e-003,  7.272811e-003,  8.887157e-003,  1.040112e-002,  1.180232e-002,  1.329916e-002,
   1.484239e-002,  1.635634e-002,  1.782388e-002,  1.928053e-002,  2.064900e-002,  2.197776e-002,  2.329312e-002,  2.455140e-002,  2.580663e-002,
   2.695870e-002,  2.789678e-002,  2.865565e-002,  2.929528e-002,  2.991832e-002,  3.044219e-002,  3.087617e-002,  3.118649e-002,  3.134317e-002,
   3.137674e-002,  3.132466e-002,  3.118910e-002,  3.101798e-002,  3.079929e-002,  3.053619e-002,  3.018039e-002,  2.966197e-002,  2.905223e-002,
   2.836924e-002,  2.769439e-002,  2.701125e-002,  2.629913e-002,  2.558599e-002,  2.471208e-002,  2.374464e-002,  2.282130e-002,  2.183831e-002,
   2.084821e-002,  1.984954e-002,  1.884930e-002,  1.792678e-002,  1.688622e-002,  1.582119e-002,  1.470698e-002,  1.365960e-002,  1.254829e-002,
   1.146662e-002,  1.043918e-002,  9.432422e-003,  8.408720e-003,  7.361661e-003,  6.296192e-003,  5.237162e-003,  4.297232e-003,  3.340338e-003,
   2.401789e-003,  1.485533e-003,  6.973520e-004,  -9.765721e-005, -7.986929e-004, -1.457459e-003, -2.051026e-003, -2.508999e-003, -2.823115e-003,
   -3.085576e-003, -3.301244e-003, -3.532309e-003, -3.759468e-003, -3.939279e-003, -4.105624e-003, -4.257060e-003, -4.402302e-003, -4.524387e-003,
   -4.614262e-003, -4.709395e-003, -4.766498e-003, -4.789093e-003, -4.838223e-003, -4.927303e-003, -5.075132e-003, -5.237850e-003, -5.343672e-003,
   -5.369815e-003, -5.385244e-003, -5.385448e-003, -5.421267e-003, -5.451886e-003, -5.448310e-003, -5.548790e-003, -5.637334e-003, -5.718407e-003,
   -5.754008e-003, -5.770676e-003, -5.760104e-003, -5.781192e-003, -5.772122e-003, -5.747847e-003, -5.744699e-003, -5.664803e-003, -5.564198e-003,
   -5.508380e-003, -5.504042e-003, -5.430905e-003, -5.305196e-003, -5.246689e-003, -5.252686e-003, -5.248574e-003, -5.177898e-003, -5.032330e-003,
   -4.853154e-003, -4.721768e-003, -4.628169e-003, -4.584288e-003, -4.565798e-003, -4.615826e-003, -4.702669e-003, -4.776684e-003, -4.843721e-003,
   -4.803575e-003, -4.784674e-003, -4.752776e-003, -4.745525e-003, -4.743236e-003, -4.811438e-003, -4.950630e-003, -5.125605e-003, -5.270802e-003,
   -5.411600e-003, -5.591552e-003, -5.763395e-003, -5.915234e-003, -6.008405e-003, -6.098120e-003, -6.184349e-003, -6.332087e-003, -6.521344e-003,
   -6.718278e-003, -6.965978e-003, -7.265330e-003, -7.524359e-003, -7.761833e-003, -7.987428e-003, -8.184914e-003, -8.384649e-003, -8.693130e-003,
   -9.019203e-003, -9.372612e-003, -9.725989e-003, -1.009062e-002, -1.043568e-002, -1.076088e-002, -1.102721e-002, -1.128950e-002, -1.158322e-002,
   -1.188324e-002, -1.213739e-002, -1.237289e-002, -1.259527e-002, -1.282652e-002, -1.311049e-002, -1.338502e-002, -1.361028e-002, -1.380472e-002,
   -1.397776e-002, -1.408034e-002, -1.412290e-002, -1.413199e-002, -1.408977e-002, -1.400033e-002, -1.391448e-002, -1.383656e-002, -1.370991e-002,
   -1.354660e-002, -1.330013e-002, -1.299053e-002, -1.265488e-002, -1.235031e-002, -1.202417e-002, -1.166323e-002, -1.129266e-002, -1.087387e-002,
   -1.039377e-002, -9.934663e-003, -9.424126e-003, -8.834887e-003, -8.230009e-003, -7.702270e-003, -7.204794e-003, -6.682111e-003, -6.144585e-003,
   -5.587094e-003, -5.002825e-003, -4.375693e-003, -3.722229e-003, -3.089703e-003, -2.465468e-003, -1.800777e-003, -1.116030e-003, -4.498091e-004,
   2.248057e-004,  9.706666e-004,  1.733746e-003,  2.505235e-003,  3.348760e-003,  4.171017e-003,  4.942018e-003,  5.728039e-003,  6.524442e-003,
   7.318125e-003,  8.073822e-003,  8.783564e-003,  9.509737e-003,  1.026816e-002,  1.098915e-002,  1.173011e-002,  1.247034e-002,  1.322201e-002,
   1.401679e-002,  1.480660e-002,  1.558687e-002,  1.634232e-002,  1.709538e-002,  1.781741e-002,  1.846771e-002,  1.902315e-002,  1.955720e-002,
   2.007976e-002,  2.060608e-002,  2.113101e-002,  2.166041e-002,  2.218780e-002,  2.270317e-002,  2.316922e-002,  2.362090e-002,  2.403324e-002,
   2.447493e-002,  2.488595e-002,  2.530160e-002,  2.572022e-002,  2.605959e-002,  2.633706e-002,  2.658410e-002,  2.679599e-002,  2.698466e-002,
   2.715546e-002,  2.726182e-002,  2.731446e-002,  2.730675e-002,  2.731138e-002,  2.728518e-002,  2.726644e-002,  2.723452e-002,  2.717142e-002,
   2.706998e-002,  2.695426e-002,  2.684809e-002,  2.668433e-002,  2.647758e-002,  2.625914e-002,  2.602748e-002,  2.578017e-002,  2.552078e-002,
   2.526091e-002,  2.502719e-002,  2.479559e-002,  2.456060e-002,  2.428876e-002,  2.403608e-002,  2.376839e-002,  2.350502e-002,  2.320176e-002,
   2.289762e-002,  2.259429e-002,  2.229809e-002,  2.198899e-002,  2.168862e-002,  2.138450e-002,  2.108281e-002,  2.078204e-002,  2.046311e-002,
   2.010149e-002,  1.971926e-002,  1.933504e-002,  1.894218e-002,  1.851907e-002,  1.805759e-002,  1.757056e-002,  1.705722e-002,  1.650379e-002,
   1.592092e-002,  1.531940e-002,  1.471146e-002,  1.408378e-002,  1.343434e-002,  1.271643e-002,  1.194604e-002,  1.115917e-002,  1.039148e-002,
   9.613897e-003,  8.793899e-003,  7.978010e-003,  7.123317e-003,  6.245877e-003,  5.370102e-003,  4.476524e-003,  3.576845e-003,  2.676305e-003,
   1.758402e-003,  8.446902e-004,  -7.110065e-005, -9.733178e-004, -1.869164e-003, -2.762325e-003, -3.658872e-003, -4.569332e-003, -5.511076e-003,
   -6.478237e-003, -7.459028e-003, -8.443705e-003, -9.467735e-003, -1.049145e-002, -1.153028e-002, -1.258350e-002, -1.364316e-002, -1.469400e-002,
   -1.571618e-002, -1.671194e-002, -1.770642e-002, -1.864553e-002, -1.957009e-002, -2.048951e-002, -2.141449e-002, -2.232687e-002, -2.323075e-002,
   -2.407870e-002, -2.492980e-002, -2.579019e-002, -2.664221e-002, -2.742733e-002, -2.814326e-002, -2.885675e-002, -2.955288e-002, -3.022473e-002,
   -3.083768e-002, -3.140972e-002, -3.195704e-002, -3.249520e-002, -3.304792e-002, -3.357974e-002, -3.409454e-002, -3.455706e-002, -3.494506e-002,
   -3.532302e-002, -3.568962e-002, -3.604982e-002, -3.643438e-002, -3.682183e-002, -3.719656e-002, -3.755569e-002, -3.785514e-002, -3.814662e-002,
   -3.845371e-002, -3.875486e-002, -3.902183e-002, -3.926361e-002, -3.948225e-002, -3.958732e-002, -3.967712e-002, -3.973963e-002, -3.975492e-002,
   -3.971670e-002, -3.965357e-002, -3.953955e-002, -3.939289e-002, -3.920699e-002, -3.899348e-002, -3.875126e-002, -3.850175e-002, -3.820469e-002,
   -3.785769e-002, -3.749264e-002, -3.710484e-002, -3.669338e-002, -3.621590e-002, -3.569464e-002, -3.508582e-002, -3.439865e-002, -3.368438e-002,
   -3.295247e-002, -3.221960e-002, -3.151954e-002, -3.079015e-002, -3.003636e-002, -2.925127e-002, -2.845931e-002, -2.767171e-002, -2.687716e-002,
   -2.608908e-002, -2.531272e-002, -2.452898e-002, -2.376143e-002, -2.298945e-002, -2.221931e-002, -2.149787e-002, -2.078149e-002, -2.002688e-002,
   -1.924975e-002, -1.846294e-002, -1.766731e-002, -1.688026e-002, -1.609423e-002, -1.532322e-002, -1.454264e-002, -1.379617e-002, -1.300885e-002,
   -1.222838e-002, -1.145498e-002, -1.067497e-002, -9.891558e-003, -9.175706e-003, -8.465063e-003, -7.750555e-003, -7.045032e-003, -6.335894e-003,
   -5.622342e-003, -4.913743e-003, -4.320842e-003, -3.798131e-003, -3.269022e-003, -2.734525e-003, -2.208693e-003, -1.682748e-003, -1.143876e-003,
   -6.081016e-004, -6.630030e-005, 4.881984e-004,  1.053882e-003,  1.605480e-003,  2.076789e-003,  2.544047e-003,  3.025428e-003,  3.513402e-003,
   3.978367e-003,  4.386814e-003,  4.716371e-003,  5.014728e-003,  5.334329e-003,  5.662562e-003,  6.058405e-003,  6.446699e-003,  6.840161e-003,
   7.241860e-003,  7.674519e-003,  8.123500e-003,  8.575565e-003,  9.019672e-003,  9.450103e-003,  9.876752e-003,  1.030647e-002,  1.072961e-002,
   1.114144e-002,  1.154630e-002,  1.184170e-002,  1.207532e-002,  1.233833e-002,  1.261466e-002,  1.287894e-002,  1.308786e-002,  1.327828e-002,
   1.348041e-002,  1.369956e-002,  1.392951e-002,  1.416685e-002,  1.440413e-002,  1.462540e-002,  1.484389e-002,  1.508447e-002,  1.532451e-002,
   1.558096e-002,  1.586768e-002,  1.615642e-002,  1.643420e-002,  1.669900e-002,  1.694894e-002,  1.719108e-002,  1.743280e-002,  1.765179e-002,
   1.781542e-002,  1.796699e-002,  1.811802e-002,  1.826513e-002,  1.841026e-002,  1.854011e-002,  1.864458e-002,  1.871480e-002,  1.879340e-002,
   1.889738e-002,  1.901934e-002,  1.908576e-002,  1.916819e-002,  1.927523e-002,  1.940246e-002,  1.953514e-002,  1.967653e-002,  1.981623e-002,
   1.992489e-002,  2.004373e-002,  2.018901e-002,  2.033955e-002,  2.048860e-002,  2.066218e-002,  2.083185e-002,  2.101261e-002,  2.120715e-002,
   2.140490e-002,  2.160185e-002,  2.179537e-002,  2.195982e-002,  2.207417e-002,  2.217943e-002,  2.227547e-002,  2.234468e-002,  2.240482e-002,
   2.244652e-002,  2.246348e-002,  2.246817e-002,  2.247667e-002,  2.247706e-002,  2.246136e-002,  2.243421e-002,  2.238140e-002,  2.228066e-002,
   2.217668e-002,  2.207545e-002,  2.196340e-002,  2.182217e-002,  2.167603e-002,  2.155638e-002,  2.143114e-002,  2.127399e-002,  2.111776e-002,
   2.097319e-002,  2.083404e-002,  2.069418e-002,  2.056094e-002,  2.042159e-002,  2.030101e-002,  2.019684e-002,  2.009938e-002,  2.000351e-002,
   1.990383e-002,  1.979381e-002,  1.968590e-002,  1.957534e-002,  1.944928e-002,  1.931353e-002,  1.916016e-002,  1.895429e-002,  1.870555e-002,
   1.844438e-002,  1.818109e-002,  1.789508e-002,  1.761845e-002,  1.732106e-002,  1.700858e-002,  1.669065e-002,  1.636746e-002,  1.604298e-002,
   1.572119e-002,  1.540721e-002,  1.509434e-002,  1.477797e-002,  1.445579e-002,  1.413619e-002,  1.380992e-002,  1.347754e-002,  1.316513e-002,
   1.287765e-002,  1.259116e-002,  1.230700e-002,  1.205244e-002,  1.179915e-002,  1.153887e-002,  1.127258e-002,  1.099731e-002,  1.072762e-002,
   1.045186e-002,  1.017873e-002,  9.911024e-003,  9.643432e-003,  9.385897e-003,  9.097465e-003,  8.796735e-003,  8.491115e-003,  8.169308e-003,
   7.835788e-003,  7.498905e-003,  7.156931e-003,  6.798763e-003,  6.448502e-003,  6.112574e-003,  5.807285e-003,  5.512039e-003,  5.244423e-003,
   4.983049e-003,  4.727585e-003,  4.475615e-003,  4.223985e-003,  3.986483e-003,  3.722121e-003,  3.478817e-003,  3.264948e-003,  3.058838e-003,
   2.844829e-003,  2.621190e-003,  2.401502e-003,  2.173198e-003,  1.935061e-003,  1.684484e-003,  1.443250e-003,  1.192445e-003,  9.358708e-004,
   6.640067e-004,  3.911635e-004,  8.753651e-005,  -2.324088e-004, -5.587866e-004, -8.957589e-004, -1.240984e-003, -1.605898e-003, -1.969859e-003,
   -2.313585e-003, -2.669489e-003, -3.036341e-003, -3.412040e-003, -3.791887e-003, -4.186591e-003, -4.576267e-003, -4.961596e-003, -5.339523e-003,
   -5.699528e-003, -6.032103e-003, -6.384200e-003, -6.746542e-003, -7.111394e-003, -7.470422e-003, -7.830704e-003, -8.179860e-003, -8.525526e-003,
   -8.843227e-003, -9.150797e-003, -9.440520e-003, -9.699417e-003, -9.955033e-003, -1.021250e-002, -1.047285e-002, -1.073737e-002, -1.102376e-002,
   -1.132571e-002, -1.162909e-002, -1.192733e-002, -1.221872e-002, -1.248308e-002, -1.275180e-002, -1.302408e-002, -1.330674e-002, -1.361168e-002,
   -1.393081e-002, -1.425966e-002, -1.456352e-002, -1.486341e-002, -1.515424e-002, -1.538027e-002, -1.560887e-002, -1.584675e-002, -1.607153e-002,
   -1.631649e-002, -1.656848e-002, -1.680136e-002, -1.702400e-002, -1.724729e-002, -1.747449e-002, -1.765796e-002, -1.782648e-002, -1.798849e-002,
   -1.814933e-002, -1.832042e-002, -1.850273e-002, -1.868757e-002, -1.887861e-002, -1.907686e-002, -1.926864e-002, -1.942867e-002, -1.957442e-002,
   -1.973200e-002, -1.990341e-002, -2.009741e-002, -2.030249e-002, -2.051201e-002, -2.071748e-002, -2.091934e-002, -2.112629e-002, -2.131107e-002,
   -2.145359e-002, -2.159981e-002, -2.173789e-002, -2.187444e-002, -2.200218e-002, -2.213378e-002, -2.227790e-002, -2.239264e-002, -2.250166e-002,
   -2.260443e-002, -2.263148e-002, -2.266883e-002, -2.268151e-002, -2.268970e-002, -2.269930e-002, -2.271236e-002, -2.271743e-002, -2.268455e-002,
   -2.264106e-002, -2.259842e-002, -2.243410e-002, -2.224910e-002, -2.207414e-002, -2.191017e-002, -2.175289e-002, -2.159886e-002, -2.144884e-002,
   -2.129710e-002, -2.110407e-002, -2.090125e-002, -2.062630e-002, -2.029199e-002, -1.995701e-002, -1.960875e-002, -1.921918e-002, -1.883493e-002,
   -1.842686e-002, -1.801856e-002, -1.760148e-002, -1.713699e-002, -1.660590e-002, -1.599780e-002, -1.537926e-002, -1.475072e-002, -1.408667e-002,
   -1.340152e-002, -1.269229e-002, -1.193805e-002, -1.116873e-002, -1.040116e-002, -9.555318e-003, -8.611026e-003, -7.648784e-003, -6.666498e-003,
   -5.689759e-003, -4.719994e-003, -3.757357e-003, -2.804373e-003, -1.859909e-003, -9.256437e-004, -2.013541e-017},
  {0.000000e+000,  1.507455e-001,  1.207007e-001,  9.171221e-002,  6.179052e-002,  3.365747e-002,  1.332257e-002,  -2.375174e-003, -1.649751e-002,
   -2.877970e-002, -3.811668e-002, -4.527494e-002, -5.011530e-002, -5.315954e-002, -5.572485e-002, -5.786769e-002, -5.867673e-002, -5.705429e-002,
   -5.326458e-002, -4.860399e-002, -4.401021e-002, -3.995093e-002, -3.576162e-002, -3.153032e-002, -2.650787e-002, -2.115455e-002, -1.580126e-002,
   -1.088052e-002, -6.794520e-003, -3.031228e-003, 7.699568e-004,  4.962568e-003,  8.936494e-003,  1.270241e-002,  1.686004e-002,  2.118074e-002,
   2.557811e-002,  2.970777e-002,  3.409884e-002,  3.867944e-002,  4.342115e-002,  4.733632e-002,  5.110933e-002,  5.475782e-002,  5.758125e-002,
   5.941473e-002,  6.072315e-002,  6.154284e-002,  6.129292e-002,  6.065663e-002,  5.912191e-002,  5.703610e-002,  5.489733e-002,  5.218830e-002,
   4.934198e-002,  4.593269e-002,  4.193563e-002,  3.756416e-002,  3.264069e-002,  2.791803e-002,  2.265526e-002,  1.703786e-002,  1.112656e-002,
   5.029451e-003,  -8.870066e-004, -6.429659e-003, -1.209488e-002, -1.795477e-002, -2.389911e-002, -2.949066e-002, -3.445773e-002, -3.937190e-002,
   -4.413430e-002, -4.874777e-002, -5.267152e-002, -5.633061e-002, -5.965567e-002, -6.268070e-002, -6.514167e-002, -6.739588e-002, -6.926296e-002,
   -7.003671e-002, -7.108702e-002, -7.180639e-002, -7.177871e-002, -7.139445e-002, -7.100258e-002, -7.006411e-002, -6.861398e-002, -6.684054e-002,
   -6.465894e-002, -6.219882e-002, -5.890686e-002, -5.571682e-002, -5.216535e-002, -4.807539e-002, -4.392300e-002, -3.944633e-002, -3.483985e-002,
   -3.003443e-002, -2.491446e-002, -1.948053e-002, -1.414013e-002, -8.453057e-003, -2.650175e-003, 2.943184e-003,  8.558212e-003,  1.401360e-002,
   1.961674e-002,  2.476884e-002,  2.968361e-002,  3.432279e-002,  3.893293e-002,  4.288325e-002,  4.688597e-002,  5.040807e-002,  5.363671e-002,
   5.646457e-002,  5.877778e-002,  6.074455e-002,  6.207494e-002,  6.318869e-002,  6.393809e-002,  6.410510e-002,  6.427001e-002,  6.421797e-002,
   6.396191e-002,  6.349514e-002,  6.263445e-002,  6.143830e-002,  6.012655e-002,  5.865263e-002,  5.692138e-002,  5.520538e-002,  5.372955e-002,
   5.203802e-002,  5.041504e-002,  4.895197e-002,  4.693858e-002,  4.490112e-002,  4.297358e-002,  4.090379e-002,  3.889292e-002,  3.695421e-002,
   3.483684e-002,  3.238920e-002,  2.995791e-002,  2.748953e-002,  2.486904e-002,  2.199338e-002,  1.923505e-002,  1.644573e-002,  1.343826e-002,
   1.006541e-002,  6.671872e-003,  3.071788e-003,  -1.568400e-004, -3.428808e-003, -6.719075e-003, -1.009985e-002, -1.350290e-002, -1.699157e-002,
   -2.015547e-002, -2.321278e-002, -2.628419e-002, -2.925985e-002, -3.237629e-002, -3.517825e-002, -3.779963e-002, -4.038895e-002, -4.299644e-002,
   -4.581103e-002, -4.802005e-002, -5.008550e-002, -5.221627e-002, -5.448365e-002, -5.639040e-002, -5.801093e-002, -5.961495e-002, -6.118521e-002,
   -6.217152e-002, -6.314675e-002, -6.408047e-002, -6.443810e-002, -6.448580e-002, -6.461142e-002, -6.419266e-002, -6.336891e-002, -6.252112e-002,
   -6.082518e-002, -5.911583e-002, -5.709120e-002, -5.450672e-002, -5.171306e-002, -4.822821e-002, -4.474604e-002, -4.082495e-002, -3.690032e-002,
   -3.247575e-002, -2.803771e-002, -2.339857e-002, -1.884295e-002, -1.422596e-002, -9.614114e-003, -5.041266e-003, -4.446784e-004, 3.949733e-003,
   8.251256e-003,  1.222173e-002,  1.612896e-002,  1.961673e-002,  2.321542e-002,  2.630637e-002,  2.935242e-002,  3.198098e-002,  3.446069e-002,
   3.681257e-002,  3.883299e-002,  4.089755e-002,  4.232988e-002,  4.373358e-002,  4.497128e-002,  4.589218e-002,  4.695297e-002,  4.769053e-002,
   4.810847e-002,  4.864462e-002,  4.883958e-002,  4.899831e-002,  4.918537e-002,  4.913879e-002,  4.890685e-002,  4.866293e-002,  4.829285e-002,
   4.774044e-002,  4.718648e-002,  4.667514e-002,  4.581629e-002,  4.492544e-002,  4.411025e-002,  4.306915e-002,  4.196890e-002,  4.090352e-002,
   3.991363e-002,  3.866343e-002,  3.735754e-002,  3.601406e-002,  3.474194e-002,  3.316444e-002,  3.158613e-002,  3.010587e-002,  2.853235e-002,
   2.672790e-002,  2.493368e-002,  2.317910e-002,  2.145095e-002,  1.956620e-002,  1.767439e-002,  1.581577e-002,  1.394612e-002,  1.201088e-002,
   1.008587e-002,  8.221889e-003,  6.389277e-003,  4.629087e-003,  2.666268e-003,  7.295213e-004,  -1.079513e-003, -2.819868e-003, -4.586865e-003,
   -6.284481e-003, -7.956978e-003, -9.595485e-003, -1.106582e-002, -1.253188e-002, -1.394419e-002, -1.520342e-002, -1.642875e-002, -1.756485e-002,
   -1.876650e-002, -1.982803e-002, -2.077306e-002, -2.160304e-002, -2.234521e-002, -2.313108e-002, -2.382931e-002, -2.448592e-002, -2.504228e-002,
   -2.553018e-002, -2.606546e-002, -2.660545e-002, -2.706670e-002, -2.741439e-002, -2.767432e-002, -2.801954e-002, -2.831347e-002, -2.861195e-002,
   -2.887123e-002, -2.905667e-002, -2.911488e-002, -2.920747e-002, -2.926428e-002, -2.934518e-002, -2.945847e-002, -2.944722e-002, -2.939849e-002,
   -2.937279e-002, -2.928941e-002, -2.914309e-002, -2.899382e-002, -2.901849e-002, -2.898158e-002, -2.890917e-002, -2.873517e-002, -2.853805e-002,
   -2.831494e-002, -2.809450e-002, -2.802744e-002, -2.796440e-002, -2.783785e-002, -2.766449e-002, -2.748631e-002, -2.720883e-002, -2.697823e-002,
   -2.691683e-002, -2.689137e-002, -2.686864e-002, -2.682734e-002, -2.667790e-002, -2.654989e-002, -2.640144e-002, -2.616097e-002, -2.600905e-002,
   -2.580411e-002, -2.551551e-002, -2.526653e-002, -2.508277e-002, -2.477066e-002, -2.440104e-002, -2.401076e-002, -2.361477e-002, -2.314140e-002,
   -2.265344e-002, -2.208807e-002, -2.146436e-002, -2.084392e-002, -2.004937e-002, -1.918571e-002, -1.835898e-002, -1.768489e-002, -1.696431e-002,
   -1.613480e-002, -1.519525e-002, -1.418729e-002, -1.319371e-002, -1.223807e-002, -1.129099e-002, -1.027270e-002, -9.288805e-003, -8.308808e-003,
   -7.309813e-003, -6.267727e-003, -5.206320e-003, -4.083539e-003, -3.084312e-003, -2.086245e-003, -1.050033e-003, 4.998547e-005,  1.066313e-003,
   2.021410e-003,  3.017337e-003,  4.026281e-003,  5.044716e-003,  6.124675e-003,  7.125214e-003,  8.115053e-003,  9.037940e-003,  1.002129e-002,
   1.095755e-002,  1.192147e-002,  1.291961e-002,  1.395327e-002,  1.501197e-002,  1.597175e-002,  1.683475e-002,  1.765669e-002,  1.855457e-002,
   1.946130e-002,  2.038072e-002,  2.122765e-002,  2.213247e-002,  2.296523e-002,  2.381279e-002,  2.462380e-002,  2.540353e-002,  2.615253e-002,
   2.682719e-002,  2.750333e-002,  2.822515e-002,  2.887570e-002,  2.940916e-002,  2.993575e-002,  3.051099e-002,  3.111243e-002,  3.161910e-002,
   3.209820e-002,  3.253353e-002,  3.279163e-002,  3.307110e-002,  3.333781e-002,  3.358343e-002,  3.384312e-002,  3.408320e-002,  3.431763e-002,
   3.453719e-002,  3.471092e-002,  3.476957e-002,  3.482974e-002,  3.488886e-002,  3.487440e-002,  3.482113e-002,  3.477919e-002,  3.474281e-002,
   3.470721e-002,  3.455085e-002,  3.435650e-002,  3.414889e-002,  3.386373e-002,  3.353237e-002,  3.318449e-002,  3.281683e-002,  3.238839e-002,
   3.186102e-002,  3.127100e-002,  3.061074e-002,  2.993174e-002,  2.919960e-002,  2.844869e-002,  2.771817e-002,  2.695492e-002,  2.618520e-002,
   2.542574e-002,  2.466143e-002,  2.379740e-002,  2.295379e-002,  2.204366e-002,  2.113896e-002,  2.022909e-002,  1.933885e-002,  1.845589e-002,
   1.759167e-002,  1.672857e-002,  1.583019e-002,  1.481065e-002,  1.376404e-002,  1.279384e-002,  1.186478e-002,  1.094294e-002,  1.001004e-002,
   9.012174e-003,  8.082517e-003,  7.169932e-003,  6.256297e-003,  5.244143e-003,  4.210156e-003,  3.173984e-003,  2.151424e-003,  1.129065e-003,
   7.185728e-005,  -9.537177e-004, -1.978641e-003, -2.996118e-003, -3.948044e-003, -4.944983e-003, -6.060654e-003, -7.173239e-003, -8.263116e-003,
   -9.291362e-003, -1.028351e-002, -1.125762e-002, -1.220515e-002, -1.312572e-002, -1.404869e-002, -1.498295e-002, -1.589178e-002, -1.687253e-002,
   -1.787364e-002, -1.883711e-002, -1.978343e-002, -2.068520e-002, -2.153163e-002, -2.236686e-002, -2.320237e-002, -2.401354e-002, -2.479700e-002,
   -2.548873e-002, -2.615126e-002, -2.685416e-002, -2.757484e-002, -2.829151e-002, -2.896108e-002, -2.956827e-002, -3.011979e-002, -3.064041e-002,
   -3.115683e-002, -3.168951e-002, -3.216816e-002, -3.260952e-002, -3.298530e-002, -3.333476e-002, -3.373130e-002, -3.407092e-002, -3.435486e-002,
   -3.461992e-002, -3.475103e-002, -3.483662e-002, -3.491736e-002, -3.496680e-002, -3.497289e-002, -3.496535e-002, -3.493678e-002, -3.491557e-002,
   -3.492174e-002, -3.493524e-002, -3.496301e-002, -3.497345e-002, -3.487417e-002, -3.473014e-002, -3.451913e-002, -3.426984e-002, -3.402763e-002,
   -3.377191e-002, -3.348873e-002, -3.317374e-002, -3.282796e-002, -3.245477e-002, -3.208893e-002, -3.170444e-002, -3.129554e-002, -3.091144e-002,
   -3.055035e-002, -3.014052e-002, -2.970653e-002, -2.924689e-002, -2.877350e-002, -2.827706e-002, -2.772609e-002, -2.714500e-002, -2.645422e-002,
   -2.567297e-002, -2.487842e-002, -2.406899e-002, -2.328278e-002, -2.252632e-002, -2.179114e-002, -2.107730e-002, -2.035702e-002, -1.959177e-002,
   -1.879094e-002, -1.792391e-002, -1.702358e-002, -1.612899e-002, -1.524853e-002, -1.435823e-002, -1.344119e-002, -1.249419e-002, -1.152394e-002,
   -1.054476e-002, -9.584596e-003, -8.620266e-003, -7.604014e-003, -6.535475e-003, -5.434275e-003, -4.338105e-003, -3.207219e-003, -2.091769e-003,
   -9.785595e-004, 1.698964e-004,  1.262579e-003,  2.340592e-003,  3.446993e-003,  4.561649e-003,  5.696582e-003,  6.855829e-003,  8.053227e-003,
   9.199333e-003,  1.032752e-002,  1.140867e-002,  1.234371e-002,  1.330707e-002,  1.428309e-002,  1.526401e-002,  1.625672e-002,  1.723995e-002,
   1.825994e-002,  1.929007e-002,  2.033209e-002,  2.140126e-002,  2.221302e-002,  2.293528e-002,  2.359944e-002,  2.426900e-002,  2.493809e-002,
   2.555341e-002,  2.617221e-002,  2.682864e-002,  2.750845e-002,  2.817458e-002,  2.884649e-002,  2.954125e-002,  3.009369e-002,  3.042899e-002,
   3.079001e-002,  3.116041e-002,  3.155298e-002,  3.195887e-002,  3.237526e-002,  3.281738e-002,  3.328424e-002,  3.380567e-002,  3.435142e-002,
   3.490482e-002,  3.530946e-002,  3.568174e-002,  3.608347e-002,  3.641704e-002,  3.647525e-002,  3.654460e-002,  3.662770e-002,  3.670958e-002,
   3.682143e-002,  3.695622e-002,  3.711807e-002,  3.727668e-002,  3.743557e-002,  3.758555e-002,  3.771415e-002,  3.785510e-002,  3.801110e-002,
   3.816554e-002,  3.827483e-002,  3.837108e-002,  3.843883e-002,  3.841973e-002,  3.841019e-002,  3.830109e-002,  3.801662e-002,  3.771771e-002,
   3.738390e-002,  3.702411e-002,  3.661568e-002,  3.618336e-002,  3.575402e-002,  3.532903e-002,  3.489354e-002,  3.446403e-002,  3.404808e-002,
   3.361245e-002,  3.317832e-002,  3.275886e-002,  3.234730e-002,  3.196426e-002,  3.157168e-002,  3.114090e-002,  3.064398e-002,  3.008919e-002,
   2.957976e-002,  2.907225e-002,  2.856804e-002,  2.805755e-002,  2.752631e-002,  2.694661e-002,  2.612992e-002,  2.530734e-002,  2.452570e-002,
   2.372374e-002,  2.292920e-002,  2.213835e-002,  2.135455e-002,  2.052935e-002,  1.970821e-002,  1.890817e-002,  1.813941e-002,  1.741154e-002,
   1.669089e-002,  1.597296e-002,  1.528024e-002,  1.456072e-002,  1.383897e-002,  1.317138e-002,  1.255615e-002,  1.196954e-002,  1.140584e-002,
   1.083495e-002,  1.026730e-002,  9.715342e-003,  9.196408e-003,  8.719287e-003,  8.180861e-003,  7.649272e-003,  7.120772e-003,  6.596352e-003,
   6.082540e-003,  5.603839e-003,  5.140709e-003,  4.708265e-003,  4.294533e-003,  3.880151e-003,  3.321137e-003,  2.743674e-003,  2.157028e-003,
   1.568430e-003,  9.792462e-004,  3.859348e-004,  -2.069354e-004, -8.029176e-004, -1.412156e-003, -1.998078e-003, -2.569707e-003, -3.126044e-003,
   -3.671261e-003, -4.197133e-003, -4.703609e-003, -5.169262e-003, -5.612812e-003, -6.041460e-003, -6.525097e-003, -7.024805e-003, -7.508268e-003,
   -7.966510e-003, -8.410419e-003, -8.841791e-003, -9.272304e-003, -9.702981e-003, -1.012522e-002, -1.054875e-002, -1.096610e-002, -1.136526e-002,
   -1.176295e-002, -1.218526e-002, -1.261010e-002, -1.304709e-002, -1.343999e-002, -1.380190e-002, -1.415720e-002, -1.450148e-002, -1.481715e-002,
   -1.511271e-002, -1.539437e-002, -1.567916e-002, -1.594710e-002, -1.621766e-002, -1.649069e-002, -1.677384e-002, -1.706291e-002, -1.735078e-002,
   -1.778201e-002, -1.827519e-002, -1.877452e-002, -1.926988e-002, -1.975993e-002, -2.023905e-002, -2.070333e-002, -2.115199e-002, -2.159680e-002,
   -2.201455e-002, -2.245062e-002, -2.293145e-002, -2.341226e-002, -2.390530e-002, -2.439455e-002, -2.489573e-002, -2.538210e-002, -2.585069e-002,
   -2.631210e-002, -2.676656e-002, -2.721564e-002, -2.764699e-002, -2.804987e-002, -2.843253e-002, -2.879446e-002, -2.914842e-002, -2.948872e-002,
   -2.981655e-002, -3.011373e-002, -3.039260e-002, -3.063766e-002, -3.084019e-002, -3.105178e-002, -3.124592e-002, -3.140965e-002, -3.152888e-002,
   -3.162988e-002, -3.171277e-002, -3.178741e-002, -3.185242e-002, -3.188986e-002, -3.193901e-002, -3.197612e-002, -3.201158e-002, -3.203229e-002,
   -3.204133e-002, -3.204453e-002, -3.203612e-002, -3.199997e-002, -3.197920e-002, -3.193995e-002, -3.188434e-002, -3.180956e-002, -3.173601e-002,
   -3.166591e-002, -3.159756e-002, -3.152534e-002, -3.142901e-002, -3.133299e-002, -3.122326e-002, -3.109537e-002, -3.094049e-002, -3.076455e-002,
   -3.057683e-002, -3.036474e-002, -3.013159e-002, -2.995462e-002, -2.975585e-002, -2.954206e-002, -2.931729e-002, -2.907734e-002, -2.882566e-002,
   -2.856925e-002, -2.836073e-002, -2.815740e-002, -2.792169e-002, -2.764472e-002, -2.734216e-002, -2.703747e-002, -2.672691e-002, -2.640106e-002,
   -2.605751e-002, -2.571478e-002, -2.537412e-002, -2.502843e-002, -2.465196e-002, -2.426497e-002, -2.389776e-002, -2.352990e-002, -2.313097e-002,
   -2.272339e-002, -2.230516e-002, -2.188208e-002, -2.143910e-002, -2.100070e-002, -2.057200e-002, -2.014454e-002, -1.970938e-002, -1.927460e-002,
   -1.884924e-002, -1.841703e-002, -1.796012e-002, -1.749917e-002, -1.699678e-002, -1.652079e-002, -1.605484e-002, -1.558911e-002, -1.516947e-002,
   -1.474583e-002, -1.431388e-002, -1.387555e-002, -1.343679e-002, -1.297288e-002, -1.245838e-002, -1.196012e-002, -1.151270e-002, -1.106075e-002,
   -1.060709e-002, -1.015104e-002, -9.682566e-003, -9.212216e-003, -8.731728e-003, -8.208278e-003, -7.643232e-003, -7.087355e-003, -6.578601e-003,
   -6.048960e-003, -5.477234e-003, -4.897702e-003, -4.299889e-003, -3.662780e-003, -3.001082e-003, -2.297310e-003, -1.584170e-003, -8.516245e-004,
   -1.952714e-004, 4.833759e-004,  1.183689e-003,  1.901444e-003,  2.626945e-003,  3.356069e-003,  4.121274e-003,  4.924593e-003,  5.701597e-003,
   6.462709e-003,  7.150691e-003,  7.854372e-003,  8.555725e-003,  9.263497e-003,  9.983510e-003,  1.070692e-002,  1.144402e-002,  1.217113e-002,
   1.284441e-002,  1.353203e-002,  1.415597e-002,  1.473274e-002,  1.531914e-002,  1.592020e-002,  1.653393e-002,  1.716095e-002,  1.779465e-002,
   1.842422e-002,  1.903823e-002,  1.967016e-002,  2.027178e-002,  2.078086e-002,  2.131783e-002,  2.188602e-002,  2.246889e-002,  2.306096e-002,
   2.366982e-002,  2.425589e-002,  2.485314e-002,  2.546142e-002,  2.606522e-002,  2.651181e-002,  2.697275e-002,  2.744145e-002,  2.792537e-002,
   2.838825e-002,  2.886726e-002,  2.933813e-002,  2.978398e-002,  3.023047e-002,  3.068084e-002,  3.097320e-002,  3.124851e-002,  3.151979e-002,
   3.179491e-002,  3.208364e-002,  3.238522e-002,  3.270960e-002,  3.304227e-002,  3.338576e-002,  3.376693e-002,  3.403786e-002,  3.424990e-002,
   3.448659e-002,  3.475116e-002,  3.505739e-002,  3.539451e-002,  3.575027e-002,  3.611933e-002,  3.649073e-002,  3.688173e-002,  3.719951e-002,
   3.738622e-002,  3.759411e-002,  3.784242e-002,  3.810564e-002,  3.838660e-002,  3.868005e-002,  3.898292e-002,  3.924536e-002,  3.950280e-002,
   3.972558e-002,  3.973594e-002,  3.975274e-002,  3.978129e-002,  3.981270e-002,  3.984607e-002,  3.987135e-002,  3.986742e-002,  3.983345e-002,
   3.977924e-002,  3.972687e-002,  3.939447e-002,  3.903504e-002,  3.868324e-002,  3.833726e-002,  3.799708e-002,  3.766243e-002,  3.733177e-002,
   3.699997e-002,  3.663235e-002,  3.624944e-002,  3.564720e-002,  3.496800e-002,  3.429306e-002,  3.361142e-002,  3.290150e-002,  3.219412e-002,
   3.149192e-002,  3.079306e-002,  3.008957e-002,  2.930615e-002,  2.835259e-002,  2.721108e-002,  2.606995e-002,  2.493019e-002,  2.379139e-002,
   2.265073e-002,  2.153695e-002,  2.038014e-002,  1.920723e-002,  1.802808e-002,  1.663728e-002,  1.495627e-002,  1.327881e-002,  1.160589e-002,
   9.935733e-003,  8.270407e-003,  6.608634e-003,  4.951101e-003,  3.297583e-003,  1.647433e-003,  -6.357235e-017},
  {0.000000e+000,  4.681131e-002,  3.448546e-002,  2.787317e-002,  9.077404e-003,  -1.252344e-002, -1.981374e-002, -2.022446e-002, -1.977085e-002,
   -1.690704e-002, -1.085543e-002, -3.675414e-003, 3.000490e-003,  6.717629e-003,  5.669027e-003,  2.072485e-003,  -5.012936e-004, -1.170948e-003,
   -2.397314e-004, -7.352893e-005, -1.721719e-003, -5.648954e-003, -8.984094e-003, -1.196890e-002, -1.556017e-002, -1.883280e-002, -2.117636e-002,
   -2.178414e-002, -2.045620e-002, -1.774205e-002, -1.351744e-002, -8.063788e-003, -1.939619e-003, 4.290677e-003,  1.058171e-002,  1.655834e-002,
   2.145392e-002,  2.635716e-002,  3.162410e-002,  3.651302e-002,  4.110853e-002,  4.530762e-002,  4.825638e-002,  5.006986e-002,  5.095183e-002,
   5.020408e-002,  4.785951e-002,  4.428271e-002,  3.991452e-002,  3.477011e-002,  2.873794e-002,  2.134703e-002,  1.273631e-002,  3.663851e-003,
   -6.029854e-003, -1.575807e-002, -2.491389e-002, -3.361578e-002, -4.141220e-002, -4.798057e-002, -5.285234e-002, -5.599161e-002, -5.772764e-002,
   -5.855767e-002, -5.854105e-002, -5.801915e-002, -5.695607e-002, -5.533240e-002, -5.323196e-002, -5.069518e-002, -4.795854e-002, -4.473753e-002,
   -4.117124e-002, -3.724427e-002, -3.321496e-002, -2.912680e-002, -2.482910e-002, -2.033936e-002, -1.569094e-002, -1.062176e-002, -5.170073e-003,
   3.437857e-004,  5.848103e-003,  1.125088e-002,  1.656631e-002,  2.169067e-002,  2.633630e-002,  3.086059e-002,  3.502068e-002,  3.873037e-002,
   4.183588e-002,  4.451947e-002,  4.678120e-002,  4.859437e-002,  4.970678e-002,  5.023995e-002,  5.038301e-002,  4.983822e-002,  4.855151e-002,
   4.718407e-002,  4.576427e-002,  4.390175e-002,  4.157071e-002,  3.880250e-002,  3.576013e-002,  3.229183e-002,  2.847238e-002,  2.440965e-002,
   2.012665e-002,  1.559214e-002,  1.074161e-002,  5.951684e-003,  1.151384e-003,  -3.585619e-003, -8.887757e-003, -1.384535e-002, -1.852657e-002,
   -2.288487e-002, -2.716061e-002, -3.125988e-002, -3.473129e-002, -3.773333e-002, -4.020690e-002, -4.265230e-002, -4.493803e-002, -4.666470e-002,
   -4.805004e-002, -4.896643e-002, -4.989895e-002, -5.036629e-002, -5.021192e-002, -4.963145e-002, -4.856864e-002, -4.738171e-002, -4.572717e-002,
   -4.331828e-002, -4.020556e-002, -3.658248e-002, -3.273865e-002, -2.844455e-002, -2.379064e-002, -1.869489e-002, -1.358453e-002, -8.443050e-003,
   -3.364645e-003, 1.860701e-003,  7.123102e-003,  1.238238e-002,  1.757942e-002,  2.234447e-002,  2.642148e-002,  3.020768e-002,  3.373309e-002,
   3.683327e-002,  3.981301e-002,  4.254222e-002,  4.469727e-002,  4.665348e-002,  4.855023e-002,  5.049459e-002,  5.250306e-002,  5.419849e-002,
   5.525308e-002,  5.609343e-002,  5.680514e-002,  5.758628e-002,  5.837509e-002,  5.863108e-002,  5.836131e-002,  5.798997e-002,  5.741974e-002,
   5.695278e-002,  5.583392e-002,  5.458059e-002,  5.316203e-002,  5.172504e-002,  4.972813e-002,  4.758693e-002,  4.553395e-002,  4.351386e-002,
   4.071082e-002,  3.784024e-002,  3.500919e-002,  3.172657e-002,  2.824462e-002,  2.487347e-002,  2.106127e-002,  1.698121e-002,  1.299358e-002,
   8.379497e-003,  3.935987e-003,  -6.608164e-004, -5.529345e-003, -1.019073e-002, -1.535437e-002, -2.023319e-002, -2.546930e-002, -3.047127e-002,
   -3.571817e-002, -4.071906e-002, -4.573477e-002, -5.051431e-002, -5.516725e-002, -5.948015e-002, -6.348838e-002, -6.729707e-002, -7.065566e-002,
   -7.376872e-002, -7.635738e-002, -7.874548e-002, -8.043464e-002, -8.203416e-002, -8.298526e-002, -8.381424e-002, -8.403609e-002, -8.399522e-002,
   -8.362292e-002, -8.280955e-002, -8.193264e-002, -8.045636e-002, -7.892246e-002, -7.713694e-002, -7.494625e-002, -7.286040e-002, -7.045504e-002,
   -6.778598e-002, -6.515759e-002, -6.216961e-002, -5.912094e-002, -5.610186e-002, -5.278094e-002, -4.936363e-002, -4.598159e-002, -4.242170e-002,
   -3.876846e-002, -3.519103e-002, -3.159487e-002, -2.771813e-002, -2.388344e-002, -2.015988e-002, -1.638076e-002, -1.255269e-002, -8.791596e-003,
   -5.133212e-003, -1.274546e-003, 2.479637e-003,  6.032230e-003,  9.420152e-003,  1.288947e-002,  1.619042e-002,  1.927861e-002,  2.216957e-002,
   2.501808e-002,  2.770244e-002,  3.024260e-002,  3.260544e-002,  3.508378e-002,  3.740506e-002,  3.952824e-002,  4.145633e-002,  4.331550e-002,
   4.507710e-002,  4.664530e-002,  4.804002e-002,  4.922756e-002,  5.037657e-002,  5.138086e-002,  5.223361e-002,  5.295540e-002,  5.367978e-002,
   5.436264e-002,  5.489276e-002,  5.520533e-002,  5.531303e-002,  5.539436e-002,  5.543604e-002,  5.532854e-002,  5.507301e-002,  5.464520e-002,
   5.415568e-002,  5.354191e-002,  5.279835e-002,  5.193196e-002,  5.097215e-002,  5.002294e-002,  4.900709e-002,  4.786388e-002,  4.653563e-002,
   4.507678e-002,  4.355459e-002,  4.199924e-002,  4.037431e-002,  3.864483e-002,  3.679183e-002,  3.490835e-002,  3.300271e-002,  3.090309e-002,
   2.876163e-002,  2.660743e-002,  2.444052e-002,  2.240324e-002,  2.038992e-002,  1.831627e-002,  1.609441e-002,  1.387756e-002,  1.174006e-002,
   9.751399e-003,  7.766189e-003,  5.844567e-003,  3.982798e-003,  2.117273e-003,  3.151913e-004,  -1.360628e-003, -2.939121e-003, -4.451436e-003,
   -5.858844e-003, -7.168514e-003, -8.499262e-003, -9.705243e-003, -1.081210e-002, -1.189051e-002, -1.291298e-002, -1.387140e-002, -1.465477e-002,
   -1.550300e-002, -1.637613e-002, -1.719256e-002, -1.803177e-002, -1.888324e-002, -1.968082e-002, -2.042611e-002, -2.116963e-002, -2.207949e-002,
   -2.299855e-002, -2.388119e-002, -2.467255e-002, -2.531417e-002, -2.592913e-002, -2.644008e-002, -2.682552e-002, -2.718591e-002, -2.754750e-002,
   -2.765186e-002, -2.765523e-002, -2.752406e-002, -2.726710e-002, -2.688072e-002, -2.640137e-002, -2.570285e-002, -2.515455e-002, -2.455274e-002,
   -2.390108e-002, -2.319054e-002, -2.239094e-002, -2.154277e-002, -2.055979e-002, -1.945161e-002, -1.830144e-002, -1.730625e-002, -1.635173e-002,
   -1.538551e-002, -1.442422e-002, -1.337190e-002, -1.235285e-002, -1.128799e-002, -1.006423e-002, -8.741049e-003, -7.472599e-003, -6.401690e-003,
   -5.221186e-003, -3.989571e-003, -2.756025e-003, -1.520108e-003, -2.012723e-004, 1.237720e-003,  2.688091e-003,  4.202303e-003,  5.734698e-003,
   7.020855e-003,  8.318617e-003,  9.573227e-003,  1.089393e-002,  1.223390e-002,  1.362433e-002,  1.507834e-002,  1.652139e-002,  1.792093e-002,
   1.924950e-002,  2.042536e-002,  2.143528e-002,  2.239416e-002,  2.339400e-002,  2.438456e-002,  2.532135e-002,  2.616545e-002,  2.698230e-002,
   2.770054e-002,  2.833202e-002,  2.894373e-002,  2.958028e-002,  2.991290e-002,  3.012259e-002,  3.028503e-002,  3.033722e-002,  3.030585e-002,
   3.019283e-002,  3.007496e-002,  3.003720e-002,  2.999292e-002,  2.996758e-002,  2.993461e-002,  2.980423e-002,  2.955674e-002,  2.930377e-002,
   2.897844e-002,  2.865083e-002,  2.848003e-002,  2.830830e-002,  2.813526e-002,  2.792500e-002,  2.766062e-002,  2.730710e-002,  2.693337e-002,
   2.659270e-002,  2.614234e-002,  2.564160e-002,  2.515083e-002,  2.461619e-002,  2.395083e-002,  2.308640e-002,  2.211561e-002,  2.107071e-002,
   1.996197e-002,  1.886544e-002,  1.785440e-002,  1.676589e-002,  1.567677e-002,  1.454009e-002,  1.342230e-002,  1.226866e-002,  1.104708e-002,
   9.824566e-003,  8.595248e-003,  7.422231e-003,  6.177077e-003,  4.908154e-003,  3.637750e-003,  2.406062e-003,  1.150715e-003,  -1.269682e-004,
   -1.485081e-003, -2.869399e-003, -4.230416e-003, -5.489638e-003, -6.794520e-003, -8.186402e-003, -9.585763e-003, -1.098258e-002, -1.231384e-002,
   -1.370129e-002, -1.516476e-002, -1.662410e-002, -1.813693e-002, -1.958581e-002, -2.108534e-002, -2.263624e-002, -2.422710e-002, -2.581051e-002,
   -2.737335e-002, -2.892406e-002, -3.039598e-002, -3.186074e-002, -3.332416e-002, -3.478130e-002, -3.614510e-002, -3.751609e-002, -3.885534e-002,
   -4.018989e-002, -4.152692e-002, -4.283544e-002, -4.410973e-002, -4.532101e-002, -4.642662e-002, -4.745378e-002, -4.839035e-002, -4.923504e-002,
   -4.999617e-002, -5.073088e-002, -5.137246e-002, -5.192545e-002, -5.248106e-002, -5.302770e-002, -5.353326e-002, -5.397520e-002, -5.435785e-002,
   -5.470494e-002, -5.502279e-002, -5.518973e-002, -5.527213e-002, -5.528006e-002, -5.526554e-002, -5.516498e-002, -5.497562e-002, -5.476407e-002,
   -5.450516e-002, -5.418434e-002, -5.384248e-002, -5.348794e-002, -5.309449e-002, -5.261004e-002, -5.191361e-002, -5.118071e-002, -5.048657e-002,
   -4.977398e-002, -4.888613e-002, -4.794007e-002, -4.695792e-002, -4.597193e-002, -4.497811e-002, -4.396739e-002, -4.297801e-002, -4.197763e-002,
   -4.098473e-002, -3.996192e-002, -3.891484e-002, -3.788558e-002, -3.667123e-002, -3.541216e-002, -3.419372e-002, -3.303450e-002, -3.191623e-002,
   -3.079176e-002, -2.967039e-002, -2.858740e-002, -2.754537e-002, -2.657461e-002, -2.561912e-002, -2.452975e-002, -2.326314e-002, -2.199472e-002,
   -2.072116e-002, -1.944397e-002, -1.814401e-002, -1.681423e-002, -1.546728e-002, -1.406499e-002, -1.265142e-002, -1.128272e-002, -9.781957e-003,
   -8.171467e-003, -6.557077e-003, -4.975358e-003, -3.376001e-003, -1.754926e-003, -1.140562e-004, 1.509670e-003,  3.113203e-003,  4.681309e-003,
   6.329369e-003,  8.145204e-003,  9.908321e-003,  1.162172e-002,  1.324871e-002,  1.482348e-002,  1.635826e-002,  1.785242e-002,  1.928703e-002,
   2.069971e-002,  2.223961e-002,  2.387469e-002,  2.546514e-002,  2.701919e-002,  2.850560e-002,  2.993761e-002,  3.138086e-002,  3.283292e-002,
   3.426880e-002,  3.571753e-002,  3.709773e-002,  3.850995e-002,  3.991266e-002,  4.131552e-002,  4.272713e-002,  4.417610e-002,  4.567907e-002,
   4.713312e-002,  4.858780e-002,  4.994958e-002,  5.099983e-002,  5.202061e-002,  5.303529e-002,  5.402985e-002,  5.501470e-002,  5.601541e-002,
   5.697689e-002,  5.788245e-002,  5.878455e-002,  5.960431e-002,  5.993314e-002,  6.004867e-002,  6.017560e-002,  6.025680e-002,  6.028332e-002,
   6.036600e-002,  6.047204e-002,  6.054307e-002,  6.061440e-002,  6.066773e-002,  6.067408e-002,  6.064750e-002,  6.029579e-002,  5.948691e-002,
   5.871027e-002,  5.798872e-002,  5.730511e-002,  5.662379e-002,  5.596847e-002,  5.535131e-002,  5.478482e-002,  5.418309e-002,  5.354282e-002,
   5.290137e-002,  5.234137e-002,  5.183970e-002,  5.136903e-002,  5.066515e-002,  4.934083e-002,  4.801558e-002,  4.669566e-002,  4.537542e-002,
   4.400899e-002,  4.263368e-002,  4.124278e-002,  3.983301e-002,  3.841035e-002,  3.697916e-002,  3.549100e-002,  3.397292e-002,  3.245419e-002,
   3.094846e-002,  2.942530e-002,  2.787906e-002,  2.636620e-002,  2.494316e-002,  2.354671e-002,  2.191724e-002,  1.997041e-002,  1.806422e-002,
   1.621102e-002,  1.446106e-002,  1.291231e-002,  1.143140e-002,  1.001174e-002,  8.622862e-003,  7.266216e-003,  5.909518e-003,  4.587831e-003,
   3.242925e-003,  1.913073e-003,  6.163586e-004,  -5.650576e-004, -1.612659e-003, -2.639918e-003, -3.609561e-003, -4.506571e-003, -5.356361e-003,
   -6.214368e-003, -7.096796e-003, -8.025984e-003, -9.000385e-003, -1.000258e-002, -1.097974e-002, -1.221216e-002, -1.331860e-002, -1.444947e-002,
   -1.561844e-002, -1.687950e-002, -1.814989e-002, -1.941037e-002, -2.055378e-002, -2.170066e-002, -2.283110e-002, -2.395691e-002, -2.509341e-002,
   -2.618455e-002, -2.723229e-002, -2.801128e-002, -2.853404e-002, -2.895595e-002, -2.932786e-002, -2.968468e-002, -2.999819e-002, -3.028305e-002,
   -3.054678e-002, -3.077979e-002, -3.100213e-002, -3.122261e-002, -3.151470e-002, -3.172709e-002, -3.190430e-002, -3.204822e-002, -3.217858e-002,
   -3.222945e-002, -3.218066e-002, -3.191587e-002, -3.156741e-002, -3.123162e-002, -3.102675e-002, -3.111331e-002, -3.125889e-002, -3.142315e-002,
   -3.160778e-002, -3.177897e-002, -3.192405e-002, -3.203485e-002, -3.212855e-002, -3.218406e-002, -3.220427e-002, -3.218557e-002, -3.216532e-002,
   -3.215987e-002, -3.217860e-002, -3.200768e-002, -3.171497e-002, -3.139800e-002, -3.107310e-002, -3.069901e-002, -3.017591e-002, -2.955571e-002,
   -2.893570e-002, -2.830517e-002, -2.767579e-002, -2.702912e-002, -2.638762e-002, -2.575170e-002, -2.514445e-002, -2.455085e-002, -2.401040e-002,
   -2.345075e-002, -2.286864e-002, -2.230433e-002, -2.174911e-002, -2.118840e-002, -2.062891e-002, -2.006041e-002, -1.948396e-002, -1.885741e-002,
   -1.815325e-002, -1.744793e-002, -1.671256e-002, -1.596254e-002, -1.518492e-002, -1.440409e-002, -1.360366e-002, -1.276341e-002, -1.192953e-002,
   -1.131855e-002, -1.075737e-002, -1.002369e-002, -9.305102e-003, -8.616256e-003, -7.950955e-003, -7.311456e-003, -6.678224e-003, -6.041242e-003,
   -5.385214e-003, -4.747592e-003, -4.080719e-003, -3.454269e-003, -2.879744e-003, -2.343424e-003, -1.879314e-003, -1.446905e-003, -1.032713e-003,
   -6.463152e-004, -2.763472e-004, 1.004613e-004,  5.282436e-004,  9.870480e-004,  1.455067e-003,  1.935803e-003,  2.427716e-003,  2.917809e-003,
   3.426500e-003,  3.931207e-003,  4.440017e-003,  4.950393e-003,  5.456166e-003,  5.947855e-003,  6.439354e-003,  6.939765e-003,  7.429828e-003,
   7.900502e-003,  8.348521e-003,  8.763991e-003,  9.170761e-003,  9.576973e-003,  9.994175e-003,  1.037298e-002,  1.083292e-002,  1.126701e-002,
   1.165610e-002,  1.200309e-002,  1.231259e-002,  1.256936e-002,  1.277863e-002,  1.294129e-002,  1.304473e-002,  1.310577e-002,  1.313875e-002,
   1.315785e-002,  1.315361e-002,  1.313038e-002,  1.307920e-002,  1.295946e-002,  1.283788e-002,  1.271356e-002,  1.268945e-002,  1.272269e-002,
   1.280713e-002,  1.290529e-002,  1.295629e-002,  1.288772e-002,  1.280596e-002,  1.269083e-002,  1.255395e-002,  1.239690e-002,  1.222712e-002,
   1.205917e-002,  1.194490e-002,  1.185235e-002,  1.175429e-002,  1.162861e-002,  1.147165e-002,  1.129526e-002,  1.107945e-002,  1.081822e-002,
   1.051647e-002,  1.019372e-002,  9.856525e-003,  9.509824e-003,  9.129752e-003,  8.744128e-003,  8.371728e-003,  8.023015e-003,  7.691966e-003,
   7.391482e-003,  7.127639e-003,  6.903494e-003,  6.689683e-003,  6.493887e-003,  6.357181e-003,  6.257253e-003,  6.180738e-003,  6.219192e-003,
   6.258491e-003,  6.317628e-003,  6.409330e-003,  6.524055e-003,  6.616680e-003,  6.709712e-003,  6.805812e-003,  6.894513e-003,  7.026513e-003,
   7.145610e-003,  7.248054e-003,  7.341368e-003,  7.414935e-003,  7.410269e-003,  7.413855e-003,  7.402326e-003,  7.374186e-003,  7.320299e-003,
   7.248887e-003,  7.150171e-003,  7.035966e-003,  6.912878e-003,  6.768290e-003,  6.593352e-003,  6.397631e-003,  6.208808e-003,  6.046527e-003,
   5.895229e-003,  5.753246e-003,  5.636468e-003,  5.535089e-003,  5.430815e-003,  5.316514e-003,  5.203072e-003,  5.076031e-003,  4.947930e-003,
   4.858131e-003,  4.762396e-003,  4.663724e-003,  4.563925e-003,  4.459467e-003,  4.345069e-003,  4.217650e-003,  4.068917e-003,  3.934200e-003,
   3.804770e-003,  3.696061e-003,  3.609597e-003,  3.501340e-003,  3.383188e-003,  3.251549e-003,  3.140899e-003,  3.032227e-003,  2.881046e-003,
   2.619986e-003,  2.350280e-003,  2.104944e-003,  1.873185e-003,  1.630876e-003,  1.369334e-003,  1.105577e-003,  8.510127e-004,  5.952370e-004,
   3.385831e-004,  7.613545e-005,  -1.933397e-004, -4.570994e-004, -6.873165e-004, -9.421861e-004, -1.240337e-003, -1.545867e-003, -1.854179e-003,
   -2.132665e-003, -2.397875e-003, -2.687182e-003, -3.000602e-003, -3.331590e-003, -3.607402e-003, -3.912631e-003, -4.228442e-003, -4.552572e-003,
   -4.847655e-003, -5.128624e-003, -5.387860e-003, -5.629705e-003, -5.868755e-003, -6.102562e-003, -6.256287e-003, -6.404354e-003, -6.538640e-003,
   -6.654996e-003, -6.759347e-003, -6.844263e-003, -6.931231e-003, -7.024069e-003, -7.124276e-003, -7.238232e-003, -7.307320e-003, -7.359717e-003,
   -7.417052e-003, -7.477403e-003, -7.537770e-003, -7.577184e-003, -7.619149e-003, -7.685883e-003, -7.766367e-003, -7.867068e-003, -7.951303e-003,
   -7.998447e-003, -8.066885e-003, -8.163488e-003, -8.280622e-003, -8.423789e-003, -8.594658e-003, -8.810135e-003, -9.059259e-003, -9.338173e-003,
   -9.639212e-003, -9.877399e-003, -1.011859e-002, -1.036583e-002, -1.061711e-002, -1.086555e-002, -1.110966e-002, -1.132911e-002, -1.150975e-002,
   -1.168918e-002, -1.185982e-002, -1.189004e-002, -1.188348e-002, -1.184896e-002, -1.178765e-002, -1.170955e-002, -1.162512e-002, -1.154200e-002,
   -1.144819e-002, -1.134496e-002, -1.125208e-002, -1.107638e-002, -1.085459e-002, -1.063878e-002, -1.042280e-002, -1.018981e-002, -9.957078e-003,
   -9.724109e-003, -9.506621e-003, -9.299984e-003, -9.105711e-003, -8.882068e-003, -8.624317e-003, -8.406313e-003, -8.219835e-003, -8.026353e-003,
   -7.835124e-003, -7.643890e-003, -7.422261e-003, -7.180429e-003, -6.900958e-003, -6.493511e-003, -5.934865e-003, -5.357188e-003, -4.757886e-003,
   -4.144439e-003, -3.509118e-003, -2.855865e-003, -2.177809e-003, -1.479250e-003, -7.512174e-004, -1.016566e-017},
  {0.000000e+000,  9.337579e-002,  8.054700e-002,  6.256344e-002,  3.666294e-002,  8.144030e-003,  -1.059384e-002, -2.663954e-002, -3.935114e-002,
   -4.824101e-002, -5.237458e-002, -5.184092e-002, -4.726596e-002, -4.032197e-002, -3.534554e-002, -3.300175e-002, -3.222506e-002, -3.109026e-002,
   -2.817204e-002, -2.516272e-002, -2.076238e-002, -1.440327e-002, -6.912883e-003, 1.941417e-003,  1.157612e-002,  2.126827e-002,  3.039692e-002,
   3.774032e-002,  4.245606e-002,  4.444934e-002,  4.460454e-002,  4.343607e-002,  4.107697e-002,  3.760178e-002,  3.386266e-002,  2.996247e-002,
   2.615551e-002,  2.180640e-002,  1.697367e-002,  1.177458e-002,  6.244900e-003,  5.070997e-004,  -5.046233e-003, -1.037382e-002, -1.509954e-002,
   -1.909733e-002, -2.221596e-002, -2.381300e-002, -2.486913e-002, -2.565004e-002, -2.611091e-002, -2.613241e-002, -2.550826e-002, -2.404751e-002,
   -2.226260e-002, -2.009056e-002, -1.753187e-002, -1.486596e-002, -1.213645e-002, -9.042711e-003, -5.815066e-003, -2.922695e-003, 6.328107e-005,
   3.130231e-003,  6.150614e-003,  9.359206e-003,  1.243885e-002,  1.544246e-002,  1.827674e-002,  2.096147e-002,  2.357433e-002,  2.594095e-002,
   2.801248e-002,  2.966496e-002,  3.101287e-002,  3.224910e-002,  3.311050e-002,  3.338042e-002,  3.301061e-002,  3.168125e-002,  2.988833e-002,
   2.758315e-002,  2.447003e-002,  2.050972e-002,  1.628483e-002,  1.147938e-002,  6.069612e-003,  4.319296e-004,  -5.188078e-003, -1.082200e-002,
   -1.641430e-002, -2.201648e-002, -2.710552e-002, -3.195749e-002, -3.649277e-002, -4.012370e-002, -4.320136e-002, -4.551116e-002, -4.667907e-002,
   -4.724751e-002, -4.716803e-002, -4.660996e-002, -4.558051e-002, -4.405821e-002, -4.220763e-002, -3.997135e-002, -3.723699e-002, -3.432818e-002,
   -3.108256e-002, -2.769270e-002, -2.381317e-002, -1.993181e-002, -1.601529e-002, -1.215511e-002, -7.974437e-003, -3.711301e-003, 5.040333e-004,
   4.524147e-003,  8.259167e-003,  1.191973e-002,  1.532632e-002,  1.848794e-002,  2.125973e-002,  2.375283e-002,  2.629281e-002,  2.892457e-002,
   3.134179e-002,  3.340889e-002,  3.515550e-002,  3.656751e-002,  3.787512e-002,  3.893071e-002,  3.961539e-002,  3.981786e-002,  3.990924e-002,
   3.939848e-002,  3.859373e-002,  3.751452e-002,  3.588884e-002,  3.405013e-002,  3.197804e-002,  2.972880e-002,  2.759941e-002,  2.546564e-002,
   2.339918e-002,  2.093479e-002,  1.839426e-002,  1.594785e-002,  1.330018e-002,  1.090515e-002,  8.845472e-003,  6.767977e-003,  4.753374e-003,
   2.727377e-003,  9.251994e-004,  -1.073709e-003, -2.956624e-003, -4.900178e-003, -7.063213e-003, -9.318317e-003, -1.150778e-002, -1.378903e-002,
   -1.568296e-002, -1.766367e-002, -1.971595e-002, -2.159365e-002, -2.352753e-002, -2.530709e-002, -2.683944e-002, -2.855413e-002, -3.043345e-002,
   -3.230536e-002, -3.363735e-002, -3.500978e-002, -3.638806e-002, -3.793768e-002, -3.901289e-002, -3.971353e-002, -4.039272e-002, -4.122470e-002,
   -4.127548e-002, -4.140999e-002, -4.167933e-002, -4.128496e-002, -4.069180e-002, -4.036119e-002, -3.946187e-002, -3.827728e-002, -3.708067e-002,
   -3.509397e-002, -3.299071e-002, -3.067334e-002, -2.770009e-002, -2.467655e-002, -2.094021e-002, -1.728392e-002, -1.298017e-002, -8.677546e-003,
   -4.119176e-003, 3.914347e-004,  4.987787e-003,  9.541484e-003,  1.406785e-002,  1.869771e-002,  2.319567e-002,  2.750408e-002,  3.160078e-002,
   3.547548e-002,  3.906471e-002,  4.249579e-002,  4.547527e-002,  4.836086e-002,  5.055178e-002,  5.268234e-002,  5.420818e-002,  5.567213e-002,
   5.675608e-002,  5.751439e-002,  5.827158e-002,  5.826996e-002,  5.820207e-002,  5.781884e-002,  5.704479e-002,  5.616921e-002,  5.498818e-002,
   5.350800e-002,  5.202346e-002,  5.009597e-002,  4.806783e-002,  4.599423e-002,  4.364423e-002,  4.113364e-002,  3.866013e-002,  3.609612e-002,
   3.335584e-002,  3.066471e-002,  2.806307e-002,  2.520214e-002,  2.247422e-002,  1.991643e-002,  1.722360e-002,  1.451583e-002,  1.193606e-002,
   9.520540e-003,  6.953139e-003,  4.558911e-003,  2.287653e-003,  2.052085e-004,  -2.048454e-003, -4.205553e-003, -6.180249e-003, -8.077998e-003,
   -9.991269e-003, -1.182419e-002, -1.354970e-002, -1.522469e-002, -1.701507e-002, -1.876009e-002, -2.043974e-002, -2.204278e-002, -2.365799e-002,
   -2.528322e-002, -2.681548e-002, -2.829378e-002, -2.978555e-002, -3.129256e-002, -3.265782e-002, -3.381694e-002, -3.482830e-002, -3.577425e-002,
   -3.655835e-002, -3.712273e-002, -3.751840e-002, -3.772809e-002, -3.777965e-002, -3.771771e-002, -3.748561e-002, -3.714185e-002, -3.671973e-002,
   -3.638967e-002, -3.592087e-002, -3.524906e-002, -3.453363e-002, -3.367208e-002, -3.282128e-002, -3.192228e-002, -3.094828e-002, -2.996387e-002,
   -2.895276e-002, -2.798544e-002, -2.699783e-002, -2.598904e-002, -2.505665e-002, -2.406740e-002, -2.317733e-002, -2.238234e-002, -2.157464e-002,
   -2.079896e-002, -1.995379e-002, -1.901615e-002, -1.809261e-002, -1.710185e-002, -1.611102e-002, -1.509913e-002, -1.404581e-002, -1.302115e-002,
   -1.200123e-002, -1.104464e-002, -9.955152e-003, -8.730752e-003, -7.477647e-003, -6.247350e-003, -5.104490e-003, -3.869194e-003, -2.607954e-003,
   -1.385911e-003, -1.641177e-004, 9.854357e-004,  2.060707e-003,  3.154591e-003,  4.187122e-003,  5.179847e-003,  6.077607e-003,  6.777136e-003,
   7.424068e-003,  8.014570e-003,  8.583143e-003,  9.165609e-003,  9.725707e-003,  1.012095e-002,  1.055190e-002,  1.093842e-002,  1.132863e-002,
   1.166970e-002,  1.200443e-002,  1.232981e-002,  1.260928e-002,  1.288811e-002,  1.319934e-002,  1.342834e-002,  1.364720e-002,  1.389613e-002,
   1.403256e-002,  1.419949e-002,  1.436808e-002,  1.450918e-002,  1.462757e-002,  1.474620e-002,  1.484067e-002,  1.488036e-002,  1.488585e-002,
   1.485840e-002,  1.482058e-002,  1.478127e-002,  1.469202e-002,  1.440663e-002,  1.410424e-002,  1.374990e-002,  1.343710e-002,  1.311401e-002,
   1.275624e-002,  1.228563e-002,  1.161193e-002,  1.090090e-002,  1.007068e-002,  9.343667e-003,  8.678377e-003,  8.033764e-003,  7.440297e-003,
   6.761212e-003,  6.026261e-003,  5.338306e-003,  4.729615e-003,  4.308365e-003,  3.823137e-003,  3.389233e-003,  2.861451e-003,  2.335036e-003,
   1.829381e-003,  1.309549e-003,  7.877082e-004,  3.416839e-004,  -1.170449e-004, -6.148117e-004, -1.155524e-003, -1.688575e-003, -2.237354e-003,
   -2.823631e-003, -3.452555e-003, -4.052090e-003, -4.615889e-003, -5.217007e-003, -5.784518e-003, -6.373255e-003, -7.041528e-003, -7.614589e-003,
   -8.177274e-003, -8.712735e-003, -9.077423e-003, -9.461381e-003, -9.785105e-003, -1.004130e-002, -1.020022e-002, -1.029365e-002, -1.033404e-002,
   -1.023723e-002, -9.933239e-003, -9.599172e-003, -9.315980e-003, -9.005085e-003, -8.640219e-003, -8.236887e-003, -7.734047e-003, -7.192223e-003,
   -6.675314e-003, -6.214613e-003, -5.635462e-003, -4.983051e-003, -4.247794e-003, -3.557568e-003, -2.866000e-003, -2.102296e-003, -1.298655e-003,
   -4.638119e-004, 3.587447e-004,  1.159503e-003,  2.088161e-003,  2.984260e-003,  3.770795e-003,  4.504367e-003,  5.192513e-003,  5.833605e-003,
   6.431160e-003,  6.987493e-003,  7.534671e-003,  8.059066e-003,  8.699260e-003,  9.342952e-003,  9.986501e-003,  1.066711e-002,  1.132237e-002,
   1.199838e-002,  1.260538e-002,  1.306040e-002,  1.348763e-002,  1.382594e-002,  1.414093e-002,  1.451043e-002,  1.484075e-002,  1.509472e-002,
   1.529071e-002,  1.548732e-002,  1.561509e-002,  1.552972e-002,  1.534550e-002,  1.506998e-002,  1.477325e-002,  1.440358e-002,  1.408849e-002,
   1.366535e-002,  1.314723e-002,  1.253122e-002,  1.186016e-002,  1.103214e-002,  1.015124e-002,  9.193284e-003,  8.199210e-003,  7.176804e-003,
   6.115569e-003,  5.071359e-003,  4.173115e-003,  3.299768e-003,  2.476470e-003,  1.603802e-003,  5.976111e-004,  -4.051276e-004, -1.385052e-003,
   -2.347748e-003, -3.232117e-003, -4.088827e-003, -4.867963e-003, -5.591498e-003, -6.131005e-003, -6.627589e-003, -7.027709e-003, -7.474431e-003,
   -7.923041e-003, -8.315020e-003, -8.613571e-003, -8.908797e-003, -9.122805e-003, -9.299557e-003, -9.409668e-003, -9.468532e-003, -9.445102e-003,
   -9.323435e-003, -9.165683e-003, -9.024795e-003, -8.870623e-003, -8.762402e-003, -8.682179e-003, -8.592505e-003, -8.453258e-003, -8.263731e-003,
   -8.087003e-003, -7.912042e-003, -7.736209e-003, -7.521169e-003, -7.249127e-003, -6.965512e-003, -6.762702e-003, -6.515550e-003, -6.258677e-003,
   -6.013257e-003, -5.770505e-003, -5.493118e-003, -5.255936e-003, -5.034171e-003, -4.816254e-003, -4.629203e-003, -4.449963e-003, -4.336181e-003,
   -4.268466e-003, -4.292624e-003, -4.391840e-003, -4.533672e-003, -4.736679e-003, -4.994259e-003, -5.228097e-003, -5.456070e-003, -5.734247e-003,
   -6.046107e-003, -6.378313e-003, -6.736148e-003, -7.135370e-003, -7.632638e-003, -8.178881e-003, -8.785749e-003, -9.447093e-003, -1.012371e-002,
   -1.083444e-002, -1.148722e-002, -1.206124e-002, -1.252398e-002, -1.285561e-002, -1.306116e-002, -1.313299e-002, -1.311074e-002, -1.299841e-002,
   -1.280540e-002, -1.251108e-002, -1.210224e-002, -1.164463e-002, -1.119139e-002, -1.073385e-002, -1.022790e-002, -9.616787e-003, -8.907662e-003,
   -8.118590e-003, -7.282146e-003, -6.398673e-003, -5.506171e-003, -4.597237e-003, -3.703928e-003, -2.829107e-003, -1.932029e-003, -9.461520e-004,
   3.753457e-005,  9.556617e-004,  1.818693e-003,  2.702970e-003,  3.613503e-003,  4.494044e-003,  5.315143e-003,  6.157584e-003,  7.025176e-003,
   7.949765e-003,  8.926645e-003,  9.954034e-003,  1.104090e-002,  1.217455e-002,  1.336638e-002,  1.460108e-002,  1.591158e-002,  1.728392e-002,
   1.855519e-002,  1.975071e-002,  2.093432e-002,  2.211945e-002,  2.334418e-002,  2.458248e-002,  2.581480e-002,  2.701267e-002,  2.815575e-002,
   2.922650e-002,  3.031731e-002,  3.140689e-002,  3.236835e-002,  3.330991e-002,  3.419446e-002,  3.499449e-002,  3.576448e-002,  3.644604e-002,
   3.699905e-002,  3.747390e-002,  3.793745e-002,  3.840063e-002,  3.881495e-002,  3.915204e-002,  3.937664e-002,  3.961970e-002,  3.988549e-002,
   4.010040e-002,  4.030473e-002,  4.051671e-002,  4.069752e-002,  4.085415e-002,  4.096553e-002,  4.102323e-002,  4.093267e-002,  4.072444e-002,
   4.047253e-002,  4.008965e-002,  3.958233e-002,  3.899244e-002,  3.831920e-002,  3.756706e-002,  3.672373e-002,  3.578440e-002,  3.472734e-002,
   3.354933e-002,  3.231533e-002,  3.099715e-002,  2.955171e-002,  2.798917e-002,  2.632923e-002,  2.458800e-002,  2.278689e-002,  2.090699e-002,
   1.898109e-002,  1.697175e-002,  1.492934e-002,  1.280709e-002,  1.057119e-002,  8.312012e-003,  6.028641e-003,  3.704349e-003,  1.368374e-003,
   -9.636291e-004, -3.221179e-003, -5.194699e-003, -7.076719e-003, -8.911461e-003, -1.071179e-002, -1.249202e-002, -1.425596e-002, -1.601797e-002,
   -1.774000e-002, -1.939483e-002, -2.099249e-002, -2.239130e-002, -2.357917e-002, -2.473676e-002, -2.570602e-002, -2.661983e-002, -2.753098e-002,
   -2.845196e-002, -2.930966e-002, -3.015494e-002, -3.104343e-002, -3.194993e-002, -3.290752e-002, -3.361877e-002, -3.420379e-002, -3.480905e-002,
   -3.549334e-002, -3.625962e-002, -3.708951e-002, -3.796340e-002, -3.869558e-002, -3.943532e-002, -4.019785e-002, -4.099971e-002, -4.181653e-002,
   -4.268911e-002, -4.358275e-002, -4.417339e-002, -4.450766e-002, -4.493635e-002, -4.532211e-002, -4.566009e-002, -4.599084e-002, -4.632297e-002,
   -4.665601e-002, -4.703642e-002, -4.745356e-002, -4.792047e-002, -4.839403e-002, -4.870564e-002, -4.899779e-002, -4.928525e-002, -4.959662e-002,
   -4.987861e-002, -5.007376e-002, -4.998058e-002, -4.982173e-002, -4.968543e-002, -4.964423e-002, -4.963048e-002, -4.957751e-002, -4.953594e-002,
   -4.950427e-002, -4.951134e-002, -4.955110e-002, -4.957089e-002, -4.955461e-002, -4.950445e-002, -4.943094e-002, -4.931222e-002, -4.917423e-002,
   -4.901950e-002, -4.879597e-002, -4.833046e-002, -4.779963e-002, -4.726231e-002, -4.670867e-002, -4.615839e-002, -4.538542e-002, -4.447395e-002,
   -4.353573e-002, -4.258400e-002, -4.164180e-002, -4.072973e-002, -3.983688e-002, -3.899708e-002, -3.819590e-002, -3.741894e-002, -3.659510e-002,
   -3.583894e-002, -3.516010e-002, -3.451904e-002, -3.388106e-002, -3.331450e-002, -3.278897e-002, -3.228370e-002, -3.175822e-002, -3.114787e-002,
   -3.043007e-002, -2.970818e-002, -2.892343e-002, -2.808010e-002, -2.716863e-002, -2.620993e-002, -2.517996e-002, -2.401188e-002, -2.280922e-002,
   -2.159224e-002, -2.035964e-002, -1.885166e-002, -1.732302e-002, -1.577494e-002, -1.418543e-002, -1.255596e-002, -1.090489e-002, -9.229455e-003,
   -7.559030e-003, -5.879610e-003, -4.270280e-003, -2.700607e-003, -1.172344e-003, 3.035896e-004,  1.853425e-003,  3.386585e-003,  4.889981e-003,
   6.408420e-003,  7.933404e-003,  9.464477e-003,  1.105332e-002,  1.270783e-002,  1.437190e-002,  1.603634e-002,  1.770604e-002,  1.940208e-002,
   2.107708e-002,  2.273079e-002,  2.435622e-002,  2.595365e-002,  2.754913e-002,  2.907069e-002,  3.053007e-002,  3.192599e-002,  3.322939e-002,
   3.446752e-002,  3.562821e-002,  3.670819e-002,  3.778943e-002,  3.881524e-002,  3.972464e-002,  4.057232e-002,  4.154276e-002,  4.249255e-002,
   4.333301e-002,  4.407401e-002,  4.471403e-002,  4.528109e-002,  4.575084e-002,  4.615970e-002,  4.653299e-002,  4.687983e-002,  4.719266e-002,
   4.746699e-002,  4.770137e-002,  4.790248e-002,  4.812787e-002,  4.840149e-002,  4.868858e-002,  4.899610e-002,  4.939016e-002,  4.982599e-002,
   5.028005e-002,  5.069078e-002,  5.100873e-002,  5.125548e-002,  5.143315e-002,  5.156982e-002,  5.165233e-002,  5.166331e-002,  5.161557e-002,
   5.149329e-002,  5.126921e-002,  5.100872e-002,  5.071450e-002,  5.038752e-002,  5.001719e-002,  4.958009e-002,  4.906007e-002,  4.846992e-002,
   4.778778e-002,  4.703981e-002,  4.624614e-002,  4.547481e-002,  4.470176e-002,  4.394577e-002,  4.321158e-002,  4.248757e-002,  4.180063e-002,
   4.113622e-002,  4.051122e-002,  3.993146e-002,  3.939281e-002,  3.898187e-002,  3.868661e-002,  3.841846e-002,  3.816450e-002,  3.805861e-002,
   3.797960e-002,  3.790789e-002,  3.782917e-002,  3.770065e-002,  3.755250e-002,  3.744995e-002,  3.735331e-002,  3.723614e-002,  3.703699e-002,
   3.679838e-002,  3.650905e-002,  3.614840e-002,  3.571775e-002,  3.526075e-002,  3.483020e-002,  3.442124e-002,  3.409020e-002,  3.371572e-002,
   3.329526e-002,  3.284643e-002,  3.236931e-002,  3.185238e-002,  3.129653e-002,  3.073311e-002,  3.016913e-002,  2.962126e-002,  2.916572e-002,
   2.869517e-002,  2.825708e-002,  2.780402e-002,  2.732901e-002,  2.682298e-002,  2.626712e-002,  2.566305e-002,  2.499945e-002,  2.428835e-002,
   2.372180e-002,  2.311835e-002,  2.246110e-002,  2.176425e-002,  2.104785e-002,  2.026311e-002,  1.941361e-002,  1.850893e-002,  1.753306e-002,
   1.650973e-002,  1.561526e-002,  1.469558e-002,  1.372472e-002,  1.272100e-002,  1.170618e-002,  1.068380e-002,  9.679732e-003,  8.657886e-003,
   7.651527e-003,  6.622926e-003,  5.681231e-003,  4.801839e-003,  3.873979e-003,  2.905915e-003,  1.896289e-003,  8.439484e-004,  -2.630574e-004,
   -1.457973e-003, -2.676914e-003, -3.964507e-003, -5.248744e-003, -6.417704e-003, -7.674556e-003, -9.026760e-003, -1.043564e-002, -1.191928e-002,
   -1.341661e-002, -1.496836e-002, -1.657154e-002, -1.824421e-002, -1.995019e-002, -2.136379e-002, -2.283756e-002, -2.437045e-002, -2.595351e-002,
   -2.755731e-002, -2.913923e-002, -3.074726e-002, -3.233955e-002, -3.391494e-002, -3.547784e-002, -3.672283e-002, -3.788117e-002, -3.896046e-002,
   -3.997611e-002, -4.095671e-002, -4.191678e-002, -4.288731e-002, -4.386789e-002, -4.488039e-002, -4.593007e-002, -4.677068e-002, -4.748846e-002,
   -4.825510e-002, -4.907650e-002, -4.996382e-002, -5.085780e-002, -5.178688e-002, -5.273962e-002, -5.370904e-002, -5.475475e-002, -5.569017e-002,
   -5.640125e-002, -5.719480e-002, -5.804965e-002, -5.898991e-002, -6.001694e-002, -6.113002e-002, -6.234433e-002, -6.349029e-002, -6.466185e-002,
   -6.581352e-002, -6.656992e-002, -6.738337e-002, -6.820166e-002, -6.901374e-002, -6.981737e-002, -7.061313e-002, -7.141248e-002, -7.219523e-002,
   -7.291148e-002, -7.362366e-002, -7.366409e-002, -7.354246e-002, -7.336383e-002, -7.313253e-002, -7.286657e-002, -7.258232e-002, -7.228563e-002,
   -7.201053e-002, -7.162843e-002, -7.120132e-002, -7.033058e-002, -6.921598e-002, -6.808678e-002, -6.689582e-002, -6.550464e-002, -6.411324e-002,
   -6.274257e-002, -6.137885e-002, -6.004870e-002, -5.860752e-002, -5.687383e-002, -5.481994e-002, -5.282281e-002, -5.087249e-002, -4.893320e-002,
   -4.696397e-002, -4.496778e-002, -4.270812e-002, -4.032353e-002, -3.792581e-002, -3.517678e-002, -3.177874e-002, -2.838066e-002, -2.497265e-002,
   -2.153301e-002, -1.805253e-002, -1.453713e-002, -1.097515e-002, -7.373098e-003, -3.712301e-003, 1.043064e-016},
  {0.000000e+000,  -2.936768e-001, -2.015949e-001, -1.220699e-001, -5.804498e-002, -5.519080e-003, 3.533058e-002,  6.731481e-002,  9.339430e-002,
   1.135458e-001,  1.279245e-001,  1.361439e-001,  1.374618e-001,  1.339212e-001,  1.257410e-001,  1.147397e-001,  1.013346e-001,  8.624868e-002,
   6.842650e-002,  5.014312e-002,  3.088195e-002,  1.082044e-002,  -8.111322e-003, -2.675255e-002, -4.481194e-002, -6.168148e-002, -7.697756e-002,
   -8.950938e-002, -9.937547e-002, -1.063143e-001, -1.108610e-001, -1.130846e-001, -1.137385e-001, -1.131079e-001, -1.103790e-001, -1.063397e-001,
   -1.017369e-001, -9.633422e-002, -8.980022e-002, -8.223918e-002, -7.366070e-002, -6.456267e-002, -5.520378e-002, -4.477592e-002, -3.455095e-002,
   -2.477141e-002, -1.444846e-002, -5.134203e-003, 3.986291e-003,  1.358703e-002,  2.267270e-002,  3.193805e-002,  4.036000e-002,  4.722075e-002,
   5.376914e-002,  5.927965e-002,  6.378966e-002,  6.772552e-002,  7.117900e-002,  7.475348e-002,  7.751042e-002,  7.978749e-002,  8.096580e-002,
   8.104600e-002,  8.078002e-002,  7.946478e-002,  7.704405e-002,  7.472491e-002,  7.213703e-002,  6.846022e-002,  6.468923e-002,  6.072799e-002,
   5.627498e-002,  5.105749e-002,  4.570861e-002,  4.156578e-002,  3.735507e-002,  3.269376e-002,  2.791665e-002,  2.311310e-002,  1.853042e-002,
   1.394646e-002,  9.929325e-003,  6.043247e-003,  2.054935e-003,  -1.841048e-003, -5.745632e-003, -1.016518e-002, -1.330462e-002, -1.639998e-002,
   -1.984540e-002, -2.336333e-002, -2.704136e-002, -3.027176e-002, -3.354240e-002, -3.677033e-002, -4.058446e-002, -4.484417e-002, -4.759682e-002,
   -5.084941e-002, -5.429818e-002, -5.774795e-002, -6.062470e-002, -6.250695e-002, -6.459745e-002, -6.704703e-002, -6.857499e-002, -6.965070e-002,
   -7.074597e-002, -7.215960e-002, -7.211470e-002, -7.192852e-002, -7.185874e-002, -7.066754e-002, -6.899936e-002, -6.736284e-002, -6.466165e-002,
   -6.164115e-002, -5.857296e-002, -5.436931e-002, -5.010039e-002, -4.535452e-002, -3.988804e-002, -3.449618e-002, -2.836020e-002, -2.212858e-002,
   -1.547472e-002, -8.954541e-003, -2.535012e-003, 4.128329e-003,  1.053920e-002,  1.711540e-002,  2.338534e-002,  2.924300e-002,  3.552279e-002,
   4.168130e-002,  4.740185e-002,  5.301939e-002,  5.782601e-002,  6.240031e-002,  6.657105e-002,  7.024735e-002,  7.399709e-002,  7.689109e-002,
   7.967738e-002,  8.158660e-002,  8.314143e-002,  8.457268e-002,  8.460744e-002,  8.478982e-002,  8.495112e-002,  8.412648e-002,  8.291248e-002,
   8.144217e-002,  7.923192e-002,  7.676066e-002,  7.417096e-002,  7.119955e-002,  6.825478e-002,  6.457495e-002,  6.023473e-002,  5.575412e-002,
   5.169566e-002,  4.693907e-002,  4.188323e-002,  3.685779e-002,  3.128173e-002,  2.569002e-002,  2.038308e-002,  1.483897e-002,  8.877003e-003,
   2.688030e-003,  -2.741197e-003, -8.290472e-003, -1.422623e-002, -2.001177e-002, -2.543532e-002, -3.080157e-002, -3.633894e-002, -4.167820e-002,
   -4.606155e-002, -5.075269e-002, -5.540333e-002, -5.924835e-002, -6.245726e-002, -6.600031e-002, -6.868650e-002, -7.084773e-002, -7.273671e-002,
   -7.389852e-002, -7.487878e-002, -7.524029e-002, -7.474255e-002, -7.407999e-002, -7.259613e-002, -7.104394e-002, -6.841792e-002, -6.564814e-002,
   -6.238021e-002, -5.898563e-002, -5.491038e-002, -5.065509e-002, -4.624402e-002, -4.203314e-002, -3.789913e-002, -3.363404e-002, -2.949475e-002,
   -2.549986e-002, -2.178322e-002, -1.815861e-002, -1.504353e-002, -1.160480e-002, -8.864023e-003, -5.922494e-003, -3.420531e-003, -9.987396e-004,
   1.230515e-003,  3.087195e-003,  5.056426e-003,  6.588084e-003,  8.046189e-003,  9.373976e-003,  1.040771e-002,  1.174158e-002,  1.282667e-002,
   1.373572e-002,  1.468166e-002,  1.522524e-002,  1.584725e-002,  1.671026e-002,  1.724098e-002,  1.770623e-002,  1.801950e-002,  1.816463e-002,
   1.827345e-002,  1.859983e-002,  1.898470e-002,  1.888698e-002,  1.894233e-002,  1.909027e-002,  1.901929e-002,  1.891470e-002,  1.885301e-002,
   1.888202e-002,  1.860902e-002,  1.837130e-002,  1.826879e-002,  1.811034e-002,  1.765121e-002,  1.735133e-002,  1.716652e-002,  1.700131e-002,
   1.656082e-002,  1.617117e-002,  1.570243e-002,  1.545613e-002,  1.510207e-002,  1.480608e-002,  1.441838e-002,  1.410778e-002,  1.377689e-002,
   1.353286e-002,  1.343980e-002,  1.346744e-002,  1.345521e-002,  1.320992e-002,  1.306366e-002,  1.284477e-002,  1.271885e-002,  1.238879e-002,
   1.200176e-002,  1.150655e-002,  1.109537e-002,  1.083720e-002,  1.031358e-002,  9.565111e-003,  8.801930e-003,  8.079452e-003,  7.271431e-003,
   6.548226e-003,  6.026242e-003,  5.280815e-003,  4.592209e-003,  3.819072e-003,  2.880257e-003,  1.983226e-003,  1.140822e-003,  3.996909e-004,
   -8.522758e-005, -6.494040e-004, -1.385765e-003, -2.153876e-003, -2.883218e-003, -3.819219e-003, -4.556017e-003, -5.188247e-003, -5.653660e-003,
   -6.017518e-003, -6.380325e-003, -6.886456e-003, -7.514929e-003, -8.228115e-003, -8.785033e-003, -9.261756e-003, -9.600018e-003, -9.878417e-003,
   -1.013148e-002, -1.031248e-002, -1.052252e-002, -1.085787e-002, -1.130320e-002, -1.173121e-002, -1.204879e-002, -1.233928e-002, -1.245130e-002,
   -1.236927e-002, -1.221533e-002, -1.231641e-002, -1.271262e-002, -1.301432e-002, -1.307163e-002, -1.291921e-002, -1.258418e-002, -1.223215e-002,
   -1.199725e-002, -1.178477e-002, -1.139687e-002, -1.105983e-002, -1.071305e-002, -1.027994e-002, -9.744510e-003, -9.218520e-003, -8.857367e-003,
   -8.497478e-003, -7.943536e-003, -7.376532e-003, -6.777619e-003, -6.115300e-003, -5.627660e-003, -5.233202e-003, -4.874954e-003, -4.407527e-003,
   -4.022906e-003, -3.526863e-003, -3.070908e-003, -2.408599e-003, -1.908698e-003, -1.540239e-003, -1.271974e-003, -9.739660e-004, -5.589403e-004,
   -8.258355e-005, 5.415968e-004,  1.118237e-003,  1.569301e-003,  2.017566e-003,  2.445089e-003,  3.092905e-003,  3.609528e-003,  4.107092e-003,
   4.654387e-003,  5.327793e-003,  5.773269e-003,  6.292694e-003,  6.977780e-003,  7.589159e-003,  8.230404e-003,  9.010027e-003,  9.713868e-003,
   1.035827e-002,  1.075201e-002,  1.111499e-002,  1.140439e-002,  1.166118e-002,  1.198110e-002,  1.240441e-002,  1.278734e-002,  1.318441e-002,
   1.349859e-002,  1.357861e-002,  1.365388e-002,  1.380309e-002,  1.403954e-002,  1.421868e-002,  1.418233e-002,  1.411611e-002,  1.416000e-002,
   1.424730e-002,  1.409272e-002,  1.409251e-002,  1.419539e-002,  1.418713e-002,  1.421271e-002,  1.413665e-002,  1.403632e-002,  1.399163e-002,
   1.399067e-002,  1.396313e-002,  1.371654e-002,  1.333010e-002,  1.293880e-002,  1.256885e-002,  1.224894e-002,  1.199725e-002,  1.175304e-002,
   1.148493e-002,  1.119659e-002,  1.079604e-002,  1.015031e-002,  9.565293e-003,  9.019779e-003,  8.496733e-003,  8.051583e-003,  7.593983e-003,
   7.200224e-003,  6.621290e-003,  5.890945e-003,  5.285071e-003,  4.630048e-003,  3.924453e-003,  3.315777e-003,  2.738697e-003,  2.238671e-003,
   1.766340e-003,  1.187857e-003,  6.924309e-004,  2.707819e-004,  -2.683250e-004, -8.025090e-004, -1.230826e-003, -1.817614e-003, -2.325287e-003,
   -2.726808e-003, -3.156073e-003, -3.595694e-003, -3.975455e-003, -4.255906e-003, -4.455909e-003, -4.601438e-003, -4.721331e-003, -4.926394e-003,
   -5.114726e-003, -5.453687e-003, -5.946068e-003, -6.374388e-003, -6.705998e-003, -6.979633e-003, -7.202080e-003, -7.363996e-003, -7.512350e-003,
   -7.673691e-003, -7.799986e-003, -7.958815e-003, -8.296506e-003, -8.630880e-003, -9.057584e-003, -9.380145e-003, -9.623917e-003, -9.764959e-003,
   -9.842687e-003, -9.841396e-003, -9.732894e-003, -9.586204e-003, -9.512504e-003, -9.428227e-003, -9.238353e-003, -8.990154e-003, -8.803221e-003,
   -8.675061e-003, -8.784048e-003, -8.886083e-003, -8.957777e-003, -8.930264e-003, -8.835069e-003, -8.864927e-003, -8.827950e-003, -8.760685e-003,
   -8.613337e-003, -8.493304e-003, -8.308700e-003, -8.095132e-003, -7.842690e-003, -7.608056e-003, -7.521895e-003, -7.685235e-003, -7.866583e-003,
   -8.072438e-003, -8.285467e-003, -8.510732e-003, -8.618677e-003, -8.687487e-003, -8.776203e-003, -8.794228e-003, -8.749712e-003, -8.656180e-003,
   -8.498556e-003, -8.311921e-003, -8.176089e-003, -8.062720e-003, -8.131976e-003, -8.257884e-003, -8.278275e-003, -8.287908e-003, -8.303266e-003,
   -8.259429e-003, -8.199778e-003, -8.113108e-003, -7.985273e-003, -7.836651e-003, -7.664828e-003, -7.661636e-003, -7.691789e-003, -7.730387e-003,
   -7.757622e-003, -7.661235e-003, -7.541190e-003, -7.612368e-003, -7.805112e-003, -7.983787e-003, -8.132910e-003, -8.288107e-003, -8.331002e-003,
   -8.281455e-003, -8.271275e-003, -8.264693e-003, -8.275415e-003, -8.236136e-003, -8.088917e-003, -7.965373e-003, -7.827753e-003, -7.625517e-003,
   -7.388793e-003, -7.107577e-003, -6.794117e-003, -6.612974e-003, -6.477065e-003, -6.242760e-003, -5.981966e-003, -5.764776e-003, -5.448761e-003,
   -5.044742e-003, -4.580647e-003, -4.150102e-003, -3.751930e-003, -3.391930e-003, -3.000885e-003, -2.617643e-003, -2.231810e-003, -1.779358e-003,
   -1.298472e-003, -8.489956e-004, -4.351513e-004, -1.041706e-004, 9.963910e-005,  1.274792e-004,  1.508024e-004,  1.850784e-004,  2.374298e-004,
   3.362977e-004,  5.360913e-004,  7.358193e-004,  9.807954e-004,  1.232764e-003,  1.550029e-003,  1.955373e-003,  2.402896e-003,  2.840806e-003,
   3.311111e-003,  3.769763e-003,  4.249881e-003,  4.768687e-003,  5.326996e-003,  5.924390e-003,  6.497732e-003,  6.930072e-003,  7.176890e-003,
   7.361552e-003,  7.547584e-003,  7.707608e-003,  7.854872e-003,  8.028688e-003,  8.244274e-003,  8.449570e-003,  8.607686e-003,  8.791022e-003,
   8.857488e-003,  8.906268e-003,  8.998656e-003,  9.000183e-003,  9.024599e-003,  9.095320e-003,  9.233406e-003,  9.386764e-003,  9.648181e-003,
   9.944573e-003,  1.023837e-002,  1.053789e-002,  1.072921e-002,  1.068953e-002,  1.061984e-002,  1.061898e-002,  1.060712e-002,  1.067886e-002,
   1.074872e-002,  1.085869e-002,  1.100744e-002,  1.115670e-002,  1.128521e-002,  1.140377e-002,  1.158208e-002,  1.163734e-002,  1.148630e-002,
   1.132360e-002,  1.115935e-002,  1.098737e-002,  1.082004e-002,  1.068577e-002,  1.057331e-002,  1.046538e-002,  1.037540e-002,  1.021240e-002,
   9.990249e-003,  9.671927e-003,  9.360159e-003,  9.098900e-003,  8.709533e-003,  8.166034e-003,  7.653474e-003,  7.140204e-003,  6.670485e-003,
   6.258721e-003,  5.855775e-003,  5.526621e-003,  5.285678e-003,  5.136632e-003,  5.061678e-003,  5.032726e-003,  5.007274e-003,  5.036058e-003,
   5.136255e-003,  5.269003e-003,  5.416654e-003,  5.604207e-003,  5.737814e-003,  5.906916e-003,  6.010574e-003,  5.934993e-003,  5.821985e-003,
   5.680258e-003,  5.548788e-003,  5.412331e-003,  5.255356e-003,  5.126781e-003,  5.021458e-003,  4.969456e-003,  4.924835e-003,  4.848574e-003,
   4.676046e-003,  4.482570e-003,  4.306927e-003,  4.143328e-003,  4.031528e-003,  3.957084e-003,  3.870657e-003,  3.743736e-003,  3.578103e-003,
   3.399313e-003,  3.195686e-003,  3.003193e-003,  2.831148e-003,  2.651942e-003,  2.570384e-003,  2.414776e-003,  2.207626e-003,  2.028747e-003,
   1.804843e-003,  1.437045e-003,  1.085409e-003,  7.768265e-004,  5.257356e-004,  2.832211e-004,  7.939926e-005,  -8.185038e-005, -2.642934e-004,
   -3.893426e-004, -4.803039e-004, -5.583388e-004, -6.912243e-004, -8.922830e-004, -1.103698e-003, -1.313241e-003, -1.539198e-003, -1.744262e-003,
   -1.898197e-003, -2.000999e-003, -2.089315e-003, -2.188149e-003, -2.387017e-003, -2.549236e-003, -2.688044e-003, -2.787079e-003, -2.841859e-003,
   -2.930464e-003, -3.068594e-003, -3.248214e-003, -3.437049e-003, -3.606165e-003, -3.747210e-003, -3.915627e-003, -4.083446e-003, -4.223562e-003,
   -4.342259e-003, -4.500291e-003, -4.674399e-003, -4.828653e-003, -4.987135e-003, -5.080731e-003, -5.196160e-003, -5.313727e-003, -5.406999e-003,
   -5.497271e-003, -5.611920e-003, -5.699726e-003, -5.774775e-003, -5.827751e-003, -5.860136e-003, -5.835875e-003, -5.812617e-003, -5.794548e-003,
   -5.754962e-003, -5.696424e-003, -5.627999e-003, -5.525310e-003, -5.407427e-003, -5.340450e-003, -5.273184e-003, -5.228324e-003, -5.194937e-003,
   -5.141431e-003, -5.166114e-003, -5.156070e-003, -5.140736e-003, -5.125548e-003, -5.113386e-003, -5.027214e-003, -4.929130e-003, -4.829162e-003,
   -4.780176e-003, -4.767687e-003, -4.764598e-003, -4.805533e-003, -4.842525e-003, -4.877159e-003, -4.903936e-003, -4.925239e-003, -4.910348e-003,
   -4.901364e-003, -4.865290e-003, -4.795979e-003, -4.682319e-003, -4.548763e-003, -4.441000e-003, -4.335957e-003, -4.195996e-003, -4.026592e-003,
   -3.855323e-003, -3.679350e-003, -3.615158e-003, -3.563790e-003, -3.507993e-003, -3.400825e-003, -3.313285e-003, -3.210967e-003, -3.132612e-003,
   -3.060857e-003, -2.992745e-003, -2.928459e-003, -2.873708e-003, -2.890812e-003, -2.932178e-003, -3.007318e-003, -3.126197e-003, -3.259832e-003,
   -3.387900e-003, -3.523348e-003, -3.674451e-003, -3.827247e-003, -3.969389e-003, -4.095850e-003, -4.199474e-003, -4.295658e-003, -4.376171e-003,
   -4.451044e-003, -4.484057e-003, -4.466344e-003, -4.433656e-003, -4.410333e-003, -4.413169e-003, -4.379511e-003, -4.319999e-003, -4.251073e-003,
   -4.117601e-003, -3.926462e-003, -3.756393e-003, -3.564936e-003, -3.376022e-003, -3.148865e-003, -2.893821e-003, -2.669323e-003, -2.422560e-003,
   -2.149523e-003, -1.850924e-003, -1.550038e-003, -1.295857e-003, -1.137224e-003, -1.010534e-003, -9.196924e-004, -8.734266e-004, -8.723178e-004,
   -8.866582e-004, -9.112268e-004, -9.921129e-004, -1.099246e-003, -1.222787e-003, -1.362810e-003, -1.491410e-003, -1.596758e-003, -1.705382e-003,
   -1.814625e-003, -1.943649e-003, -2.043062e-003, -2.134246e-003, -2.252688e-003, -2.374122e-003, -2.431223e-003, -2.439711e-003, -2.415068e-003,
   -2.330210e-003, -2.182512e-003, -1.979074e-003, -1.746538e-003, -1.541191e-003, -1.402165e-003, -1.279310e-003, -1.192885e-003, -1.118719e-003,
   -1.065302e-003, -1.025728e-003, -9.944830e-004, -9.799140e-004, -9.764293e-004, -9.627254e-004, -9.227947e-004, -8.766555e-004, -8.536206e-004,
   -8.899056e-004, -9.019655e-004, -9.178436e-004, -9.004027e-004, -8.456344e-004, -7.583629e-004, -6.377012e-004, -4.864260e-004, -3.816787e-004,
   -2.541675e-004, -9.779120e-005, 1.130500e-004,  3.961810e-004,  6.761234e-004,  9.783680e-004,  1.278447e-003,  1.638380e-003,  2.012629e-003,
   2.421799e-003,  2.842232e-003,  3.264205e-003,  3.729394e-003,  4.231021e-003,  4.765229e-003,  5.282722e-003,  5.788358e-003,  6.289456e-003,
   6.749198e-003,  7.024100e-003,  7.207942e-003,  7.334569e-003,  7.455426e-003,  7.560493e-003,  7.665876e-003,  7.734223e-003,  7.781479e-003,
   7.816486e-003,  7.813068e-003,  7.785428e-003,  7.735542e-003,  7.681516e-003,  7.602725e-003,  7.524671e-003,  7.445705e-003,  7.304258e-003,
   7.137539e-003,  6.980915e-003,  6.814667e-003,  6.628111e-003,  6.451876e-003,  6.272940e-003,  6.108483e-003,  5.931899e-003,  5.721106e-003,
   5.449523e-003,  5.169551e-003,  4.928307e-003,  4.714848e-003,  4.510251e-003,  4.303939e-003,  4.094503e-003,  3.880572e-003,  3.621729e-003,
   3.359829e-003,  3.141626e-003,  2.931855e-003,  2.740337e-003,  2.588937e-003,  2.431991e-003,  2.313353e-003,  2.210978e-003,  2.126756e-003,
   1.990951e-003,  1.822069e-003,  1.731355e-003,  1.663912e-003,  1.608721e-003,  1.581127e-003,  1.560562e-003,  1.561507e-003,  1.570561e-003,
   1.602764e-003,  1.614179e-003,  1.595199e-003,  1.595560e-003,  1.595194e-003,  1.592725e-003,  1.629488e-003,  1.653593e-003,  1.649492e-003,
   1.604501e-003,  1.520757e-003,  1.413421e-003,  1.295971e-003,  1.182100e-003,  1.073205e-003,  9.057418e-004,  7.393787e-004,  5.609143e-004,
   3.536729e-004,  1.109452e-004,  -1.645280e-004, -4.681189e-004, -7.657539e-004, -1.086370e-003, -1.387928e-003, -1.696252e-003, -1.997915e-003,
   -2.281441e-003, -2.574554e-003, -2.926901e-003, -3.256042e-003, -3.573890e-003, -3.882270e-003, -4.177003e-003, -4.394570e-003, -4.577888e-003,
   -4.678746e-003, -4.708638e-003, -4.794129e-003, -4.880412e-003, -4.958695e-003, -5.042706e-003, -5.125962e-003, -5.227551e-003, -5.354214e-003,
   -5.447163e-003, -5.527750e-003, -5.604583e-003, -5.724183e-003, -5.882734e-003, -6.076476e-003, -6.297282e-003, -6.535573e-003, -6.785053e-003,
   -6.984168e-003, -7.067299e-003, -7.118797e-003, -7.146493e-003, -7.278332e-003, -7.427251e-003, -7.589382e-003, -7.779550e-003, -7.965826e-003,
   -8.132341e-003, -8.298978e-003, -8.408957e-003, -8.277868e-003, -8.085832e-003, -7.844389e-003, -7.576261e-003, -7.286521e-003, -6.935731e-003,
   -6.579726e-003, -6.345295e-003, -6.136374e-003, -5.949192e-003, -5.728288e-003, -5.154815e-003, -4.592246e-003, -4.013779e-003, -3.421577e-003,
   -2.848376e-003, -2.301668e-003, -1.778515e-003, -1.287604e-003, -8.249034e-004, -3.974324e-004, 6.021932e-018},
  {0.000000e+000,  -1.419539e-001, -1.036124e-001, -6.792405e-002, -2.708800e-002, 1.517038e-002,  4.019696e-002,  5.969302e-002,  7.318021e-002,
   7.955336e-002,  7.740017e-002,  6.786770e-002,  5.264640e-002,  3.606222e-002,  2.435019e-002,  1.902869e-002,  1.784040e-002,  2.015166e-002,
   2.176854e-002,  2.380658e-002,  2.387411e-002,  1.935135e-002,  1.038963e-002,  -1.001266e-003, -1.433260e-002, -2.778570e-002, -4.081063e-002,
   -5.304675e-002, -6.476809e-002, -7.332503e-002, -7.868723e-002, -8.142049e-002, -8.262070e-002, -8.287768e-002, -8.119369e-002, -7.735994e-002,
   -7.207675e-002, -6.624884e-002, -5.734553e-002, -4.611067e-002, -3.305934e-002, -2.016471e-002, -6.374361e-003, 8.127395e-003,  2.130722e-002,
   3.278650e-002,  4.353354e-002,  5.205411e-002,  5.887513e-002,  6.586277e-002,  7.168401e-002,  7.693746e-002,  8.264459e-002,  8.641797e-002,
   9.037891e-002,  9.304619e-002,  9.399092e-002,  9.404765e-002,  9.111092e-002,  8.638032e-002,  7.929395e-002,  7.036889e-002,  5.953161e-002,
   4.825266e-002,  3.633480e-002,  2.367534e-002,  1.052038e-002,  -2.657346e-003, -1.589899e-002, -2.896741e-002, -4.152623e-002, -5.338227e-002,
   -6.409219e-002, -7.406542e-002, -8.205233e-002, -9.017282e-002, -9.689866e-002, -1.023482e-001, -1.055274e-001, -1.067142e-001, -1.067523e-001,
   -1.041731e-001, -1.007724e-001, -9.483050e-002, -8.787849e-002, -7.957985e-002, -6.943558e-002, -5.877117e-002, -4.777642e-002, -3.635834e-002,
   -2.434076e-002, -1.169129e-002, 4.245005e-004,  1.149325e-002,  2.258445e-002,  3.241976e-002,  4.132175e-002,  4.970854e-002,  5.553423e-002,
   6.049711e-002,  6.509272e-002,  6.927640e-002,  7.257623e-002,  7.518055e-002,  7.756234e-002,  7.945192e-002,  8.039453e-002,  8.097967e-002,
   8.128767e-002,  8.108285e-002,  7.982047e-002,  7.824626e-002,  7.656209e-002,  7.350573e-002,  7.002981e-002,  6.663025e-002,  6.219666e-002,
   5.728286e-002,  5.233078e-002,  4.657957e-002,  4.063100e-002,  3.430746e-002,  2.768315e-002,  2.085859e-002,  1.364530e-002,  6.248875e-003,
   -1.250127e-003, -8.652431e-003, -1.588737e-002, -2.317202e-002, -2.976850e-002, -3.625468e-002, -4.235110e-002, -4.798755e-002, -5.290627e-002,
   -5.679774e-002, -5.985921e-002, -6.230819e-002, -6.392358e-002, -6.487407e-002, -6.509388e-002, -6.480806e-002, -6.428655e-002, -6.324443e-002,
   -6.185623e-002, -6.007233e-002, -5.821870e-002, -5.653940e-002, -5.441352e-002, -5.258841e-002, -5.119751e-002, -4.981180e-002, -4.884794e-002,
   -4.856944e-002, -4.807488e-002, -4.738218e-002, -4.656297e-002, -4.545571e-002, -4.451550e-002, -4.302666e-002, -4.098589e-002, -3.906619e-002,
   -3.745225e-002, -3.521159e-002, -3.305556e-002, -3.075919e-002, -2.816611e-002, -2.553889e-002, -2.286192e-002, -2.012358e-002, -1.677399e-002,
   -1.321086e-002, -9.671028e-003, -6.194379e-003, -2.438305e-003, 1.305949e-003,  4.998369e-003,  9.002757e-003,  1.307251e-002,  1.685137e-002,
   2.035346e-002,  2.406746e-002,  2.767851e-002,  3.103426e-002,  3.420898e-002,  3.733744e-002,  4.021906e-002,  4.268473e-002,  4.501986e-002,
   4.693454e-002,  4.883143e-002,  5.010330e-002,  5.092922e-002,  5.144524e-002,  5.156375e-002,  5.134105e-002,  5.069609e-002,  4.997770e-002,
   4.896712e-002,  4.802644e-002,  4.688289e-002,  4.557125e-002,  4.409246e-002,  4.265972e-002,  4.112532e-002,  3.964203e-002,  3.808217e-002,
   3.666312e-002,  3.534755e-002,  3.392347e-002,  3.280277e-002,  3.155641e-002,  3.068470e-002,  2.954000e-002,  2.834969e-002,  2.719150e-002,
   2.587153e-002,  2.505802e-002,  2.408689e-002,  2.314924e-002,  2.221252e-002,  2.126470e-002,  2.086830e-002,  2.040811e-002,  2.010343e-002,
   1.988996e-002,  1.935163e-002,  1.899015e-002,  1.861569e-002,  1.821986e-002,  1.796585e-002,  1.752384e-002,  1.709545e-002,  1.650732e-002,
   1.589593e-002,  1.520503e-002,  1.440425e-002,  1.365198e-002,  1.264166e-002,  1.127104e-002,  9.841914e-003,  8.339769e-003,  6.712574e-003,
   4.933912e-003,  2.884468e-003,  5.985493e-004,  -1.708059e-003, -3.991786e-003, -6.257966e-003, -8.585060e-003, -1.100853e-002, -1.385632e-002,
   -1.659416e-002, -1.910374e-002, -2.157096e-002, -2.398674e-002, -2.617890e-002, -2.825907e-002, -3.018520e-002, -3.190477e-002, -3.336141e-002,
   -3.466525e-002, -3.578901e-002, -3.680746e-002, -3.771924e-002, -3.827121e-002, -3.877290e-002, -3.913692e-002, -3.950250e-002, -3.981678e-002,
   -4.004068e-002, -4.023469e-002, -4.030622e-002, -4.033762e-002, -4.025896e-002, -4.013123e-002, -3.998137e-002, -3.978413e-002, -3.967819e-002,
   -3.939395e-002, -3.883163e-002, -3.810040e-002, -3.757120e-002, -3.705130e-002, -3.640822e-002, -3.584473e-002, -3.522015e-002, -3.416148e-002,
   -3.278193e-002, -3.134782e-002, -2.977984e-002, -2.829860e-002, -2.696610e-002, -2.551638e-002, -2.404139e-002, -2.224460e-002, -2.022519e-002,
   -1.829419e-002, -1.649663e-002, -1.473209e-002, -1.310277e-002, -1.167724e-002, -1.034436e-002, -8.846850e-003, -7.353908e-003, -5.725595e-003,
   -4.293107e-003, -3.148903e-003, -2.236444e-003, -1.645302e-003, -1.233031e-003, -4.919654e-004, 1.413101e-004,  5.636048e-004,  1.077949e-003,
   1.506724e-003,  1.655457e-003,  1.694085e-003,  1.580385e-003,  1.407083e-003,  1.290979e-003,  1.241103e-003,  1.164737e-003,  7.979683e-004,
   6.047147e-004,  5.998700e-004,  4.217476e-004,  2.288406e-004,  1.315521e-004,  1.019066e-004,  1.381810e-004,  4.759979e-004,  1.007209e-003,
   1.238664e-003,  1.383367e-003,  1.443117e-003,  1.410411e-003,  1.365550e-003,  1.273418e-003,  1.424101e-003,  1.407576e-003,  1.630785e-003,
   1.940799e-003,  2.176384e-003,  2.280105e-003,  2.394124e-003,  2.835923e-003,  3.174333e-003,  3.526331e-003,  3.968612e-003,  4.578331e-003,
   5.055281e-003,  5.761884e-003,  6.541719e-003,  7.434230e-003,  8.211070e-003,  9.345373e-003,  1.054248e-002,  1.162063e-002,  1.261968e-002,
   1.374627e-002,  1.506815e-002,  1.660291e-002,  1.806392e-002,  1.970821e-002,  2.139701e-002,  2.289452e-002,  2.448306e-002,  2.601973e-002,
   2.743160e-002,  2.882312e-002,  3.021573e-002,  3.158087e-002,  3.285834e-002,  3.407062e-002,  3.516235e-002,  3.628794e-002,  3.720631e-002,
   3.800676e-002,  3.885607e-002,  3.964268e-002,  4.028641e-002,  4.062831e-002,  4.108059e-002,  4.148136e-002,  4.168244e-002,  4.176866e-002,
   4.181152e-002,  4.198007e-002,  4.218633e-002,  4.237012e-002,  4.253384e-002,  4.259278e-002,  4.243740e-002,  4.206305e-002,  4.150209e-002,
   4.086748e-002,  4.016169e-002,  3.960730e-002,  3.887417e-002,  3.806509e-002,  3.697609e-002,  3.571246e-002,  3.438925e-002,  3.301974e-002,
   3.150530e-002,  2.962946e-002,  2.769375e-002,  2.577277e-002,  2.379602e-002,  2.163412e-002,  1.946542e-002,  1.734635e-002,  1.509087e-002,
   1.262924e-002,  1.015724e-002,  7.902637e-003,  5.665930e-003,  3.406363e-003,  1.172860e-003,  -9.998845e-004, -3.263325e-003, -5.638867e-003,
   -8.192518e-003, -1.071512e-002, -1.299464e-002, -1.505132e-002, -1.706454e-002, -1.902563e-002, -2.067841e-002, -2.190756e-002, -2.302112e-002,
   -2.424621e-002, -2.530534e-002, -2.628679e-002, -2.722248e-002, -2.806121e-002, -2.894963e-002, -2.989156e-002, -3.077421e-002, -3.140256e-002,
   -3.212894e-002, -3.264985e-002, -3.302154e-002, -3.324528e-002, -3.348531e-002, -3.370481e-002, -3.382639e-002, -3.389419e-002, -3.400893e-002,
   -3.426127e-002, -3.452348e-002, -3.477738e-002, -3.491843e-002, -3.492807e-002, -3.476538e-002, -3.436834e-002, -3.393744e-002, -3.331573e-002,
   -3.268536e-002, -3.194480e-002, -3.123312e-002, -3.047864e-002, -2.961140e-002, -2.868011e-002, -2.774287e-002, -2.679371e-002, -2.586089e-002,
   -2.482176e-002, -2.366655e-002, -2.243803e-002, -2.125467e-002, -1.989082e-002, -1.853484e-002, -1.720170e-002, -1.585174e-002, -1.459108e-002,
   -1.324508e-002, -1.193631e-002, -1.071926e-002, -9.540640e-003, -8.517981e-003, -7.488759e-003, -6.416223e-003, -5.386322e-003, -4.353601e-003,
   -3.370936e-003, -2.506711e-003, -1.788548e-003, -1.242683e-003, -6.646805e-004, -1.758541e-004, 3.037850e-004,  7.090468e-004,  9.946048e-004,
   1.409651e-003,  1.777146e-003,  2.075085e-003,  2.318047e-003,  2.646397e-003,  3.001634e-003,  3.335471e-003,  3.609256e-003,  3.852900e-003,
   3.941584e-003,  3.848084e-003,  3.729051e-003,  3.693554e-003,  3.659795e-003,  3.448675e-003,  3.068618e-003,  2.594031e-003,  2.213261e-003,
   1.758666e-003,  1.230598e-003,  5.974798e-004,  1.002171e-004,  -3.511939e-004, -7.997501e-004, -1.291263e-003, -1.827102e-003, -2.317758e-003,
   -2.901357e-003, -3.432364e-003, -3.863615e-003, -4.343495e-003, -4.930273e-003, -5.421391e-003, -5.859212e-003, -6.179578e-003, -6.463739e-003,
   -6.845580e-003, -7.266627e-003, -7.589516e-003, -7.702766e-003, -7.427188e-003, -7.142174e-003, -6.800878e-003, -6.367102e-003, -5.864443e-003,
   -5.382831e-003, -4.881120e-003, -4.481691e-003, -4.207930e-003, -4.041625e-003, -3.913481e-003, -3.798549e-003, -3.659885e-003, -3.447355e-003,
   -3.227707e-003, -3.052418e-003, -2.849870e-003, -2.540188e-003, -2.169183e-003, -1.623437e-003, -9.806347e-004, -2.884090e-004, 4.951020e-004,
   1.268905e-003,  2.020584e-003,  2.804607e-003,  3.686111e-003,  4.623393e-003,  5.558912e-003,  6.590802e-003,  7.683101e-003,  8.814030e-003,
   9.926143e-003,  1.098814e-002,  1.202529e-002,  1.312637e-002,  1.433848e-002,  1.557870e-002,  1.672425e-002,  1.785887e-002,  1.900206e-002,
   2.008627e-002,  2.110877e-002,  2.206490e-002,  2.294132e-002,  2.383328e-002,  2.463579e-002,  2.523893e-002,  2.572642e-002,  2.616126e-002,
   2.653914e-002,  2.681667e-002,  2.698384e-002,  2.701180e-002,  2.705757e-002,  2.710002e-002,  2.717537e-002,  2.721729e-002,  2.722810e-002,
   2.723821e-002,  2.725637e-002,  2.729546e-002,  2.723936e-002,  2.713780e-002,  2.694573e-002,  2.668998e-002,  2.644269e-002,  2.620186e-002,
   2.597265e-002,  2.581422e-002,  2.569973e-002,  2.557705e-002,  2.544458e-002,  2.522740e-002,  2.494625e-002,  2.455333e-002,  2.410170e-002,
   2.351828e-002,  2.282917e-002,  2.211129e-002,  2.135670e-002,  2.053562e-002,  1.963763e-002,  1.866019e-002,  1.760652e-002,  1.658837e-002,
   1.564097e-002,  1.469566e-002,  1.369593e-002,  1.267910e-002,  1.164322e-002,  1.050212e-002,  9.382651e-003,  8.228941e-003,  7.003910e-003,
   5.715816e-003,  4.385959e-003,  3.187868e-003,  2.077364e-003,  1.056469e-003,  1.056810e-004,  -8.166558e-004, -1.749681e-003, -2.671533e-003,
   -3.560762e-003, -4.396105e-003, -5.183609e-003, -5.961650e-003, -6.726190e-003, -7.532381e-003, -8.388815e-003, -9.148416e-003, -1.001064e-002,
   -1.090672e-002, -1.186608e-002, -1.281656e-002, -1.391314e-002, -1.509008e-002, -1.630194e-002, -1.748983e-002, -1.866812e-002, -1.990342e-002,
   -2.124323e-002, -2.266669e-002, -2.409413e-002, -2.540345e-002, -2.651204e-002, -2.759958e-002, -2.860726e-002, -2.963686e-002, -3.066199e-002,
   -3.170440e-002, -3.271547e-002, -3.366741e-002, -3.451744e-002, -3.526645e-002, -3.597432e-002, -3.654182e-002, -3.686749e-002, -3.708588e-002,
   -3.716189e-002, -3.717350e-002, -3.712003e-002, -3.705128e-002, -3.693900e-002, -3.687041e-002, -3.681770e-002, -3.672809e-002, -3.663553e-002,
   -3.660483e-002, -3.660009e-002, -3.643445e-002, -3.608549e-002, -3.582227e-002, -3.563342e-002, -3.544855e-002, -3.533970e-002, -3.521676e-002,
   -3.507009e-002, -3.489187e-002, -3.474534e-002, -3.462618e-002, -3.442417e-002, -3.418774e-002, -3.397048e-002, -3.368356e-002, -3.338937e-002,
   -3.305459e-002, -3.269441e-002, -3.198629e-002, -3.111630e-002, -3.022737e-002, -2.931267e-002, -2.834872e-002, -2.726518e-002, -2.609620e-002,
   -2.487626e-002, -2.359541e-002, -2.236799e-002, -2.118645e-002, -2.003864e-002, -1.887809e-002, -1.777604e-002, -1.671133e-002, -1.569087e-002,
   -1.470441e-002, -1.374682e-002, -1.284282e-002, -1.201802e-002, -1.114242e-002, -1.026903e-002, -9.444259e-003, -8.502198e-003, -7.545191e-003,
   -6.625737e-003, -5.724872e-003, -4.875653e-003, -4.011697e-003, -3.114425e-003, -2.133028e-003, -1.132353e-003, -7.581203e-006, 1.138889e-003,
   2.263788e-003,  3.370658e-003,  4.518324e-003,  5.673439e-003,  6.774203e-003,  7.822776e-003,  8.848177e-003,  9.819092e-003,  1.071289e-002,
   1.154698e-002,  1.233961e-002,  1.308728e-002,  1.368194e-002,  1.416295e-002,  1.455475e-002,  1.490606e-002,  1.526442e-002,  1.561591e-002,
   1.594705e-002,  1.624214e-002,  1.677711e-002,  1.738704e-002,  1.801871e-002,  1.862352e-002,  1.921178e-002,  1.969546e-002,  2.012506e-002,
   2.044887e-002,  2.084089e-002,  2.135367e-002,  2.194371e-002,  2.262269e-002,  2.341510e-002,  2.427020e-002,  2.509585e-002,  2.587514e-002,
   2.668172e-002,  2.745540e-002,  2.812808e-002,  2.872863e-002,  2.924824e-002,  2.970274e-002,  3.004808e-002,  3.029362e-002,  3.046823e-002,
   3.055698e-002,  3.058566e-002,  3.056395e-002,  3.047943e-002,  3.038018e-002,  3.015302e-002,  2.981492e-002,  2.940199e-002,  2.894101e-002,
   2.849902e-002,  2.808541e-002,  2.770490e-002,  2.731710e-002,  2.688582e-002,  2.647155e-002,  2.608558e-002,  2.591296e-002,  2.581973e-002,
   2.575380e-002,  2.571715e-002,  2.572992e-002,  2.577940e-002,  2.589100e-002,  2.607847e-002,  2.634906e-002,  2.659737e-002,  2.681429e-002,
   2.698701e-002,  2.714503e-002,  2.725628e-002,  2.729188e-002,  2.723950e-002,  2.706785e-002,  2.679017e-002,  2.632206e-002,  2.570716e-002,
   2.502466e-002,  2.428319e-002,  2.334337e-002,  2.231898e-002,  2.122946e-002,  2.013992e-002,  1.905499e-002,  1.799630e-002,  1.693870e-002,
   1.588512e-002,  1.485546e-002,  1.376223e-002,  1.264511e-002,  1.151455e-002,  1.043219e-002,  9.414249e-003,  8.489298e-003,  7.670184e-003,
   6.923129e-003,  6.231918e-003,  5.602638e-003,  5.008505e-003,  4.501276e-003,  4.072697e-003,  3.668189e-003,  3.220896e-003,  2.748418e-003,
   2.191690e-003,  1.597310e-003,  9.583032e-004,  2.915937e-004,  -3.414514e-004, -1.006103e-003, -1.716042e-003, -2.454044e-003, -3.131360e-003,
   -3.851934e-003, -4.556372e-003, -5.288167e-003, -6.098473e-003, -6.879084e-003, -7.646168e-003, -8.386765e-003, -9.097550e-003, -9.790325e-003,
   -1.046676e-002, -1.111886e-002, -1.174480e-002, -1.229662e-002, -1.275620e-002, -1.311655e-002, -1.344013e-002, -1.370861e-002, -1.395867e-002,
   -1.419176e-002, -1.438439e-002, -1.452059e-002, -1.456022e-002, -1.447935e-002, -1.432253e-002, -1.405163e-002, -1.376406e-002, -1.351821e-002,
   -1.326792e-002, -1.302730e-002, -1.276939e-002, -1.248687e-002, -1.210445e-002, -1.169238e-002, -1.128910e-002, -1.087348e-002, -1.046596e-002,
   -1.003700e-002, -9.591587e-003, -9.137892e-003, -8.684494e-003, -8.265109e-003, -7.879819e-003, -7.487533e-003, -7.078767e-003, -6.663434e-003,
   -6.218614e-003, -5.754517e-003, -5.350267e-003, -4.991624e-003, -4.649861e-003, -4.300304e-003, -3.951166e-003, -3.712821e-003, -3.546430e-003,
   -3.414193e-003, -3.331016e-003, -3.299512e-003, -3.278189e-003, -3.264178e-003, -3.251670e-003, -3.279345e-003, -3.358939e-003, -3.549348e-003,
   -3.799394e-003, -4.082149e-003, -4.391320e-003, -4.710511e-003, -5.044619e-003, -5.410087e-003, -5.711682e-003, -5.996753e-003, -6.340770e-003,
   -6.584797e-003, -6.727178e-003, -6.768959e-003, -6.777004e-003, -6.771874e-003, -6.786380e-003, -6.778971e-003, -6.805732e-003, -6.859159e-003,
   -6.962634e-003, -7.052824e-003, -7.162723e-003, -7.256644e-003, -7.347714e-003, -7.450831e-003, -7.590599e-003, -7.678282e-003, -7.770598e-003,
   -7.932179e-003, -8.099055e-003, -8.254360e-003, -8.401964e-003, -8.529252e-003, -8.638737e-003, -8.706753e-003, -8.708989e-003, -8.640035e-003,
   -8.552731e-003, -8.461409e-003, -8.355552e-003, -8.320266e-003, -8.273267e-003, -8.183507e-003, -8.035477e-003, -7.841541e-003, -7.603160e-003,
   -7.317098e-003, -7.023905e-003, -6.754152e-003, -6.494216e-003, -6.191246e-003, -5.855130e-003, -5.490166e-003, -5.107889e-003, -4.692356e-003,
   -4.183558e-003, -3.597480e-003, -3.021860e-003, -2.368777e-003, -1.732934e-003, -1.128342e-003, -5.544300e-004, -2.789279e-005, 4.621089e-004,
   9.479503e-004,  1.355681e-003,  1.661723e-003,  1.846546e-003,  1.966050e-003,  2.029690e-003,  2.058399e-003,  2.069139e-003,  2.085198e-003,
   2.086770e-003,  2.118438e-003,  2.191080e-003,  2.283026e-003,  2.280907e-003,  2.282985e-003,  2.254391e-003,  2.112161e-003,  1.946159e-003,
   1.757909e-003,  1.599493e-003,  1.512843e-003,  1.589365e-003,  1.736455e-003,  1.947146e-003,  2.212924e-003,  2.511569e-003,  2.772376e-003,
   3.034046e-003,  3.178168e-003,  3.165527e-003,  3.055279e-003,  2.938614e-003,  3.061092e-003,  3.094326e-003,  3.032048e-003,  2.882782e-003,
   2.681154e-003,  2.409797e-003,  2.075953e-003,  1.665721e-003,  1.188743e-003,  6.284173e-004,  2.064357e-017},
  {0.000000e+000,  -5.884035e-003, 1.206050e-002,  3.049206e-002,  3.003751e-002,  1.966938e-002,  1.709589e-002,  1.097572e-002,  5.710203e-003,
   3.384460e-003,  5.629450e-003,  1.143536e-002,  1.917816e-002,  2.587902e-002,  2.589293e-002,  1.871079e-002,  5.688994e-003,  -1.257538e-002,
   -3.206193e-002, -5.227155e-002, -6.826732e-002, -7.666923e-002, -7.778825e-002, -7.387267e-002, -6.796031e-002, -5.995261e-002, -4.956054e-002,
   -3.672650e-002, -2.252167e-002, -8.694235e-003, 4.488508e-003,  1.696310e-002,  2.825635e-002,  3.791796e-002,  4.659577e-002,  5.390258e-002,
   5.931234e-002,  6.192430e-002,  6.156818e-002,  5.863152e-002,  5.357603e-002,  4.669202e-002,  3.916060e-002,  3.117202e-002,  2.359120e-002,
   1.704662e-002,  1.212091e-002,  8.710634e-003,  5.831097e-003,  3.360740e-003,  5.391114e-004,  -3.764149e-003, -9.071557e-003, -1.531453e-002,
   -2.255599e-002, -2.966411e-002, -3.601688e-002, -4.185548e-002, -4.654736e-002, -4.908090e-002, -4.971211e-002, -4.805107e-002, -4.496298e-002,
   -4.147839e-002, -3.795349e-002, -3.409726e-002, -2.930175e-002, -2.347795e-002, -1.686408e-002, -1.021798e-002, -3.376739e-003, 3.754763e-003,
   1.130456e-002,  1.885608e-002,  2.589634e-002,  3.323095e-002,  4.051716e-002,  4.714532e-002,  5.248908e-002,  5.655314e-002,  5.943179e-002,
   6.044005e-002,  6.046374e-002,  5.946990e-002,  5.665442e-002,  5.263206e-002,  4.804912e-002,  4.197308e-002,  3.557421e-002,  2.879640e-002,
   2.130866e-002,  1.412141e-002,  6.402630e-003,  -3.954837e-004, -6.820323e-003, -1.268624e-002, -1.766589e-002, -2.165018e-002, -2.393816e-002,
   -2.563379e-002, -2.677766e-002, -2.823566e-002, -2.937754e-002, -3.041117e-002, -3.146949e-002, -3.267914e-002, -3.384882e-002, -3.490533e-002,
   -3.612919e-002, -3.728481e-002, -3.788315e-002, -3.844097e-002, -3.912957e-002, -3.894780e-002, -3.844641e-002, -3.738447e-002, -3.592443e-002,
   -3.402646e-002, -3.156060e-002, -2.857174e-002, -2.479943e-002, -2.073766e-002, -1.614759e-002, -1.124309e-002, -6.154171e-003, -8.895209e-004,
   4.301080e-003,  9.167609e-003,  1.394155e-002,  1.858114e-002,  2.283719e-002,  2.696660e-002,  3.068767e-002,  3.329175e-002,  3.510834e-002,
   3.621983e-002,  3.628220e-002,  3.552816e-002,  3.418535e-002,  3.208951e-002,  2.929572e-002,  2.604667e-002,  2.294167e-002,  1.937953e-002,
   1.562590e-002,  1.189731e-002,  8.045938e-003,  4.237038e-003,  4.310596e-004,  -2.706980e-003, -5.062185e-003, -7.028978e-003, -8.336149e-003,
   -8.766212e-003, -8.931890e-003, -8.995374e-003, -9.001025e-003, -8.741414e-003, -8.518932e-003, -8.407627e-003, -8.284246e-003, -8.117318e-003,
   -7.625531e-003, -7.526594e-003, -7.456860e-003, -7.662614e-003, -7.723305e-003, -7.689266e-003, -7.542797e-003, -7.756374e-003, -8.293640e-003,
   -8.805057e-003, -9.057601e-003, -9.720454e-003, -1.066413e-002, -1.172893e-002, -1.242470e-002, -1.312386e-002, -1.394897e-002, -1.488869e-002,
   -1.518750e-002, -1.563231e-002, -1.633437e-002, -1.684247e-002, -1.722660e-002, -1.777575e-002, -1.780741e-002, -1.778761e-002, -1.763925e-002,
   -1.714208e-002, -1.649148e-002, -1.562869e-002, -1.416601e-002, -1.295431e-002, -1.101993e-002, -8.948106e-003, -6.121230e-003, -3.173768e-003,
   1.660451e-004,  3.487262e-003,  6.887342e-003,  1.031193e-002,  1.346142e-002,  1.656899e-002,  1.942181e-002,  2.240880e-002,  2.498714e-002,
   2.751651e-002,  2.986261e-002,  3.191622e-002,  3.363757e-002,  3.495018e-002,  3.587321e-002,  3.667872e-002,  3.692653e-002,  3.719468e-002,
   3.700629e-002,  3.650387e-002,  3.592412e-002,  3.520577e-002,  3.447157e-002,  3.337643e-002,  3.201951e-002,  3.043860e-002,  2.849360e-002,
   2.664718e-002,  2.451794e-002,  2.237383e-002,  2.002122e-002,  1.757373e-002,  1.514208e-002,  1.270289e-002,  1.043545e-002,  8.049355e-003,
   5.636358e-003,  3.536537e-003,  1.348231e-003,  -8.218181e-004, -2.493908e-003, -3.951792e-003, -5.248754e-003, -6.500497e-003, -7.593310e-003,
   -8.091750e-003, -8.625289e-003, -8.914666e-003, -8.996373e-003, -8.989998e-003, -8.992182e-003, -8.942410e-003, -8.802284e-003, -8.096253e-003,
   -7.462768e-003, -6.823762e-003, -6.019022e-003, -5.316966e-003, -4.808466e-003, -4.183201e-003, -3.691915e-003, -3.272723e-003, -2.804278e-003,
   -2.752393e-003, -2.858813e-003, -3.139648e-003, -3.631077e-003, -4.178289e-003, -4.837927e-003, -5.415356e-003, -5.852108e-003, -6.244190e-003,
   -6.752684e-003, -7.179716e-003, -7.599783e-003, -8.096081e-003, -8.604389e-003, -9.210337e-003, -9.832264e-003, -1.044150e-002, -1.105628e-002,
   -1.175909e-002, -1.250079e-002, -1.318013e-002, -1.376539e-002, -1.421848e-002, -1.470018e-002, -1.535426e-002, -1.593455e-002, -1.644070e-002,
   -1.696452e-002, -1.762929e-002, -1.828440e-002, -1.903388e-002, -1.977325e-002, -2.060567e-002, -2.139396e-002, -2.226622e-002, -2.327479e-002,
   -2.422805e-002, -2.524178e-002, -2.625225e-002, -2.732794e-002, -2.848347e-002, -2.933124e-002, -3.004910e-002, -3.077191e-002, -3.159298e-002,
   -3.236835e-002, -3.290230e-002, -3.331127e-002, -3.345762e-002, -3.320700e-002, -3.271422e-002, -3.203304e-002, -3.113345e-002, -2.991892e-002,
   -2.850035e-002, -2.686171e-002, -2.504731e-002, -2.311087e-002, -2.094423e-002, -1.855454e-002, -1.603842e-002, -1.345968e-002, -1.066311e-002,
   -7.677695e-003, -4.693214e-003, -1.804628e-003, 1.198819e-003,  4.050774e-003,  6.727898e-003,  9.258785e-003,  1.175012e-002,  1.410771e-002,
   1.640370e-002,  1.872032e-002,  2.106224e-002,  2.347714e-002,  2.588787e-002,  2.832950e-002,  3.066889e-002,  3.292749e-002,  3.505272e-002,
   3.707771e-002,  3.897498e-002,  4.074446e-002,  4.245702e-002,  4.395962e-002,  4.521019e-002,  4.619311e-002,  4.688558e-002,  4.750285e-002,
   4.794766e-002,  4.816383e-002,  4.810482e-002,  4.792793e-002,  4.729618e-002,  4.652057e-002,  4.558017e-002,  4.452366e-002,  4.319393e-002,
   4.170817e-002,  3.992725e-002,  3.788809e-002,  3.552905e-002,  3.306365e-002,  3.054822e-002,  2.812698e-002,  2.558530e-002,  2.297020e-002,
   2.032699e-002,  1.759461e-002,  1.491980e-002,  1.230803e-002,  9.845191e-003,  7.546819e-003,  5.449565e-003,  3.372990e-003,  1.356474e-003,
   -6.244383e-004, -2.610921e-003, -4.586890e-003, -6.278519e-003, -7.890025e-003, -9.517659e-003, -1.103433e-002, -1.232521e-002, -1.350277e-002,
   -1.452207e-002, -1.563505e-002, -1.662070e-002, -1.747172e-002, -1.809808e-002, -1.868008e-002, -1.924296e-002, -1.972334e-002, -1.995173e-002,
   -1.992581e-002, -1.988442e-002, -1.969942e-002, -1.948009e-002, -1.907908e-002, -1.854615e-002, -1.787303e-002, -1.699768e-002, -1.594111e-002,
   -1.459593e-002, -1.299512e-002, -1.109364e-002, -9.132048e-003, -7.098413e-003, -5.133031e-003, -3.156067e-003, -1.176582e-003, 8.107661e-004,
   2.753242e-003,  4.567266e-003,  6.461167e-003,  8.365149e-003,  1.023503e-002,  1.199766e-002,  1.367235e-002,  1.514784e-002,  1.654619e-002,
   1.774623e-002,  1.876584e-002,  1.959939e-002,  2.027723e-002,  2.075191e-002,  2.098424e-002,  2.090633e-002,  2.048742e-002,  1.985573e-002,
   1.914052e-002,  1.828560e-002,  1.722887e-002,  1.606533e-002,  1.494413e-002,  1.375048e-002,  1.252149e-002,  1.132415e-002,  1.021822e-002,
   9.142808e-003,  7.972039e-003,  6.717654e-003,  5.346377e-003,  4.066137e-003,  2.773927e-003,  1.623577e-003,  5.727074e-004,  -4.577180e-004,
   -1.420504e-003, -2.300119e-003, -3.070242e-003, -3.835211e-003, -4.607136e-003, -5.486896e-003, -6.424022e-003, -7.375626e-003, -8.289346e-003,
   -9.244838e-003, -1.026491e-002, -1.143799e-002, -1.272087e-002, -1.413782e-002, -1.564241e-002, -1.723947e-002, -1.889180e-002, -2.051288e-002,
   -2.204456e-002, -2.367888e-002, -2.526027e-002, -2.691839e-002, -2.851257e-002, -3.000154e-002, -3.161105e-002, -3.331999e-002, -3.503159e-002,
   -3.662259e-002, -3.805864e-002, -3.942737e-002, -4.068278e-002, -4.189856e-002, -4.286019e-002, -4.363595e-002, -4.429410e-002, -4.496614e-002,
   -4.568508e-002, -4.638920e-002, -4.690511e-002, -4.718796e-002, -4.740586e-002, -4.759310e-002, -4.774237e-002, -4.767961e-002, -4.749608e-002,
   -4.723799e-002, -4.696139e-002, -4.672770e-002, -4.646786e-002, -4.610451e-002, -4.578019e-002, -4.551681e-002, -4.523970e-002, -4.497662e-002,
   -4.461293e-002, -4.408986e-002, -4.344115e-002, -4.269466e-002, -4.190986e-002, -4.101344e-002, -4.001374e-002, -3.877195e-002, -3.730987e-002,
   -3.576281e-002, -3.404682e-002, -3.226266e-002, -3.029614e-002, -2.812401e-002, -2.579066e-002, -2.340318e-002, -2.092865e-002, -1.838213e-002,
   -1.568175e-002, -1.289884e-002, -1.017833e-002, -7.495431e-003, -4.834545e-003, -2.142456e-003, 5.920163e-004,  3.337825e-003,  5.959578e-003,
   8.519402e-003,  1.102971e-002,  1.344931e-002,  1.576932e-002,  1.796100e-002,  1.991082e-002,  2.168644e-002,  2.337365e-002,  2.504023e-002,
   2.678373e-002,  2.862147e-002,  3.049878e-002,  3.241890e-002,  3.436431e-002,  3.641611e-002,  3.856386e-002,  4.073100e-002,  4.283885e-002,
   4.490802e-002,  4.689472e-002,  4.871002e-002,  5.046645e-002,  5.204726e-002,  5.343029e-002,  5.472832e-002,  5.599236e-002,  5.721597e-002,
   5.839899e-002,  5.957367e-002,  6.056500e-002,  6.136720e-002,  6.186965e-002,  6.211838e-002,  6.226175e-002,  6.229212e-002,  6.214178e-002,
   6.190056e-002,  6.152783e-002,  6.101349e-002,  6.050825e-002,  6.002261e-002,  5.945987e-002,  5.870049e-002,  5.780476e-002,  5.684328e-002,
   5.594430e-002,  5.514625e-002,  5.451345e-002,  5.392397e-002,  5.337463e-002,  5.275612e-002,  5.213341e-002,  5.162743e-002,  5.126525e-002,
   5.069816e-002,  5.000647e-002,  4.919533e-002,  4.829488e-002,  4.734442e-002,  4.636469e-002,  4.530876e-002,  4.408834e-002,  4.273445e-002,
   4.124301e-002,  3.971368e-002,  3.816382e-002,  3.635555e-002,  3.442473e-002,  3.242237e-002,  3.032685e-002,  2.810918e-002,  2.570025e-002,
   2.315001e-002,  2.051721e-002,  1.781774e-002,  1.504993e-002,  1.223533e-002,  9.403792e-003,  6.614334e-003,  3.961789e-003,  1.352513e-003,
   -1.142669e-003, -3.556329e-003, -5.808669e-003, -7.896957e-003, -9.784636e-003, -1.150217e-002, -1.308122e-002, -1.463586e-002, -1.613689e-002,
   -1.753596e-002, -1.880683e-002, -1.998000e-002, -2.100789e-002, -2.209715e-002, -2.315729e-002, -2.421098e-002, -2.529663e-002, -2.641581e-002,
   -2.758166e-002, -2.869584e-002, -2.979604e-002, -3.095794e-002, -3.225884e-002, -3.361836e-002, -3.503545e-002, -3.645276e-002, -3.783637e-002,
   -3.929751e-002, -4.089781e-002, -4.259918e-002, -4.432874e-002, -4.607143e-002, -4.773009e-002, -4.920081e-002, -5.047505e-002, -5.164006e-002,
   -5.269007e-002, -5.353123e-002, -5.403724e-002, -5.434575e-002, -5.443941e-002, -5.436548e-002, -5.425290e-002, -5.409159e-002, -5.387804e-002,
   -5.379968e-002, -5.374968e-002, -5.360891e-002, -5.324331e-002, -5.274358e-002, -5.222948e-002, -5.160853e-002, -5.102097e-002, -5.055632e-002,
   -5.009110e-002, -4.961392e-002, -4.919782e-002, -4.890147e-002, -4.865878e-002, -4.853132e-002, -4.840425e-002, -4.825781e-002, -4.817701e-002,
   -4.814303e-002, -4.827690e-002, -4.839454e-002, -4.851642e-002, -4.853947e-002, -4.851070e-002, -4.835915e-002, -4.806847e-002, -4.772811e-002,
   -4.735464e-002, -4.686800e-002, -4.616908e-002, -4.515623e-002, -4.409057e-002, -4.273307e-002, -4.112326e-002, -3.938006e-002, -3.749485e-002,
   -3.557317e-002, -3.367075e-002, -3.179954e-002, -2.987817e-002, -2.790936e-002, -2.572261e-002, -2.346290e-002, -2.115555e-002, -1.891577e-002,
   -1.679818e-002, -1.477311e-002, -1.243367e-002, -1.002242e-002, -7.706430e-003, -5.560307e-003, -3.565738e-003, -1.700999e-003, 4.548754e-005,
   1.703930e-003,  3.307118e-003,  4.857230e-003,  6.397235e-003,  7.923882e-003,  9.460259e-003,  1.106621e-002,  1.270158e-002,  1.435002e-002,
   1.601426e-002,  1.764552e-002,  1.926211e-002,  2.078512e-002,  2.229888e-002,  2.374488e-002,  2.518172e-002,  2.686031e-002,  2.867680e-002,
   3.047771e-002,  3.223375e-002,  3.387937e-002,  3.545273e-002,  3.691159e-002,  3.824734e-002,  3.954426e-002,  4.082855e-002,  4.204487e-002,
   4.314479e-002,  4.410489e-002,  4.499020e-002,  4.571630e-002,  4.630931e-002,  4.683214e-002,  4.735618e-002,  4.790854e-002,  4.847886e-002,
   4.893745e-002,  4.941052e-002,  4.991920e-002,  5.043605e-002,  5.094296e-002,  5.148773e-002,  5.203289e-002,  5.260084e-002,  5.310336e-002,
   5.352573e-002,  5.382221e-002,  5.425348e-002,  5.457538e-002,  5.479892e-002,  5.487953e-002,  5.487374e-002,  5.468993e-002,  5.432971e-002,
   5.377583e-002,  5.311632e-002,  5.224699e-002,  5.121794e-002,  5.003129e-002,  4.869618e-002,  4.720427e-002,  4.546396e-002,  4.364570e-002,
   4.182177e-002,  4.002437e-002,  3.824361e-002,  3.652127e-002,  3.481240e-002,  3.322805e-002,  3.166959e-002,  3.018601e-002,  2.874048e-002,
   2.740325e-002,  2.617446e-002,  2.505664e-002,  2.406591e-002,  2.328137e-002,  2.266331e-002,  2.205704e-002,  2.146733e-002,  2.085548e-002,
   2.027054e-002,  1.963182e-002,  1.899520e-002,  1.840720e-002,  1.782242e-002,  1.715968e-002,  1.646351e-002,  1.588462e-002,  1.533953e-002,
   1.475195e-002,  1.402474e-002,  1.309852e-002,  1.207905e-002,  1.095860e-002,  9.732415e-003,  8.430559e-003,  7.069104e-003,  5.627828e-003,
   4.144554e-003,  2.612547e-003,  1.078197e-003,  -3.333381e-004, -1.660112e-003, -2.819464e-003, -3.856188e-003, -4.675506e-003, -5.290251e-003,
   -5.731264e-003, -6.131214e-003, -6.553499e-003, -6.806265e-003, -7.035203e-003, -7.211436e-003, -7.395562e-003, -7.599733e-003, -7.776983e-003,
   -7.917681e-003, -8.115935e-003, -8.351167e-003, -8.462478e-003, -8.520384e-003, -8.543514e-003, -8.582004e-003, -8.686430e-003, -8.921784e-003,
   -9.378241e-003, -9.984562e-003, -1.070819e-002, -1.144842e-002, -1.216734e-002, -1.286840e-002, -1.355399e-002, -1.423771e-002, -1.485368e-002,
   -1.539165e-002, -1.587404e-002, -1.635753e-002, -1.671768e-002, -1.694643e-002, -1.704845e-002, -1.708001e-002, -1.707063e-002, -1.693722e-002,
   -1.683292e-002, -1.669635e-002, -1.663055e-002, -1.664120e-002, -1.659552e-002, -1.662302e-002, -1.674169e-002, -1.693562e-002, -1.723151e-002,
   -1.759452e-002, -1.803317e-002, -1.857834e-002, -1.926417e-002, -2.000791e-002, -2.079699e-002, -2.178555e-002, -2.305588e-002, -2.442474e-002,
   -2.587617e-002, -2.736611e-002, -2.886701e-002, -3.039988e-002, -3.194743e-002, -3.332878e-002, -3.456006e-002, -3.567533e-002, -3.674389e-002,
   -3.767837e-002, -3.860935e-002, -3.928897e-002, -3.975846e-002, -4.005642e-002, -4.022738e-002, -4.019999e-002, -4.001636e-002, -3.973286e-002,
   -3.941271e-002, -3.895531e-002, -3.836477e-002, -3.766485e-002, -3.697775e-002, -3.620546e-002, -3.534119e-002, -3.439193e-002, -3.339706e-002,
   -3.244995e-002, -3.156241e-002, -3.081037e-002, -3.013177e-002, -2.946770e-002, -2.880825e-002, -2.812245e-002, -2.744323e-002, -2.669691e-002,
   -2.591785e-002, -2.518238e-002, -2.454735e-002, -2.400416e-002, -2.345074e-002, -2.286687e-002, -2.222466e-002, -2.150362e-002, -2.072564e-002,
   -1.985872e-002, -1.896279e-002, -1.805334e-002, -1.713478e-002, -1.627721e-002, -1.540866e-002, -1.449563e-002, -1.353659e-002, -1.258583e-002,
   -1.161945e-002, -1.064567e-002, -9.697183e-003, -8.766315e-003, -7.884624e-003, -7.248590e-003, -6.613830e-003, -5.981632e-003, -5.358558e-003,
   -4.684666e-003, -4.061358e-003, -3.394395e-003, -2.704937e-003, -1.992494e-003, -1.265195e-003, -6.845468e-004, -1.080782e-004, 4.257485e-004,
   9.852376e-004,  1.683515e-003,  2.508954e-003,  3.467462e-003,  4.520353e-003,  5.608052e-003,  6.758289e-003,  7.913474e-003,  9.121853e-003,
   1.047055e-002,  1.199733e-002,  1.366311e-002,  1.525929e-002,  1.684295e-002,  1.845380e-002,  2.008954e-002,  2.181070e-002,  2.352426e-002,
   2.516126e-002,  2.685818e-002,  2.855091e-002,  3.021117e-002,  3.187322e-002,  3.354269e-002,  3.517659e-002,  3.652914e-002,  3.774941e-002,
   3.887767e-002,  3.973597e-002,  4.048107e-002,  4.117310e-002,  4.185933e-002,  4.257679e-002,  4.334223e-002,  4.412559e-002,  4.484661e-002,
   4.553661e-002,  4.620972e-002,  4.647402e-002,  4.666042e-002,  4.698923e-002,  4.745676e-002,  4.803383e-002,  4.868036e-002,  4.937314e-002,
   4.998720e-002,  5.037414e-002,  5.070796e-002,  5.085181e-002,  5.089037e-002,  5.094595e-002,  5.090955e-002,  5.051478e-002,  5.013270e-002,
   4.969428e-002,  4.925393e-002,  4.869329e-002,  4.782868e-002,  4.668914e-002,  4.525280e-002,  4.372563e-002,  4.212665e-002,  4.033387e-002,
   3.845674e-002,  3.655031e-002,  3.419669e-002,  3.170815e-002,  2.924282e-002,  2.647364e-002,  2.354786e-002,  2.060480e-002,  1.765068e-002,
   1.477969e-002,  1.201827e-002,  9.359265e-003,  6.832206e-003,  4.422553e-003,  2.152366e-003,  1.115139e-016},
  {0.000000e+000,  -2.579398e-001, -1.209567e-001, -1.932490e-002, 2.504666e-002,  3.760578e-002,  5.783333e-002,  6.761293e-002,  7.434871e-002,
   7.908871e-002,  8.784226e-002,  9.907153e-002,  1.101218e-001,  1.189280e-001,  1.136878e-001,  9.264423e-002,  6.011690e-002,  2.173496e-002,
   -1.755617e-002, -5.624576e-002, -8.941955e-002, -1.129872e-001, -1.263236e-001, -1.315514e-001, -1.303526e-001, -1.240840e-001, -1.136003e-001,
   -9.992641e-002, -8.610108e-002, -7.163968e-002, -5.759440e-002, -4.251288e-002, -2.767609e-002, -1.359326e-002, 7.703830e-004,  1.501648e-002,
   2.836959e-002,  3.884818e-002,  4.631836e-002,  5.056561e-002,  5.256275e-002,  5.108808e-002,  4.837986e-002,  4.531974e-002,  4.190391e-002,
   3.886251e-002,  3.834583e-002,  3.955288e-002,  4.053713e-002,  4.172433e-002,  3.956807e-002,  3.614354e-002,  3.136865e-002,  2.491181e-002,
   1.852397e-002,  1.143958e-002,  4.409165e-003,  -2.266289e-003, -8.557574e-003, -1.352364e-002, -1.756921e-002, -1.901168e-002, -1.933776e-002,
   -2.004519e-002, -2.022225e-002, -1.937490e-002, -1.828170e-002, -1.674618e-002, -1.469506e-002, -1.204811e-002, -8.579812e-003, -4.427528e-003,
   3.616970e-004,  5.099766e-003,  1.097479e-002,  1.545632e-002,  1.975683e-002,  2.381555e-002,  2.770366e-002,  3.035031e-002,  3.069347e-002,
   3.000374e-002,  2.646521e-002,  2.213796e-002,  1.632744e-002,  9.611939e-003,  2.464927e-003,  -5.452643e-003, -1.477599e-002, -2.404947e-002,
   -3.276840e-002, -4.067040e-002, -4.763239e-002, -5.479383e-002, -5.999768e-002, -6.344228e-002, -6.477467e-002, -6.281421e-002, -5.982008e-002,
   -5.487841e-002, -4.827628e-002, -4.055054e-002, -3.342795e-002, -2.628211e-002, -1.818398e-002, -9.700948e-003, -2.041464e-003, 5.061294e-003,
   1.255927e-002,  2.012797e-002,  2.589389e-002,  3.187245e-002,  3.843609e-002,  4.340302e-002,  4.789767e-002,  5.259461e-002,  5.620754e-002,
   5.940958e-002,  6.281688e-002,  6.470254e-002,  6.624533e-002,  6.730981e-002,  6.758890e-002,  6.759588e-002,  6.630336e-002,  6.442698e-002,
   6.216506e-002,  5.918142e-002,  5.575290e-002,  5.118315e-002,  4.674005e-002,  4.178763e-002,  3.653629e-002,  3.068895e-002,  2.349925e-002,
   1.581754e-002,  7.878387e-003,  -6.886181e-004, -9.249308e-003, -1.821434e-002, -2.673689e-002, -3.492459e-002, -4.339498e-002, -5.120203e-002,
   -5.873327e-002, -6.544557e-002, -7.133148e-002, -7.676154e-002, -8.055690e-002, -8.398265e-002, -8.641409e-002, -8.696943e-002, -8.643045e-002,
   -8.427497e-002, -8.095234e-002, -7.756008e-002, -7.407493e-002, -7.043029e-002, -6.678125e-002, -6.298851e-002, -5.833634e-002, -5.378697e-002,
   -4.955872e-002, -4.419111e-002, -3.872515e-002, -3.292736e-002, -2.664201e-002, -2.033412e-002, -1.446422e-002, -8.907711e-003, -2.955067e-003,
   2.399817e-003,  7.114083e-003,  1.193007e-002,  1.690367e-002,  2.174539e-002,  2.561761e-002,  2.978104e-002,  3.374028e-002,  3.771790e-002,
   4.051783e-002,  4.374519e-002,  4.664450e-002,  4.870739e-002,  4.993152e-002,  5.142378e-002,  5.211863e-002,  5.224159e-002,  5.236009e-002,
   5.158623e-002,  5.080987e-002,  4.946461e-002,  4.774334e-002,  4.624232e-002,  4.478164e-002,  4.325651e-002,  4.093693e-002,  3.838341e-002,
   3.583514e-002,  3.326730e-002,  3.064711e-002,  2.774813e-002,  2.511689e-002,  2.258792e-002,  2.041250e-002,  1.831328e-002,  1.624659e-002,
   1.420284e-002,  1.216297e-002,  9.958626e-003,  7.791126e-003,  5.516001e-003,  3.696278e-003,  1.620315e-003,  -8.438702e-005, -1.743089e-003,
   -3.159685e-003, -4.207882e-003, -5.405470e-003, -6.339237e-003, -7.585506e-003, -8.845937e-003, -1.026351e-002, -1.217476e-002, -1.430957e-002,
   -1.664366e-002, -1.902981e-002, -2.118980e-002, -2.320684e-002, -2.539996e-002, -2.752148e-002, -2.937368e-002, -3.133944e-002, -3.315962e-002,
   -3.472621e-002, -3.607433e-002, -3.697657e-002, -3.724698e-002, -3.727162e-002, -3.702979e-002, -3.667382e-002, -3.569018e-002, -3.416013e-002,
   -3.221873e-002, -2.982019e-002, -2.719112e-002, -2.453182e-002, -2.166123e-002, -1.833190e-002, -1.485849e-002, -1.131786e-002, -7.878930e-003,
   -4.391772e-003, -6.966317e-004, 2.750646e-003,  5.956787e-003,  9.095940e-003,  1.203525e-002,  1.447489e-002,  1.655321e-002,  1.843273e-002,
   1.982740e-002,  2.076265e-002,  2.118521e-002,  2.141936e-002,  2.128287e-002,  2.087018e-002,  2.035876e-002,  1.991192e-002,  1.983346e-002,
   2.005756e-002,  2.033808e-002,  2.060518e-002,  2.108593e-002,  2.154459e-002,  2.217383e-002,  2.276094e-002,  2.327822e-002,  2.352310e-002,
   2.370586e-002,  2.398790e-002,  2.436696e-002,  2.459088e-002,  2.467673e-002,  2.485049e-002,  2.487367e-002,  2.447821e-002,  2.417875e-002,
   2.377879e-002,  2.299162e-002,  2.185145e-002,  2.032041e-002,  1.863735e-002,  1.653366e-002,  1.419286e-002,  1.180981e-002,  9.317537e-003,
   6.749421e-003,  4.055280e-003,  1.357940e-003,  -1.281496e-003, -4.161932e-003, -6.926867e-003, -9.448191e-003, -1.177807e-002, -1.358487e-002,
   -1.520972e-002, -1.654234e-002, -1.753675e-002, -1.846182e-002, -1.911281e-002, -1.888710e-002, -1.808285e-002, -1.712806e-002, -1.613268e-002,
   -1.494508e-002, -1.364783e-002, -1.235170e-002, -1.107139e-002, -9.711666e-003, -8.429320e-003, -7.124912e-003, -5.589019e-003, -3.905409e-003,
   -2.196126e-003, -3.586341e-004, 1.586919e-003,  2.722414e-003,  3.098131e-003,  3.316094e-003,  3.332841e-003,  3.213552e-003,  3.178998e-003,
   3.364780e-003,  3.439043e-003,  3.404151e-003,  3.610437e-003,  4.061402e-003,  4.446161e-003,  5.030620e-003,  5.955267e-003,  6.882735e-003,
   7.661038e-003,  8.398200e-003,  9.215394e-003,  9.814869e-003,  1.068802e-002,  1.164980e-002,  1.234742e-002,  1.293027e-002,  1.321345e-002,
   1.358017e-002,  1.360308e-002,  1.332827e-002,  1.292256e-002,  1.253662e-002,  1.193453e-002,  1.097354e-002,  9.608262e-003,  7.727396e-003,
   5.181497e-003,  2.498065e-003,  8.392901e-005,  -2.753614e-003, -5.874013e-003, -9.066884e-003, -1.221922e-002, -1.530662e-002, -1.841245e-002,
   -2.134858e-002, -2.361042e-002, -2.593328e-002, -2.841748e-002, -3.068935e-002, -3.268556e-002, -3.460273e-002, -3.637718e-002, -3.784616e-002,
   -3.897207e-002, -3.989913e-002, -4.084184e-002, -4.161193e-002, -4.224743e-002, -4.272912e-002, -4.332241e-002, -4.402182e-002, -4.452376e-002,
   -4.506558e-002, -4.528480e-002, -4.546102e-002, -4.559239e-002, -4.611191e-002, -4.668735e-002, -4.709852e-002, -4.723655e-002, -4.745577e-002,
   -4.775760e-002, -4.783295e-002, -4.757291e-002, -4.731658e-002, -4.693088e-002, -4.636473e-002, -4.527026e-002, -4.392313e-002, -4.232921e-002,
   -4.058036e-002, -3.830428e-002, -3.563550e-002, -3.252757e-002, -2.947177e-002, -2.609116e-002, -2.252321e-002, -1.882878e-002, -1.536624e-002,
   -1.178465e-002, -7.949011e-003, -4.070393e-003, -2.169144e-004, 3.653688e-003,  7.723708e-003,  1.168033e-002,  1.546843e-002,  1.906044e-002,
   2.267620e-002,  2.635240e-002,  2.999622e-002,  3.326988e-002,  3.609206e-002,  3.854707e-002,  4.039571e-002,  4.218781e-002,  4.365848e-002,
   4.492490e-002,  4.587969e-002,  4.670635e-002,  4.746898e-002,  4.822103e-002,  4.922597e-002,  5.035996e-002,  5.168701e-002,  5.302462e-002,
   5.431828e-002,  5.574555e-002,  5.716833e-002,  5.851182e-002,  5.970190e-002,  6.062621e-002,  6.131199e-002,  6.187983e-002,  6.242391e-002,
   6.307774e-002,  6.358222e-002,  6.392120e-002,  6.404110e-002,  6.397023e-002,  6.414935e-002,  6.390093e-002,  6.311954e-002,  6.182869e-002,
   6.025462e-002,  5.846745e-002,  5.627545e-002,  5.370097e-002,  5.086212e-002,  4.779427e-002,  4.450851e-002,  4.093421e-002,  3.710409e-002,
   3.311468e-002,  2.955969e-002,  2.605301e-002,  2.247117e-002,  1.871255e-002,  1.477813e-002,  1.093143e-002,  7.142533e-003,  3.338119e-003,
   -4.218725e-004, -4.152341e-003, -7.620255e-003, -1.079695e-002, -1.377148e-002, -1.649072e-002, -1.882488e-002, -2.069452e-002, -2.226946e-002,
   -2.359193e-002, -2.482650e-002, -2.621025e-002, -2.742695e-002, -2.847715e-002, -2.931658e-002, -3.001557e-002, -3.069451e-002, -3.125401e-002,
   -3.177524e-002, -3.219790e-002, -3.247020e-002, -3.272664e-002, -3.279779e-002, -3.263522e-002, -3.244683e-002, -3.222611e-002, -3.213730e-002,
   -3.209843e-002, -3.227508e-002, -3.256853e-002, -3.275860e-002, -3.273513e-002, -3.249075e-002, -3.201190e-002, -3.153708e-002, -3.095856e-002,
   -3.013429e-002, -2.898258e-002, -2.755313e-002, -2.572948e-002, -2.360818e-002, -2.141612e-002, -1.911493e-002, -1.679410e-002, -1.461674e-002,
   -1.256759e-002, -1.060445e-002, -8.690035e-003, -6.837316e-003, -5.127986e-003, -3.560941e-003, -2.282790e-003, -1.246488e-003, -2.973902e-004,
   6.036451e-004,  1.307093e-003,  1.665978e-003,  1.747005e-003,  1.506567e-003,  9.812409e-004,  2.203542e-004,  -6.531253e-004, -1.681214e-003,
   -2.734614e-003, -3.757117e-003, -4.544129e-003, -4.963993e-003, -4.966266e-003, -4.609048e-003, -4.097634e-003, -3.432080e-003, -2.618152e-003,
   -1.660368e-003, -7.237833e-004, 6.128496e-005,  7.160381e-004,  1.312671e-003,  2.144561e-003,  3.002123e-003,  3.878402e-003,  4.715605e-003,
   5.403221e-003,  5.927875e-003,  6.323630e-003,  6.462751e-003,  6.248945e-003,  5.646920e-003,  4.782494e-003,  3.694970e-003,  2.381798e-003,
   1.009759e-003,  -3.573277e-004, -1.749128e-003, -3.192651e-003, -4.741605e-003, -6.371721e-003, -8.005634e-003, -9.490331e-003, -1.071508e-002,
   -1.170148e-002, -1.247470e-002, -1.319494e-002, -1.387452e-002, -1.429349e-002, -1.441293e-002, -1.413480e-002, -1.355052e-002, -1.277048e-002,
   -1.187251e-002, -1.086824e-002, -9.790924e-003, -8.634118e-003, -7.568894e-003, -6.702131e-003, -6.024374e-003, -5.571644e-003, -5.145867e-003,
   -4.660619e-003, -4.168417e-003, -3.612648e-003, -2.891409e-003, -2.164632e-003, -1.474701e-003, -1.017929e-003, -8.793184e-004, -1.119031e-003,
   -1.625717e-003, -2.389485e-003, -3.264484e-003, -4.157508e-003, -5.140339e-003, -5.965895e-003, -6.638305e-003, -7.134637e-003, -7.518238e-003,
   -7.531199e-003, -7.281284e-003, -6.756853e-003, -6.034889e-003, -5.124576e-003, -4.092030e-003, -2.867205e-003, -1.451115e-003, 2.239897e-004,
   2.110914e-003,  4.097981e-003,  6.129396e-003,  8.113317e-003,  9.938029e-003,  1.170526e-002,  1.338156e-002,  1.488051e-002,  1.625691e-002,
   1.735182e-002,  1.821789e-002,  1.884886e-002,  1.927077e-002,  1.943597e-002,  1.930072e-002,  1.876736e-002,  1.770444e-002,  1.630472e-002,
   1.469489e-002,  1.287807e-002,  1.086195e-002,  8.783380e-003,  6.777411e-003,  4.842621e-003,  2.984875e-003,  1.441480e-003,  9.822667e-005,
   -9.469432e-004, -1.556145e-003, -1.622938e-003, -1.253699e-003, -6.320784e-004, 1.547057e-004,  1.161875e-003,  2.363016e-003,  3.635548e-003,
   4.995336e-003,  6.441811e-003,  7.925154e-003,  9.416030e-003,  1.112582e-002,  1.294499e-002,  1.477188e-002,  1.673515e-002,  1.875369e-002,
   2.061192e-002,  2.226624e-002,  2.370853e-002,  2.478138e-002,  2.551645e-002,  2.603810e-002,  2.642191e-002,  2.662482e-002,  2.660716e-002,
   2.629400e-002,  2.560136e-002,  2.468079e-002,  2.366704e-002,  2.259868e-002,  2.147261e-002,  2.027612e-002,  1.906563e-002,  1.796267e-002,
   1.695637e-002,  1.601241e-002,  1.507960e-002,  1.423999e-002,  1.361573e-002,  1.327799e-002,  1.318320e-002,  1.335855e-002,  1.365530e-002,
   1.403293e-002,  1.446425e-002,  1.491372e-002,  1.518441e-002,  1.508684e-002,  1.482889e-002,  1.460668e-002,  1.439235e-002,  1.421736e-002,
   1.418394e-002,  1.423821e-002,  1.396676e-002,  1.354445e-002,  1.298255e-002,  1.212716e-002,  1.097619e-002,  9.402749e-003,  7.573798e-003,
   5.595428e-003,  3.515146e-003,  1.485177e-003,  -4.882044e-004, -2.362990e-003, -4.052034e-003, -5.482022e-003, -6.651650e-003, -7.596364e-003,
   -8.507816e-003, -9.470378e-003, -1.028909e-002, -1.093851e-002, -1.143958e-002, -1.179755e-002, -1.208581e-002, -1.236813e-002, -1.272414e-002,
   -1.309716e-002, -1.345903e-002, -1.385009e-002, -1.428607e-002, -1.479398e-002, -1.527407e-002, -1.575459e-002, -1.633419e-002, -1.703189e-002,
   -1.787018e-002, -1.887978e-002, -2.003423e-002, -2.136734e-002, -2.269959e-002, -2.400660e-002, -2.528676e-002, -2.652036e-002, -2.762633e-002,
   -2.855865e-002, -2.922374e-002, -2.966257e-002, -2.971810e-002, -2.947755e-002, -2.904298e-002, -2.847870e-002, -2.780494e-002, -2.710601e-002,
   -2.637022e-002, -2.562690e-002, -2.505907e-002, -2.454080e-002, -2.409288e-002, -2.375043e-002, -2.345757e-002, -2.311544e-002, -2.272731e-002,
   -2.229195e-002, -2.188252e-002, -2.141581e-002, -2.111549e-002, -2.106495e-002, -2.132958e-002, -2.186872e-002, -2.253665e-002, -2.326625e-002,
   -2.399170e-002, -2.463249e-002, -2.508957e-002, -2.535475e-002, -2.552324e-002, -2.543599e-002, -2.506226e-002, -2.446855e-002, -2.356986e-002,
   -2.241903e-002, -2.114630e-002, -1.971796e-002, -1.818763e-002, -1.663143e-002, -1.495635e-002, -1.309890e-002, -1.118190e-002, -9.284025e-003,
   -7.421051e-003, -5.629939e-003, -3.948830e-003, -2.429027e-003, -1.061970e-003, 2.193347e-004,  1.338235e-003,  2.240275e-003,  2.909313e-003,
   3.341588e-003,  3.507632e-003,  3.431855e-003,  2.972452e-003,  2.230958e-003,  1.300598e-003,  1.916446e-004,  -1.096381e-003, -2.459304e-003,
   -3.894535e-003, -5.393157e-003, -6.819771e-003, -8.182386e-003, -9.446314e-003, -1.037507e-002, -1.090151e-002, -1.082440e-002, -1.025120e-002,
   -9.172517e-003, -7.938720e-003, -6.504267e-003, -5.105796e-003, -3.747840e-003, -2.432724e-003, -1.143524e-003, 1.246597e-004,  1.377356e-003,
   2.640967e-003,  4.002917e-003,  5.459114e-003,  6.838093e-003,  8.104481e-003,  9.337010e-003,  1.050151e-002,  1.142605e-002,  1.202659e-002,
   1.226805e-002,  1.219793e-002,  1.191685e-002,  1.143601e-002,  1.088010e-002,  1.042566e-002,  1.008632e-002,  9.938196e-003,  1.003155e-002,
   1.038871e-002,  1.101200e-002,  1.182630e-002,  1.280232e-002,  1.389360e-002,  1.515404e-002,  1.652723e-002,  1.800978e-002,  1.957076e-002,
   2.120760e-002,  2.293185e-002,  2.460919e-002,  2.622679e-002,  2.760060e-002,  2.880274e-002,  2.991452e-002,  3.087578e-002,  3.175920e-002,
   3.247300e-002,  3.299391e-002,  3.326776e-002,  3.321213e-002,  3.278646e-002,  3.195643e-002,  3.073559e-002,  2.922576e-002,  2.752823e-002,
   2.569974e-002,  2.371693e-002,  2.170333e-002,  1.964248e-002,  1.757875e-002,  1.543505e-002,  1.332448e-002,  1.135122e-002,  9.568384e-003,
   8.017653e-003,  6.721457e-003,  5.781147e-003,  5.137044e-003,  4.789883e-003,  4.564974e-003,  4.333416e-003,  4.154308e-003,  4.117791e-003,
   4.174322e-003,  4.336080e-003,  4.586243e-003,  4.934014e-003,  5.360635e-003,  5.687154e-003,  5.939883e-003,  6.078859e-003,  6.193818e-003,
   6.233641e-003,  6.230615e-003,  6.171828e-003,  6.037512e-003,  5.889675e-003,  5.794554e-003,  5.789711e-003,  5.835376e-003,  5.987347e-003,
   6.108669e-003,  6.164964e-003,  6.139106e-003,  6.042786e-003,  5.886521e-003,  5.720929e-003,  5.610427e-003,  5.596352e-003,  5.689164e-003,
   5.873301e-003,  6.044754e-003,  6.199628e-003,  6.303955e-003,  6.357360e-003,  6.267259e-003,  6.137201e-003,  5.919732e-003,  5.632784e-003,
   5.270683e-003,  4.763314e-003,  4.151010e-003,  3.381284e-003,  2.459789e-003,  1.415645e-003,  2.846581e-004,  -9.016040e-004, -2.072679e-003,
   -3.195387e-003, -4.372159e-003, -5.493731e-003, -6.489536e-003, -7.410036e-003, -8.249778e-003, -9.020135e-003, -9.679026e-003, -1.024993e-002,
   -1.059533e-002, -1.069940e-002, -1.057291e-002, -1.037040e-002, -1.008951e-002, -9.803875e-003, -9.588151e-003, -9.352192e-003, -9.079449e-003,
   -8.737069e-003, -8.270414e-003, -7.721555e-003, -7.106008e-003, -6.552974e-003, -6.071447e-003, -5.627334e-003, -5.260632e-003, -4.940564e-003,
   -4.680510e-003, -4.493115e-003, -4.518905e-003, -4.674544e-003, -4.982171e-003, -5.456682e-003, -6.227990e-003, -7.194331e-003, -8.369432e-003,
   -9.673612e-003, -1.104694e-002, -1.238453e-002, -1.370461e-002, -1.498773e-002, -1.617976e-002, -1.726968e-002, -1.835257e-002, -1.944410e-002,
   -2.039484e-002, -2.120457e-002, -2.177195e-002, -2.207613e-002, -2.203223e-002, -2.166245e-002, -2.106259e-002, -2.032756e-002, -1.951773e-002,
   -1.870273e-002, -1.789780e-002, -1.709755e-002, -1.626338e-002, -1.553065e-002, -1.478031e-002, -1.399874e-002, -1.316922e-002, -1.227253e-002,
   -1.133702e-002, -1.044539e-002, -9.706953e-003, -9.170190e-003, -8.882478e-003, -8.908699e-003, -9.208948e-003, -9.718379e-003, -1.033312e-002,
   -1.101671e-002, -1.187972e-002, -1.258727e-002, -1.310278e-002, -1.339329e-002, -1.341135e-002, -1.308742e-002, -1.263665e-002, -1.201478e-002,
   -1.118051e-002, -1.006663e-002, -8.698361e-003, -7.000645e-003, -5.014099e-003, -2.661863e-003, -9.504265e-017},
  {0.000000e+000,  -2.469714e-002, -2.473741e-002, -2.405222e-002, -3.741649e-003, 2.191523e-002,  3.004823e-002,  3.490736e-002,  3.573678e-002,
   3.198222e-002,  2.153496e-002,  5.702981e-003,  -1.289214e-002, -2.994308e-002, -3.871065e-002, -3.894194e-002, -3.340419e-002, -2.426176e-002,
   -1.466523e-002, -3.085266e-003, 7.732097e-003,  1.503688e-002,  1.859290e-002,  1.864447e-002,  1.710718e-002,  1.421894e-002,  1.018549e-002,
   5.587017e-003,  1.192989e-003,  -1.994035e-003, -4.262802e-003, -6.295929e-003, -7.636204e-003, -8.170831e-003, -8.616133e-003, -8.658765e-003,
   -8.173853e-003, -6.305262e-003, -3.508473e-003, 4.313680e-005,  4.071673e-003,  8.678984e-003,  1.303724e-002,  1.668072e-002,  1.909616e-002,
   1.994462e-002,  1.870585e-002,  1.551111e-002,  1.160449e-002,  7.490275e-003,  4.442047e-003,  2.945680e-003,  2.356617e-003,  2.250466e-003,
   2.092284e-003,  1.829290e-003,  1.088032e-003,  -1.959431e-004, -1.711074e-003, -4.201147e-003, -7.821432e-003, -1.258203e-002, -1.716226e-002,
   -2.097909e-002, -2.367560e-002, -2.557019e-002, -2.671241e-002, -2.731694e-002, -2.703611e-002, -2.607524e-002, -2.432872e-002, -2.218602e-002,
   -1.956096e-002, -1.642157e-002, -1.306824e-002, -9.128684e-003, -5.022810e-003, -9.088909e-004, 3.112213e-003,  7.408376e-003,  1.207519e-002,
   1.677878e-002,  2.180218e-002,  2.659783e-002,  3.138106e-002,  3.598792e-002,  3.984319e-002,  4.272506e-002,  4.433416e-002,  4.461072e-002,
   4.327752e-002,  4.044258e-002,  3.630138e-002,  3.116601e-002,  2.491316e-002,  1.780005e-002,  9.515282e-003,  2.064248e-004,  -9.068661e-003,
   -1.837233e-002, -2.730946e-002, -3.490568e-002, -4.063500e-002, -4.392272e-002, -4.557725e-002, -4.587873e-002, -4.485252e-002, -4.275832e-002,
   -4.008398e-002, -3.694630e-002, -3.304749e-002, -2.867330e-002, -2.397167e-002, -1.852278e-002, -1.271055e-002, -6.908028e-003, -9.235115e-004,
   4.936529e-003,  1.046311e-002,  1.555157e-002,  1.956183e-002,  2.223251e-002,  2.328826e-002,  2.283432e-002,  2.121724e-002,  1.820797e-002,
   1.445283e-002,  1.005728e-002,  5.757214e-003,  1.708169e-003,  -2.368862e-003, -5.969397e-003, -8.953819e-003, -1.091631e-002, -1.153879e-002,
   -1.093272e-002, -9.583846e-003, -7.227005e-003, -4.264415e-003, -6.332222e-004, 3.563772e-003,  8.025719e-003,  1.287193e-002,  1.782613e-002,
   2.253753e-002,  2.677626e-002,  3.036717e-002,  3.329387e-002,  3.537673e-002,  3.672864e-002,  3.757941e-002,  3.725171e-002,  3.591777e-002,
   3.347496e-002,  2.979634e-002,  2.495512e-002,  1.884777e-002,  1.194969e-002,  4.639894e-003,  -2.832655e-003, -1.030999e-002, -1.717243e-002,
   -2.310889e-002, -2.816440e-002, -3.175951e-002, -3.384981e-002, -3.451982e-002, -3.438689e-002, -3.356070e-002, -3.223152e-002, -3.060941e-002,
   -2.874502e-002, -2.639277e-002, -2.348729e-002, -1.991079e-002, -1.568495e-002, -1.065097e-002, -5.328739e-003, 3.436562e-004,  6.088442e-003,
   1.190536e-002,  1.717460e-002,  2.168178e-002,  2.516354e-002,  2.763609e-002,  2.888219e-002,  2.930595e-002,  2.878452e-002,  2.710643e-002,
   2.461488e-002,  2.113023e-002,  1.695251e-002,  1.212703e-002,  6.948012e-003,  1.508608e-003,  -3.814585e-003, -8.648795e-003, -1.315810e-002,
   -1.760640e-002, -2.184816e-002, -2.575361e-002, -2.903948e-002, -3.116364e-002, -3.165045e-002, -3.033117e-002, -2.780772e-002, -2.431087e-002,
   -2.053059e-002, -1.683747e-002, -1.331233e-002, -1.008198e-002, -7.237729e-003, -4.673095e-003, -1.874590e-003, 1.184268e-003,  4.574012e-003,
   8.403873e-003,  1.233318e-002,  1.643578e-002,  2.011707e-002,  2.310985e-002,  2.494469e-002,  2.490363e-002,  2.320294e-002,  2.020001e-002,
   1.665536e-002,  1.270204e-002,  8.612392e-003,  4.478917e-003,  1.571016e-004,  -4.365922e-003, -9.130007e-003, -1.384645e-002, -1.828565e-002,
   -2.235556e-002, -2.575146e-002, -2.834808e-002, -3.020620e-002, -3.106271e-002, -3.114853e-002, -3.020945e-002, -2.813767e-002, -2.501593e-002,
   -2.099232e-002, -1.602425e-002, -1.064933e-002, -5.045817e-003, 1.254503e-004,  4.967998e-003,  9.552591e-003,  1.366735e-002,  1.710611e-002,
   1.998054e-002,  2.231760e-002,  2.432907e-002,  2.600744e-002,  2.726502e-002,  2.819859e-002,  2.863906e-002,  2.822755e-002,  2.653581e-002,
   2.294667e-002,  1.778420e-002,  1.143211e-002,  4.104702e-003,  -4.014319e-003, -1.202931e-002, -1.958348e-002, -2.631378e-002, -3.174873e-002,
   -3.564200e-002, -3.743810e-002, -3.769528e-002, -3.679272e-002, -3.530662e-002, -3.303707e-002, -3.029167e-002, -2.702925e-002, -2.327617e-002,
   -1.888226e-002, -1.401580e-002, -8.596156e-003, -2.685436e-003, 3.539384e-003,  1.005315e-002,  1.680412e-002,  2.360350e-002,  3.004834e-002,
   3.575538e-002,  4.032734e-002,  4.376997e-002,  4.607003e-002,  4.731562e-002,  4.740315e-002,  4.663758e-002,  4.480173e-002,  4.201254e-002,
   3.841397e-002,  3.402428e-002,  2.922936e-002,  2.436055e-002,  1.965072e-002,  1.519454e-002,  1.091344e-002,  6.779922e-003,  2.651729e-003,
   -1.142556e-003, -4.355308e-003, -6.874424e-003, -8.187367e-003, -8.004693e-003, -6.653978e-003, -4.675131e-003, -2.412549e-003, -1.801794e-004,
   1.960451e-003,  3.827486e-003,  5.336422e-003,  6.455668e-003,  7.130686e-003,  7.704794e-003,  8.426043e-003,  9.196559e-003,  9.846271e-003,
   1.034433e-002,  1.058532e-002,  1.013297e-002,  8.621587e-003,  5.706139e-003,  1.455167e-003,  -4.188250e-003, -1.052945e-002, -1.721039e-002,
   -2.394485e-002, -3.058344e-002, -3.662466e-002, -4.184156e-002, -4.620814e-002, -4.926624e-002, -5.120101e-002, -5.182468e-002, -5.133663e-002,
   -4.946614e-002, -4.645581e-002, -4.243800e-002, -3.769361e-002, -3.224662e-002, -2.612433e-002, -1.953594e-002, -1.264116e-002, -5.611731e-003,
   1.309327e-003,  7.759884e-003,  1.360613e-002,  1.873400e-002,  2.334811e-002,  2.703138e-002,  2.983114e-002,  3.161283e-002,  3.257043e-002,
   3.243703e-002,  3.129269e-002,  2.910848e-002,  2.596110e-002,  2.211607e-002,  1.783682e-002,  1.363941e-002,  9.775343e-003,  6.289424e-003,
   3.168244e-003,  5.442142e-004,  -1.432615e-003, -2.882379e-003, -3.757345e-003, -4.019791e-003, -3.602201e-003, -2.572118e-003, -9.670831e-004,
   9.029681e-004,  2.872666e-003,  4.880329e-003,  7.085902e-003,  9.357564e-003,  1.165989e-002,  1.398067e-002,  1.630992e-002,  1.856286e-002,
   2.061765e-002,  2.214967e-002,  2.288716e-002,  2.274893e-002,  2.155210e-002,  1.984837e-002,  1.773392e-002,  1.526252e-002,  1.250028e-002,
   9.520906e-003,  6.080876e-003,  2.117947e-003,  -2.154828e-003, -6.470547e-003, -1.082293e-002, -1.511478e-002, -1.901925e-002, -2.252049e-002,
   -2.537071e-002, -2.770976e-002, -2.932445e-002, -3.033750e-002, -3.050300e-002, -3.011630e-002, -2.915869e-002, -2.780598e-002, -2.603283e-002,
   -2.395820e-002, -2.171752e-002, -1.941299e-002, -1.700557e-002, -1.478619e-002, -1.284328e-002, -1.111396e-002, -9.706651e-003, -8.524213e-003,
   -7.608755e-003, -6.815194e-003, -6.397150e-003, -6.352473e-003, -7.017941e-003, -8.643011e-003, -1.161232e-002, -1.560416e-002, -2.014740e-002,
   -2.488373e-002, -2.963286e-002, -3.410267e-002, -3.790953e-002, -4.083287e-002, -4.222920e-002, -4.184246e-002, -3.988442e-002, -3.704735e-002,
   -3.362409e-002, -3.007321e-002, -2.650582e-002, -2.295975e-002, -1.922940e-002, -1.514926e-002, -1.058975e-002, -5.348284e-003, 5.125951e-004,
   6.877922e-003,  1.373155e-002,  2.097317e-002,  2.830371e-002,  3.544873e-002,  4.198773e-002,  4.748402e-002,  5.180024e-002,  5.471164e-002,
   5.658613e-002,  5.737312e-002,  5.727197e-002,  5.622846e-002,  5.430131e-002,  5.140708e-002,  4.792081e-002,  4.392795e-002,  3.975572e-002,
   3.543148e-002,  3.099325e-002,  2.642971e-002,  2.175544e-002,  1.688887e-002,  1.171612e-002,  6.227816e-003,  5.519335e-004,  -5.072114e-003,
   -1.046543e-002, -1.551374e-002, -1.999188e-002, -2.362500e-002, -2.643011e-002, -2.782810e-002, -2.796351e-002, -2.697521e-002, -2.543845e-002,
   -2.346073e-002, -2.116862e-002, -1.848509e-002, -1.557067e-002, -1.227826e-002, -8.675187e-003, -4.761031e-003, -4.820634e-004, 3.906117e-003,
   8.156725e-003,  1.215343e-002,  1.572166e-002,  1.891351e-002,  2.172695e-002,  2.402011e-002,  2.574990e-002,  2.674857e-002,  2.698458e-002,
   2.647294e-002,  2.525541e-002,  2.335007e-002,  2.088851e-002,  1.799333e-002,  1.499020e-002,  1.216037e-002,  9.681682e-003,  7.817044e-003,
   6.748233e-003,  6.583826e-003,  7.596197e-003,  9.844509e-003,  1.315159e-002,  1.710790e-002,  2.134541e-002,  2.553117e-002,  2.967176e-002,
   3.352215e-002,  3.695839e-002,  4.001679e-002,  4.261101e-002,  4.475191e-002,  4.648808e-002,  4.778138e-002,  4.860870e-002,  4.909802e-002,
   4.895594e-002,  4.811304e-002,  4.619319e-002,  4.286583e-002,  3.757626e-002,  3.078569e-002,  2.270371e-002,  1.387770e-002,  4.779164e-003,
   -4.092503e-003, -1.223514e-002, -1.943952e-002, -2.501403e-002, -2.890377e-002, -3.074296e-002, -3.146610e-002, -3.118263e-002, -3.031050e-002,
   -2.902008e-002, -2.750036e-002, -2.575038e-002, -2.389904e-002, -2.210426e-002, -2.036294e-002, -1.863248e-002, -1.669441e-002, -1.452353e-002,
   -1.226031e-002, -1.015735e-002, -8.429232e-003, -7.551904e-003, -7.805462e-003, -9.591092e-003, -1.251954e-002, -1.624616e-002, -2.042288e-002,
   -2.489127e-002, -2.961188e-002, -3.457365e-002, -3.974123e-002, -4.515161e-002, -5.066904e-002, -5.605736e-002, -6.114674e-002, -6.562307e-002,
   -6.922415e-002, -7.189946e-002, -7.361066e-002, -7.433874e-002, -7.405536e-002, -7.270721e-002, -7.012071e-002, -6.611841e-002, -6.100698e-002,
   -5.502489e-002, -4.868240e-002, -4.232679e-002, -3.612787e-002, -3.028428e-002, -2.487482e-002, -1.998584e-002, -1.574838e-002, -1.197147e-002,
   -8.556320e-003, -5.313683e-003, -2.056393e-003, 1.300921e-003,  4.759251e-003,  7.977133e-003,  1.041292e-002,  1.159322e-002,  1.095794e-002,
   8.868775e-003,  5.720589e-003,  1.987927e-003,  -2.142447e-003, -6.294556e-003, -1.019883e-002, -1.354720e-002, -1.568827e-002, -1.662010e-002,
   -1.626665e-002, -1.495183e-002, -1.263052e-002, -9.424037e-003, -5.214581e-003, -3.637457e-004, 5.184059e-003,  1.123331e-002,  1.783394e-002,
   2.477580e-002,  3.196704e-002,  3.925451e-002,  4.636777e-002,  5.324160e-002,  5.970919e-002,  6.560096e-002,  7.076938e-002,  7.526375e-002,
   7.894620e-002,  8.173836e-002,  8.338935e-002,  8.389413e-002,  8.295499e-002,  8.052404e-002,  7.633860e-002,  7.064882e-002,  6.368782e-002,
   5.574961e-002,  4.712387e-002,  3.798304e-002,  2.847083e-002,  1.876894e-002,  9.199882e-003,  8.134982e-005,  -8.292884e-003, -1.578281e-002,
   -2.208553e-002, -2.686247e-002, -2.986153e-002, -3.109736e-002, -3.103209e-002, -3.000446e-002, -2.835409e-002, -2.610663e-002, -2.350317e-002,
   -2.038541e-002, -1.674303e-002, -1.252272e-002, -7.866186e-003, -2.851779e-003, 2.492958e-003,  8.033557e-003,  1.367719e-002,  1.931524e-002,
   2.477433e-002,  2.961346e-002,  3.353311e-002,  3.612810e-002,  3.755714e-002,  3.776986e-002,  3.696566e-002,  3.494299e-002,  3.198361e-002,
   2.795162e-002,  2.309764e-002,  1.740483e-002,  1.108238e-002,  4.356670e-003,  -2.321363e-003, -8.611773e-003, -1.452709e-002, -2.007548e-002,
   -2.534522e-002, -3.017915e-002, -3.470007e-002, -3.849996e-002, -4.131858e-002, -4.254531e-002, -4.249640e-002, -4.128506e-002, -3.936655e-002,
   -3.702202e-002, -3.448186e-002, -3.190818e-002, -2.934765e-002, -2.684640e-002, -2.460685e-002, -2.221496e-002, -1.964941e-002, -1.697355e-002,
   -1.424889e-002, -1.160120e-002, -9.247429e-003, -7.441464e-003, -6.361837e-003, -6.528129e-003, -8.050804e-003, -1.102172e-002, -1.492772e-002,
   -1.948966e-002, -2.436264e-002, -2.923087e-002, -3.383541e-002, -3.788422e-002, -4.107220e-002, -4.299821e-002, -4.374500e-002, -4.370206e-002,
   -4.299503e-002, -4.176135e-002, -4.030828e-002, -3.855888e-002, -3.641545e-002, -3.388490e-002, -3.092344e-002, -2.770441e-002, -2.423872e-002,
   -2.068526e-002, -1.718202e-002, -1.392786e-002, -1.103860e-002, -8.474431e-003, -6.318499e-003, -4.599155e-003, -3.422108e-003, -2.864479e-003,
   -3.108889e-003, -4.030147e-003, -5.601586e-003, -7.665182e-003, -1.009093e-002, -1.265057e-002, -1.499711e-002, -1.699155e-002, -1.836148e-002,
   -1.901478e-002, -1.855544e-002, -1.709955e-002, -1.429007e-002, -1.041143e-002, -5.460287e-003, -1.261665e-004, 5.386747e-003,  1.089976e-002,
   1.626002e-002,  2.136863e-002,  2.598781e-002,  3.025222e-002,  3.411378e-002,  3.765520e-002,  4.092193e-002,  4.407766e-002,  4.711565e-002,
   5.002545e-002,  5.253883e-002,  5.441827e-002,  5.516846e-002,  5.452273e-002,  5.231446e-002,  4.903327e-002,  4.494703e-002,  4.041311e-002,
   3.570318e-002,  3.118171e-002,  2.717054e-002,  2.386149e-002,  2.160893e-002,  2.049939e-002,  2.038334e-002,  2.116251e-002,  2.286725e-002,
   2.550860e-002,  2.894125e-002,  3.308738e-002,  3.792023e-002,  4.331846e-002,  4.918008e-002,  5.532373e-002,  6.159011e-002,  6.779338e-002,
   7.374011e-002,  7.924353e-002,  8.423250e-002,  8.856909e-002,  9.221454e-002,  9.504767e-002,  9.707952e-002,  9.807293e-002,  9.799350e-002,
   9.672070e-002,  9.415504e-002,  9.002348e-002,  8.450535e-002,  7.751431e-002,  6.940370e-002,  6.022578e-002,  5.033211e-002,  3.981972e-002,
   2.890956e-002,  1.780620e-002,  6.837274e-003,  -3.649866e-003, -1.346158e-002, -2.202409e-002, -2.927461e-002, -3.418701e-002, -3.712054e-002,
   -3.801048e-002, -3.799177e-002, -3.726162e-002, -3.619610e-002, -3.506033e-002, -3.400738e-002, -3.308499e-002, -3.234542e-002, -3.170849e-002,
   -3.109412e-002, -3.025806e-002, -2.916112e-002, -2.775150e-002, -2.622987e-002, -2.484602e-002, -2.393411e-002, -2.409971e-002, -2.573158e-002,
   -2.916639e-002, -3.379603e-002, -3.916467e-002, -4.486303e-002, -5.070799e-002, -5.639171e-002, -6.160724e-002, -6.602924e-002, -6.921359e-002,
   -7.122981e-002, -7.199898e-002, -7.168501e-002, -7.024902e-002, -6.776982e-002, -6.444134e-002, -6.037314e-002, -5.562864e-002, -5.029028e-002,
   -4.437816e-002, -3.802252e-002, -3.145502e-002, -2.485232e-002, -1.840639e-002, -1.235996e-002, -6.777109e-003, -1.772432e-003, 2.620537e-003,
   6.263084e-003,  9.094347e-003,  1.090423e-002,  1.170086e-002,  1.140007e-002,  1.000376e-002,  7.240458e-003,  3.183850e-003,  -1.888138e-003,
   -7.616923e-003, -1.385779e-002, -2.034156e-002, -2.700623e-002, -3.368848e-002, -4.017702e-002, -4.643075e-002, -5.220429e-002, -5.740459e-002,
   -6.166947e-002, -6.508270e-002, -6.702545e-002, -6.779592e-002, -6.742814e-002, -6.647366e-002, -6.500989e-002, -6.315287e-002, -6.095275e-002,
   -5.846067e-002, -5.555226e-002, -5.228052e-002, -4.860444e-002, -4.471134e-002, -4.066064e-002, -3.656729e-002, -3.265045e-002, -2.903471e-002,
   -2.584128e-002, -2.297362e-002, -2.040460e-002, -1.796517e-002, -1.557589e-002, -1.311999e-002, -1.026399e-002, -6.838540e-003, -3.021240e-003,
   8.577324e-004,  4.517220e-003,  7.792295e-003,  1.059834e-002,  1.309582e-002,  1.548577e-002,  1.807547e-002,  2.106829e-002,  2.450881e-002,
   2.821024e-002,  3.197372e-002,  3.565061e-002,  3.905510e-002,  4.210720e-002,  4.478590e-002,  4.702872e-002,  4.874047e-002,  4.982489e-002,
   5.008851e-002,  4.962144e-002,  4.843749e-002,  4.653002e-002,  4.392504e-002,  4.065179e-002,  3.687196e-002,  3.284988e-002,  2.874829e-002,
   2.468267e-002,  2.080937e-002,  1.727332e-002,  1.404233e-002,  1.108063e-002,  8.401815e-003,  5.919254e-003,  3.778594e-003,  2.106801e-003,
   1.245779e-003,  1.378594e-003,  2.542308e-003,  4.343873e-003,  6.437735e-003,  8.610165e-003,  1.076727e-002,  1.291231e-002,  1.512545e-002,
   1.763357e-002,  2.059015e-002,  2.385508e-002,  2.733745e-002,  3.091171e-002,  3.446772e-002,  3.781009e-002,  4.082006e-002,  4.347937e-002,
   4.566470e-002,  4.742892e-002,  4.858360e-002,  4.916511e-002,  4.900863e-002,  4.814129e-002,  4.638987e-002,  4.362059e-002,  3.988572e-002,
   3.532695e-002,  2.990024e-002,  2.397584e-002,  1.788353e-002,  1.186827e-002,  6.180271e-003,  8.880984e-004,  -3.978949e-003, -8.481564e-003,
   -1.262243e-002, -1.627360e-002, -1.929416e-002, -2.138942e-002, -2.203095e-002, -2.130047e-002, -1.960012e-002, -1.735257e-002, -1.482877e-002,
   -1.222444e-002, -9.705679e-003, -7.346903e-003, -5.179196e-003, -2.998641e-003, -7.377860e-004, 1.586075e-003,  3.984716e-003,  6.592354e-003,
   9.220608e-003,  1.159025e-002,  1.343546e-002,  1.426936e-002,  1.371354e-002,  1.144513e-002,  7.906687e-003,  3.383170e-003,  -1.721122e-003,
   -7.078401e-003, -1.232085e-002, -1.725658e-002, -2.157435e-002, -2.485614e-002, -2.723712e-002, -2.853628e-002, -2.936226e-002, -2.956426e-002,
   -2.892067e-002, -2.713533e-002, -2.432830e-002, -2.018329e-002, -1.487482e-002, -8.065705e-003, -4.364645e-016},
  {0.000000e+000,  2.809420e-003,  -1.018166e-002, -1.607233e-002, -6.531790e-003, 9.806124e-003,  1.547079e-002,  1.789322e-002,  2.090920e-002,
   2.277750e-002,  2.272582e-002,  2.096861e-002,  1.861513e-002,  1.398930e-002,  9.723537e-003,  6.832688e-003,  4.442118e-003,  -3.286288e-003,
   -1.543934e-002, -2.795253e-002, -3.955612e-002, -4.810746e-002, -5.207969e-002, -5.463485e-002, -5.850764e-002, -6.197131e-002, -6.348723e-002,
   -6.040675e-002, -5.143065e-002, -3.913079e-002, -2.436117e-002, -8.321060e-003, 7.847207e-003,  2.324741e-002,  3.768372e-002,  4.978536e-002,
   5.901839e-002,  6.590013e-002,  7.029410e-002,  7.237472e-002,  7.293774e-002,  7.211752e-002,  6.999381e-002,  6.665861e-002,  6.280686e-002,
   5.910306e-002,  5.514026e-002,  5.083006e-002,  4.657457e-002,  4.226260e-002,  3.811827e-002,  3.144685e-002,  2.234341e-002,  1.130665e-002,
   -1.228664e-003, -1.412547e-002, -2.665243e-002, -3.848116e-002, -4.958071e-002, -5.857460e-002, -6.477188e-002, -6.806169e-002, -6.988016e-002,
   -7.073277e-002, -7.151384e-002, -7.239182e-002, -7.174895e-002, -7.010280e-002, -6.744340e-002, -6.444957e-002, -6.164063e-002, -5.812576e-002,
   -5.367930e-002, -4.848620e-002, -4.297960e-002, -3.657945e-002, -2.995950e-002, -2.296909e-002, -1.597946e-002, -8.585166e-003, -1.697770e-003,
   4.594097e-003,  1.148932e-002,  1.864880e-002,  2.454625e-002,  2.995974e-002,  3.540992e-002,  4.048432e-002,  4.511239e-002,  4.926768e-002,
   5.268009e-002,  5.575321e-002,  5.734974e-002,  5.920056e-002,  6.032806e-002,  5.995693e-002,  5.969690e-002,  5.902042e-002,  5.781207e-002,
   5.622053e-002,  5.381067e-002,  5.049819e-002,  4.761916e-002,  4.397071e-002,  3.998229e-002,  3.513161e-002,  2.942715e-002,  2.346468e-002,
   1.659425e-002,  9.489434e-003,  2.247064e-003,  -4.686881e-003, -1.174621e-002, -1.771552e-002, -2.386280e-002, -2.966788e-002, -3.437926e-002,
   -3.819551e-002, -4.163036e-002, -4.412448e-002, -4.555780e-002, -4.623978e-002, -4.544021e-002, -4.476229e-002, -4.358747e-002, -4.207403e-002,
   -4.058685e-002, -3.819245e-002, -3.615695e-002, -3.405509e-002, -3.179835e-002, -2.949527e-002, -2.648948e-002, -2.369028e-002, -2.114936e-002,
   -1.836444e-002, -1.591602e-002, -1.363393e-002, -1.136803e-002, -9.137404e-003, -7.535997e-003, -5.620719e-003, -3.213874e-003, -1.470036e-003,
   -1.923592e-004, 1.624043e-003,  3.547500e-003,  5.339353e-003,  6.709763e-003,  8.519441e-003,  1.007765e-002,  1.163250e-002,  1.367996e-002,
   1.581156e-002,  1.724416e-002,  1.839022e-002,  1.950540e-002,  2.023805e-002,  2.076328e-002,  2.068973e-002,  1.967446e-002,  1.825632e-002,
   1.712688e-002,  1.629514e-002,  1.496719e-002,  1.384224e-002,  1.222421e-002,  1.104391e-002,  9.688910e-003,  8.311743e-003,  6.099691e-003,
   4.040970e-003,  2.728207e-003,  1.296239e-003,  -3.271050e-004, -1.922908e-003, -3.056780e-003, -4.447362e-003, -6.021394e-003, -7.704061e-003,
   -8.476206e-003, -9.592973e-003, -1.139000e-002, -1.291937e-002, -1.483325e-002, -1.662574e-002, -1.839277e-002, -1.977263e-002, -2.159780e-002,
   -2.298761e-002, -2.444793e-002, -2.541764e-002, -2.607849e-002, -2.653594e-002, -2.625631e-002, -2.607451e-002, -2.522690e-002, -2.381982e-002,
   -2.209074e-002, -1.965890e-002, -1.650331e-002, -1.267991e-002, -8.316619e-003, -4.122197e-003, 6.139747e-004,  5.426511e-003,  1.008538e-002,
   1.478529e-002,  1.908357e-002,  2.327826e-002,  2.681402e-002,  3.041813e-002,  3.346004e-002,  3.662196e-002,  3.956993e-002,  4.235200e-002,
   4.478214e-002,  4.653939e-002,  4.830894e-002,  4.948398e-002,  5.054973e-002,  5.105857e-002,  5.050251e-002,  4.961175e-002,  4.782370e-002,
   4.582569e-002,  4.386202e-002,  4.110515e-002,  3.822829e-002,  3.546672e-002,  3.212723e-002,  2.876827e-002,  2.521422e-002,  2.131439e-002,
   1.761771e-002,  1.397709e-002,  1.067392e-002,  7.543316e-003,  4.366291e-003,  1.737139e-003,  -7.447393e-004, -3.013053e-003, -4.591211e-003,
   -5.725243e-003, -6.626321e-003, -7.209248e-003, -7.683898e-003, -7.636667e-003, -7.853054e-003, -7.986021e-003, -7.726953e-003, -7.367519e-003,
   -6.967053e-003, -6.343483e-003, -5.740733e-003, -5.276809e-003, -4.778452e-003, -4.480262e-003, -4.075902e-003, -3.580844e-003, -3.453706e-003,
   -3.529391e-003, -3.686823e-003, -4.354754e-003, -5.070101e-003, -5.457422e-003, -6.091960e-003, -6.374289e-003, -6.448705e-003, -6.388631e-003,
   -5.845405e-003, -4.843681e-003, -3.979188e-003, -3.074580e-003, -2.277702e-003, -1.925746e-003, -1.628717e-003, -1.406584e-003, -1.278687e-003,
   -1.262424e-003, -1.415470e-003, -1.777537e-003, -2.472035e-003, -3.214778e-003, -3.956296e-003, -4.650500e-003, -5.418870e-003, -6.527017e-003,
   -7.932233e-003, -9.894023e-003, -1.201590e-002, -1.445854e-002, -1.729280e-002, -2.017117e-002, -2.323385e-002, -2.645051e-002, -2.976934e-002,
   -3.354606e-002, -3.716312e-002, -4.084034e-002, -4.469100e-002, -4.802205e-002, -5.104382e-002, -5.378772e-002, -5.643616e-002, -5.879358e-002,
   -6.113698e-002, -6.347768e-002, -6.499656e-002, -6.606218e-002, -6.666706e-002, -6.644076e-002, -6.592303e-002, -6.526618e-002, -6.405506e-002,
   -6.249396e-002, -6.097593e-002, -5.937146e-002, -5.764781e-002, -5.538720e-002, -5.260856e-002, -4.966647e-002, -4.619167e-002, -4.256092e-002,
   -3.869885e-002, -3.498655e-002, -3.147448e-002, -2.776321e-002, -2.440123e-002, -2.141686e-002, -1.823270e-002, -1.508519e-002, -1.260855e-002,
   -1.029625e-002, -7.651348e-003, -5.079844e-003, -2.508632e-003, 3.713189e-004,  3.481791e-003,  6.670783e-003,  9.664226e-003,  1.295243e-002,
   1.639668e-002,  1.963827e-002,  2.294923e-002,  2.659309e-002,  3.039730e-002,  3.433333e-002,  3.817145e-002,  4.179942e-002,  4.539036e-002,
   4.862560e-002,  5.183228e-002,  5.502648e-002,  5.808067e-002,  6.084900e-002,  6.341277e-002,  6.574665e-002,  6.741887e-002,  6.867368e-002,
   6.959052e-002,  7.031543e-002,  7.042482e-002,  7.021797e-002,  7.007120e-002,  7.006946e-002,  6.961916e-002,  6.908332e-002,  6.829339e-002,
   6.748685e-002,  6.637344e-002,  6.538728e-002,  6.473878e-002,  6.422098e-002,  6.387686e-002,  6.329067e-002,  6.286465e-002,  6.251631e-002,
   6.188805e-002,  6.105184e-002,  6.027457e-002,  5.917069e-002,  5.799086e-002,  5.699766e-002,  5.628580e-002,  5.530932e-002,  5.426259e-002,
   5.306346e-002,  5.151547e-002,  4.933541e-002,  4.663960e-002,  4.381481e-002,  4.088084e-002,  3.784104e-002,  3.480345e-002,  3.164293e-002,
   2.852055e-002,  2.516690e-002,  2.142936e-002,  1.767626e-002,  1.381035e-002,  9.869841e-003,  5.840078e-003,  1.961443e-003,  -1.358005e-003,
   -4.485878e-003, -7.844382e-003, -1.106633e-002, -1.413394e-002, -1.704586e-002, -1.989014e-002, -2.259185e-002, -2.510935e-002, -2.738712e-002,
   -2.965424e-002, -3.162825e-002, -3.340499e-002, -3.516393e-002, -3.685782e-002, -3.853843e-002, -3.995720e-002, -4.124214e-002, -4.253524e-002,
   -4.369096e-002, -4.475482e-002, -4.585656e-002, -4.689625e-002, -4.779712e-002, -4.873259e-002, -4.978599e-002, -5.109208e-002, -5.227883e-002,
   -5.339013e-002, -5.436726e-002, -5.517795e-002, -5.562611e-002, -5.606504e-002, -5.596047e-002, -5.523544e-002, -5.410832e-002, -5.231778e-002,
   -5.051189e-002, -4.865704e-002, -4.707922e-002, -4.551303e-002, -4.370392e-002, -4.186493e-002, -3.984977e-002, -3.772692e-002, -3.534138e-002,
   -3.281257e-002, -3.043038e-002, -2.817283e-002, -2.586624e-002, -2.348127e-002, -2.129979e-002, -1.967071e-002, -1.839842e-002, -1.758337e-002,
   -1.692628e-002, -1.655944e-002, -1.635380e-002, -1.630859e-002, -1.657208e-002, -1.692339e-002, -1.738999e-002, -1.809193e-002, -1.884559e-002,
   -1.934509e-002, -1.997869e-002, -2.068653e-002, -2.147315e-002, -2.232529e-002, -2.288271e-002, -2.354313e-002, -2.417639e-002, -2.481200e-002,
   -2.556814e-002, -2.596303e-002, -2.634337e-002, -2.627289e-002, -2.605863e-002, -2.562108e-002, -2.464726e-002, -2.362012e-002, -2.237576e-002,
   -2.099902e-002, -1.956252e-002, -1.798387e-002, -1.623161e-002, -1.425377e-002, -1.219557e-002, -1.007178e-002, -8.158232e-003, -6.325662e-003,
   -4.402081e-003, -2.443807e-003, -5.249522e-004, 1.116050e-003,  2.573652e-003,  3.830355e-003,  5.231720e-003,  6.668176e-003,  7.899824e-003,
   8.566820e-003,  9.086328e-003,  9.565302e-003,  1.009236e-002,  1.041448e-002,  1.049655e-002,  1.023852e-002,  1.014630e-002,  1.049090e-002,
   1.106715e-002,  1.201162e-002,  1.303328e-002,  1.423878e-002,  1.573134e-002,  1.754041e-002,  1.944909e-002,  2.130418e-002,  2.279024e-002,
   2.414751e-002,  2.561326e-002,  2.707436e-002,  2.834315e-002,  2.955795e-002,  3.041365e-002,  3.138294e-002,  3.250166e-002,  3.341287e-002,
   3.403989e-002,  3.457351e-002,  3.486614e-002,  3.486823e-002,  3.454881e-002,  3.386356e-002,  3.300952e-002,  3.216468e-002,  3.105147e-002,
   2.995258e-002,  2.907563e-002,  2.836722e-002,  2.807916e-002,  2.819382e-002,  2.838264e-002,  2.874392e-002,  2.930124e-002,  3.000012e-002,
   3.082115e-002,  3.160027e-002,  3.202467e-002,  3.221299e-002,  3.213385e-002,  3.201174e-002,  3.195233e-002,  3.182716e-002,  3.149019e-002,
   3.104207e-002,  3.067949e-002,  3.034484e-002,  2.983977e-002,  2.880255e-002,  2.726677e-002,  2.528284e-002,  2.307693e-002,  2.086115e-002,
   1.852106e-002,  1.601943e-002,  1.343327e-002,  1.065968e-002,  7.784080e-003,  5.057599e-003,  2.257712e-003,  -5.166272e-004, -3.099734e-003,
   -5.503263e-003, -7.692548e-003, -9.775971e-003, -1.143168e-002, -1.273145e-002, -1.379694e-002, -1.453645e-002, -1.485248e-002, -1.478715e-002,
   -1.456329e-002, -1.416304e-002, -1.378568e-002, -1.367538e-002, -1.346707e-002, -1.338091e-002, -1.337350e-002, -1.344266e-002, -1.353764e-002,
   -1.371793e-002, -1.369050e-002, -1.370878e-002, -1.354285e-002, -1.367127e-002, -1.380686e-002, -1.389728e-002, -1.409517e-002, -1.467250e-002,
   -1.566821e-002, -1.688552e-002, -1.812636e-002, -1.934493e-002, -2.040972e-002, -2.125185e-002, -2.191478e-002, -2.265382e-002, -2.379584e-002,
   -2.447061e-002, -2.483882e-002, -2.466953e-002, -2.419094e-002, -2.354120e-002, -2.269191e-002, -2.169821e-002, -2.041436e-002, -1.892845e-002,
   -1.727855e-002, -1.540800e-002, -1.364184e-002, -1.184800e-002, -1.046199e-002, -9.719390e-003, -8.879728e-003, -8.060939e-003, -7.387932e-003,
   -6.826069e-003, -6.333804e-003, -6.051961e-003, -5.931181e-003, -5.879742e-003, -6.004457e-003, -6.466059e-003, -7.343483e-003, -8.425080e-003,
   -9.639188e-003, -1.103471e-002, -1.231647e-002, -1.353618e-002, -1.470765e-002, -1.584574e-002, -1.708902e-002, -1.832268e-002, -1.910493e-002,
   -1.925496e-002, -1.898867e-002, -1.843157e-002, -1.736933e-002, -1.577318e-002, -1.370763e-002, -1.132518e-002, -8.694927e-003, -5.833429e-003,
   -2.880202e-003, 1.200538e-004,  3.182671e-003,  6.302583e-003,  9.494026e-003,  1.294633e-002,  1.644557e-002,  1.981930e-002,  2.316515e-002,
   2.634589e-002,  2.937961e-002,  3.235725e-002,  3.509975e-002,  3.762362e-002,  4.001504e-002,  4.158814e-002,  4.258871e-002,  4.334019e-002,
   4.405809e-002,  4.443160e-002,  4.448508e-002,  4.444019e-002,  4.393559e-002,  4.338478e-002,  4.269724e-002,  4.207625e-002,  4.169790e-002,
   4.121821e-002,  4.074979e-002,  4.020284e-002,  3.948899e-002,  3.893418e-002,  3.868117e-002,  3.893758e-002,  3.943516e-002,  3.980624e-002,
   4.027181e-002,  4.080484e-002,  4.131376e-002,  4.164916e-002,  4.183542e-002,  4.159049e-002,  4.116916e-002,  4.056963e-002,  3.999757e-002,
   3.944882e-002,  3.891403e-002,  3.807400e-002,  3.720542e-002,  3.616425e-002,  3.469979e-002,  3.260476e-002,  3.017073e-002,  2.754672e-002,
   2.477863e-002,  2.195307e-002,  1.907490e-002,  1.629220e-002,  1.371438e-002,  1.123741e-002,  9.049839e-003,  7.219714e-003,  5.585377e-003,
   3.969487e-003,  2.484008e-003,  8.596376e-004,  -5.845881e-004, -1.981340e-003, -3.207072e-003, -4.217189e-003, -5.311963e-003, -6.446577e-003,
   -7.501763e-003, -8.535742e-003, -9.563127e-003, -1.065290e-002, -1.175375e-002, -1.291877e-002, -1.412201e-002, -1.544301e-002, -1.693868e-002,
   -1.861178e-002, -2.036392e-002, -2.227662e-002, -2.422983e-002, -2.606564e-002, -2.775785e-002, -2.954101e-002, -3.116040e-002, -3.252434e-002,
   -3.383050e-002, -3.498702e-002, -3.587027e-002, -3.633093e-002, -3.639564e-002, -3.618091e-002, -3.586866e-002, -3.559997e-002, -3.533912e-002,
   -3.522113e-002, -3.522200e-002, -3.540567e-002, -3.554025e-002, -3.575823e-002, -3.593865e-002, -3.603758e-002, -3.603350e-002, -3.588265e-002,
   -3.557097e-002, -3.522465e-002, -3.501552e-002, -3.505161e-002, -3.529570e-002, -3.580193e-002, -3.648309e-002, -3.721433e-002, -3.805832e-002,
   -3.878846e-002, -3.944967e-002, -3.998897e-002, -4.028615e-002, -4.051445e-002, -4.050024e-002, -4.014576e-002, -3.959262e-002, -3.869401e-002,
   -3.755213e-002, -3.617108e-002, -3.462522e-002, -3.303161e-002, -3.128883e-002, -2.941250e-002, -2.744797e-002, -2.531693e-002, -2.305536e-002,
   -2.085937e-002, -1.874498e-002, -1.677514e-002, -1.508296e-002, -1.364214e-002, -1.237144e-002, -1.124997e-002, -1.046911e-002, -9.808205e-003,
   -9.511396e-003, -9.490375e-003, -9.878623e-003, -1.065723e-002, -1.170485e-002, -1.295802e-002, -1.434085e-002, -1.576909e-002, -1.729681e-002,
   -1.886865e-002, -2.043805e-002, -2.197814e-002, -2.342369e-002, -2.479661e-002, -2.582199e-002, -2.637706e-002, -2.631817e-002, -2.577374e-002,
   -2.476469e-002, -2.347682e-002, -2.193465e-002, -2.036816e-002, -1.871834e-002, -1.691508e-002, -1.507779e-002, -1.329426e-002, -1.154331e-002,
   -9.832614e-003, -8.087838e-003, -6.224715e-003, -4.325074e-003, -2.329493e-003, -3.341823e-004, 1.549680e-003,  3.178575e-003,  4.457852e-003,
   5.302413e-003,  5.862484e-003,  6.293863e-003,  6.533263e-003,  6.768137e-003,  6.924227e-003,  7.212002e-003,  7.725657e-003,  8.505379e-003,
   9.444463e-003,  1.057038e-002,  1.193028e-002,  1.346425e-002,  1.525876e-002,  1.691790e-002,  1.866684e-002,  2.049635e-002,  2.218015e-002,
   2.373882e-002,  2.531557e-002,  2.699776e-002,  2.875195e-002,  3.036702e-002,  3.189079e-002,  3.327291e-002,  3.447763e-002,  3.540290e-002,
   3.607898e-002,  3.651880e-002,  3.672107e-002,  3.670173e-002,  3.634252e-002,  3.574405e-002,  3.487347e-002,  3.377866e-002,  3.239732e-002,
   3.085258e-002,  2.919181e-002,  2.744419e-002,  2.560025e-002,  2.383301e-002,  2.204382e-002,  2.027120e-002,  1.866113e-002,  1.723227e-002,
   1.596429e-002,  1.488236e-002,  1.413082e-002,  1.364276e-002,  1.345665e-002,  1.339082e-002,  1.339199e-002,  1.336845e-002,  1.334505e-002,
   1.345700e-002,  1.366851e-002,  1.391576e-002,  1.421393e-002,  1.463397e-002,  1.518057e-002,  1.562639e-002,  1.594114e-002,  1.608331e-002,
   1.614689e-002,  1.625631e-002,  1.642853e-002,  1.646063e-002,  1.647893e-002,  1.658519e-002,  1.673895e-002,  1.697354e-002,  1.719142e-002,
   1.732659e-002,  1.746007e-002,  1.763408e-002,  1.779985e-002,  1.791608e-002,  1.807997e-002,  1.831716e-002,  1.863347e-002,  1.902103e-002,
   1.942895e-002,  1.983889e-002,  2.020219e-002,  2.053772e-002,  2.089104e-002,  2.118801e-002,  2.146233e-002,  2.153422e-002,  2.140011e-002,
   2.093561e-002,  2.026548e-002,  1.942257e-002,  1.840138e-002,  1.722718e-002,  1.609799e-002,  1.489345e-002,  1.364427e-002,  1.231308e-002,
   1.101310e-002,  9.770681e-003,  8.442610e-003,  7.183730e-003,  5.965439e-003,  4.779826e-003,  3.802337e-003,  2.959676e-003,  2.220901e-003,
   1.621127e-003,  1.216553e-003,  9.882911e-004,  7.562584e-004,  5.403305e-004,  2.496082e-004,  -1.623190e-004, -5.324524e-004, -8.451632e-004,
   -1.211276e-003, -1.583089e-003, -1.895811e-003, -2.109040e-003, -2.431405e-003, -2.975188e-003, -3.585077e-003, -4.352275e-003, -5.128317e-003,
   -5.850866e-003, -6.757719e-003, -7.814969e-003, -9.050739e-003, -1.051684e-002, -1.216976e-002, -1.401496e-002, -1.592177e-002, -1.802597e-002,
   -2.026878e-002, -2.242096e-002, -2.465691e-002, -2.685876e-002, -2.900694e-002, -3.107607e-002, -3.304047e-002, -3.487575e-002, -3.665964e-002,
   -3.828642e-002, -3.978452e-002, -4.072626e-002, -4.138006e-002, -4.170846e-002, -4.175056e-002, -4.160614e-002, -4.136515e-002, -4.109265e-002,
   -4.082368e-002, -4.048039e-002, -4.011434e-002, -3.952376e-002, -3.882572e-002, -3.812580e-002, -3.738514e-002, -3.647261e-002, -3.553116e-002,
   -3.463221e-002, -3.381664e-002, -3.312101e-002, -3.244309e-002, -3.185788e-002, -3.142738e-002, -3.129164e-002, -3.138592e-002, -3.153924e-002,
   -3.167297e-002, -3.174434e-002, -3.150999e-002, -3.102688e-002, -3.028653e-002, -2.890663e-002, -2.690131e-002, -2.480032e-002, -2.257537e-002,
   -2.016211e-002, -1.749404e-002, -1.459472e-002, -1.138792e-002, -7.915766e-003, -4.100576e-003, -9.188738e-017},
  {0.000000e+000,  1.775357e-001,  7.979680e-002,  1.352792e-002,  -4.181026e-002, -8.132769e-002, -9.404215e-002, -9.455916e-002, -8.989608e-002,
   -7.985256e-002, -6.352006e-002, -4.249475e-002, -2.158452e-002, -2.144340e-003, 1.387942e-002,  2.614182e-002,  3.623704e-002,  4.952434e-002,
   6.440980e-002,  7.656527e-002,  8.532643e-002,  9.006238e-002,  8.925514e-002,  8.553569e-002,  8.001661e-002,  7.234274e-002,  6.292727e-002,
   5.081386e-002,  3.455084e-002,  1.628341e-002,  -9.577941e-004, -1.710321e-002, -3.364821e-002, -4.937845e-002, -6.160547e-002, -7.215006e-002,
   -7.944840e-002, -8.551187e-002, -8.850542e-002, -8.786581e-002, -8.574996e-002, -8.164471e-002, -7.543580e-002, -6.745867e-002, -5.972414e-002,
   -5.113554e-002, -4.158569e-002, -3.217542e-002, -2.235508e-002, -1.259558e-002, -4.125795e-003, 4.980666e-003,  1.542817e-002,  2.425986e-002,
   3.323126e-002,  4.138104e-002,  4.786503e-002,  5.384034e-002,  5.833674e-002,  5.985009e-002,  6.008450e-002,  5.856717e-002,  5.535562e-002,
   5.217350e-002,  4.939453e-002,  4.647304e-002,  4.302402e-002,  3.869665e-002,  3.376300e-002,  2.895096e-002,  2.508852e-002,  2.138382e-002,
   1.790209e-002,  1.397248e-002,  1.085247e-002,  7.112188e-003,  4.141784e-003,  1.008189e-003,  -1.734751e-003, -4.170502e-003, -5.749999e-003,
   -6.565894e-003, -8.863328e-003, -1.047774e-002, -1.134416e-002, -1.237537e-002, -1.359732e-002, -1.499437e-002, -1.656193e-002, -1.875878e-002,
   -2.116694e-002, -2.377183e-002, -2.583156e-002, -2.972528e-002, -3.352681e-002, -3.652694e-002, -3.924507e-002, -4.137043e-002, -4.400875e-002,
   -4.597247e-002, -4.615330e-002, -4.443518e-002, -4.269496e-002, -3.992261e-002, -3.606324e-002, -3.078620e-002, -2.500238e-002, -1.934453e-002,
   -1.294978e-002, -5.985306e-003, 6.514435e-004,  7.523569e-003,  1.469514e-002,  2.019589e-002,  2.646191e-002,  3.300599e-002,  3.863131e-002,
   4.337335e-002,  4.811716e-002,  5.140081e-002,  5.356248e-002,  5.459523e-002,  5.348807e-002,  5.220604e-002,  4.915858e-002,  4.542092e-002,
   4.126595e-002,  3.610679e-002,  3.093757e-002,  2.501628e-002,  1.937139e-002,  1.391436e-002,  8.183900e-003,  3.182525e-003,  -1.561228e-003,
   -6.152567e-003, -1.003398e-002, -1.312406e-002, -1.580312e-002, -1.801383e-002, -1.940371e-002, -2.016203e-002, -2.105435e-002, -2.114119e-002,
   -2.037169e-002, -1.994137e-002, -1.934457e-002, -1.869300e-002, -1.806662e-002, -1.770362e-002, -1.741813e-002, -1.694187e-002, -1.680878e-002,
   -1.744478e-002, -1.743596e-002, -1.789348e-002, -1.848119e-002, -1.931411e-002, -2.069512e-002, -2.212333e-002, -2.299142e-002, -2.329873e-002,
   -2.367479e-002, -2.315248e-002, -2.254663e-002, -2.116020e-002, -1.878980e-002, -1.636173e-002, -1.359265e-002, -1.084110e-002, -7.631074e-003,
   -4.656106e-003, -2.122915e-003, 8.894334e-004,  4.645573e-003,  8.285496e-003,  1.132095e-002,  1.480997e-002,  1.825488e-002,  2.156204e-002,
   2.443520e-002,  2.778102e-002,  3.067893e-002,  3.261212e-002,  3.396389e-002,  3.433366e-002,  3.416079e-002,  3.297483e-002,  3.162678e-002,
   2.971160e-002,  2.783266e-002,  2.509069e-002,  2.207689e-002,  1.883806e-002,  1.577284e-002,  1.242304e-002,  8.554981e-003,  4.585555e-003,
   6.295037e-004,  -3.454476e-003, -7.768312e-003, -1.168489e-002, -1.528311e-002, -1.806253e-002, -1.981329e-002, -2.133462e-002, -2.190818e-002,
   -2.226976e-002, -2.224323e-002, -2.247921e-002, -2.243741e-002, -2.190444e-002, -2.096512e-002, -1.985596e-002, -1.875623e-002, -1.726679e-002,
   -1.558051e-002, -1.292094e-002, -1.037565e-002, -8.147544e-003, -6.437165e-003, -5.227895e-003, -4.158536e-003, -3.732459e-003, -3.722019e-003,
   -4.418284e-003, -5.350611e-003, -6.384840e-003, -7.369892e-003, -8.086721e-003, -8.829875e-003, -9.976483e-003, -1.128610e-002, -1.227019e-002,
   -1.288059e-002, -1.316039e-002, -1.299378e-002, -1.232223e-002, -1.129450e-002, -1.033996e-002, -8.544031e-003, -6.416954e-003, -3.781462e-003,
   -5.711857e-004, 3.006480e-003,  6.724098e-003,  1.076401e-002,  1.491517e-002,  1.895882e-002,  2.256829e-002,  2.590205e-002,  2.861946e-002,
   3.150810e-002,  3.415531e-002,  3.629499e-002,  3.811590e-002,  3.945154e-002,  4.027185e-002,  4.107981e-002,  4.160502e-002,  4.122586e-002,
   3.995920e-002,  3.781511e-002,  3.466041e-002,  3.106434e-002,  2.731750e-002,  2.336091e-002,  1.926572e-002,  1.498141e-002,  1.066941e-002,
   6.827950e-003,  3.929504e-003,  1.759070e-003,  5.049203e-006,  -1.236753e-003, -2.031242e-003, -3.023990e-003, -3.997621e-003, -4.846515e-003,
   -5.539956e-003, -5.614635e-003, -5.390870e-003, -5.293738e-003, -4.959130e-003, -4.652576e-003, -4.340632e-003, -4.029976e-003, -3.551811e-003,
   -2.873659e-003, -2.737576e-003, -3.096771e-003, -3.675966e-003, -4.912411e-003, -6.339363e-003, -8.262740e-003, -1.008501e-002, -1.186835e-002,
   -1.416567e-002, -1.651681e-002, -1.885461e-002, -2.101977e-002, -2.302081e-002, -2.520444e-002, -2.701756e-002, -2.872377e-002, -2.963996e-002,
   -3.049702e-002, -3.142430e-002, -3.186568e-002, -3.136799e-002, -3.013262e-002, -2.838334e-002, -2.608881e-002, -2.367548e-002, -2.104875e-002,
   -1.850133e-002, -1.626662e-002, -1.424306e-002, -1.216910e-002, -1.007748e-002, -8.601265e-003, -7.327093e-003, -6.156899e-003, -5.263699e-003,
   -4.500261e-003, -3.868689e-003, -3.471726e-003, -3.621955e-003, -4.361121e-003, -5.825650e-003, -7.523705e-003, -9.524831e-003, -1.113932e-002,
   -1.300857e-002, -1.443190e-002, -1.598567e-002, -1.755453e-002, -1.858104e-002, -1.876336e-002, -1.890419e-002, -1.853937e-002, -1.717003e-002,
   -1.518982e-002, -1.340745e-002, -1.166089e-002, -9.369656e-003, -6.375983e-003, -3.794227e-003, -9.063803e-004, 2.630407e-003,  5.814687e-003,
   8.457891e-003,  1.113809e-002,  1.383462e-002,  1.630567e-002,  1.795249e-002,  1.923565e-002,  2.063875e-002,  2.170862e-002,  2.202251e-002,
   2.190855e-002,  2.131468e-002,  2.012651e-002,  1.837314e-002,  1.611885e-002,  1.369061e-002,  1.112773e-002,  8.527285e-003,  6.354191e-003,
   4.498634e-003,  3.205042e-003,  2.104224e-003,  1.452466e-003,  1.030718e-003,  8.000544e-004,  8.816518e-004,  1.198639e-003,  1.529135e-003,
   2.624371e-003,  4.219281e-003,  5.570242e-003,  6.871363e-003,  8.345820e-003,  9.974319e-003,  1.168317e-002,  1.370895e-002,  1.566419e-002,
   1.728765e-002,  1.910706e-002,  2.073761e-002,  2.189938e-002,  2.300193e-002,  2.397654e-002,  2.428721e-002,  2.408840e-002,  2.403179e-002,
   2.375233e-002,  2.336199e-002,  2.326847e-002,  2.302351e-002,  2.278487e-002,  2.246375e-002,  2.221760e-002,  2.205809e-002,  2.194189e-002,
   2.205544e-002,  2.226019e-002,  2.240831e-002,  2.316443e-002,  2.446934e-002,  2.578075e-002,  2.708407e-002,  2.885995e-002,  3.097414e-002,
   3.285330e-002,  3.454499e-002,  3.600295e-002,  3.718985e-002,  3.845224e-002,  3.961443e-002,  4.031147e-002,  4.055667e-002,  4.062118e-002,
   4.058071e-002,  4.039952e-002,  3.970058e-002,  3.854700e-002,  3.684086e-002,  3.427955e-002,  3.125401e-002,  2.787866e-002,  2.395604e-002,
   1.942683e-002,  1.482693e-002,  1.048785e-002,  6.045669e-003,  1.982673e-003,  -1.302004e-003, -3.899580e-003, -5.886104e-003, -7.842257e-003,
   -9.674443e-003, -1.105018e-002, -1.237017e-002, -1.361624e-002, -1.502766e-002, -1.603838e-002, -1.661329e-002, -1.706196e-002, -1.710428e-002,
   -1.716246e-002, -1.704844e-002, -1.664906e-002, -1.602535e-002, -1.540476e-002, -1.505375e-002, -1.475886e-002, -1.478372e-002, -1.529264e-002,
   -1.635865e-002, -1.777904e-002, -1.943414e-002, -2.142450e-002, -2.368372e-002, -2.625104e-002, -2.898016e-002, -3.201301e-002, -3.513431e-002,
   -3.830305e-002, -4.121431e-002, -4.401926e-002, -4.682618e-002, -4.941242e-002, -5.210793e-002, -5.493625e-002, -5.790831e-002, -6.089795e-002,
   -6.379123e-002, -6.650859e-002, -6.910548e-002, -7.126689e-002, -7.298534e-002, -7.419012e-002, -7.499471e-002, -7.476631e-002, -7.414241e-002,
   -7.328070e-002, -7.232296e-002, -7.106393e-002, -6.968162e-002, -6.801872e-002, -6.629371e-002, -6.421620e-002, -6.203182e-002, -5.979665e-002,
   -5.726520e-002, -5.468427e-002, -5.205914e-002, -4.954892e-002, -4.721034e-002, -4.493305e-002, -4.271330e-002, -4.077976e-002, -3.902642e-002,
   -3.774334e-002, -3.660856e-002, -3.561699e-002, -3.464784e-002, -3.360078e-002, -3.245776e-002, -3.106918e-002, -2.941113e-002, -2.756369e-002,
   -2.518323e-002, -2.236100e-002, -1.906614e-002, -1.513502e-002, -1.066250e-002, -5.681722e-003, -3.627199e-004, 4.849522e-003,  9.939384e-003,
   1.493057e-002,  1.974156e-002,  2.450762e-002,  2.918955e-002,  3.348365e-002,  3.766386e-002,  4.191393e-002,  4.577118e-002,  4.961030e-002,
   5.326948e-002,  5.665471e-002,  5.960551e-002,  6.212528e-002,  6.362037e-002,  6.463237e-002,  6.510611e-002,  6.501099e-002,  6.478102e-002,
   6.437586e-002,  6.401700e-002,  6.395799e-002,  6.448419e-002,  6.546915e-002,  6.707784e-002,  6.892822e-002,  7.064042e-002,  7.225311e-002,
   7.377380e-002,  7.524948e-002,  7.637023e-002,  7.737744e-002,  7.797798e-002,  7.851166e-002,  7.888344e-002,  7.909658e-002,  7.911198e-002,
   7.878248e-002,  7.778447e-002,  7.639693e-002,  7.467471e-002,  7.215210e-002,  6.866437e-002,  6.455535e-002,  5.989722e-002,  5.492741e-002,
   4.986163e-002,  4.466924e-002,  3.919746e-002,  3.343930e-002,  2.759372e-002,  2.154575e-002,  1.548573e-002,  9.867207e-003,  4.594771e-003,
   -4.861828e-004, -5.317351e-003, -9.733447e-003, -1.373598e-002, -1.712451e-002, -1.994701e-002, -2.240120e-002, -2.426787e-002, -2.553491e-002,
   -2.681574e-002, -2.795392e-002, -2.874376e-002, -2.909890e-002, -2.966294e-002, -3.030858e-002, -3.103860e-002, -3.196441e-002, -3.287562e-002,
   -3.385058e-002, -3.484905e-002, -3.569129e-002, -3.637912e-002, -3.649371e-002, -3.642645e-002, -3.634688e-002, -3.652791e-002, -3.765951e-002,
   -3.941217e-002, -4.160522e-002, -4.403155e-002, -4.650886e-002, -4.882421e-002, -5.100350e-002, -5.296732e-002, -5.371197e-002, -5.339855e-002,
   -5.269341e-002, -5.153556e-002, -4.975909e-002, -4.759429e-002, -4.500084e-002, -4.201360e-002, -3.873806e-002, -3.510419e-002, -3.104240e-002,
   -2.663765e-002, -2.225724e-002, -1.802804e-002, -1.384412e-002, -9.820509e-003, -5.050622e-003, -4.289706e-004, 4.052347e-003,  8.205976e-003,
   1.192988e-002,  1.524583e-002,  1.807433e-002,  2.038908e-002,  2.202368e-002,  2.313006e-002,  2.338327e-002,  2.299727e-002,  2.193849e-002,
   2.026913e-002,  1.817884e-002,  1.570489e-002,  1.309728e-002,  1.032596e-002,  7.360666e-003,  4.936064e-003,  3.377962e-003,  2.120746e-003,
   1.173231e-003,  8.454707e-004,  1.201537e-003,  2.048667e-003,  3.265170e-003,  4.649957e-003,  6.221985e-003,  7.788325e-003,  9.483841e-003,
   1.107598e-002,  1.252047e-002,  1.402649e-002,  1.551110e-002,  1.708970e-002,  1.877187e-002,  2.067124e-002,  2.263600e-002,  2.437845e-002,
   2.573648e-002,  2.668888e-002,  2.715850e-002,  2.706352e-002,  2.640040e-002,  2.515413e-002,  2.428459e-002,  2.305134e-002,  2.144984e-002,
   1.924720e-002,  1.642339e-002,  1.321792e-002,  9.807667e-003,  6.797553e-003,  3.735818e-003,  7.514496e-004,  -2.166591e-003, -4.979942e-003,
   -7.600587e-003, -9.896762e-003, -1.157031e-002, -1.263526e-002, -1.341388e-002, -1.373675e-002, -1.361667e-002, -1.293288e-002, -1.186383e-002,
   -1.051878e-002, -8.980802e-003, -7.485443e-003, -6.153049e-003, -5.251272e-003, -4.228142e-003, -3.160194e-003, -2.085850e-003, -1.061451e-003,
   1.950122e-004,  1.459818e-003,  2.644450e-003,  3.392209e-003,  3.663072e-003,  3.417374e-003,  3.087652e-003,  2.184496e-003,  9.372766e-004,
   -7.760320e-004, -2.820221e-003, -5.122270e-003, -7.301273e-003, -9.263047e-003, -1.080978e-002, -1.194177e-002, -1.257250e-002, -1.309406e-002,
   -1.360562e-002, -1.414431e-002, -1.414208e-002, -1.386393e-002, -1.342487e-002, -1.288935e-002, -1.209866e-002, -1.123930e-002, -1.027309e-002,
   -9.341628e-003, -8.439419e-003, -7.611592e-003, -6.857919e-003, -6.202253e-003, -5.447803e-003, -4.974656e-003, -4.786738e-003, -4.817972e-003,
   -5.098632e-003, -5.534286e-003, -6.200894e-003, -6.997894e-003, -7.957233e-003, -8.975942e-003, -9.901044e-003, -1.069107e-002, -1.110689e-002,
   -1.127027e-002, -1.109272e-002, -1.050726e-002, -9.507492e-003, -8.115713e-003, -6.430399e-003, -4.421938e-003, -2.272362e-003, -1.816417e-004,
   2.030257e-003,  4.134755e-003,  6.023023e-003,  7.810538e-003,  9.156440e-003,  1.024259e-002,  1.111831e-002,  1.189350e-002,  1.259942e-002,
   1.310139e-002,  1.327879e-002,  1.315171e-002,  1.252567e-002,  1.112800e-002,  8.994592e-003,  6.421979e-003,  3.538716e-003,  3.993954e-004,
   -2.835571e-003, -6.087859e-003, -9.221628e-003, -1.197625e-002, -1.434723e-002, -1.632804e-002, -1.784148e-002, -1.888035e-002, -1.948038e-002,
   -1.954604e-002, -1.911668e-002, -1.829814e-002, -1.730183e-002, -1.598150e-002, -1.446889e-002, -1.274503e-002, -1.078627e-002, -8.696629e-003,
   -6.663931e-003, -4.758186e-003, -2.985306e-003, -1.346903e-003, 1.714629e-004,  1.503688e-003,  2.620473e-003,  3.419879e-003,  3.913133e-003,
   3.983803e-003,  3.627704e-003,  2.761205e-003,  1.373365e-003,  -7.614991e-004, -3.359978e-003, -6.327332e-003, -9.489271e-003, -1.285245e-002,
   -1.628861e-002, -1.966313e-002, -2.305150e-002, -2.635355e-002, -2.939505e-002, -3.182279e-002, -3.366256e-002, -3.428710e-002, -3.390725e-002,
   -3.269257e-002, -3.094919e-002, -2.875207e-002, -2.632205e-002, -2.374175e-002, -2.108559e-002, -1.842597e-002, -1.582152e-002, -1.321845e-002,
   -1.054523e-002, -7.588319e-003, -4.343790e-003, -1.007493e-003, 2.452652e-003,  5.753544e-003,  8.825611e-003,  1.144666e-002,  1.342857e-002,
   1.460600e-002,  1.527906e-002,  1.564168e-002,  1.556156e-002,  1.525283e-002,  1.497526e-002,  1.477464e-002,  1.477853e-002,  1.529520e-002,
   1.616800e-002,  1.737829e-002,  1.898786e-002,  2.082708e-002,  2.292831e-002,  2.539158e-002,  2.815409e-002,  3.113407e-002,  3.422539e-002,
   3.734651e-002,  4.054805e-002,  4.381825e-002,  4.694746e-002,  4.979756e-002,  5.248548e-002,  5.485682e-002,  5.697983e-002,  5.879039e-002,
   6.025996e-002,  6.138572e-002,  6.213849e-002,  6.254298e-002,  6.213726e-002,  6.111987e-002,  5.961144e-002,  5.760319e-002,  5.506664e-002,
   5.217947e-002,  4.898028e-002,  4.545073e-002,  4.171353e-002,  3.784315e-002,  3.368698e-002,  2.941330e-002,  2.514378e-002,  2.112067e-002,
   1.730015e-002,  1.380694e-002,  1.074233e-002,  8.111265e-003,  5.932291e-003,  3.967943e-003,  2.124484e-003,  2.590918e-004,  -1.614750e-003,
   -3.221389e-003, -4.685661e-003, -5.996490e-003, -7.168788e-003, -8.353833e-003, -9.407996e-003, -1.060870e-002, -1.197320e-002, -1.347213e-002,
   -1.502766e-002, -1.650786e-002, -1.807159e-002, -1.972657e-002, -2.140553e-002, -2.310271e-002, -2.455948e-002, -2.595821e-002, -2.726262e-002,
   -2.829948e-002, -2.929560e-002, -3.016580e-002, -3.104933e-002, -3.194615e-002, -3.275305e-002, -3.329386e-002, -3.348462e-002, -3.323642e-002,
   -3.268994e-002, -3.197261e-002, -3.115347e-002, -3.014446e-002, -2.882002e-002, -2.734648e-002, -2.583023e-002, -2.425473e-002, -2.271960e-002,
   -2.135692e-002, -2.021249e-002, -1.921181e-002, -1.840541e-002, -1.780193e-002, -1.708260e-002, -1.653625e-002, -1.605120e-002, -1.573433e-002,
   -1.542857e-002, -1.488292e-002, -1.426872e-002, -1.356561e-002, -1.284821e-002, -1.216225e-002, -1.119633e-002, -1.033367e-002, -9.469171e-003,
   -8.475329e-003, -7.252268e-003, -5.751224e-003, -4.212961e-003, -2.722542e-003, -1.440589e-003, -4.467704e-004, 6.579989e-004,  1.813995e-003,
   2.956321e-003,  4.202859e-003,  5.523915e-003,  6.832496e-003,  7.916275e-003,  8.690821e-003,  9.389211e-003,  9.914250e-003,  1.047504e-002,
   1.115510e-002,  1.163301e-002,  1.186959e-002,  1.178835e-002,  1.136925e-002,  1.073839e-002,  9.806369e-003,  8.580976e-003,  7.023311e-003,
   5.227929e-003,  3.581448e-003,  1.674001e-003,  -2.985087e-004, -2.187038e-003, -3.948673e-003, -5.603546e-003, -7.083235e-003, -8.440955e-003,
   -9.694266e-003, -1.092461e-002, -1.151291e-002, -1.176717e-002, -1.150360e-002, -1.078362e-002, -9.779732e-003, -8.650834e-003, -7.540768e-003,
   -6.564140e-003, -5.746833e-003, -5.044707e-003, -4.079054e-003, -2.880693e-003, -1.766820e-003, -7.531407e-004, 1.536002e-004,  9.972695e-004,
   1.514170e-003,  1.794759e-003,  1.766574e-003,  1.399637e-003,  7.233265e-004,  -3.432990e-004, -1.971344e-003, -4.029041e-003, -6.459820e-003,
   -8.946882e-003, -1.117553e-002, -1.336150e-002, -1.533071e-002, -1.677262e-002, -1.736740e-002, -1.696338e-002, -1.647855e-002, -1.588990e-002,
   -1.499175e-002, -1.364992e-002, -1.191554e-002, -9.664514e-003, -6.972047e-003, -3.712297e-003, 1.604006e-016},
  {0.000000e+000,  2.038977e-001,  5.986865e-002,  -2.943833e-002, -7.799666e-002, -9.455111e-002, -9.181085e-002, -8.392553e-002, -7.199876e-002,
   -5.644654e-002, -3.877417e-002, -1.894875e-002, 1.009213e-003,  1.790310e-002,  3.261412e-002,  4.651401e-002,  5.801635e-002,  6.683222e-002,
   7.214600e-002,  7.485705e-002,  7.358793e-002,  6.958921e-002,  6.187436e-002,  5.197944e-002,  3.971716e-002,  2.704245e-002,  1.407361e-002,
   1.397047e-003,  -9.703171e-003, -1.932254e-002, -2.683198e-002, -3.274516e-002, -3.789992e-002, -4.282698e-002, -4.668334e-002, -4.931934e-002,
   -5.059847e-002, -5.211500e-002, -5.158548e-002, -4.862963e-002, -4.493928e-002, -4.019584e-002, -3.521807e-002, -2.887773e-002, -2.261393e-002,
   -1.728430e-002, -1.101569e-002, -4.683203e-003, 1.118357e-003,  7.670594e-003,  1.411585e-002,  1.895433e-002,  2.304213e-002,  2.609218e-002,
   2.919360e-002,  3.087543e-002,  3.124964e-002,  3.164525e-002,  3.109008e-002,  3.038019e-002,  3.022243e-002,  3.008269e-002,  2.843726e-002,
   2.660720e-002,  2.479568e-002,  2.230414e-002,  1.947827e-002,  1.670303e-002,  1.323369e-002,  9.039395e-003,  5.287494e-003,  1.356397e-003,
   -2.354074e-003, -6.225131e-003, -9.184846e-003, -1.151499e-002, -1.356011e-002, -1.546715e-002, -1.719785e-002, -1.903340e-002, -2.042553e-002,
   -2.092884e-002, -2.167044e-002, -2.157935e-002, -2.112037e-002, -2.044625e-002, -1.954117e-002, -1.821105e-002, -1.605512e-002, -1.398371e-002,
   -1.200372e-002, -9.451352e-003, -6.988076e-003, -4.615986e-003, -2.342345e-003, 1.613535e-004,  2.904732e-003,  4.932203e-003,  6.368238e-003,
   7.562709e-003,  9.143085e-003,  1.008219e-002,  1.080866e-002,  1.151120e-002,  1.251888e-002,  1.319438e-002,  1.336476e-002,  1.308933e-002,
   1.267152e-002,  1.174073e-002,  1.118541e-002,  1.032100e-002,  9.654384e-003,  8.508705e-003,  7.499380e-003,  6.289018e-003,  4.965812e-003,
   3.897420e-003,  2.870485e-003,  1.839803e-003,  1.197311e-003,  3.646383e-004,  -1.088043e-004, -1.641654e-003, -2.939876e-003, -4.559207e-003,
   -6.083721e-003, -7.883860e-003, -1.042554e-002, -1.267706e-002, -1.501106e-002, -1.577742e-002, -1.642432e-002, -1.637608e-002, -1.584167e-002,
   -1.460733e-002, -1.253995e-002, -1.029386e-002, -7.819679e-003, -5.157811e-003, -2.415107e-003, 1.666464e-004,  2.251748e-003,  4.320920e-003,
   6.234691e-003,  7.793974e-003,  9.442236e-003,  1.080505e-002,  1.236911e-002,  1.337776e-002,  1.377380e-002,  1.412727e-002,  1.386806e-002,
   1.331523e-002,  1.270956e-002,  1.149312e-002,  1.025597e-002,  8.388563e-003,  6.375204e-003,  3.815845e-003,  1.012968e-003,  -1.399721e-003,
   -3.834535e-003, -6.341051e-003, -7.555108e-003, -8.631437e-003, -9.460954e-003, -1.000364e-002, -1.074642e-002, -1.168537e-002, -1.193079e-002,
   -1.182945e-002, -1.195279e-002, -1.132751e-002, -1.085958e-002, -9.892540e-003, -8.961343e-003, -7.922163e-003, -6.631306e-003, -4.882750e-003,
   -3.767355e-003, -2.535538e-003, -1.054977e-003, -2.860438e-005, 5.330343e-004,  1.292331e-003,  1.433929e-003,  1.731070e-003,  2.259687e-003,
   2.852055e-003,  2.403100e-003,  1.752836e-003,  4.696530e-004,  -1.098445e-003, -2.427891e-003, -2.971284e-003, -3.481177e-003, -4.161724e-003,
   -3.073227e-003, -2.428219e-003, -1.484795e-003, -8.435546e-004, -3.580265e-004, 1.018132e-005,  1.240260e-003,  3.431439e-003,  5.212790e-003,
   7.105515e-003,  9.362173e-003,  1.160303e-002,  1.368285e-002,  1.625282e-002,  1.966779e-002,  2.221942e-002,  2.447969e-002,  2.651007e-002,
   2.855703e-002,  3.070740e-002,  3.202880e-002,  3.379481e-002,  3.485243e-002,  3.496797e-002,  3.460821e-002,  3.433300e-002,  3.361378e-002,
   3.179794e-002,  2.918193e-002,  2.663118e-002,  2.328188e-002,  1.964777e-002,  1.595553e-002,  1.204813e-002,  7.612108e-003,  2.669550e-003,
   -2.293426e-003, -6.832927e-003, -1.186429e-002, -1.712440e-002, -2.201673e-002, -2.599345e-002, -2.957282e-002, -3.361600e-002, -3.744508e-002,
   -3.962718e-002, -4.222042e-002, -4.502838e-002, -4.789559e-002, -4.996224e-002, -5.196838e-002, -5.421404e-002, -5.678315e-002, -5.764661e-002,
   -5.799532e-002, -5.869838e-002, -5.931909e-002, -5.932131e-002, -5.875619e-002, -5.790336e-002, -5.684888e-002, -5.537023e-002, -5.258649e-002,
   -5.004176e-002, -4.763360e-002, -4.517555e-002, -4.185483e-002, -3.785347e-002, -3.337568e-002, -2.899931e-002, -2.452926e-002, -1.914155e-002,
   -1.346341e-002, -7.615584e-003, -1.541612e-003, 5.020995e-003,  1.176112e-002,  1.802937e-002,  2.344018e-002,  2.861669e-002,  3.380264e-002,
   3.889844e-002,  4.339233e-002,  4.731591e-002,  5.146970e-002,  5.537960e-002,  5.839466e-002,  6.065892e-002,  6.231486e-002,  6.378404e-002,
   6.523854e-002,  6.607171e-002,  6.599560e-002,  6.527617e-002,  6.461802e-002,  6.320286e-002,  6.117599e-002,  5.881066e-002,  5.590146e-002,
   5.301861e-002,  5.013788e-002,  4.702900e-002,  4.370030e-002,  3.995248e-002,  3.586635e-002,  3.153618e-002,  2.725323e-002,  2.291460e-002,
   1.838014e-002,  1.460601e-002,  1.102648e-002,  8.120367e-003,  5.065249e-003,  1.737932e-003,  -1.011730e-003, -3.147316e-003, -4.481536e-003,
   -6.074214e-003, -7.514559e-003, -9.156324e-003, -1.037794e-002, -1.107405e-002, -1.172200e-002, -1.252735e-002, -1.315486e-002, -1.272022e-002,
   -1.234652e-002, -1.223645e-002, -1.227328e-002, -1.235086e-002, -1.277333e-002, -1.371944e-002, -1.478117e-002, -1.577827e-002, -1.730560e-002,
   -1.900038e-002, -2.038587e-002, -2.174282e-002, -2.266705e-002, -2.333158e-002, -2.362447e-002, -2.329662e-002, -2.261270e-002, -2.224872e-002,
   -2.129169e-002, -2.035654e-002, -1.924514e-002, -1.809091e-002, -1.676887e-002, -1.579749e-002, -1.455195e-002, -1.367036e-002, -1.293713e-002,
   -1.217810e-002, -1.140223e-002, -1.048087e-002, -9.495843e-003, -8.751255e-003, -8.063505e-003, -7.037342e-003, -6.107426e-003, -5.328495e-003,
   -4.449697e-003, -3.911455e-003, -3.501307e-003, -2.831702e-003, -2.412742e-003, -2.426512e-003, -2.280264e-003, -2.254412e-003, -2.310929e-003,
   -1.822689e-003, -1.055015e-003, -3.095796e-004, 1.004677e-003,  2.104851e-003,  3.309984e-003,  4.953510e-003,  6.465559e-003,  7.755958e-003,
   8.856977e-003,  1.001807e-002,  1.103338e-002,  1.215749e-002,  1.314452e-002,  1.380485e-002,  1.416623e-002,  1.468435e-002,  1.466699e-002,
   1.437880e-002,  1.387350e-002,  1.273483e-002,  1.128784e-002,  1.034932e-002,  8.903706e-003,  7.120053e-003,  5.308982e-003,  3.312845e-003,
   7.750683e-004,  -1.671693e-003, -3.925227e-003, -6.748509e-003, -1.007054e-002, -1.328866e-002, -1.663213e-002, -2.007830e-002, -2.329442e-002,
   -2.628339e-002, -2.895602e-002, -3.120966e-002, -3.309309e-002, -3.483582e-002, -3.656914e-002, -3.812007e-002, -3.989632e-002, -4.157040e-002,
   -4.268643e-002, -4.308429e-002, -4.314905e-002, -4.322757e-002, -4.281862e-002, -4.203354e-002, -4.116743e-002, -4.007474e-002, -3.883531e-002,
   -3.774353e-002, -3.678234e-002, -3.533250e-002, -3.360346e-002, -3.176519e-002, -2.928535e-002, -2.624132e-002, -2.304734e-002, -2.001894e-002,
   -1.712506e-002, -1.383000e-002, -1.047400e-002, -6.833856e-003, -2.938309e-003, 8.382916e-004,  4.974584e-003,  9.608949e-003,  1.516981e-002,
   2.059556e-002,  2.563920e-002,  3.080621e-002,  3.584224e-002,  4.029793e-002,  4.446684e-002,  4.853835e-002,  5.248158e-002,  5.603093e-002,
   5.952553e-002,  6.279237e-002,  6.560385e-002,  6.823341e-002,  7.069727e-002,  7.317271e-002,  7.509902e-002,  7.611028e-002,  7.630491e-002,
   7.590466e-002,  7.521284e-002,  7.388243e-002,  7.185528e-002,  6.955907e-002,  6.667665e-002,  6.357474e-002,  6.020980e-002,  5.652693e-002,
   5.274491e-002,  4.893944e-002,  4.515162e-002,  4.131544e-002,  3.726452e-002,  3.299605e-002,  2.885540e-002,  2.475995e-002,  2.068679e-002,
   1.675184e-002,  1.320004e-002,  9.920054e-003,  6.617535e-003,  3.704446e-003,  9.802665e-004,  -1.769586e-003, -3.985101e-003, -6.020592e-003,
   -7.922071e-003, -9.781234e-003, -1.151929e-002, -1.278941e-002, -1.399082e-002, -1.505156e-002, -1.600855e-002, -1.702415e-002, -1.779437e-002,
   -1.822644e-002, -1.871108e-002, -1.949713e-002, -2.045065e-002, -2.174309e-002, -2.328937e-002, -2.504176e-002, -2.692291e-002, -2.895548e-002,
   -3.104563e-002, -3.331170e-002, -3.556487e-002, -3.782073e-002, -3.994800e-002, -4.193592e-002, -4.369154e-002, -4.495409e-002, -4.600990e-002,
   -4.683610e-002, -4.704017e-002, -4.684475e-002, -4.634755e-002, -4.547854e-002, -4.442972e-002, -4.334853e-002, -4.186357e-002, -4.037194e-002,
   -3.857011e-002, -3.668145e-002, -3.504295e-002, -3.350181e-002, -3.171778e-002, -2.997645e-002, -2.839207e-002, -2.668402e-002, -2.491234e-002,
   -2.330417e-002, -2.193242e-002, -2.077107e-002, -1.994255e-002, -1.935393e-002, -1.910959e-002, -1.895475e-002, -1.879883e-002, -1.872891e-002,
   -1.875136e-002, -1.871446e-002, -1.857140e-002, -1.825883e-002, -1.767523e-002, -1.681002e-002, -1.596656e-002, -1.487790e-002, -1.344102e-002,
   -1.162909e-002, -9.852538e-003, -8.113489e-003, -6.445951e-003, -4.641957e-003, -2.885425e-003, -1.083789e-003, 7.257122e-004,  2.550678e-003,
   4.469009e-003,  6.470269e-003,  8.153632e-003,  9.612265e-003,  1.071153e-002,  1.152931e-002,  1.198704e-002,  1.222847e-002,  1.250427e-002,
   1.286550e-002,  1.323518e-002,  1.352264e-002,  1.366316e-002,  1.368216e-002,  1.356630e-002,  1.348990e-002,  1.352584e-002,  1.366536e-002,
   1.389662e-002,  1.424056e-002,  1.468941e-002,  1.525777e-002,  1.599095e-002,  1.712325e-002,  1.853401e-002,  2.015504e-002,  2.234412e-002,
   2.463301e-002,  2.708933e-002,  2.953201e-002,  3.158713e-002,  3.339768e-002,  3.509685e-002,  3.687388e-002,  3.882640e-002,  4.059849e-002,
   4.202608e-002,  4.339748e-002,  4.472859e-002,  4.602700e-002,  4.676366e-002,  4.696798e-002,  4.685429e-002,  4.655567e-002,  4.590091e-002,
   4.486815e-002,  4.356470e-002,  4.214784e-002,  4.049342e-002,  3.877558e-002,  3.702745e-002,  3.532785e-002,  3.350575e-002,  3.150888e-002,
   2.967715e-002,  2.799735e-002,  2.661135e-002,  2.535264e-002,  2.432964e-002,  2.326283e-002,  2.237897e-002,  2.161819e-002,  2.090879e-002,
   2.010783e-002,  1.930238e-002,  1.835758e-002,  1.725111e-002,  1.584139e-002,  1.379933e-002,  1.157148e-002,  9.268491e-003,  6.705655e-003,
   3.715205e-003,  4.107081e-004,  -3.087601e-003, -6.798565e-003, -1.095160e-002, -1.540491e-002, -2.002156e-002, -2.449577e-002, -2.919329e-002,
   -3.395445e-002, -3.868531e-002, -4.353909e-002, -4.844245e-002, -5.329503e-002, -5.809130e-002, -6.290737e-002, -6.772933e-002, -7.189172e-002,
   -7.551542e-002, -7.850489e-002, -8.063716e-002, -8.220160e-002, -8.336836e-002, -8.406753e-002, -8.441841e-002, -8.444045e-002, -8.391728e-002,
   -8.295204e-002, -8.152658e-002, -7.973977e-002, -7.751409e-002, -7.500005e-002, -7.228445e-002, -6.906917e-002, -6.537511e-002, -6.141198e-002,
   -5.724726e-002, -5.284759e-002, -4.848487e-002, -4.401123e-002, -3.970338e-002, -3.573580e-002, -3.260237e-002, -2.964431e-002, -2.677199e-002,
   -2.404109e-002, -2.135362e-002, -1.888864e-002, -1.624491e-002, -1.332417e-002, -1.031546e-002, -7.261665e-003, -4.268121e-003, -1.508795e-003,
   1.134295e-003,  3.619571e-003,  5.828011e-003,  8.110666e-003,  1.040704e-002,  1.319549e-002,  1.620710e-002,  1.916553e-002,  2.209625e-002,
   2.500756e-002,  2.775402e-002,  3.036326e-002,  3.288114e-002,  3.527847e-002,  3.786179e-002,  4.037397e-002,  4.285528e-002,  4.534341e-002,
   4.758996e-002,  4.938518e-002,  5.116656e-002,  5.275974e-002,  5.416225e-002,  5.535033e-002,  5.590618e-002,  5.616684e-002,  5.619416e-002,
   5.602111e-002,  5.555202e-002,  5.494568e-002,  5.425079e-002,  5.352648e-002,  5.294317e-002,  5.251581e-002,  5.223673e-002,  5.199132e-002,
   5.166691e-002,  5.134220e-002,  5.096302e-002,  5.033949e-002,  4.969348e-002,  4.905626e-002,  4.825902e-002,  4.749799e-002,  4.673475e-002,
   4.582434e-002,  4.472824e-002,  4.351704e-002,  4.223126e-002,  4.085643e-002,  3.937696e-002,  3.769328e-002,  3.580202e-002,  3.366185e-002,
   3.121069e-002,  2.864057e-002,  2.601440e-002,  2.338889e-002,  2.062021e-002,  1.769810e-002,  1.490952e-002,  1.217546e-002,  9.358863e-003,
   6.301049e-003,  3.555297e-003,  1.238527e-003,  -6.116535e-004, -2.176547e-003, -3.355215e-003, -4.286351e-003, -4.988579e-003, -5.747776e-003,
   -6.681510e-003, -7.600147e-003, -8.416422e-003, -9.151412e-003, -9.772220e-003, -1.020583e-002, -1.056118e-002, -1.089222e-002, -1.116069e-002,
   -1.135084e-002, -1.147240e-002, -1.158118e-002, -1.179887e-002, -1.230994e-002, -1.298814e-002, -1.377298e-002, -1.466114e-002, -1.544403e-002,
   -1.615037e-002, -1.670681e-002, -1.709712e-002, -1.754141e-002, -1.800747e-002, -1.828585e-002, -1.838731e-002, -1.832312e-002, -1.813977e-002,
   -1.784323e-002, -1.741100e-002, -1.691073e-002, -1.632508e-002, -1.554783e-002, -1.460601e-002, -1.365363e-002, -1.288288e-002, -1.231089e-002,
   -1.190100e-002, -1.169113e-002, -1.170780e-002, -1.183701e-002, -1.194267e-002, -1.225889e-002, -1.279041e-002, -1.359520e-002, -1.433554e-002,
   -1.504622e-002, -1.605093e-002, -1.738929e-002, -1.904751e-002, -2.101755e-002, -2.325450e-002, -2.573629e-002, -2.829256e-002, -3.092450e-002,
   -3.360584e-002, -3.626469e-002, -3.879736e-002, -4.076347e-002, -4.205671e-002, -4.287240e-002, -4.339240e-002, -4.352638e-002, -4.320936e-002,
   -4.234417e-002, -4.109221e-002, -3.982037e-002, -3.851914e-002, -3.699785e-002, -3.534256e-002, -3.359361e-002, -3.176071e-002, -2.988578e-002,
   -2.780529e-002, -2.552479e-002, -2.306791e-002, -2.042006e-002, -1.752280e-002, -1.463915e-002, -1.188046e-002, -9.355941e-003, -7.073806e-003,
   -5.058920e-003, -3.291251e-003, -1.717509e-003, -2.524424e-004, 1.023075e-003,  2.260394e-003,  3.567657e-003,  5.079620e-003,  6.856197e-003,
   8.699813e-003,  1.063617e-002,  1.267506e-002,  1.475928e-002,  1.687259e-002,  1.910209e-002,  2.126923e-002,  2.329358e-002,  2.521197e-002,
   2.701610e-002,  2.863762e-002,  3.010457e-002,  3.123741e-002,  3.206594e-002,  3.262429e-002,  3.282690e-002,  3.267768e-002,  3.219683e-002,
   3.132763e-002,  3.004464e-002,  2.832705e-002,  2.626040e-002,  2.379265e-002,  2.081880e-002,  1.762662e-002,  1.424133e-002,  1.065133e-002,
   6.965864e-003,  3.232117e-003,  -5.094708e-004, -4.106098e-003, -7.623158e-003, -1.100570e-002, -1.415960e-002, -1.697216e-002, -1.938143e-002,
   -2.133751e-002, -2.265492e-002, -2.348320e-002, -2.383396e-002, -2.366856e-002, -2.325705e-002, -2.271105e-002, -2.193964e-002, -2.098082e-002,
   -1.980062e-002, -1.843948e-002, -1.692524e-002, -1.523926e-002, -1.334551e-002, -1.118717e-002, -8.944406e-003, -6.764265e-003, -4.646752e-003,
   -2.614082e-003, -6.296331e-004, 1.150117e-003,  2.828635e-003,  4.412365e-003,  5.928408e-003,  7.507944e-003,  9.290022e-003,  1.114943e-002,
   1.287923e-002,  1.454201e-002,  1.611053e-002,  1.758332e-002,  1.898921e-002,  2.024133e-002,  2.141627e-002,  2.256373e-002,  2.373198e-002,
   2.496664e-002,  2.614804e-002,  2.716888e-002,  2.804019e-002,  2.875792e-002,  2.945554e-002,  2.996165e-002,  3.036138e-002,  3.063906e-002,
   3.067688e-002,  3.028947e-002,  2.953769e-002,  2.852818e-002,  2.737068e-002,  2.620999e-002,  2.488068e-002,  2.340507e-002,  2.180249e-002,
   2.007300e-002,  1.846771e-002,  1.687297e-002,  1.529707e-002,  1.374633e-002,  1.223441e-002,  1.080189e-002,  9.363292e-003,  8.066254e-003,
   7.057066e-003,  6.279500e-003,  5.748732e-003,  5.397326e-003,  5.210849e-003,  5.058444e-003,  5.004529e-003,  4.988791e-003,  4.955283e-003,
   4.933273e-003,  4.963275e-003,  4.974368e-003,  5.099264e-003,  5.254558e-003,  5.312861e-003,  5.220178e-003,  5.047695e-003,  4.838553e-003,
   4.549059e-003,  4.117503e-003,  3.671899e-003,  3.046092e-003,  2.163210e-003,  1.101814e-003,  -7.744071e-005, -1.194064e-003, -2.514380e-003,
   -4.079641e-003, -5.848599e-003, -7.838580e-003, -1.010623e-002, -1.239045e-002, -1.463796e-002, -1.681831e-002, -1.882169e-002, -2.062006e-002,
   -2.234526e-002, -2.399241e-002, -2.525671e-002, -2.616381e-002, -2.677689e-002, -2.711283e-002, -2.724403e-002, -2.725471e-002, -2.720445e-002,
   -2.713185e-002, -2.731374e-002, -2.753442e-002, -2.771595e-002, -2.758083e-002, -2.738584e-002, -2.701981e-002, -2.619481e-002, -2.531688e-002,
   -2.447496e-002, -2.366043e-002, -2.289788e-002, -2.225163e-002, -2.187533e-002, -2.181494e-002, -2.199627e-002, -2.237662e-002, -2.311109e-002,
   -2.399615e-002, -2.451233e-002, -2.442773e-002, -2.398563e-002, -2.323590e-002, -2.194075e-002, -2.036509e-002, -1.876638e-002, -1.714303e-002,
   -1.538013e-002, -1.342394e-002, -1.128224e-002, -8.859936e-003, -6.198258e-003, -3.229861e-003, -1.215553e-016},
  {0.000000e+000,  -4.426256e-001, -9.788617e-002, 1.103052e-001,  2.074472e-001,  2.236316e-001,  1.905781e-001,  1.553585e-001,  1.162719e-001,
   7.326630e-002,  2.565355e-002,  -2.661771e-002, -7.898507e-002, -1.232298e-001, -1.535677e-001, -1.707928e-001, -1.718427e-001, -1.543418e-001,
   -1.242447e-001, -8.760311e-002, -4.904209e-002, -1.852978e-002, 5.422101e-003,  2.645649e-002,  4.626530e-002,  6.276776e-002,  7.470737e-002,
   7.947473e-002,  7.874632e-002,  7.476442e-002,  6.710252e-002,  5.668877e-002,  4.690894e-002,  3.583451e-002,  2.376012e-002,  1.339382e-002,
   3.719670e-003,  -2.079770e-003, -3.446964e-003, -2.730284e-003, 1.204935e-003,  4.354620e-003,  7.186059e-003,  8.658222e-003,  9.326182e-003,
   7.479452e-003,  9.300147e-004,  -7.350316e-003, -1.560447e-002, -2.437501e-002, -3.139798e-002, -3.580118e-002, -3.681373e-002, -3.280146e-002,
   -2.755347e-002, -2.027133e-002, -1.204846e-002, -4.985635e-003, 1.326156e-003,  7.075843e-003,  1.094889e-002,  9.658565e-003,  8.698411e-003,
   8.313470e-003,  7.450266e-003,  6.850333e-003,  6.251132e-003,  4.996391e-003,  2.673786e-003,  6.534366e-004,  -1.342255e-003, -3.754922e-003,
   -7.308775e-003, -9.656508e-003, -1.154943e-002, -1.340400e-002, -1.549289e-002, -1.689364e-002, -1.784053e-002, -1.864461e-002, -1.790010e-002,
   -1.531855e-002, -1.206865e-002, -9.881805e-003, -5.823708e-003, -1.604496e-003, 1.683076e-003,  5.385228e-003,  8.287201e-003,  1.130908e-002,
   1.484023e-002,  1.658365e-002,  1.917724e-002,  2.101180e-002,  2.081750e-002,  2.011015e-002,  1.746059e-002,  1.414899e-002,  1.046083e-002,
   5.986478e-003,  1.928149e-003,  -8.264124e-004, -3.367271e-003, -5.848097e-003, -7.483155e-003, -8.553182e-003, -8.197007e-003, -8.442523e-003,
   -7.854757e-003, -6.368900e-003, -3.748691e-003, -1.691001e-003, 7.225895e-004,  2.886092e-003,  5.741766e-003,  8.288244e-003,  1.017717e-002,
   1.150823e-002,  1.195427e-002,  1.274806e-002,  1.227997e-002,  1.115023e-002,  9.023154e-003,  6.439063e-003,  4.560128e-003,  2.083562e-003,
   -1.255635e-003, -5.060332e-003, -8.679987e-003, -1.290611e-002, -1.681560e-002, -2.084523e-002, -2.492939e-002, -2.789864e-002, -2.882802e-002,
   -2.912818e-002, -2.756511e-002, -2.559286e-002, -2.262439e-002, -1.854269e-002, -1.365014e-002, -9.728028e-003, -5.351973e-003, 1.151219e-005,
   6.367849e-003,  1.130888e-002,  1.637912e-002,  2.062565e-002,  2.460765e-002,  2.775190e-002,  3.047390e-002,  3.243981e-002,  3.265326e-002,
   3.152360e-002,  2.963271e-002,  2.767579e-002,  2.551175e-002,  2.312655e-002,  2.055888e-002,  1.765303e-002,  1.522919e-002,  1.197632e-002,
   9.233995e-003,  6.499312e-003,  4.264982e-003,  2.984319e-003,  1.050249e-003,  -1.987282e-004, -1.507741e-003, -2.796039e-003, -4.056193e-003,
   -4.976315e-003, -5.481622e-003, -6.175870e-003, -6.526531e-003, -6.919749e-003, -7.450196e-003, -7.121866e-003, -6.505571e-003, -6.143038e-003,
   -5.438646e-003, -5.219527e-003, -4.999457e-003, -4.246250e-003, -3.941065e-003, -3.994740e-003, -4.182282e-003, -3.993894e-003, -3.789955e-003,
   -3.646234e-003, -4.460992e-003, -5.310140e-003, -6.485153e-003, -7.686435e-003, -8.934210e-003, -1.057511e-002, -1.211719e-002, -1.315324e-002,
   -1.447711e-002, -1.581320e-002, -1.730214e-002, -1.873890e-002, -1.965352e-002, -1.958190e-002, -1.957804e-002, -1.890122e-002, -1.840664e-002,
   -1.790402e-002, -1.621263e-002, -1.418810e-002, -1.228494e-002, -1.019742e-002, -7.162075e-003, -4.457602e-003, -1.529338e-003, 1.791121e-003,
   4.794344e-003,  7.650136e-003,  1.038940e-002,  1.372243e-002,  1.673587e-002,  1.964875e-002,  2.229075e-002,  2.369957e-002,  2.534590e-002,
   2.645219e-002,  2.719062e-002,  2.762791e-002,  2.759310e-002,  2.718226e-002,  2.641654e-002,  2.535439e-002,  2.468030e-002,  2.270722e-002,
   2.095719e-002,  1.912157e-002,  1.641603e-002,  1.370782e-002,  1.107192e-002,  9.226676e-003,  7.001006e-003,  4.527941e-003,  2.405401e-003,
   1.095899e-003,  -7.735699e-004, -2.655811e-003, -4.735180e-003, -6.672915e-003, -8.651625e-003, -1.120396e-002, -1.365487e-002, -1.591794e-002,
   -1.860750e-002, -2.098193e-002, -2.306572e-002, -2.525036e-002, -2.654935e-002, -2.787005e-002, -2.960896e-002, -3.188759e-002, -3.304582e-002,
   -3.362509e-002, -3.421006e-002, -3.493158e-002, -3.527951e-002, -3.541151e-002, -3.616275e-002, -3.667030e-002, -3.645722e-002, -3.534547e-002,
   -3.384610e-002, -3.192936e-002, -3.007744e-002, -2.816464e-002, -2.599383e-002, -2.364519e-002, -2.056853e-002, -1.721039e-002, -1.379104e-002,
   -1.101966e-002, -8.279911e-003, -5.622427e-003, -3.033445e-003, -3.456622e-005, 3.156631e-003,  6.854350e-003,  1.036193e-002,  1.319639e-002,
   1.547752e-002,  1.801207e-002,  2.066166e-002,  2.227310e-002,  2.414273e-002,  2.664079e-002,  2.869163e-002,  3.030688e-002,  3.128613e-002,
   3.210737e-002,  3.323065e-002,  3.430051e-002,  3.496578e-002,  3.573864e-002,  3.690582e-002,  3.775529e-002,  3.815364e-002,  3.812283e-002,
   3.809212e-002,  3.835298e-002,  3.836190e-002,  3.849059e-002,  3.875257e-002,  3.914174e-002,  3.934953e-002,  3.915474e-002,  3.886012e-002,
   3.830582e-002,  3.761627e-002,  3.683023e-002,  3.518517e-002,  3.367588e-002,  3.253379e-002,  3.106042e-002,  2.882998e-002,  2.622605e-002,
   2.310408e-002,  2.041273e-002,  1.741670e-002,  1.413832e-002,  1.057358e-002,  6.703073e-003,  3.278225e-003,  1.649775e-004,  -3.372965e-003,
   -7.129515e-003, -1.079104e-002, -1.454826e-002, -1.792318e-002, -2.190900e-002, -2.550286e-002, -2.851237e-002, -3.107104e-002, -3.305261e-002,
   -3.461994e-002, -3.612647e-002, -3.740351e-002, -3.872915e-002, -3.959441e-002, -4.057913e-002, -4.139544e-002, -4.191170e-002, -4.162979e-002,
   -4.134529e-002, -4.105334e-002, -4.031408e-002, -3.923497e-002, -3.834592e-002, -3.734537e-002, -3.683082e-002, -3.657909e-002, -3.589161e-002,
   -3.498336e-002, -3.395033e-002, -3.273263e-002, -3.183399e-002, -3.094509e-002, -2.983059e-002, -2.840917e-002, -2.697139e-002, -2.530493e-002,
   -2.424594e-002, -2.312261e-002, -2.148955e-002, -1.930896e-002, -1.706080e-002, -1.525190e-002, -1.337980e-002, -1.124707e-002, -8.980724e-003,
   -6.313428e-003, -3.738550e-003, -1.155300e-003, 1.462800e-003,  4.117725e-003,  6.576173e-003,  9.156960e-003,  1.127338e-002,  1.330129e-002,
   1.552762e-002,  1.760814e-002,  1.996352e-002,  2.202453e-002,  2.414522e-002,  2.611037e-002,  2.795979e-002,  2.932229e-002,  3.054205e-002,
   3.140910e-002,  3.166134e-002,  3.185657e-002,  3.184578e-002,  3.196037e-002,  3.198783e-002,  3.158186e-002,  3.074272e-002,  2.957877e-002,
   2.857800e-002,  2.762290e-002,  2.656386e-002,  2.538639e-002,  2.389762e-002,  2.246380e-002,  2.096857e-002,  1.937127e-002,  1.802197e-002,
   1.668617e-002,  1.476751e-002,  1.326889e-002,  1.232738e-002,  1.173407e-002,  1.098063e-002,  1.018137e-002,  8.966329e-003,  7.971853e-003,
   7.195106e-003,  6.592168e-003,  5.924248e-003,  5.587663e-003,  4.914722e-003,  3.926392e-003,  2.833351e-003,  1.739622e-003,  7.716546e-004,
   -1.380842e-004, -7.569115e-004, -1.178506e-003, -1.528822e-003, -1.645077e-003, -1.569529e-003, -1.275292e-003, -7.566247e-004, -2.034698e-004,
   5.606138e-004,  1.390843e-003,  2.289548e-003,  3.109334e-003,  3.698633e-003,  4.000512e-003,  4.394167e-003,  5.186160e-003,  6.097267e-003,
   6.857379e-003,  7.680091e-003,  8.616599e-003,  8.980693e-003,  8.861837e-003,  8.835621e-003,  9.021308e-003,  8.928020e-003,  8.789753e-003,
   8.395309e-003,  7.397421e-003,  6.203323e-003,  4.886902e-003,  3.676173e-003,  2.702861e-003,  1.350104e-003,  -2.499577e-005, -1.655689e-003,
   -3.220519e-003, -4.921209e-003, -6.453772e-003, -7.723878e-003, -9.124404e-003, -1.084593e-002, -1.325368e-002, -1.553902e-002, -1.763123e-002,
   -1.977015e-002, -2.151874e-002, -2.297458e-002, -2.406587e-002, -2.473961e-002, -2.485753e-002, -2.495961e-002, -2.472564e-002, -2.456694e-002,
   -2.428995e-002, -2.371211e-002, -2.352511e-002, -2.351498e-002, -2.332999e-002, -2.282696e-002, -2.226596e-002, -2.177532e-002, -2.128669e-002,
   -2.076872e-002, -2.050420e-002, -2.019321e-002, -1.987545e-002, -1.972984e-002, -1.932872e-002, -1.885399e-002, -1.850600e-002, -1.837970e-002,
   -1.833540e-002, -1.839107e-002, -1.843416e-002, -1.862415e-002, -1.869155e-002, -1.873371e-002, -1.912060e-002, -1.936999e-002, -1.925480e-002,
   -1.895933e-002, -1.855780e-002, -1.807826e-002, -1.735073e-002, -1.647183e-002, -1.582349e-002, -1.481334e-002, -1.282715e-002, -1.087725e-002,
   -8.901899e-003, -6.841317e-003, -4.661811e-003, -2.376884e-003, -3.888844e-004, 1.512233e-003,  3.396649e-003,  5.589986e-003,  7.739855e-003,
   9.897991e-003,  1.213807e-002,  1.422586e-002,  1.585109e-002,  1.718941e-002,  1.834364e-002,  1.934096e-002,  2.030101e-002,  2.100210e-002,
   2.160543e-002,  2.235764e-002,  2.316455e-002,  2.402791e-002,  2.489666e-002,  2.581245e-002,  2.680838e-002,  2.806215e-002,  2.921748e-002,
   3.009971e-002,  3.071540e-002,  3.143973e-002,  3.207420e-002,  3.255228e-002,  3.285824e-002,  3.299576e-002,  3.321511e-002,  3.318542e-002,
   3.234970e-002,  3.111225e-002,  2.985794e-002,  2.849297e-002,  2.731962e-002,  2.595160e-002,  2.429608e-002,  2.257101e-002,  2.040358e-002,
   1.816682e-002,  1.598018e-002,  1.377310e-002,  1.156882e-002,  9.352989e-003,  7.217448e-003,  5.121836e-003,  3.106883e-003,  1.026752e-003,
   -1.154152e-003, -3.090965e-003, -4.711256e-003, -6.128800e-003, -7.401729e-003, -8.748151e-003, -1.005783e-002, -1.134497e-002, -1.191050e-002,
   -1.211458e-002, -1.228022e-002, -1.230333e-002, -1.198417e-002, -1.150072e-002, -1.105589e-002, -1.059785e-002, -1.065774e-002, -1.056733e-002,
   -1.061557e-002, -1.064500e-002, -1.053697e-002, -1.033711e-002, -9.531796e-003, -8.518715e-003, -7.761465e-003, -7.395734e-003, -7.076393e-003,
   -6.666961e-003, -6.179050e-003, -5.830931e-003, -5.689979e-003, -5.596322e-003, -5.533289e-003, -5.495375e-003, -5.351921e-003, -4.527135e-003,
   -3.682631e-003, -2.747405e-003, -1.492281e-003, -2.266926e-004, 1.077606e-003,  2.516098e-003,  3.965081e-003,  5.034290e-003,  5.899161e-003,
   6.721525e-003,  7.365934e-003,  7.930988e-003,  8.618543e-003,  9.532525e-003,  1.080112e-002,  1.184946e-002,  1.232808e-002,  1.268872e-002,
   1.273024e-002,  1.253847e-002,  1.210405e-002,  1.142066e-002,  1.060681e-002,  9.827226e-003,  8.979523e-003,  7.749134e-003,  6.172073e-003,
   4.464178e-003,  2.671899e-003,  6.769367e-004,  -1.444927e-003, -3.662987e-003, -5.961754e-003, -7.891737e-003, -9.788798e-003, -1.196441e-002,
   -1.426424e-002, -1.650583e-002, -1.813978e-002, -1.952051e-002, -2.079222e-002, -2.199140e-002, -2.318612e-002, -2.428860e-002, -2.536385e-002,
   -2.632518e-002, -2.708004e-002, -2.772888e-002, -2.793252e-002, -2.763354e-002, -2.729784e-002, -2.680502e-002, -2.625252e-002, -2.562801e-002,
   -2.520969e-002, -2.459134e-002, -2.402998e-002, -2.367944e-002, -2.349122e-002, -2.347004e-002, -2.268655e-002, -2.177420e-002, -2.102067e-002,
   -2.046612e-002, -2.017435e-002, -2.010539e-002, -1.984907e-002, -1.941804e-002, -1.894860e-002, -1.847332e-002, -1.803340e-002, -1.760023e-002,
   -1.714239e-002, -1.670953e-002, -1.597351e-002, -1.467756e-002, -1.334437e-002, -1.143254e-002, -9.190748e-003, -6.932587e-003, -4.763536e-003,
   -2.551227e-003, -2.080688e-004, 2.219243e-003,  4.409672e-003,  6.443073e-003,  8.377831e-003,  1.021087e-002,  1.201156e-002,  1.374064e-002,
   1.545830e-002,  1.702197e-002,  1.888390e-002,  2.071518e-002,  2.245935e-002,  2.344217e-002,  2.440418e-002,  2.522417e-002,  2.594909e-002,
   2.645563e-002,  2.669631e-002,  2.675554e-002,  2.674782e-002,  2.667195e-002,  2.652849e-002,  2.627962e-002,  2.596760e-002,  2.567768e-002,
   2.546515e-002,  2.536571e-002,  2.524167e-002,  2.506378e-002,  2.497145e-002,  2.491217e-002,  2.476054e-002,  2.489279e-002,  2.497366e-002,
   2.503084e-002,  2.515165e-002,  2.516790e-002,  2.510283e-002,  2.498922e-002,  2.482976e-002,  2.454682e-002,  2.416579e-002,  2.381887e-002,
   2.336490e-002,  2.242567e-002,  2.132110e-002,  2.024481e-002,  1.909589e-002,  1.787123e-002,  1.656772e-002,  1.532286e-002,  1.415350e-002,
   1.311266e-002,  1.220944e-002,  1.149946e-002,  1.055560e-002,  9.755882e-003,  8.992160e-003,  8.292029e-003,  7.805815e-003,  7.355886e-003,
   6.959233e-003,  6.586886e-003,  6.569916e-003,  6.496576e-003,  6.406097e-003,  6.001400e-003,  5.458051e-003,  4.926243e-003,  4.315321e-003,
   3.649063e-003,  2.913955e-003,  2.172937e-003,  1.323520e-003,  2.494032e-004,  -1.016842e-003, -2.265649e-003, -3.811695e-003, -5.729069e-003,
   -7.528427e-003, -9.359915e-003, -1.115366e-002, -1.289618e-002, -1.436931e-002, -1.565365e-002, -1.676667e-002, -1.776497e-002, -1.858983e-002,
   -1.937746e-002, -2.036896e-002, -2.135186e-002, -2.212974e-002, -2.264182e-002, -2.316925e-002, -2.365002e-002, -2.414610e-002, -2.478922e-002,
   -2.543580e-002, -2.605312e-002, -2.671318e-002, -2.741154e-002, -2.847393e-002, -2.961953e-002, -3.076283e-002, -3.149091e-002, -3.195223e-002,
   -3.249157e-002, -3.313850e-002, -3.396393e-002, -3.494448e-002, -3.608686e-002, -3.721108e-002, -3.841949e-002, -3.989676e-002, -4.134524e-002,
   -4.278263e-002, -4.418183e-002, -4.539317e-002, -4.600373e-002, -4.607777e-002, -4.588179e-002, -4.533499e-002, -4.441912e-002, -4.314347e-002,
   -4.137390e-002, -3.963328e-002, -3.768302e-002, -3.546730e-002, -3.298884e-002, -3.033928e-002, -2.740187e-002, -2.440793e-002, -2.134315e-002,
   -1.816116e-002, -1.496300e-002, -1.160043e-002, -8.079983e-003, -4.961348e-003, -1.850219e-003, 1.395687e-003,  4.545362e-003,  7.506101e-003,
   1.021898e-002,  1.274419e-002,  1.520360e-002,  1.771136e-002,  2.009179e-002,  2.236379e-002,  2.460752e-002,  2.660510e-002,  2.826751e-002,
   2.992299e-002,  3.158282e-002,  3.312083e-002,  3.459771e-002,  3.604084e-002,  3.741493e-002,  3.872687e-002,  3.999709e-002,  4.147162e-002,
   4.292926e-002,  4.437781e-002,  4.533007e-002,  4.592974e-002,  4.629982e-002,  4.658148e-002,  4.703863e-002,  4.741979e-002,  4.756681e-002,
   4.750426e-002,  4.725191e-002,  4.678453e-002,  4.614883e-002,  4.559104e-002,  4.489925e-002,  4.352546e-002,  4.195567e-002,  4.020170e-002,
   3.827532e-002,  3.620106e-002,  3.414337e-002,  3.196287e-002,  2.964226e-002,  2.729380e-002,  2.493518e-002,  2.286074e-002,  2.093077e-002,
   1.913063e-002,  1.697084e-002,  1.489076e-002,  1.292853e-002,  1.105977e-002,  9.244886e-003,  7.475782e-003,  5.788072e-003,  4.388515e-003,
   3.096280e-003,  1.877727e-003,  7.323806e-004,  -3.526722e-004, -1.412134e-003, -3.003547e-003, -4.489163e-003, -5.870796e-003, -7.201572e-003,
   -8.424293e-003, -9.596610e-003, -1.082831e-002, -1.199337e-002, -1.312588e-002, -1.417553e-002, -1.518676e-002, -1.613656e-002, -1.694176e-002,
   -1.763842e-002, -1.849378e-002, -1.924874e-002, -1.972425e-002, -2.008452e-002, -2.044026e-002, -2.070091e-002, -2.083397e-002, -2.080791e-002,
   -2.064436e-002, -2.015454e-002, -1.948716e-002, -1.874811e-002, -1.789859e-002, -1.745872e-002, -1.705482e-002, -1.657329e-002, -1.605583e-002,
   -1.526581e-002, -1.441425e-002, -1.330928e-002, -1.221088e-002, -1.114925e-002, -1.007136e-002, -9.052310e-003, -8.101342e-003, -6.970330e-003,
   -5.879696e-003, -5.170864e-003, -4.381743e-003, -3.250538e-003, -2.109429e-003, -1.069344e-003, 2.367350e-005,  1.139974e-003,  2.068386e-003,
   2.867085e-003,  3.617170e-003,  4.322660e-003,  5.017536e-003,  5.853732e-003,  6.643603e-003,  6.956689e-003,  7.182838e-003,  7.277807e-003,
   7.253118e-003,  7.160764e-003,  6.984247e-003,  6.586128e-003,  6.184843e-003,  6.037641e-003,  6.031915e-003,  5.939830e-003,  5.841023e-003,
   5.748898e-003,  5.558739e-003,  4.700314e-003,  3.831358e-003,  2.986117e-003,  2.095344e-003,  1.179259e-003,  5.411149e-004,  -2.201710e-004,
   -1.136316e-003, -2.083543e-003, -3.000939e-003, -3.863737e-003, -4.718609e-003, -5.564055e-003, -6.398729e-003, -7.477716e-003, -8.498700e-003,
   -9.038157e-003, -9.474478e-003, -9.704287e-003, -9.998273e-003, -1.022132e-002, -1.041375e-002, -1.061439e-002, -1.084289e-002, -1.115954e-002,
   -1.152177e-002, -1.116880e-002, -1.066547e-002, -1.016949e-002, -1.040908e-002, -1.081580e-002, -1.135060e-002, -1.212178e-002, -1.296112e-002,
   -1.353674e-002, -1.423231e-002, -1.510847e-002, -1.505159e-002, -1.500618e-002, -1.508254e-002, -1.530489e-002, -1.563732e-002, -1.563577e-002,
   -1.564875e-002, -1.650280e-002, -1.750175e-002, -1.851541e-002, -1.941360e-002, -1.841245e-002, -1.718508e-002, -1.572792e-002, -1.396834e-002,
   -1.218440e-002, -1.033563e-002, -8.433616e-003, -6.438788e-003, -4.373265e-003, -2.216235e-003, -2.579775e-017},
  {0.000000e+000,  -6.037378e-002, -6.469045e-003, 2.566552e-002,  4.210873e-002,  4.124150e-002,  3.096052e-002,  1.524907e-002,  2.785362e-003,
   -7.728595e-003, -1.698578e-002, -2.445510e-002, -2.919319e-002, -3.148743e-002, -3.142251e-002, -2.962631e-002, -2.550305e-002, -1.973155e-002,
   -1.427010e-002, -7.931907e-003, -6.112233e-004, 7.491481e-003,  1.559396e-002,  2.351770e-002,  2.877784e-002,  3.255009e-002,  3.492912e-002,
   3.425700e-002,  3.255751e-002,  2.866576e-002,  2.492890e-002,  2.033932e-002,  1.534457e-002,  7.894215e-003,  5.786402e-004,  -5.714463e-003,
   -9.626747e-003, -1.367878e-002, -1.634066e-002, -1.844778e-002, -2.053967e-002, -2.310193e-002, -2.553322e-002, -2.710448e-002, -2.760002e-002,
   -2.805446e-002, -2.734367e-002, -2.496195e-002, -2.176249e-002, -1.742829e-002, -1.233449e-002, -8.869814e-003, -4.536597e-003, 2.414270e-004,
   3.938743e-003,  7.684524e-003,  1.100897e-002,  1.401072e-002,  1.595778e-002,  1.702782e-002,  1.884968e-002,  1.967238e-002,  1.974188e-002,
   2.062971e-002,  2.013866e-002,  1.842569e-002,  1.771824e-002,  1.658602e-002,  1.430307e-002,  1.201499e-002,  9.553737e-003,  6.269042e-003,
   3.360829e-003,  1.254667e-003,  -5.182312e-004, -2.372817e-003, -3.097430e-003, -3.573376e-003, -4.153988e-003, -4.488018e-003, -4.492118e-003,
   -5.161001e-003, -6.639471e-003, -7.166803e-003, -7.256751e-003, -7.773312e-003, -7.994558e-003, -7.889688e-003, -8.911424e-003, -9.977403e-003,
   -1.122079e-002, -1.155498e-002, -1.100076e-002, -1.071660e-002, -1.011592e-002, -9.500469e-003, -7.222929e-003, -4.232981e-003, -2.761877e-003,
   -1.355558e-003, 5.808436e-004,  3.069494e-003,  4.022636e-003,  3.910751e-003,  4.202777e-003,  5.278721e-003,  4.696964e-003,  3.762970e-003,
   3.120345e-003,  3.765287e-003,  3.939764e-003,  4.252810e-003,  5.437575e-003,  5.450772e-003,  6.156525e-003,  6.802959e-003,  6.699919e-003,
   6.798808e-003,  7.977533e-003,  8.510721e-003,  9.513612e-003,  1.051562e-002,  1.177616e-002,  1.312116e-002,  1.386606e-002,  1.373182e-002,
   1.313098e-002,  1.166804e-002,  9.809053e-003,  7.025868e-003,  3.968250e-003,  1.770472e-003,  -5.016523e-004, -1.935521e-003, -3.686553e-003,
   -4.829481e-003, -4.830921e-003, -6.160095e-003, -6.258897e-003, -6.919228e-003, -7.621123e-003, -8.593602e-003, -1.016672e-002, -1.202727e-002,
   -1.408548e-002, -1.511033e-002, -1.554094e-002, -1.610314e-002, -1.532400e-002, -1.542983e-002, -1.570783e-002, -1.507096e-002, -1.528697e-002,
   -1.455619e-002, -1.406848e-002, -1.362672e-002, -1.223586e-002, -1.119136e-002, -1.028329e-002, -1.046815e-002, -9.989788e-003, -9.566241e-003,
   -8.986772e-003, -8.049935e-003, -5.965631e-003, -4.368594e-003, -3.173520e-003, -1.001296e-003, -3.109018e-004, 2.629551e-004,  1.745318e-003,
   3.204123e-003,  4.035660e-003,  6.218978e-003,  7.753124e-003,  9.885569e-003,  1.116178e-002,  1.245254e-002,  1.320182e-002,  1.478459e-002,
   1.509932e-002,  1.588767e-002,  1.658916e-002,  1.657746e-002,  1.548080e-002,  1.605646e-002,  1.608772e-002,  1.586954e-002,  1.626351e-002,
   1.626150e-002,  1.550502e-002,  1.512801e-002,  1.410334e-002,  1.271030e-002,  1.192894e-002,  1.140073e-002,  1.063790e-002,  9.100201e-003,
   9.333021e-003,  9.095271e-003,  8.481116e-003,  7.338499e-003,  5.751654e-003,  3.801295e-003,  1.168824e-003,  -6.809504e-004, -3.116799e-003,
   -5.788835e-003, -7.881047e-003, -9.965807e-003, -1.219276e-002, -1.443369e-002, -1.563531e-002, -1.753826e-002, -1.941432e-002, -2.113058e-002,
   -2.274960e-002, -2.438502e-002, -2.659924e-002, -2.772699e-002, -2.903151e-002, -3.029340e-002, -3.139278e-002, -3.169041e-002, -3.153138e-002,
   -3.158971e-002, -3.159664e-002, -3.035610e-002, -2.937392e-002, -2.840589e-002, -2.711180e-002, -2.504244e-002, -2.289625e-002, -2.159539e-002,
   -1.963929e-002, -1.684629e-002, -1.452578e-002, -1.154706e-002, -8.112968e-003, -3.753865e-003, 1.071476e-003,  5.515752e-003,  1.012575e-002,
   1.547505e-002,  2.051150e-002,  2.510707e-002,  2.964321e-002,  3.356479e-002,  3.731168e-002,  4.017798e-002,  4.232159e-002,  4.555931e-002,
   4.874874e-002,  5.124080e-002,  5.340434e-002,  5.536813e-002,  5.637646e-002,  5.676013e-002,  5.718229e-002,  5.732404e-002,  5.762667e-002,
   5.706885e-002,  5.536933e-002,  5.288875e-002,  5.123134e-002,  4.912973e-002,  4.607073e-002,  4.270710e-002,  3.889235e-002,  3.498278e-002,
   3.045412e-002,  2.560045e-002,  2.085320e-002,  1.701732e-002,  1.295545e-002,  7.964438e-003,  3.261862e-003,  -1.359544e-003, -5.152683e-003,
   -8.195529e-003, -1.217268e-002, -1.566566e-002, -1.773716e-002, -1.973003e-002, -2.213997e-002, -2.455584e-002, -2.695953e-002, -2.935791e-002,
   -3.138782e-002, -3.306528e-002, -3.517096e-002, -3.749783e-002, -3.829531e-002, -3.880917e-002, -3.934775e-002, -3.965057e-002, -4.061743e-002,
   -4.112536e-002, -4.111388e-002, -4.129607e-002, -4.209697e-002, -4.240947e-002, -4.211714e-002, -4.203469e-002, -4.247345e-002, -4.244573e-002,
   -4.312946e-002, -4.308403e-002, -4.291717e-002, -4.212285e-002, -4.151760e-002, -4.083205e-002, -3.895152e-002, -3.679633e-002, -3.512734e-002,
   -3.359432e-002, -3.169090e-002, -3.006724e-002, -2.781366e-002, -2.505097e-002, -2.203950e-002, -1.970662e-002, -1.742626e-002, -1.380310e-002,
   -1.021928e-002, -7.155949e-003, -4.269678e-003, -7.184659e-004, 2.214367e-003,  4.618178e-003,  7.212744e-003,  1.011789e-002,  1.197997e-002,
   1.395555e-002,  1.624820e-002,  1.828034e-002,  1.945293e-002,  2.061147e-002,  2.232654e-002,  2.488742e-002,  2.696525e-002,  2.888020e-002,
   3.086175e-002,  3.208284e-002,  3.300377e-002,  3.399652e-002,  3.501373e-002,  3.538998e-002,  3.593130e-002,  3.624569e-002,  3.671883e-002,
   3.694650e-002,  3.611745e-002,  3.491173e-002,  3.379608e-002,  3.215676e-002,  3.050474e-002,  2.942390e-002,  2.851606e-002,  2.729075e-002,
   2.556305e-002,  2.351257e-002,  2.206939e-002,  2.063788e-002,  1.874339e-002,  1.674897e-002,  1.499513e-002,  1.282930e-002,  1.031069e-002,
   8.318007e-003,  6.849225e-003,  4.868687e-003,  2.799463e-003,  6.554596e-004,  -1.657586e-003, -3.815220e-003, -6.019962e-003, -8.374727e-003,
   -1.060240e-002, -1.246368e-002, -1.438541e-002, -1.599249e-002, -1.711392e-002, -1.829963e-002, -1.957395e-002, -2.076187e-002, -2.192923e-002,
   -2.255913e-002, -2.259167e-002, -2.263124e-002, -2.274266e-002, -2.276364e-002, -2.277775e-002, -2.255446e-002, -2.185118e-002, -2.075609e-002,
   -1.997064e-002, -1.953343e-002, -1.885195e-002, -1.806234e-002, -1.703671e-002, -1.563231e-002, -1.427013e-002, -1.333103e-002, -1.232643e-002,
   -1.134038e-002, -9.914061e-003, -7.802220e-003, -4.849087e-003, -2.247817e-003, 7.093138e-005,  2.131760e-003,  3.507166e-003,  5.108711e-003,
   7.054914e-003,  9.141091e-003,  1.116481e-002,  1.284738e-002,  1.467287e-002,  1.625545e-002,  1.738957e-002,  1.827707e-002,  1.889924e-002,
   1.908773e-002,  1.882092e-002,  1.811302e-002,  1.646014e-002,  1.450542e-002,  1.299139e-002,  1.174056e-002,  1.085030e-002,  9.895594e-003,
   8.697252e-003,  7.162899e-003,  5.196303e-003,  3.473491e-003,  1.543164e-003,  -4.213685e-004, -2.074557e-003, -3.537647e-003, -4.668432e-003,
   -6.406290e-003, -8.097026e-003, -9.015186e-003, -9.838171e-003, -1.069196e-002, -1.162989e-002, -1.209421e-002, -1.231395e-002, -1.258722e-002,
   -1.212346e-002, -1.175342e-002, -1.128135e-002, -1.041603e-002, -9.455872e-003, -7.964977e-003, -6.990851e-003, -6.215775e-003, -5.414600e-003,
   -4.704862e-003, -4.048329e-003, -3.610792e-003, -3.213320e-003, -2.062114e-003, -1.004225e-003, 2.307415e-004,  1.273663e-003,  2.001758e-003,
   3.443290e-003,  5.198106e-003,  6.909056e-003,  8.372257e-003,  8.707803e-003,  9.031754e-003,  9.231475e-003,  9.137415e-003,  8.805090e-003,
   8.294868e-003,  8.180670e-003,  8.338760e-003,  7.864747e-003,  7.392176e-003,  6.555473e-003,  5.747565e-003,  6.255572e-003,  6.865768e-003,
   7.337572e-003,  7.390398e-003,  6.762009e-003,  6.973934e-003,  7.537761e-003,  7.971484e-003,  8.123720e-003,  7.604849e-003,  7.216810e-003,
   7.532116e-003,  7.600449e-003,  7.221970e-003,  6.604117e-003,  5.589618e-003,  4.770874e-003,  4.229896e-003,  3.640737e-003,  2.992700e-003,
   2.006548e-003,  8.023127e-004,  -1.177813e-004, -9.945589e-004, -2.032928e-003, -3.132484e-003, -4.516936e-003, -5.695809e-003, -6.470323e-003,
   -7.195920e-003, -7.928012e-003, -8.794739e-003, -9.580493e-003, -9.773680e-003, -9.881701e-003, -1.006301e-002, -1.045548e-002, -1.122410e-002,
   -1.164230e-002, -1.163747e-002, -1.138447e-002, -1.123806e-002, -1.134106e-002, -1.185723e-002, -1.204192e-002, -1.168398e-002, -1.126568e-002,
   -1.089795e-002, -1.090845e-002, -1.105166e-002, -1.103055e-002, -1.023981e-002, -9.361922e-003, -8.371049e-003, -7.578562e-003, -7.349685e-003,
   -7.310679e-003, -7.294808e-003, -7.335154e-003, -7.301579e-003, -7.330223e-003, -7.763455e-003, -8.227565e-003, -8.066161e-003, -7.718895e-003,
   -7.156124e-003, -6.877906e-003, -6.921739e-003, -6.834300e-003, -6.052919e-003, -5.057393e-003, -3.905368e-003, -2.622174e-003, -1.349292e-003,
   -5.034098e-004, 5.799790e-004,  1.529785e-003,  2.692727e-003,  3.428851e-003,  4.137996e-003,  4.574666e-003,  5.135323e-003,  5.730637e-003,
   6.553256e-003,  7.186724e-003,  7.605896e-003,  7.715709e-003,  7.881939e-003,  8.185649e-003,  8.335573e-003,  8.606283e-003,  8.836317e-003,
   8.999634e-003,  9.223964e-003,  9.686810e-003,  9.935024e-003,  1.040059e-002,  1.090493e-002,  1.146881e-002,  1.189723e-002,  1.261770e-002,
   1.321377e-002,  1.409098e-002,  1.510879e-002,  1.597020e-002,  1.640195e-002,  1.658232e-002,  1.679451e-002,  1.700724e-002,  1.730688e-002,
   1.765152e-002,  1.793573e-002,  1.790739e-002,  1.797367e-002,  1.782853e-002,  1.753643e-002,  1.766969e-002,  1.759952e-002,  1.742829e-002,
   1.705576e-002,  1.673999e-002,  1.628532e-002,  1.573928e-002,  1.533888e-002,  1.467525e-002,  1.365310e-002,  1.227108e-002,  1.074951e-002,
   9.222079e-003,  7.718998e-003,  6.239504e-003,  4.895915e-003,  3.669358e-003,  2.454426e-003,  1.345865e-003,  2.091807e-004,  -7.286221e-004,
   -1.465081e-003, -2.030929e-003, -2.784536e-003, -3.528809e-003, -4.517121e-003, -5.207065e-003, -5.788640e-003, -6.267730e-003, -6.845133e-003,
   -7.835692e-003, -8.727780e-003, -9.531163e-003, -1.022097e-002, -1.088633e-002, -1.122360e-002, -1.120520e-002, -1.090742e-002, -1.051147e-002,
   -9.996182e-003, -9.743216e-003, -9.607908e-003, -9.309272e-003, -8.930210e-003, -8.891010e-003, -8.848051e-003, -8.519383e-003, -7.971881e-003,
   -7.183360e-003, -6.413700e-003, -5.484757e-003, -4.647386e-003, -4.008340e-003, -3.364449e-003, -2.953996e-003, -2.620614e-003, -2.334315e-003,
   -2.267890e-003, -2.359967e-003, -2.927530e-003, -3.405608e-003, -4.080607e-003, -4.935338e-003, -5.752372e-003, -6.416990e-003, -7.381614e-003,
   -8.781892e-003, -1.029007e-002, -1.184245e-002, -1.303781e-002, -1.434610e-002, -1.560290e-002, -1.713361e-002, -1.882600e-002, -2.064117e-002,
   -2.229700e-002, -2.428934e-002, -2.626077e-002, -2.812560e-002, -2.924710e-002, -2.997286e-002, -3.080780e-002, -3.126990e-002, -3.152929e-002,
   -3.173127e-002, -3.176193e-002, -3.189371e-002, -3.190178e-002, -3.184276e-002, -3.153658e-002, -3.104103e-002, -3.051133e-002, -2.995644e-002,
   -2.890267e-002, -2.733478e-002, -2.565742e-002, -2.418164e-002, -2.291387e-002, -2.122296e-002, -1.944181e-002, -1.748546e-002, -1.522782e-002,
   -1.309264e-002, -1.141865e-002, -9.949129e-003, -8.412726e-003, -6.820412e-003, -5.404121e-003, -4.063398e-003, -2.967430e-003, -1.739144e-003,
   -5.983088e-004, 4.915583e-004,  1.805720e-003,  3.122572e-003,  4.539031e-003,  6.164998e-003,  8.052443e-003,  1.022771e-002,  1.228164e-002,
   1.396105e-002,  1.559995e-002,  1.727900e-002,  1.876976e-002,  2.034776e-002,  2.214442e-002,  2.390706e-002,  2.563993e-002,  2.734110e-002,
   2.902073e-002,  3.079046e-002,  3.247927e-002,  3.409687e-002,  3.581839e-002,  3.786579e-002,  3.975921e-002,  4.158360e-002,  4.319656e-002,
   4.466196e-002,  4.597251e-002,  4.729922e-002,  4.886675e-002,  5.051901e-002,  5.214561e-002,  5.351464e-002,  5.482532e-002,  5.588239e-002,
   5.625881e-002,  5.646446e-002,  5.666459e-002,  5.687511e-002,  5.705516e-002,  5.734115e-002,  5.764511e-002,  5.804020e-002,  5.810874e-002,
   5.800663e-002,  5.769519e-002,  5.719326e-002,  5.666811e-002,  5.596670e-002,  5.500465e-002,  5.389550e-002,  5.246805e-002,  5.085580e-002,
   4.908175e-002,  4.716307e-002,  4.540169e-002,  4.352360e-002,  4.129263e-002,  3.899745e-002,  3.640574e-002,  3.340002e-002,  3.029288e-002,
   2.713674e-002,  2.419922e-002,  2.126105e-002,  1.814286e-002,  1.467007e-002,  1.126856e-002,  8.035846e-003,  4.936749e-003,  2.034712e-003,
   -8.402643e-004, -3.798186e-003, -6.713516e-003, -9.620852e-003, -1.236111e-002, -1.469108e-002, -1.673423e-002, -1.874035e-002, -2.076505e-002,
   -2.275763e-002, -2.457012e-002, -2.626111e-002, -2.762188e-002, -2.881963e-002, -3.008063e-002, -3.138960e-002, -3.280146e-002, -3.417407e-002,
   -3.500368e-002, -3.558858e-002, -3.613100e-002, -3.685923e-002, -3.757275e-002, -3.824011e-002, -3.881196e-002, -3.945278e-002, -4.014865e-002,
   -4.089369e-002, -4.152280e-002, -4.222498e-002, -4.300391e-002, -4.357753e-002, -4.389153e-002, -4.417572e-002, -4.468131e-002, -4.536676e-002,
   -4.616546e-002, -4.687856e-002, -4.775342e-002, -4.867290e-002, -4.967323e-002, -5.078950e-002, -5.206538e-002, -5.347670e-002, -5.497112e-002,
   -5.641970e-002, -5.769714e-002, -5.885459e-002, -6.002815e-002, -6.126985e-002, -6.245799e-002, -6.357684e-002, -6.478398e-002, -6.606717e-002,
   -6.743520e-002, -6.884572e-002, -7.012717e-002, -7.142284e-002, -7.255595e-002, -7.339904e-002, -7.408170e-002, -7.470702e-002, -7.521750e-002,
   -7.548688e-002, -7.547660e-002, -7.509164e-002, -7.452128e-002, -7.366689e-002, -7.234040e-002, -7.051609e-002, -6.851947e-002, -6.624192e-002,
   -6.388047e-002, -6.132734e-002, -5.849585e-002, -5.552270e-002, -5.250218e-002, -4.927400e-002, -4.567800e-002, -4.185546e-002, -3.780921e-002,
   -3.356174e-002, -2.912511e-002, -2.457000e-002, -1.988600e-002, -1.517933e-002, -1.038374e-002, -5.597219e-003, -7.254290e-004, 4.143014e-003,
   8.949597e-003,  1.368268e-002,  1.831937e-002,  2.285228e-002,  2.744269e-002,  3.192047e-002,  3.617557e-002,  4.037269e-002,  4.418612e-002,
   4.761960e-002,  5.086220e-002,  5.387639e-002,  5.665861e-002,  5.920675e-002,  6.136500e-002,  6.316524e-002,  6.463713e-002,  6.592216e-002,
   6.690185e-002,  6.769238e-002,  6.832333e-002,  6.879984e-002,  6.902306e-002,  6.894227e-002,  6.865506e-002,  6.807717e-002,  6.729998e-002,
   6.639905e-002,  6.538164e-002,  6.426421e-002,  6.306813e-002,  6.194848e-002,  6.087209e-002,  5.986571e-002,  5.899887e-002,  5.816417e-002,
   5.746282e-002,  5.678570e-002,  5.594664e-002,  5.501553e-002,  5.413006e-002,  5.330730e-002,  5.257485e-002,  5.192842e-002,  5.132706e-002,
   5.074689e-002,  5.050003e-002,  5.035575e-002,  5.021581e-002,  5.003469e-002,  4.979947e-002,  4.952558e-002,  4.932980e-002,  4.909361e-002,
   4.856641e-002,  4.766466e-002,  4.700044e-002,  4.636619e-002,  4.567631e-002,  4.477307e-002,  4.382717e-002,  4.287739e-002,  4.202948e-002,
   4.108119e-002,  4.025089e-002,  3.912707e-002,  3.823687e-002,  3.738083e-002,  3.653945e-002,  3.545934e-002,  3.423688e-002,  3.288536e-002,
   3.152637e-002,  3.012073e-002,  2.871450e-002,  2.720307e-002,  2.576423e-002,  2.421299e-002,  2.252979e-002,  2.060456e-002,  1.848958e-002,
   1.630198e-002,  1.402818e-002,  1.163621e-002,  9.157455e-003,  6.467600e-003,  3.681196e-003,  1.076935e-003,  -1.611882e-003, -4.520276e-003,
   -7.677941e-003, -1.089190e-002, -1.424759e-002, -1.762310e-002, -2.098455e-002, -2.436754e-002, -2.750442e-002, -2.988875e-002, -3.221942e-002,
   -3.458169e-002, -3.712299e-002, -3.970633e-002, -4.240767e-002, -4.501945e-002, -4.757800e-002, -5.010187e-002, -5.255989e-002, -5.471572e-002,
   -5.653811e-002, -5.833453e-002, -6.018337e-002, -6.191623e-002, -6.360020e-002, -6.524241e-002, -6.684681e-002, -6.843125e-002, -7.002673e-002,
   -7.152629e-002, -7.240049e-002, -7.300993e-002, -7.388027e-002, -7.498386e-002, -7.612198e-002, -7.717995e-002, -7.794049e-002, -7.872595e-002,
   -7.944172e-002, -8.020577e-002, -8.077332e-002, -7.938030e-002, -7.806317e-002, -7.696373e-002, -7.589552e-002, -7.481753e-002, -7.383193e-002,
   -7.278924e-002, -7.177350e-002, -7.024781e-002, -6.849253e-002, -6.630172e-002, -6.048931e-002, -5.491701e-002, -4.916730e-002, -4.324916e-002,
   -3.726084e-002, -3.118685e-002, -2.504838e-002, -1.886408e-002, -1.263625e-002, -6.343596e-003, -4.415809e-016}};

const double* getEmorCurve(int i) { return kEmor[i]; }

}  // namespace hdr
}  // namespace aliceVision