; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -O2 -mtriple=m68k -verify-machineinstrs \
; RUN:              -code-model=large -relocation-model=pic \
; RUN:   | FileCheck %s

; External Linkage
@a = global i32 0, align 4

define i32 @my_access_global_a() #0 {
; CHECK-LABEL: my_access_global_a:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    move.l #a@GOTOFF, %d0
; CHECK-NEXT:    move.l (0,%a0,%d0), %d0
; CHECK-NEXT:    rts
entry:
  %0 = load i32, ptr @a, align 4
  ret i32 %0
}

; WeakAny Linkage
@b = weak global i32 0, align 4

define i32 @my_access_global_b() #0 {
; CHECK-LABEL: my_access_global_b:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    move.l #b@GOTOFF, %d0
; CHECK-NEXT:    move.l (0,%a0,%d0), %d0
; CHECK-NEXT:    rts
entry:
 %0 = load i32, ptr @b, align 4
 ret i32 %0
}

; Internal Linkage
@c = internal global i32 0, align 4

define i32 @my_access_global_c() #0 {
; CHECK-LABEL: my_access_global_c:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    move.l #c@GOTOFF, %d0
; CHECK-NEXT:    move.l (0,%a0,%d0), %d0
; CHECK-NEXT:    rts
entry:
 %0 = load i32, ptr @c, align 4
 ret i32 %0
}

; External Linkage, only declaration.
@d = external global i32, align 4

define i32 @my_access_global_load_d() #0 {
; CHECK-LABEL: my_access_global_load_d:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    move.l #d@GOTOFF, %d0
; CHECK-NEXT:    move.l (0,%a0,%d0), %d0
; CHECK-NEXT:    rts
entry:
 %0 = load i32, ptr @d, align 4
 ret i32 %0
}

; External Linkage, only declaration, store a value.
define i32 @my_access_global_store_d() #0 {
; CHECK-LABEL: my_access_global_store_d:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    move.l #d@GOTOFF, %d0
; CHECK-NEXT:    move.l #2, (0,%a0,%d0)
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
entry:
 store i32 2, ptr @d, align 4
 ret i32 0
}

; External Linkage, function pointer access.
declare i32 @access_fp(ptr)
declare i32 @foo()

define i32 @my_access_fp_foo() #0 {
; CHECK-LABEL: my_access_fp_foo:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    suba.l #4, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -8
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    adda.l #foo@GOTOFF, %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr (access_fp@PLT,%pc)
; CHECK-NEXT:    adda.l #4, %sp
; CHECK-NEXT:    rts
entry:
 %call = call i32 @access_fp(ptr @foo)
 ret i32 %call
}

; LinkOnceODR Linkage, function pointer access.

$bar = comdat any

define linkonce_odr i32 @bar() comdat {
; CHECK-LABEL: bar:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
entry:
 ret i32 0
}

define i32 @my_access_fp_bar() #0 {
; CHECK-LABEL: my_access_fp_bar:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %entry
; CHECK-NEXT:    suba.l #4, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -8
; CHECK-NEXT:    lea (_GLOBAL_OFFSET_TABLE_@GOTPCREL,%pc), %a0
; CHECK-NEXT:    adda.l #bar@GOTOFF, %a0
; CHECK-NEXT:    move.l %a0, (%sp)
; CHECK-NEXT:    jsr (access_fp@PLT,%pc)
; CHECK-NEXT:    adda.l #4, %sp
; CHECK-NEXT:    rts
entry:
 %call = call i32 @access_fp(ptr @bar)
 ret i32 %call
}

!llvm.module.flags = !{!0, !1}
!0 = !{i32 1, !"PIC Level", i32 1}
!1 = !{i32 1, !"PIE Level", i32 1}
