import os
import sipconfig
import subprocess
import os
import site
import pprint
from distutils import sysconfig
from PyQt5 import QtCore
import PyQt5


class Configuration(sipconfig.Configuration):
    """The class that represents PyQt configuration values.
    """

    def getEnv(self, name, default):
        return os.environ.get(name) or default

    def __init__(self):
        qmake_bin = subprocess.check_output(
            ["which", "qmake"], universal_newlines=True).strip(' \t\n\r')
        qtconfig = subprocess.check_output(
            [qmake_bin, "-query"], universal_newlines=True)
        qtconfig = dict(x.split(":", 1) for x in qtconfig.splitlines())

        self.pyQtIncludePath = self.getEnv(
            'PYQT_INCLUDE_PATH', '/usr/share/sip/PyQt5')

        pyqtconfig = {
            "pyqt_config_args":   "--confirm-license -v " + str(self.pyQtIncludePath) + " --qsci-api -q " + qmake_bin,
            "pyqt_version":       QtCore.PYQT_VERSION,
            "pyqt_version_str":   QtCore.PYQT_VERSION_STR,
            "pyqt_bin_dir":       PyQt5.__path__[0],
            "pyqt_mod_dir":       PyQt5.__path__[0],
            "pyqt_sip_dir":       str(self.pyQtIncludePath),
            "pyqt_modules":       "QtCore QtGui QtWidgets",  # ... and many more
            "pyqt_sip_flags":     QtCore.PYQT_CONFIGURATION['sip_flags'],
            "qt_version":         QtCore.QT_VERSION,
            "qt_edition":         "free",
            "qt_winconfig":       "shared",
            "qt_framework":       0,
            "qt_threaded":        1,
            "qt_dir":             qtconfig['QT_INSTALL_PREFIX'],
            "qt_data_dir":        qtconfig['QT_INSTALL_DATA'],
            "qt_archdata_dir":    qtconfig['QT_INSTALL_DATA'],
            "qt_inc_dir":         qtconfig['QT_INSTALL_HEADERS'],
            "qt_lib_dir":         qtconfig['QT_INSTALL_LIBS']
        }

        macros = sipconfig._default_macros.copy()
        macros['INCDIR_QT'] = qtconfig['QT_INSTALL_HEADERS']
        macros['LIBDIR_QT'] = qtconfig['QT_INSTALL_LIBS']
        macros['MOC'] = os.path.join(qtconfig['QT_INSTALL_BINS'], 'moc')

        sipconfig.Configuration.__init__(self, [pyqtconfig])
        self.set_build_macros(macros)


# The name of the SIP build file generated by SIP and used by the build system.
build_file = "qtermwidget.sbf"

# Get the SIP configuration information.
config = Configuration()

# Run SIP to generate the build_file
os.system(" ".join([config.sip_bin, '-I', str(config.pyQtIncludePath), str(
    config.pyqt_sip_flags), "-b", build_file, "-o", "-c", ". " " qtermwidget.sip"]))

installs = []
installs.append(["qtermwidget.sip", os.path.join(
    config.pyqt_sip_dir, "qtermwidget")])
installs.append(["qtermwidgetconfig.py", config.pyqt_mod_dir])

makefile = sipconfig.SIPModuleMakefile(
    configuration=config, build_file=build_file, installs=installs,  qt=["QtCore", "QtGui", "QtWidgets"])

# Add the library we are wrapping.  The name doesn't include any platform
# specific prefixes or extensions (e.g. the "lib" prefix on UNIX, or the
# ".dll" extension on Windows).
makefile.extra_lib_dirs.append("../lib/")
makefile.extra_lib_dirs.append("..")
makefile.extra_libs = ["qtermwidget5"]

# Support for C++11
makefile.extra_cxxflags.append('-std=c++11')

# Generate the Makefile itself.
makefile.generate()

content = {
    # Publish where the SIP specifications for this module will be
    # installed.
    "qtermwidget_sip_dir": config.pyqt_sip_dir,

    # Publish the set of SIP flags needed by this module.  As these are the
    # same flags needed by the qt module we could leave it out, but this
    # allows us to change the flags at a later date without breaking
    # scripts that import the configuration module.
    "qtermwidget_sip_flags": config.pyqt_sip_flags
}

# This creates the qtermwidgetconfig.py module from the qtermwidgetconfig.py.in
# template and the dictionary.
sipconfig.create_config_module("qtermwidgetconfig.py", "config.py.in", content)
