\name{UKHouseOfCommons}
\alias{UKHouseOfCommons}
\docType{data}
\title{1992 United Kingdom electoral returns}
\description{Electoral returns, selected constituencies, 1992 general
  election for the British House of Commons}
\usage{data(UKHouseOfCommons)}
\format{
  A data frame with 521 observations on the following 12 variables.
  \describe{
    \item{\code{constituency}}{a character vector, name of the House of Commons constituency}
    \item{\code{county}}{a character vector, county of the House of Commons constituency}
    \item{\code{y1}}{a numeric vector, log-odds of Conservative to LibDem vote share}
    \item{\code{y2}}{a numeric vector, log-odds of Labor to LibDem vote share}
    \item{\code{y1lag}}{a numeric vector, \code{y1} from previous election}
    \item{\code{y2lag}}{a numeric vector, \code{y2} from previous election}
    \item{\code{coninc}}{a numeric vector, 1 if the incumbent is a
        Conservative, 0 otherwise}
    \item{\code{labinc}}{a numeric vector, 1 if the incumbent is from
        the Labor Party, 0 otherwise}
    \item{\code{libinc}}{a numeric vector, 1 if the incumbent is from
        the LibDems, 0 otherwise}
    \item{\code{v1}}{a numeric vector, Conservative vote share
        (proportion of 3 party vote)}
    \item{\code{v2}}{a numeric vector, Labor vote share  (proportion of 3 party vote)}
    \item{\code{v3}}{a numeric vector, LibDem vote share (proportion of 3 party vote)}
  }
}
\details{
  These data span only 521 of the 621 seats in the House of
  Commons at the time of 1992 election.  Seats missing either a Conservative,
  Labor, or a LibDem candidate appear to have been dropped.   

  The original Katz and King data set does not have case labels.  I
  used matches to an additional data source to recover a set of constituency labels for
  these data; labels could not recovered for two of the constituencies.
}
\source{
   Jonathan Katz; Gary King. 1999. "Replication data for: A Statistical Model of Multiparty Electoral Data", \url{http://hdl.handle.net/1902.1/QIGTWZYTLZ}
  
  %%Martin Baxter.  \url{http://www.electoralcalculus.co.uk/electdata_1992ob.txt}
}
\references{
  Katz, Jonathan and Gary King. 1999. ``A Statistical Model for
  Multiparty Electoral Data''. \emph{American Political Science
    Review}. 93(1): 15-32.
  
  Jackman, Simon. 2009.  \emph{Bayesian Analysis for the Social
    Sciences}.  Wiley: Chichester.  Example 6.9.
}
\examples{
data(UKHouseOfCommons)
tmp <- UKHouseOfCommons[,c("v1","v2","v3")] 
summary(apply(tmp,1,sum))

col <- rep("black",dim(tmp)[1])
col[UKHouseOfCommons$coninc==1] <- "blue"
col[UKHouseOfCommons$labinc==1] <- "red"
col[UKHouseOfCommons$libinc==1] <- "orange"

library(vcd)
vcd::ternaryplot(tmp,
                 dimnames=c("Cons","Lab","Lib-Dem"),
                 labels="outside",
                 col=col,
                 pch=1,
                 main="1992 UK House of Commons Election",
                 cex=.75)
}
\keyword{datasets}
