---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, interlignage, 
              espace entre les lignes, interligne, double interligne, 
              espacer les lignes
---

# Comment modifier l'interligne d'un document ?

S'il vous est demandé d'augmenter l'interligne de votre texte pour améliorer
sa lisibilité, pensez à proposer de diminuer la longueur des lignes du texte. 
Cette solution est souvent plus efficace et esthétique.

Si vous ne convainquez pas votre interlocuteur, voici quelques méthodes.


## Avec l'extension <ctanpkg:setspace>

L'extension <ctanpkg:setspace> est faite pour préparer 
des documents conséquents en double interligne (ou interligne 1,5). 
Elle définit :

- des commandes à mettre dans le préambule, pour modifier tout le document :
  `\singlespacing`, `\onehalfspacing` et `\doublespacing` ;
- des environnements pour une modification locale : `singlespace`, 
  `onehalfspace` et `doublespace` (à chaque fois sous la forme 
  `\begin{singlespace}`...`\end{singlespace}`).

L'extension gère également de façon homogène les autres espacements verticaux
existant dans un document (tableaux, notes de bas de page...), 
même s'il reste parfois quelques ajustements à faire. Par défaut, 
elle désactive le double interligne dans les notes de bas de page, 
les légendes de figure, etc.

Voici un exemple permettant de comparer les trois commandes :

::::{tab-set}

:::{tab-item} Avec `\singlespacing`
```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{booktabs}       % Amélioration de l'aspect des tableaux
  \usepackage[width=5cm,height=7cm]{geometry}
  \usepackage{setspace}

  \singlespacing

\begin{document}
Longtemps, je me suis couché de bonne heure. Parfois, à peine ma bougie 
éteinte, mes yeux se fermaient si vite que je n'avais pas le temps 
de me dire : \og Je m'endors. \fg{}\footnote{Une demi-heure après, 
la pensée qu'il était temps de chercher le sommeil éveillait le narrateur.}

\medskip
\begin{tabular}{lcc}
\toprule
         & Coucher   & Lever   \\
\cmidrule(lr){2-3}
Lundi    & 19h05     & \dots   \\
Mardi    & 19h20     & \dots   \\
\bottomrule
\end{tabular}
\end{document}
```
:::

:::{tab-item} Avec `\onehalfspacing`

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{booktabs}       % Amélioration de l'aspect des tableaux
  \usepackage[width=5cm,height=7cm]{geometry}
  \usepackage{setspace}

  \onehalfspacing

\begin{document}
Longtemps, je me suis couché de bonne heure. Parfois, à peine ma bougie 
éteinte, mes yeux se fermaient si vite que je n'avais pas le temps 
de me dire : \og Je m'endors. \fg{}\footnote{Une demi-heure après, 
la pensée qu'il était temps de chercher le sommeil éveillait le narrateur.}

\medskip
\begin{tabular}{lcc}
\toprule
         & Coucher   & Lever   \\
\cmidrule(lr){2-3}
Lundi    & 19h05     & \dots   \\
Mardi    & 19h20     & \dots   \\
\bottomrule
\end{tabular}
\end{document}
```
:::

:::{tab-item} Avec `\doublespacing`

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{booktabs}       % Amélioration de l'aspect des tableaux
  \usepackage[width=5cm,height=7cm]{geometry}
  \usepackage{setspace}

  \doublespacing

\begin{document}
Longtemps, je me suis couché de bonne heure. Parfois, à peine ma bougie 
éteinte, mes yeux se fermaient si vite que je n'avais pas le temps 
de me dire : \og Je m'endors. \fg{}\footnote{Une demi-heure après, 
la pensée qu'il était temps de chercher le sommeil éveillait le narrateur.}

\medskip
\begin{tabular}{lcc}
\toprule
         & Coucher   & Lever   \\
\cmidrule(lr){2-3}
Lundi    & 19h05     & \dots   \\
Mardi    & 19h20     & \dots   \\
\bottomrule
\end{tabular}
\end{document}
```
:::

::::

[La documentation de setspace](texdoc:setspace) apparaît sous forme 
de commentaires TeX dans le fichier de l'extension elle-même.


## Avec les commandes de base

### La commande `\baselineskip` 

L'interligne est initialement géré par la commande `\baselineskip` 
(exprimée en 
[unités de longueur](/2_programmation/syntaxe/longueurs/unites_de_mesure_de_tex) 
reconnues par LaTeX).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
{\setlength{\baselineskip}{1.2\baselineskip}
On peut manipuler la taille de l'interligne soit de façon absolue, 
soit de façon relative, comme ici (plus 20\%), soit de manière absolue.
Il est important de terminer le paragraphe avant la fin des accolades, 
pour que l'interligne que l'on a défini soit encore en vigueur à la fin 
du paragraphe (c'est en fait le seul moment où il est pris en compte)
.\par} %%% Le paragraphe s'achève ici dans le bloc.

{\advance\baselineskip -1pt On peut également ajuster directement 
l'interlignage dans une partie du texte.\par}
\end{document}
```

Cependant, la valeur de `\baselineskip` est réinitialisée par n'importe 
quelle commande de changement de taille des caractères. Cette solution 
doit donc rester locale.


###  La commande `\baselinestretch`

Le coefficient d'étirement de l'interligne, `\baselinestretch`, est 
plus pratique à manipuler. Voici deux instructions qui obtiennent 
le même résultat. 

```{noedit}
\linespread{1.6}\selectfont
\renewcommand{\baselinestretch}{1.6}\selectfont
```

Notez que les modifications de `\baselinestretch` ne prennent effet 
que lorsque vous sélectionnez une nouvelle police (d'où la présence 
de la commande `\selectfont` pour forcer cette modification). Ce type 
de modification s'effectue dès lors plutôt dans le préambule, 
avant toute sélection de police. En voici cependant un exemple 
dans le corps du document :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\lipsum[1]

\renewcommand{\baselinestretch}{1.6}\selectfont
\lipsum[2]
\end{document}
```


### Une méthode un peu plus honteuse

:::{warning}
Cette méthode n'est pas vraiment recommandée. Ce qui suit est informatif 
et ne devrait servir que très ponctuellement.
:::

Cette dernière méthode manuelle revient à demander une taille de caractère 
dès le début d'un paragraphe puis d'en changer aussitôt dans un groupe. 
En effet, comme on l'a vu plus haut, la taille de caractère initiale 
va en effet déterminer l'interligne du paragraphe.

La lourdeur de cette méthode la rend plus pratique pour des documents 
de taille conséquente.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\footnotesize{\normalsize Texte à interligne réduit, la
commande de changement de paragraphe est appelée pendant
que l'on est en petite taille, alors que le texte est en
taille normale.}\par

\normalsize
{\small On peut faire le contraire (le résultat est moins
laid, esthétiquement) en se basant sur les mêmes principes.
On n'est pas obligé d'appeler la commande
de fin de paragraphe, bien entendu, l'habituel changement de ligne suffit.}
\end{document}
```

La question "[](/3_composition/texte/symboles/polices/changer_la_taille_d_une_fonte)"
liste les commandes de changement de taille.


## Avec l'extension <ctanpkg:doublespace>

:::{warning}
L’extension <ctanpkg:doublespace> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). 
Ce qui suit est informatif.
:::

L'extension <ctanpkg:doublespace> permet de répondre aussi à ce besoin 
mais son code contient de nombreuses erreurs et génère des anomalies.